unit OpenDlgU;
{this unit has code used to show the system Open and Save Dialogs. The
 DlgOpenSave unit has more functions to create system Open and Save Dialogs}

interface

function MakeProgram: Boolean;
{the MakeProgram function will call some creation functions in MakeApp.pas}

implementation

uses
  Windows, Messages, DlgOpenSave, CommCtrl, CommDlg, MakeApp, SmallUtils;
  // the CommDlg unit has the system functions for dialogs like Open and Save

const
But_Height: Integer = 24;

// below are the constants for button control ID numbers
ID_ExitBut = 1000;
ID_OpenBasicBut = 1001;
ID_OpenUnitBut = 1002;
ID_OpenOptBut = 1003;
ID_SaveDlgBut = 1004;
ID_SaveOptBut = 1005;
ID_OpenMultiBut = 1006;

var
hForm1: Integer = Zero; // handle of Main Window (Form)
hListBox1: Integer;
lFName, lPath: String; // text used for Form display of file name and folder path
lNameRect, lPathRect: TRect; // invalidate rectangles for Form text display
OpenSet1: TDlgSetUp; { TDlgSetUp is in the DlgOpenSave unit, and has set up
                       Options for the creation of Open-Save Dialogs}
FilterIndex: Integer = 1;


{the DoOpenDlg function has code to create a Basic system Open Dialog box}
function DoOpenDlg: String;
var
OFName : TOpenFileName;
FileName: Array[Zero..2047] of Char; {Fixed Length Text Buffer for file path
    result in OFName.lpStrFile. You should use more than 256 chars for your
    file name text buffer, newer systems can have file paths and names with
    kilobytes of charaters. I mostly use 2 kilobytes}

begin
ZeroMemory(@FileName, SizeOf(FileName));
ZeroMemory(@OFName, SizeOf(OFName)); // Set all record elements to Zero or Nil

with OFName do
  begin
  lStructSize := SizeOf(OFName); // you MUST ALWAYS set the lStructSize
  hWndOwner := hForm1; // Returns focus to the Owner window, usually main window

  lpStrFile := @FileName; {IMPORTANT - you MUST set some kind of memory block
                           text buffer for the lpStrFile, This is where the
                           choosen file name and path is returned}

  nMaxFile := SizeOf(FileName); // you MUST have the memory size of the lpStrFile
  Flags := OFN_EXPLORER or OFN_ENABLESIZING or
                 OFN_HIDEREADONLY or OFN_FILEMUSTEXIST;
    {These Flags are some of the Usuall ones for an Open Dlg, their names give
    some indication of what option they set. You should experiment with different
    Flag options to see what they do and how they work}

  lpStrFilter := 'Text files  .TXT'#0'*.txt'#0'Delphi files, DPR,PAS,DOF'#0+
               '*.dpr;*.pas;*.dof'#0'All files'#0'*.*'#0#0; // double null end

    {the lpStrFilter are #0 terminated sets of strings which tells the Open
     Dlg what files to show, there are two strings in each set, the first
     string is displayed in the combo box, the second string has the ; separated
     file extention filters, to show the end of these sets, use a double #0}

  nFilterIndex := 1; { set your filter index, usually to One.
                     The filter index of zero is for the Custom Filter, which is
                     not used in this code. The filter index of One uses the first
                     filter in your lpStrFilter string above}

  lpStrTitle := 'Search for a File to Open'; // Title on the Open Dlg
  end;

if GetOpenFileName(OFName) then // GetOpenFileName is True if successful
  Result := FileName // FileName will have the file Path and Name in it
  else
  Result := ''; // Blank out Result string to show Failure of this function

{I could have used the code -
Result := OFName.lpStrFile
instead of the -
Result := FileName;
the OFName.lpStrFile and the FileName are the same thing}

{if you change the line -
GetOpenFileName(OFName)
to
GetSaveFileName(OFName)
you will get a system Save Dialog instead of an Open dialog}
end;


{ DoMultiFile procedure will get a multiple file name result string
  It requires special handling of the #0 delimited string returned}
procedure DoMultiFile;
var
MultiRe: TMultiResult; // returned by the OpenMultiSel function
pFileName: PChar;
begin
{the OpenMultiSel function uses a Multi-Selection dialog, the Result
 string is different than a normal open dialog, it has null #0 delimited
 file path and names}
MultiRe := OpenMultiSel(hForm1, 'C:\Stuff', 'Text files  .TXT'#0'*.txt'+
              #0'All files'#0'*.*'#0#0,'Open more than One File, Multi-Select');
{a TMultiResult is the result form a OpenMultiSel, the fOffSet will be
 -1 if it fails, or the File-Name charater offset if it succeeds}
if MultiRe.fOffSet <> -1 then
  begin
  // I list the file names in the hListBox1 List Box
  SendMessage(hListBox1, LB_RESETCONTENT, Zero, Zero);
  SetString(lPath, PChar(MultiRe.fNames), MultiRe.fOffSet-1);
  // the Folder path is in the first section of the MultiRe.fNames
  // MultiRe.fNames is several #0 delimited strings, only if more than one file
  // I use SetString( ) with the MultiRe.fOffSet-1 number to know it's length

  // if there is only ONE file name, the result string will not have #0
  // delimters, I test for the #0 delimter at MultiRe.fOffSet
  if MultiRe.fNames[MultiRe.fOffSet] <> #0 then // true if single file name
    begin
    SendMessage(hListBox1, LB_ADDSTRING, Zero,
                Integer(@MultiRe.fNames[MultiRe.fOffSet+1]));
    // the list box will add single string above using the file name offset
    end else
    begin
    pFileName := StrEnd(PChar(MultiRe.fNames));
    // StrEnd will get the #0 delimiter
    Inc(pFileName); // move to character after #0
    while pFileName^ <> #0 do // loop until there are two #0
      begin
      // add #0 terminated file name to list box
      SendMessage(hListBox1, LB_ADDSTRING, Zero, Integer(pFileName));
      pFileName := StrEnd(pFileName);
      Inc(pFileName);
      end;
    end;
  end else lPath := 'User Canceled or Error'; // MultiRe.fOffSet = -1
end;



function MessageFunc(hWnd,Msg,wParam,lParam:Integer):Integer; stdcall;
var
PaintS: TPaintStruct;
fName: String;

  procedure ShowFName(IsCheck: Boolean = False);
  begin
  {this procedure draws the new file path on the Form}
  if fName = '' then
    lFName := 'User Canceled'
    else
    lFName := fName;
  InvalidateRect(hWnd,@lNameRect, True);
  // IsCheck as True checks for the doCheckRead in OpenSet1.Options
  if IsCheck and
   (doCheckRead in OpenSet1.Options) then
    MessageBox(hForm1, 'The Read Only was Checked', 'Check ReadOnly',
                      MB_ICONINFORMATION);
  end;

begin
case Msg of
  WM_DESTROY: PostQuitMessage(Zero);
  WM_PAINT:
    begin
    {Paint the lFName and lPath strings on the form for user information}
    BeginPaint(hWnd, PaintS);
    SelectObject(PaintS.hdc, VarFont);
    SetBkColor(PaintS.hdc, GetSysColor(COLOR_3DFACE));
    DrawText(PaintS.hdc,PChar(lFName),DEF,lNameRect, DT_WORDBREAK or DT_LEFT);
    DrawText(PaintS.hdc,PChar(lPath),DEF,lPathRect, DT_WORDBREAK or DT_LEFT);
    EndPaint(hWnd,PaintS);
    Result := Zero;
    Exit;
    end;
  WM_COMMAND:
    if LOWORD(wParam) = ID_ExitBut then
      PostMessage(hForm1, WM_CLOSE, Zero, Zero)
    else if LOWORD(wParam) = ID_OpenBasicBut then
      begin
      {the code in the DoOpenDlg function will return a File path if successful
       or an empty string if the user cancels or an error happens}
      fName := DoOpenDlg;
      ShowFName; // see procedure code above, that paints the new file name on form
      end else if LOWORD(wParam) = ID_OpenUnitBut then
      begin
      {this button click uses the DlgOpenSave unit. The OpenSavDlg function
       creates a system open-save dialog and returns the file path the user
       picked from the dialog}
      fName := OpenSavDlg(hForm1,'','',True);
      // this has empty strings in it's parameters to get the default settings
      ShowFName;
      end else if LOWORD(wParam) = ID_OpenOptBut then
      begin
      // this button click uses the OpenDlgOpt function in the DlgOpenSave unit

      //this OpenSet1 record is the way to send many dialog options
      // to the OpenDlgOpt( ) function.
      OpenSet1.hOwner := hForm1; // you should always assign an Owner in TDlgSetUp
      // the rest of the record's elements are optional

      { The OpenSet1 settings below are optional and should be set to
        what you need for your dialog}
      with OpenSet1 do
        begin
        { There are several strings for text options like Filter and Title.
          All strings that are left empty will get default values}
        Filter := 'Text files  .TXT'#0'*.txt'#0'Delphi files, DPR,PAS,DOF'#0+
                     '*.dpr;*.pas;*.dof'#0'All files'#0'*.*'#0#0;
        Title := 'Open Something Else';
        //iniDirPath := 'C:\Stuff';
        Options := [doCreatePompt];
        // Options is a set of TDlgOptions to adjust the dialog creation Flags
        end;
      fName := OpenDlgOpt(OpenSet1);
      ShowFName;
      end else if LOWORD(wParam) = ID_SaveDlgBut then
      begin
      {here a more complex file Filter is created in a string}
      fName := GetFileName(ParamStr(Zero));
      fName := ChangeExt(fName,'.DPR');
      fName := fName+'  File'#0+fName+#0'Meta Files .?MF'#0'*.?mf'#0+
            'Other files, WAV,DOC,BMP'#0+'*.wav;*.doc;*.bmp'#0'All files'#0'*.*'#0#0;
      {WARNING !
       you can NOT use any normal delphi string modifiers, like + , after you add the
       Null #0, if you do use the + operator, the string will be CUT OFF at the first #0.
       so you should do all of your string modificatons before you add the #0}

      fName := OpenSavDlg(hForm1,GetFilePath(ParamStr(Zero)), fname, False);
      ShowFName;
      end else if LOWORD(wParam) = ID_SaveOptBut then
      begin
      // this OpenSet1 record has all the elements set
      with OpenSet1 do
        begin
        hOwner := hForm1;
        if OpenFolder ='C:' then
          OpenFolder := 'F:\Programs';
        iniDirPath := OpenFolder; //this dialo will track the folder with OpenFolder
        iniFileName := 'NewFile1.txt';
        Filter := 'Text files  .TXT'#0'*.txt'#0'New Text files files,  NewFile.TXT'#0+
                     'NewFile?.txt;NewFile??.txt'#0'All files'#0'*.*'#0#0;
        Title := GetWindowStr(hForm1)+' Save Dialog';
        DefExt := '.txt';
        Options := [doSave,doPathExist,doReadOnlyCB,doOverWrite,doTrackFolder,doCusFilter];
        end;
      fName := OpenDlgOpt(OpenSet1, FilterIndex);
      FilterIndex := OpenSet1.hOwner; // the last Filter Index is now in hOwner
      ShowFName(True);
      end else if LOWORD(wParam) = ID_OpenMultiBut then
      begin
      DoMultiFile;
      InvalidateRect(hWnd,@lPathRect, True);
      end;
  end;
Result := DefWindowProc(hWnd,Msg,wParam,lParam);
end;


procedure MakeControls;
begin
InitCommonControls;
lFName := 'Dialog return File Name and Path here';
// lFName is used to show the dialog File Path
SetRect(lNameRect, 4,64,420,102);// Rectangle for InvalidateRect function
lPath := 'Folder Path for Multi-Select open dialog';
SetRect(lPathRect, 4,134,420,169);

MakeButton(330,260,78, But_Height, 'E X I T', hForm1, ID_ExitBut, Zero);

MakeButton(18,4, 104, But_Height, 'Basic Open Dialog', hForm1, ID_OpenBasicBut);
MakeButton(128,4, 100, But_Height, 'Unit Open Dialog', hForm1, ID_OpenUnitBut);
MakeButton(236,4, 116, But_Height, 'Options Open Dialog', hForm1, ID_OpenOptBut);
MakeButton(18,36, 82, But_Height, 'Save Dialog', hForm1, ID_SaveDlgBut);
MakeButton(106,36, 116, But_Height, 'Options Save Dialog', hForm1, ID_SaveOptBut);
MakeButton(18,105, 120, But_Height, 'Show Muti-Sel Dialog', hForm1, ID_OpenMultiBut);

hListBox1 := MakeListBox(18,174,272,130, hForm1,#255'Multi-Select Open File Names'#0#0);
end;

function MakeProgram: Boolean;
begin
Result := False;
if SetWinClass('OpenDialog'#9'Class', @MessageFunc) = Zero then Exit;

hForm1 := MakeForm(DEF, DEF, 420, 290, 'Using the System Open and Save Dialogs',
                   WS_TILEDWINDOW or WS_CLIPCHILDREN);
if hForm1 = Zero then Exit;
Result := True;
MakeControls; // control creation
end;

end.
 