unit UseFilesU;

interface


function MakeProgram: Boolean;
{the MakeProgram function will call some functions to create the windows and
 controls for this Application. If there is a creation error, it returns False}

procedure SysErrorMsg(const Text, Title: String);
// shows message box with system error text

function GetSplitFolder: String;
// will get the folder path from the hFolderEdit edit

function OpenDialog1(Use1: Cardinal): String;
// shows the Open and Save dialogs

const
One = 1;
Two = 2;
// below are Radio Button ID
ID_1MegRB = 1010;
ID_EqualRB = 1011;

// message box file access error text is below
Err = 'ERROR - ';
CreateErrText = 'System could NOT Create file';
CreateErrTitle = 'Did NOT Create File';
ReadErrText = 'System could NOT Read file';
ReadErrTitle = 'Did NOT Read File';
WriteErrText = 'System could NOT Write file';
WriteErrTitle = 'Did Not Write File';

var    
hForm1: Integer = 0; // handle of Main Window (Form)
hPage2, hIntEdit, hStrEdit, hListBox, hEdit2: Integer;


implementation
                 
uses
  Windows, Messages, SplitFilesU, DataFilesU, ShlObj, ActiveX,
  MakeApp, CommDlg, CommCtrl, SmallUtils;
                          // ActiveX is needed for the shell CoTaskMemFree( )


const
butHeight = 24;
// control ID numbers below
ID_ExitBut = 1000;
ID_LoadTBut = 1001;
ID_SaveTBut = 1002;
ID_TabGetBut = 1003;
ID_TabSetBut = 1004;
ID_SplitBut = 1005;
ID_RestoreBut = 1006;
ID_CopyFileBut = 1007;
ID_OpenSplitBut = 1008;
ID_OpenResBut = 1009;

ID_DataNameBut = 1012;
ID_SaveFixedBut = 1013;
ID_LoadFixedBut = 1014;
ID_SaveData1But = 1015;
ID_LoadData1But = 1016;
ID_SaveVar1But = 1017;
ID_LoadVar1But = 1018;
ID_SaveStrBut = 1019;
ID_GetListBut = 1020;
ID_LoadStrBut =1021;
ID_TabCtrl = 2000;

TextRect: TRect = (left: 290; Top: 142; Right: 510; Bottom: 164);
// TextRect has the area needed for hPage2 refresh of the File Size text


var
Font1, Font2, Font3, hTab1, hPage1, hPage3, hFolderEdit, hSplitEdit,
hRestEdit, hDataEdit, hVarEdit, hButTab: Integer;
pPageProc: Pointer;
sFileSize, PersonalFolder: String;
// PersonalFolder will have the path for the user's My Documents folder
FirstOpen: Boolean = True;

procedure SysErrorMsg(const Text, Title: String);
begin
// shows a message box that adds the system error text
MessageBox(hForm1, PChar(Err+Text+#10+ SysErrorMessage(GetLastError)),
           PChar(Err+Title), MB_ICONERROR);
end;

function GetSplitFolder: String;
begin
// gets the text out of hFolderEdit and test for the folder
Result := GetWindowStr(hFolderEdit);
if not DirectoryExists(Result) then
  begin
  MessageBox(hForm1, 'ERROR - You must Have a valid Folder Path in the'+
             ' Folder Edit box', 'ERROR - Not a Valid Folder', MB_ICONERROR);
  Result := '';
  Exit;
  end;
end;

// OpenDialog1 shows the system Open and Save Dialog boxes
function OpenDialog1(Use1: Cardinal): String;
var
OfName : TOpenFilename;
FileName: Array[Zero..2047] of Char;
begin
ZeroMemory(@FileName, SizeOf(FileName));
ZeroMemory(@Ofname, SizeOf(OfName));

with OfName do
  begin
  lStructSize := sizeof(OfName);
  hWndOwner := hForm1;
  hInstance := SysInit.hInstance;
  nMaxFile := SizeOf(FileName);
  lpStrFile := @FileName;
  Flags := OFN_EXPLORER or OFN_FILEMUSTEXIST or OFN_HIDEREADONLY;
  Case Use1 of // Use1 is set to change filter and title
    Zero: begin
      lpstrFilter := 'Text files  .TXT'#0'*.txt'#0'All files'#0'*.*'#0#0;
      lpstrTitle := 'Open a Text File';
      end;
    One: begin
      lpstrFilter := 'All files'#0'*.*'#0#0;
      lpstrTitle := 'Open a File to Split';
      end;
    Two: begin
      lpstrFilter := 'Split files  3p1, 1meg1'#0'*.3p1;*.1meg1'#0'All files'#0'*.*'#0#0;
      lpstrTitle := 'Open a File to Restore';
      end;
    3: begin
      lpstrFilter := 'Text files  .TXT'#0'*.txt'#0'All files'#0'*.*'#0#0;
      lpstrTitle := 'Save a Text File';
      Flags := OFN_EXPLORER or OFN_PATHMUSTEXIST or
               OFN_OVERWRITEPROMPT or OFN_HIDEREADONLY;
      end;
    4: begin
      lpstrFilter := 'Multi-Data files  .MDTF'#0'*.mdtf'#0'All files'#0'*.*'#0#0;
      lpstrTitle := 'Save a Multi-Data File';
      lpstrDefExt := 'mdtf';
      Flags := OFN_EXPLORER or OFN_PATHMUSTEXIST or OFN_OVERWRITEPROMPT or
                OFN_HIDEREADONLY or OFN_EXTENSIONDIFFERENT;
      end;
    5: begin
      lpstrFilter := 'All files'#0'*.*'#0#0;
      lpstrTitle := 'Open a File to COPY';
      end;
    6: begin
      lpstrFilter := 'All files'#0'*.*'#0#0;
      lpstrTitle := 'Get File Name for New Copyed File';
      Flags := OFN_EXPLORER or OFN_PATHMUSTEXIST or
                OFN_OVERWRITEPROMPT or OFN_HIDEREADONLY;
      end;
    end;

  nFilterIndex := One;
  if FirstOpen then
    begin
    FirstOpen := False;
    lpstrInitialDir:= PChar(PersonalFolder)
    end;
  end;

Result := '';
// if Use1 is 3, 4, or 6 then save dialog
if Use1 in [3,4,6] then
  begin
  if GetSaveFileName(ofName) then
  Result := FileName;
  end else // open dialog
  if GetOpenFileName(ofName) then
  Result := FileName;
end;


procedure SaveTextFile;
var
hFile, TextLength, BytesWrite: Cardinal;
FileName: String;
pText: PChar;
begin
// this procedure will open a file and write a PChar string into it
FileName := OpenDialog1( 3);
if Filename = '' then Exit;
  //Filename := 'E:\h?*.n?m';
hFile := CreateFile(PChar(FileName),GENERIC_WRITE,Zero,
                    nil, CREATE_ALWAYS,FILE_ATTRIBUTE_NORMAL or
                    FILE_FLAG_SEQUENTIAL_SCAN,Zero);
{this file is opened with a Write Only flag, I have the share set to zero so
 no other program and read or write to this file during the write operation.
 By using the CREATE_ALWAYS flag a file is created or existing file is erased.
 I use the FILE_FLAG_SEQUENTIAL_SCAN flag to allow the system to use a more
 efficient file read and catching operations, however on small files this
 makes no difference}

if hFile = INVALID_HANDLE_VALUE then
  begin  // check for open file
  SysErrorMsg(CreateErrText+#10+FileName, CreateErrTitle);
  Exit;
  end;

// I will get the amount of text charaters in the multi-line edit
TextLength := GetWindowTextLength(hPage1);
if TextLength < One then
  begin
  // if the edit is empty then Close Handle and exit
  CloseHandle(hFile);
  Exit;
  end;

GetMem(pText, TextLength+One); // add one for NULL charater
{this time I use a PChar, and get a memory block for it with GetMem( )}
GetWindowText(hPage1, pText, TextLength+One);

// you will need to dereference a Pointer, pText, for a WriteFile( )
if (not WriteFile(hFile, pText^, TextLength, BytesWrite, nil)) or
       (TextLength <> BytesWrite) then
  begin // test the FileWrite and also the BytesWrite to see if successful
  CloseHandle(hFile);
  DeleteFile(PChar(FileName)); // delet the file if there is a write error
  SysErrorMsg(WriteErrText, WriteErrTitle);
  end;

FreeMem(pText);
CloseHandle(hFile);
end;


procedure LoadTextFile;
const
pError: PChar = 'File Load ERROR';

var
hFile, SizeF, BytesRead: Cardinal;
Text1: String;
begin
// this procedure will open and read a text file into a string
Text1 := OpenDialog1(Zero);
if Text1 = '' then Exit;

hFile := CreateFile(PChar(Text1), GENERIC_READ, FILE_SHARE_READ, nil,
                    OPEN_EXISTING, FILE_FLAG_SEQUENTIAL_SCAN, Zero);
{ file is opened for reading only with GENERIC_READ, ,
 For Share, I include a FILE_SHARE_READ to allow other programs to
 read from this file.
 The file must exist or a file error and no open file with OPEN_EXISTING.
 The file Flag is set to FILE_FLAG_SEQUENTIAL_SCAN, which may help in
 access speed for larger files}

if hFile = INVALID_HANDLE_VALUE then
  begin
// file handle should be checked to see if system has located and opened the file
  SysErrorMsg(CreateErrText+#10+Text1, CreateErrTitle);
  Exit;
  end;

SizeF := GetFileSize(hFile, nil);
// for most file reads you will need the size of the file on disk
if (SizeF = MAXDWORD) then
  begin
  { the GetFileSize will usually work, although if the file is larger than
  4 gigs and there is no lpFileSizeHigh it will fail}
  CloseHandle(hFile);
  // You must try to always use CloseHandle( ) when you are done with the file
  MessageBox(hForm1, 'GetFileSize  FAILED', pError, MB_ICONERROR);
  Exit;
  end;

if SizeF = Zero then
  begin
  // if the file size is zero, there is nothing in the file to read
  CloseHandle(hFile);
  SetWindowText(hPage1, nil);
  Exit;
  end;

if SizeF > 32768 then
  begin
{ although text files have no file header information, you will ususally need to
 test some property of the file bytes, to see if it is a file you want to use.
 For an example, I just test for the size of 32 Kb, even though it is not nessary}
  CloseHandle(hFile);
  MessageBox(hForm1, PChar('ERROR, File size is MORE than 32,768'#10+
             'CAN NOT LOAD, file is to large at '+Int2Thos(SizeF)),
              pError, MB_ICONERROR);
  Exit;
  end; 

// next are the file read operations
SetLength(Text1, SizeF);
{ a memory block is needed to read the file bytes into, since this is for text
  charaters I use a String, and to get the memory I use SetLength( ) }

{the next code is typical for a file read, ReadFile( ) will return False
 if it fails. You should also test the BytesRead for the amount that the
 file should read thats in SizeF}
if not ReadFile(hFile, Text1[One], SizeF, BytesRead, nil) or (SizeF <> BytesRead) then
  begin
  SysErrorMsg(ReadErrText, ReadErrTitle);
  CloseHandle(hFile);
  Exit;
  end;
CloseHandle(hFile);
// always be sure to CloseHandle( )

SetWindowText(hPage1, @Text1[One]);
//Place the Text1 string in to the Muti-line Edit hPage1
end;



function PageFunc(hWnd, Msg, WParam, LParam: Integer): Integer; stdcall;
begin
// inorder to get Tab keys, I subclass the muti-line Edit (hPage1)
case Msg of
WM_GETDLGCODE:
  begin
{WM_GETDLGCODE is sent to SubClassed Proc to get a result
that will tell the OS which Keys to use or not for the Dialog
keys, a multiline edit will be less easy to get Tab Stop
functioning, because it may need Tab key input}
  Result := DLGC_WANTALLKEYS;
{DLGC_WANTALLKEYS tells the OS to send all keys to this Edit Box
Multi-Line Edits should get all keys}
  Exit;
  end;
end;
Result := CallWindowProc(pPageProc,hWnd,Msg,wParam,lParam);
end;


procedure GetTheFile(Opp: Cardinal);
var
FileName: String;
ErrorMode, hFind: Cardinal;
FindData: TWin32FindData;
begin
// this procedure gets the file size of the file to split, to display on hPage2
if (Opp < One) or (Opp > Two) then Exit;
FileName := OpenDialog1( Opp);
if Filename = '' then Exit;
if Opp = One then
  begin
  ErrorMode := SetErrorMode(SEM_FailCriticalErrors);
  hFind := FindFirstFile(PChar(FileName), FindData);
  SetErrorMode(ErrorMode);
  if hFind <> INVALID_HANDLE_VALUE then
    begin
    FindClose(hFind);
    sFileSize := 'File Size '+Int2Thos(FindData.nFileSizeLow)+' bytes';
    SetWindowText(hSplitEdit, PChar(FileName));
    end else
    sFileSize := 'Invalid File';
  InvalidateRect(hPage2, @TextRect, True);
  end else
  SetWindowText(hRestEdit, PChar(FileName));
end;


function Page2MsgFunc(hWnd,Msg,wParam,lParam:Integer):Integer; stdcall;
var
PaintS: TPaintStruct;
cRect: TRect;
begin
// this is the messages processing for the STATIC window hPage2
case Msg of
  WM_PAINT:
    begin
  {On Page 2 I draw text and I draw two 3D bars}
    BeginPaint(hWnd, PaintS);
    SetBkMode(PaintS.hdc, TRANSPARENT);
    TextOut(PaintS.hdc,TextRect.Left,TextRect.Top, PChar(sFileSize),Length(sFileSize));
    SelectObject(PaintS.hdc, VarFont);
    TextOut(PaintS.hdc,84,198, 'Folder where split files go -',29);
    SetBkColor(PaintS.hdc, $99FF99);
    SelectObject(PaintS.hdc, Font1);
    SetBkMode(PaintS.hdc, OPAQUE);
    // the text draw below are for the titles on the page with a green background
    TextOut(PaintS.hdc,236,6, ' Copy a File ',13);
    TextOut(PaintS.hdc,240,86, ' Split a File ',14);
    TextOut(PaintS.hdc,226,270, ' Restore a File ',16);

  {the line drwing code below will draw two green 3D bars on the page}
    SelectObject(PaintS.hdc, CreatePen(PS_SOLID,Zero, $FCFFF4));
  // this first line draw is for the HighLight color
    MoveToEx(PaintS.hdc,Zero,256,nil);
    LineTo(PaintS.hdc,PaintS.rcPaint.Right,256);
    MoveToEx(PaintS.hdc,Zero,74,nil);
    LineTo(PaintS.hdc,PaintS.rcPaint.Right,74);
    DeleteObject(SelectObject(PaintS.hdc, CreatePen(PS_DOT,Zero, $70A260)));
  // a green Dot pen is used to draw the line body, with 3 lines
    MoveToEx(PaintS.hdc,Zero,255,nil);
    LineTo(PaintS.hdc,PaintS.rcPaint.Right,255);
    MoveToEx(PaintS.hdc,Zero,73,nil);
    LineTo(PaintS.hdc,PaintS.rcPaint.Right,73);
    MoveToEx(PaintS.hdc,Zero,257,nil);
    LineTo(PaintS.hdc,PaintS.rcPaint.Right,257);
    MoveToEx(PaintS.hdc,Zero,75,nil);
    LineTo(PaintS.hdc,PaintS.rcPaint.Right,75);
    MoveToEx(PaintS.hdc,Zero,258,nil);
    LineTo(PaintS.hdc,PaintS.rcPaint.Right,258);
    MoveToEx(PaintS.hdc,Zero,76,nil);
    LineTo(PaintS.hdc,PaintS.rcPaint.Right,76);
    DeleteObject(SelectObject(PaintS.hdc, GetStockObject(BLACK_PEN)));
  // a black pen is used to draw the shadow line
    MoveToEx(PaintS.hdc,Zero,259,nil);
    LineTo(PaintS.hdc,PaintS.rcPaint.Right,259);
    MoveToEx(PaintS.hdc,Zero,77,nil);
    LineTo(PaintS.hdc,PaintS.rcPaint.Right,77);

    EndPaint(hWnd,PaintS);
    Result := Zero; // Does NOT allow DefWindowProc to be called
    Exit;
    end;
  WM_ERASEBKGND:
    begin
    GetClientRect(hWnd, cRect);
    SelectObject(wParam, GetSysColorBrush(COLOR_BTNFACE));
    PatBlt(wParam,Zero,Zero,cRect.Right,cRect.Bottom, PATCOPY);
    Result := One;
    Exit;
    end;
  // below are the button click messages for page 2
  WM_COMMAND: case LOWORD(wParam) of
    ID_CopyFileBut: CopyAFile; // the split procedures are in  SplitFilesU.pas
    ID_SplitBut: StartSplit(GetWindowStr(hSplitEdit));
    ID_RestoreBut: StartRestore(GetWindowStr(hRestEdit));
    ID_OpenSplitBut: GetTheFile(One);
    ID_OpenResBut: GetTheFile(Two);
    end;
  end;

Result := DefWindowProc(hWnd,Msg,wParam,lParam);
// PLEASE NOTICE. . . I do NOT use the system STATIC message processing
// I use the DefWindowProc( ) because I do NOT want STATIC window functioning
end;


function PanelFunc1(iMsg,wParam,lParam:Integer):Integer;
var
PaintS: TPaintStruct;
FileName: String;
begin
// this is the message function for Page 3, a panel
Result := -2; // -2 will call the Default system message processing
case iMsg of
  WM_PAINT:
    begin
    BeginPaint(hPage3, PaintS); // use the hPage3  handle
    SetBkColor(PaintS.hdc, $FFBAC2);
    SelectObject(PaintS.hdc, Font1);
  // text draw below is for the Titles on page 2
    TextOut(PaintS.hdc,170,4, ' Save Fixed Data to a File ',27);
    TextOut(PaintS.hdc,156,184, ' Save Variable Data to a File ',30);
  // the line draws below create a 3D bar on the page
    SelectObject(PaintS.hdc, CreatePen(PS_SOLID,Zero, $FFE4DC));
    MoveToEx(PaintS.hdc,Zero,172,nil);
    LineTo(PaintS.hdc,PaintS.rcPaint.Right,172);
    DeleteObject(SelectObject(PaintS.hdc, CreatePen(PS_DOT,Zero, $666666)));
    MoveToEx(PaintS.hdc,Zero,171,nil);
    LineTo(PaintS.hdc,PaintS.rcPaint.Right,171);
    MoveToEx(PaintS.hdc,Zero,173,nil);
    LineTo(PaintS.hdc,PaintS.rcPaint.Right,173);
    MoveToEx(PaintS.hdc,Zero,174,nil);
    LineTo(PaintS.hdc,PaintS.rcPaint.Right,174);
    // draws smaller line
    MoveToEx(PaintS.hdc,110,269,nil);
    LineTo(PaintS.hdc,494,269);
    MoveToEx(PaintS.hdc,110,270,nil);
    LineTo(PaintS.hdc,494,270);

    DeleteObject(SelectObject(PaintS.hdc, GetStockObject(BLACK_PEN)));
    MoveToEx(PaintS.hdc,Zero,175,nil);
    LineTo(PaintS.hdc,PaintS.rcPaint.Right,175);
    MoveToEx(PaintS.hdc,110,271,nil);
    LineTo(PaintS.hdc,494,271);
    SelectObject(PaintS.hdc, VarFont);
    SetBkMode(PaintS.hdc, TRANSPARENT);
    TextOut(PaintS.hdc,2,32, 'path --> C:\Data File 1.FixedData',33);
    EndPaint(hPage3,PaintS);
    Result := Zero; // Does NOT allow DefWindowProc to be called
    end;
  WM_COMMAND: if LOWORD(wParam) = ID_DataNameBut then
    begin
    FileName := OpenDialog1( 4);
    if Filename = '' then Exit;
    SetWindowText(hDataEdit, PChar(FileName));
    end else // data file procedures below are in  DataFilesU.pas
    case LOWORD(wParam) of
      ID_SaveFixedBut: SaveFixed;
      ID_LoadFixedBut: LoadFixed;
      ID_SaveData1But: SaveRecords(GetWindowStr(hDataEdit));
      ID_LoadData1But: LoadRecords(GetWindowStr(hDataEdit));
      ID_SaveVar1But: SaveVarData(GetWindowStr(hVarEdit));
      ID_LoadVar1But: LoadVarData(GetWindowStr(hVarEdit));
      ID_SaveStrBut: SaveStringRecs;
      ID_GetListBut: LoadListBox;
      ID_LoadStrBut: Load1StringRec;
      end;
  end;
end;


procedure GetTabInfo;
var
TabInfo: TTCItem;
aryChar: Array[Zero..31] of Char;
begin
// this gets the text and LParam for the second tab
TabInfo.mask := TCIF_TEXT or TCIF_PARAM;
TabInfo.pszText := @aryChar;
TabInfo.cchTextMax := 32;
SendMessage(hTab1, TCM_GETITEM, One, Integer(@TabInfo));
MessageBox(hForm1, PChar(TabInfo.pszText+', lParam '+Int2Str(TabInfo.lParam)),
           'Tab 2 Info', MB_ICONINFORMATION);
end;


procedure SetTabInfo;
var
TabInfo: TTCItem;
Sel: Integer;
begin
TabInfo.mask := TCIF_TEXT;
TabInfo.pszText:= ' New Tab Text ';
SendMessage(hTab1, TCM_SETITEM, One, Integer(@TabInfo));
{ the TCM_SETITEM message will change the tab text and redraw the tab control.
  but it will NOT redraw any child controls (the pages). It will overdraw anything
  visible on the tab control.  So you will have to use code (below)
  to tell the system to redraw the page that is shown}
Sel := SendMessage(hTab1, TCM_GETCURSEL,Zero,Zero);
case Sel of
// I use the RedrawWindow( ) because it does child windows also
  Zero: RedrawWindow(hPage1, nil,Zero, RDW_ERASE or RDW_FRAME or RDW_INVALIDATE);
  One: RedrawWindow(hPage2, nil,Zero, RDW_ERASE or RDW_FRAME or RDW_INVALIDATE
                    or RDW_ALLCHILDREN);
  Two: RedrawWindow(hPage3, nil,Zero, RDW_ERASE or RDW_FRAME or RDW_INVALIDATE
                    or RDW_ALLCHILDREN);
  end;
end;



function MessageFunc(hWnd,Msg,wParam,lParam:Integer):Integer; stdcall;
begin
Result := Zero;
case Msg of
  WM_DESTROY: PostQuitMessage(Zero);

  WM_NOTIFY:
    begin
    if (wParam = ID_TabCtrl) then // check for Tab control ID
      if (PNMHdr(lParam).code = TCN_SELCHANGE) then
        begin
        { the TCN_SELCHANGE signals a new tab is selected,
          but you will need to get which tab this message is for
          with the TCM_GETCURSEL message}
        case SendMessage(hTab1, TCM_GETCURSEL,Zero,Zero) of
        // show the page that is now selected
          Zero: begin
            ShowWindow(hPage1,SW_SHOW);
            EnableWindow(GetDlgItem(hForm1, ID_LoadTBut), True);
            EnableWindow(GetDlgItem(hForm1, ID_SaveTBut), True);
            SetFocus(hPage1);
            end;
          One: begin ShowWindow(hPage2,SW_SHOW); SetFocus(hSplitEdit); end;
          Two: begin ShowWindow(hPage3,SW_SHOW); SetFocus(hDataEdit); end;
          end;
        Exit;
        end else
        if (PNMHdr(lParam).code = TCN_SELCHANGING) then
        begin
        // the TCN_SELCHANGING signals a tab is now UN-selected
        case SendMessage(hTab1, TCM_GETCURSEL,Zero,Zero) of
        // hide the page that is now Un-selected
          Zero: begin
            ShowWindow(hPage1,SW_HIDE);
            EnableWindow(GetDlgItem(hForm1, ID_LoadTBut), False);
            EnableWindow(GetDlgItem(hForm1, ID_SaveTBut), False);
            end;
          One: ShowWindow(hPage2,SW_HIDE);
          Two: ShowWindow(hPage3,SW_HIDE);
          end;
        Exit;
        end;
    end;

  WM_COMMAND: case LOWORD(wParam) of
    ID_ExitBut: PostMessage(hForm1, WM_CLOSE, Zero, Zero);
    ID_LoadTBut: LoadTextFile; // loads a text file into the edit
    ID_SaveTBut: SaveTextFile; // saves a Text file from the edit
    ID_TabGetBut: GetTabInfo; // gets some tab information
    ID_TabSetBut: SetTabInfo;
    end;
  end;
Result := DefWindowProc(hWnd,Msg,wParam,lParam);
end;


procedure MakePage2(tabRect1: TRect);
var
pSpecialDir : PItemIdList;
hNew: Integer;
TabInfo: TTCItem;
begin
{ for a "Page" in the Tab Control, I will create and use a container window.
  Page 2 is a system STATIC control, but I use it as a container window, NOT
  as a static window, so I sub-class it to get the button clicks.
  I placed the WS_EX_CONTROLPARENT  ex-style in this so Tab key press will move focus}
hPage2 := CreateWindowEx(WS_EX_CONTROLPARENT, 'STATIC', 'Page2', WS_CHILD or WS_BORDER,
                TabRect1.Left,TabRect1.Top, TabRect1.Right, TabRect1.Bottom,
                hTab1, 44, hInstance, nil);
{This hPage2 is NOT visible because the Text Edit Page is the first shown.
 And I have placed a border on it with WS_BORDER so you can see the
 size of it on the Tab Control, and it's position there}

SetWindowLong(hPage2, GWL_WNDPROC, Cardinal(@Page2MsgFunc));
// I do NOT get the system STATIC window Proc function address here
// I will use the DefWndProc for this Static, since I do not want static display

// I create buttons and edits below with hPage2 as their parent
MakeButton(246,34, 100, butHeight, 'Get File and Copy', hPage2, ID_CopyFileBut);

hSplitEdit := CreateWindowEx(WS_EX_CLIENTEDGE, 'EDIT',
           '? Path and File Name for Split goes here', WS_VISIBLE or WS_CHILD or
           ES_AUTOHSCROLL or WS_TABSTOP, 6, 114, 506, 22,hPage2, Zero,hInstance,nil);
SendMessage(hSplitEdit,WM_SETFONT,VarFont, Zero);

MakeButton(518,114, 80, butHeight, 'Get File to Split', hPage2, ID_OpenSplitBut);
// below I create 2 Radio buttons for split file creation options
hNew := CreateWindow('BUTTON','3 Equal Pieces Split',
              WS_VISIBLE or WS_CHILD or BS_AUTORADIOBUTTON or BS_TEXT,
              6,140,116,21,hPage2,ID_EqualRB,hInstance,nil);
SendMessage(hNew,WM_SETFONT,VarFont,Zero);
SendMessage(hNew, BM_SETCHECK, One, Zero);
SendMessage(CreateWindow('BUTTON','1 Megabyte Split',
             WS_VISIBLE or WS_CHILD or BS_AUTORADIOBUTTON or BS_TEXT or WS_GROUP,
             6,163,98,21,hPage2,ID_1MegRB,hInstance,nil),WM_SETFONT,VarFont,Zero);
MakeButton(144,148, 82, butHeight, 'Start Split File', hPage2, ID_SplitBut);

{ Below is code to get the Personal Folder file path (known as My Documents)
  for the current user and put the path in the PersonalFolder string.
  It requires the Shell function  SHGetSpecialFolderLocation( ) }
SHGetSpecialFolderLocation(hForm1, CSIDL_PERSONAL, pSpecialDir);
{there are several folders recorded in the system for each User, that the
 SHGetSpecialFolderLocation function can get the path for,
 like CSIDL_PROGRAMS or CSIDL_SENDTO }
SetLength(PersonalFolder, 1023);
PersonalFolder[1] := #0;
{you will need to get a text path from the PItemIdList
 with SHGetPathFromIDList. Remember, it is posible that there
 is NO personal folder registered for this user}
SHGetPathFromIDList(pSpecialDir, PChar(PersonalFolder));
// now PersonalFolder has the file path to folder, if registered
CoTaskMemFree(pSpecialDir);
// ALWAYS Free any PItemIdList you get from the system
SetLength(PersonalFolder, PCharLength(PChar(PersonalFolder)));
// Always find out if the special folder Exists on disk
if (Length(PersonalFolder) < 4) or (not DirectoryExists(PersonalFolder)) then
    PersonalFolder := 'C:\';

hFolderEdit := CreateWindowEx(WS_EX_CLIENTEDGE, 'EDIT',
           PChar(PersonalFolder), WS_VISIBLE or WS_CHILD or ES_AUTOHSCROLL or WS_TABSTOP,
           6, 214, 490, 22,hPage2, Zero,hInstance,nil);
SendMessage(hFolderEdit,WM_SETFONT,VarFont, Zero);
hRestEdit := CreateWindowEx(WS_EX_CLIENTEDGE, 'EDIT',
           '? Path and File Name for Restore goes here', WS_VISIBLE or WS_CHILD or
           ES_AUTOHSCROLL or WS_TABSTOP, 6, 298, 490, 22,hPage2, Zero,hInstance,nil);
SendMessage(hRestEdit,WM_SETFONT,VarFont, Zero);

MakeButton(502,298, 96, butHeight, 'Get File to Restore', hPage2, ID_OpenResBut);
MakeButton(6,326, 98, butHeight, 'Start Restore File', hPage2, ID_RestoreBut);

{the next code is just for an example of making a Tab Control with Buttons.
 Include the  TCS_BUTTONS  flag to get buttons on a Tab Control.
 This tab button control does not do anything}
hButTab := CreateWindowEx(WS_EX_LEFT, WC_TABCONTROL, nil,
    TCS_BUTTONS or WS_CHILD or WS_BORDER or WS_TABSTOP or
    WS_CLIPSIBLINGS or WS_VISIBLE or TCS_HOTTRACK,
    {181,332}427,12, 170, butHeight, hPage2, Zero, hInstance,nil);
SendMessage(hButTab,WM_SETFONT,VarFont,Zero);

TabInfo.mask := TCIF_TEXT or TCIF_PARAM;
// the mask tells the system which members of the TTCItem to read and use
TabInfo.pszText:= ' First ';
// the pszText is a PChar that will set the Text on the tab item
TabInfo.lParam:= 200;
SendMessage(hButTab, TCM_INSERTITEM, Zero, Integer(@TabInfo));

TabInfo.pszText:= ' Second ';
TabInfo.lParam:= 201;
SendMessage(hButTab, TCM_INSERTITEM, One, Integer(@TabInfo));

TabInfo.pszText:= ' Button 3 ';
TabInfo.lParam:= 202;
SendMessage(hButTab, TCM_INSERTITEM, Two, Integer(@TabInfo));
end;


procedure MakePage3(tabRect1: TRect);
var
sDC: Cardinal;
pStr: PChar;
Size1: TSize;

begin
{ Page 3 is a "Panel" window that is a container window to show and hide as
 a page in the Tab Control}
hPage3 := MakePanel(tabRect1.Left,tabRect1.Top, tabRect1.Right,
    tabRect1.Bottom, hTab1, PanelFunc1, 55, psTab);
// MakePanel function is in the MakeApp.pas unit
ShowWindow(hPage3, SW_HIDE);
// hide the panel because the Text Edit page is the first to show

// I create buttons and Edits as children of hPage3
MakeButton(170,28, 118, butHeight, 'Save Fixed Data File', hPage3, ID_SaveFixedBut);
MakeButton(314,28, 118, butHeight, 'Load Fixed Data File', hPage3, ID_LoadFixedBut);
MakeButton(491,64, 110, butHeight, 'Get Data File Name', hPage3, ID_DataNameBut);

hDataEdit := CreateWindowEx(WS_EX_CLIENTEDGE, 'EDIT',
           '? Path and Data File Name for Data Array File goes here',
           WS_VISIBLE or WS_CHILD or ES_AUTOHSCROLL or WS_TABSTOP,
           6, 66, 480, 21,hPage3, Zero, hInstance,nil);
SendMessage(hDataEdit,WM_SETFONT,VarFont, Zero);

// the next code will get the text width for a 61 character string in a fixed width font

GetMem(pStr, 62);
FillChar(pStr^, 61, 'k');
pStr[61] := #0;
sDC := GetDC(Zero);
SelectObject(sDC, Font2); // Font2 is a fixed width font
GetTextExtentPoint32(sDC, pStr, 61, Size1);

{ I make this EDIT the width needed to display 61 text characters
 this edit is used to set text in a 63 length fixed string, so it can not have
 more than 63 charaters in it, it can not have the ES_AUTOHSCROLL }
hStrEdit := CreateWindowEx(WS_EX_CLIENTEDGE, 'EDIT',
           '63 Character Fixed String Data for Array Goes Here',
           WS_VISIBLE or WS_CHILD or WS_TABSTOP,
           6, 106, Size1.cx+6, Size1.cy+6,hPage3, Zero, hInstance,nil);
SendMessage(hStrEdit,WM_SETFONT,Font2, Zero);

GetTextExtentPoint32(sDC, pStr, 9, Size1);
ReleaseDC(Zero, sDC);
FreeMem(pStr);
{ this Edit will get a number as text for a Cardinal variable,
 so I make it wide enough for 9 text charaters }
hIntEdit := CreateWindowEx(WS_EX_CLIENTEDGE, 'EDIT',
           '12345', WS_VISIBLE or WS_CHILD or ES_NUMBER or WS_TABSTOP, 6, 136,
           Size1.cx+7, Size1.cy+6,hPage3, Zero, hInstance,nil);
SendMessage(hIntEdit,WM_SETFONT,Font2, Zero);

MakeButton(170,138, 118, butHeight, 'Save Data Array File', hPage3, ID_SaveData1But);
MakeButton(314,138, 118, butHeight, 'Load Data Array File', hPage3, ID_LoadData1But);

hVarEdit := CreateWindowEx(WS_EX_CLIENTEDGE, 'EDIT',
       PChar(PersonalFolder+'\varData1.vsdf'), WS_VISIBLE or WS_CHILD or
       ES_AUTOHSCROLL or WS_TABSTOP, 6, 211, 480, 21,hPage3, Zero, hInstance,nil);
SendMessage(hVarEdit,WM_SETFONT,VarFont, Zero);

MakeButton(12,237, 124, butHeight, 'Save Variable Data File', hPage3, ID_SaveVar1But);
MakeButton(150,237, 124, butHeight, 'Load Variable Data File', hPage3, ID_LoadVar1But);
MakeButton(214,278, 120, butHeight, 'Make a Text Rec File', hPage3, ID_SaveStrBut);
MakeButton(210,310, 128, butHeight, 'Get List from File Header', hPage3, ID_GetListBut);
MakeButton(214,342, 120, butHeight, '<-- Load Text from List', hPage3, ID_LoadStrBut);
// list box below displays a list of text strings in a file 
hListBox := MakeListBox(4,282,200,90,hPage3,#255'No File Loaded'#0#0,
        WS_VISIBLE or WS_CHILD or LBS_NOTIFY
              or WS_VSCROLL or WS_CLIPSIBLINGS or WS_TABSTOP or WS_DISABLED);
hEdit2 := CreateWindowEx(WS_EX_CLIENTEDGE,'EDIT',nil,
    WS_VISIBLE or WS_CHILD or ES_LEFT or ES_AUTOVSCROLL {or WS_VSCROLL or WS_HSCROLL} or
    ES_MULTILINE, 364,278, 230, 88,hPage3,Zero,hInstance,nil);
SendMessage(hEdit2,WM_SETFONT,VarFont,Zero);
end;


procedure MakeControls;
var
TabInfo: TTCItem;
tabRect: TRect;
begin
// sFileSize is the string to draw that has the File Size for file splits
sFileSize := 'no split file';
// MakeFont is in the MakeApp unit
Font1 := MakeFont(-15, 10, 'Arial', True);
Font2 := MakeFont(-13, Zero, 'Courier New');
Font3 := MakeFont(-13, Zero, 'Times New Roman', True);

GetClientRect(hForm1, TabRect);
// TabRect will be used for control placement and Tab page sizes
// I stsrt with the TabRect as the Form's Client Rect

TabRect.Bottom := TabRect.Bottom - 30;
// MakeButton is in the MakeApp unit
MakeButton(TabRect.Right-94,TabRect.Bottom,
                    84, butHeight, 'E X I T', hForm1, ID_ExitBut, Font1);

MakeButton(6,TabRect.Bottom, 84, butHeight, 'Load Text File', hForm1, ID_LoadTBut);
MakeButton(110,TabRect.Bottom, 84, butHeight, 'Save Text File', hForm1, ID_SaveTBut);
MakeButton(300,TabRect.Bottom, 76, butHeight, 'Get Tab Info', hForm1, ID_TabGetBut);
MakeButton(386,TabRect.Bottom, 76, butHeight, 'Set Tab Info', hForm1, ID_TabSetBut);

    //  Next is code for the Tab Control  / / /
SetRect(TabRect, 4, One, TabRect.Right - 8, TabRect.Bottom -12);
{I adjust the TabRect (the Client Rect of hForm1) to have a 4 pixel space on the
 left and right of the Tab control, and a 42 pixel space below it for the buttons}


{the Tab control creation has the WS_EX_CONTROLPARENT to pass the Tab messages.
 I also have the TCS_HOTTRACK style bit, so mouse tracking is enabled}
hTab1 := CreateWindowEx(WS_EX_CONTROLPARENT, WC_TABCONTROL, nil,
    WS_VISIBLE or WS_CHILD or BS_NOTIFY or WS_TABSTOP or
    WS_CLIPSIBLINGS or TCS_HOTTRACK or WS_CLIPCHILDREN,
    TabRect.Left,TabRect.Top, TabRect.Right, TabRect.Bottom,
    hForm1, ID_TabCtrl, hInstance,nil);
{the WC_TABCONTROL constant is for the text 'SysTabControl32' }
SendMessage(hTab1,WM_SETFONT,Font3,Zero);
// be sure to set the tab font before you call TabCtrl_AdjustRect

{ to Add Tabs, you must set the TTCItem record, TabInfo, for the new item (tab) }
with TabInfo do
  begin
  // this will add three tabs to tab control
  mask := TCIF_TEXT or TCIF_PARAM;
// the mask tells the system which members of the TTCItem to read and use
  pszText:= ' Text Editor ';
// the pszText is a PChar that will set the Text on the tab item
  lParam:= 100;
{ the lParam is a user defined integer that you can use to
  store information for each separate tab}

//Place a new tab (item) in hTab1 with a TCM_INSERTITEM in SendMessage( )
  SendMessage(hTab1, TCM_INSERTITEM, Zero, Integer(@TabInfo));

  pszText:= ' Split a File '; // second tab item
  lParam:= 101;
  SendMessage(hTab1, TCM_INSERTITEM, One, Integer(@TabInfo));

  pszText:= ' Save Data to File '; // third tab item
  lParam:= 102;
  SendMessage(hTab1, TCM_INSERTITEM, Two, Integer(@TabInfo));
  end;

GetClientRect(hTab1, TabRect);

TabCtrl_AdjustRect(hTab1, False, @TabRect);
{ the TabCtrl_AdjustRect is suppose to set the rectangle to the correct
  size of the "Page" area for the Tab Control. It is close, but I found it
  nessary increase the width and decrease the height to get the correct size
  I needed for pages. The next SetRect( ) does this}
SetRect(TabRect, TabRect.Left-Two, TabRect.Top+One,
        (TabRect.Right+Two) - TabRect.Left, TabRect.Bottom -(TabRect.Top+One));
{you might like the tab page size that TabCtrl_AdjustRect gives you, or
 my adjustment of that page size, or you may want to do your own size}


{I will create three controls as Pages for the Tab control, these controls
 will be a child of the hTab1 and 2 are "Container" windows. A Tab control does
 NOT have any pages that are changed with the selection of a Tab, so you will
 need to show and hide the 3 page controls when the Tab selection changes.
 This will hide and show all of the controls these pages contain.
 Since the Tab control does not change pages, you will need to get the
 WM_NOTIFY message and change them in the TCN_SELCHANGE notify}

{Page one is just a multi-line Edit}
hPage1 := CreateWindowEx(WS_EX_CLIENTEDGE,'Edit','Type Text Here ->',
    WS_VISIBLE or WS_CHILD or ES_LEFT or ES_AUTOVSCROLL or WS_VSCROLL or WS_HSCROLL or
    ES_MULTILINE, TabRect.Left,TabRect.Top, TabRect.Right,
    TabRect.Bottom,hTab1,Zero,hInstance,nil);
SendMessage(hPage1,WM_SETFONT,Font2,Zero);

pPageProc := Pointer(SetWindowLong(hPage1, GWL_WNDPROC, Integer(@PageFunc)));

// MakePage2 procedure creates the second page for splitting a file
MakePage2(tabRect);

// MakePage3 procedure creates the third page for multi-Data files
MakePage3(tabRect);

SetFocus(hPage1);
end;


function MakeProgram: Boolean;
begin
Result := False;
// SetWinClass and MakeForm are in the MakeApp unit
if SetWinClass('FilesU Class', @MessageFunc) = Zero then Exit;
hForm1 := MakeForm(DEF, DEF, 620, 443, 'Read and Write Files');
if hForm1 = Zero then Exit;
Result := True;
MakeControls;
end;


initialization

finalization
DeleteObject(Font1);
DeleteObject(Font2);
DeleteObject(Font3);

end.
 