unit SplitFilesU;

interface

procedure CopyAFile;
{the CopyAFile procedure is your basic code to Copy a file}

procedure StartSplit(const InFile: String);
{the  StartSplit procedure will take a file path and name, and then divide
(split) that file into smaller files

The Split3Pieces( ) and Split1Meg( ) procedures do the file splits}

procedure StartRestore(const InFile: String);
{the  StartRestore procedure will take a file path and name for the first
piece of a file split and combine (restore) the file pieces back to the
orriginal file}


implementation

uses
  MakeApp, Windows, Messages, UseFilesU, SmallUtils;

const
// FileID is a safety Identifier for 1 Meg split files
FileID: Cardinal = $C2FAD1;
// ChunkSize is the memory block size used for file data transfers
// ChunkSize is 512 (hex 200) because it will give faster performance
ChunkSize: Cardinal = $200;
// Meg is a One megabyte constant
Meg: Cardinal = $100000;


{ All of the file work below is based on opening two files, one to read from
 and one to write to. Then all of these will do a "While" loop, that will
 read "ChunkSize" bytes from the read file and then writes these bytes to
 the write file.

  The first procedure is the CopyAFile procedure below, which shows an
  Open and Save dialog box to get file names, and then copies an entire
  file to another location.}

procedure CopyAFile;
var
ReadName, WriteName: String;
hFileRead, hFileWrite, Size1, BytesRead, BytesWrite: Cardinal;
BadFile: Boolean;
pBufMem: Pointer;
FileTime1: TFileTime;
begin
ReadName := OpenDialog1(5);
// ReadName is the file name to copy from
if ReadName = '' then Exit;
WriteName := OpenDialog1(6);
// WriteName is the file name for the copy of the file
if WriteName = '' then Exit;

hFileRead := CreateFile(PChar(ReadName),GENERIC_READ,FILE_SHARE_READ,nil,
               OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL or
               FILE_FLAG_SEQUENTIAL_SCAN, Zero);
// the hFileRead will be used to read the bytes from
if hFileRead = INVALID_HANDLE_VALUE then
  begin
  SysErrorMsg(CreateErrText+#10+ReadName, CreateErrTitle);
  Exit;
  end;

Size1 := GetFileSize(hFileRead, @BytesWrite);
if (Size1 = MaxDWord) or (BytesWrite <> Zero) then
  begin // test the file size for larger than 4 gigs
  CloseHandle(hFileRead);
  MessageBox(hForm1, PChar('ERROR - FileSize is to large for copy'#10+ReadName),
            'ERROR - Did not Create File', MB_ICONERROR);
  Exit;
  end;

hFileWrite := CreateFile(PChar(WriteName),GENERIC_WRITE,FILE_SHARE_READ,nil,
         CREATE_ALWAYS, FILE_ATTRIBUTE_NORMAL or FILE_FLAG_SEQUENTIAL_SCAN,Zero);
// hFileWrite is the Copied file where the bytes from hFileRead are written
if hFileWrite = INVALID_HANDLE_VALUE then
  begin
  CloseHandle(hFileRead);
  SysErrorMsg(CreateErrText+#10+WriteName, CreateErrTitle);
  Exit;
  end;

if Size1 = 0 then
  begin
  CloseHandle(hFileRead);
  CloseHandle(hFileWrite);
  Exit; // if there are no bytes to read then Exit;
  end;

{ pBufMem is the byte Storage area (buffer) of memory
used to hold the data transfered from read file to write file}
GetMem(pBufMem, ChunkSize);

BadFile := False; // BadFile is used to delete a bad copy file

while Size1 > Zero do
  begin { Keep reading and writing bytes until all bytes are copied.
     ChunkSize is used for the amount to read, if there are less than ChunkSize
     bytes to read, then ReadFile will only read the amount of bytes left,
     it will NOT read past the end of the file. BytesRead will have the correct
     amount of bytes acually read from the file. }
  if (not ReadFile(hFileRead,pBufMem^,ChunkSize,BytesRead,nil)) then
    begin
    SysErrorMsg(ReadErrText, ReadErrTitle);
    BadFile := True;
    Break;
    end;

  if BytesRead = Zero then Break;

  if (not WriteFile(hFileWrite,pBufMem^,BytesRead,BytesWrite, nil)) or
     (BytesRead <> BytesWrite) then
    begin
    SysErrorMsg(WriteErrText, WriteErrTitle);
    BadFile := True;
    Break;
    end;
  Dec(Size1, BytesWrite);
  end;  // while loop

// to make a copy file you should get the Modified Date and set that in new file
if GetFileTime(hFileRead,nil,nil,@FileTime1) then
  SetFileTime(hFileWrite,nil,nil,@FileTime1);
// Close All file handles you open
CloseHandle(hFileRead);
CloseHandle(hFileWrite);
FreeMem(pBufMem); // free your memory buffer

if BadFile then // if a file is bad then delete the file
  DeleteFile(PChar(WriteName))
  else
  MessageBox(hForm1, PChar('Copy File is Finished, you can see the file at'#10
           +WriteName),'FINISHED, Copy File', MB_ICONINFORMATION);
end;



// / / / / / / / / / / / / / / / / / / / / / / / / / / / / /

// CODE BELOW FOR FILE SPLITS

{ the StartSplit procedure below, is used to begin both the 3 piece and
  One Meg file split. The large file to be split is Opened in the StartSplit
  procedure, and it's handle is passed to the 2 split procedures,
  Split3Pieces and Split1Meg. the Split3Pieces( ) procedure will read from
  a source file and create and write to 3 destination files in a FOR LOOP,
  placing one third of file Data bytes in each of the destination files}

procedure Split3Pieces(hInFile: Cardinal; var OutFile: String);
var
hChopFile, Size1, ChopSize, BytesRead,
BytesWrite, ReadSize, Total, i: Cardinal;
pBufMem: Pointer;
BadFile: BOOL;
aryFiles: Array[One..3] of String;

begin
// hInFile is the handle of the file created in the StartSplit procedure
Size1 := GetFileSize(hInFile, @ReadSize);
if (Size1 = MaxDWord) or (ReadSize <> Zero) then
  begin // test the file size for larger than 4 gigs
  CloseHandle(hInFile);
  MessageBox(hForm1, 'ERROR - FileSize is to large'#10+'Over 4 Gigs',
            'ERROR - Did not Create File', MB_ICONERROR);
  Exit;
  end;

if Size1 < 3 then
  begin
  // you will need at least 3 bytes in the file
  CloseHandle(hInFile);
  MessageBox(hForm1, 'ERROR - FileSize is to Small, must be Larger than 2 bytes',
             'ERROR - Can NOT Split File', MB_ICONERROR);
  Exit;
  end;

{ I will use a memory buffer in pBufMem for the file byte transfers
  I get a memory block of ChunkSize in pBufMem with GetMem( ) }
GetMem(pBufMem, ChunkSize);

Total := Zero; // Total will record the bytes written to file in each WriteFile
BadFile := False;
// BadFile is used if there is a file write error, to delete the files
hChopFile := Zero;
SetLength(OutFile, Length(OutFile)- One);

for i := One to 3 do // this will loop three times, and create a new file each loop
  begin
  if BadFile then Break;
  aryFiles[i] := OutFile+Int2Str(i);// aryFiles will record file names for delete

  // create file and test for valid file handle
  hChopFile := CreateFile(PChar(aryFiles[i]),GENERIC_WRITE,FILE_SHARE_READ,nil,
               CREATE_ALWAYS,FILE_ATTRIBUTE_NORMAL or FILE_FLAG_SEQUENTIAL_SCAN,Zero);
  if hChopFile = INVALID_HANDLE_VALUE then
    begin
    SysErrorMsg(CreateErrText+#10+aryFiles[i], CreateErrTitle);
    BadFile := True;
    Break;
    end;
  // ChopSize is the new file size, one thid of total bytes
  // be sure to adjust ChopSize for the last piece, using Total
  if i = 3 then
    ChopSize := Size1-Total
    else
    ChopSize := Size1 div 3;

  while ChopSize > Zero do
    begin // keep Reading and writing bytes until Chopsize bytes are transfered
    // you will need to adjust the ReadSize for the last file read
    if ChopSize > ChunkSize then ReadSize := ChunkSize else ReadSize := ChopSize;
     if (not ReadFile(hInFile,pBufMem^,ReadSize,BytesRead,nil)) or
     (ReadSize <> BytesRead) then
        begin
        SysErrorMsg(ReadErrText, ReadErrTitle);
        BadFile := True;
        Break;
        end;

    if BytesRead = Zero then Break;

    if (not WriteFile(hChopFile,pBufMem^,BytesRead,BytesWrite,nil)) or
     (BytesRead <> BytesWrite) then
      begin
      SysErrorMsg(WriteErrText, WriteErrTitle);
      BadFile := True;
      Break;
      end;
    Dec(ChopSize, BytesWrite);
    Inc(Total, BytesWrite);
    end;
  // Close All file handles you open
  CloseHandle(hChopFile);
  hChopFile := Zero;
  end; // for loop

FreeMem(pBufMem);

CloseHandle(hInFile);
if hChopFile <> Zero then
  CloseHandle(hChopFile);

if BadFile then
  begin // if a file is bad then delete all three piece files
  for Size1 := One to 3 do
    DeleteFile(PChar(aryFiles[Size1]));
  end else
  MessageBox(hForm1, PChar('Three Piece Split is Finished, you can see the files'+
           ' at'#10+aryFiles[One]),'FINISHED, 3 Piece Split', MB_ICONINFORMATION);
end;


{ the Split1Meg( ) procedure will read from a source file and write
  to a destination file in a FOR LOOP, placing one Meg of Data bytes
  in the destination file . .

  This code is almost the same as in the Split3Pieces( ) above.
  I included it here because, in this one I place a "File Header"
  on the first file. I think it is important to always have a "File Header"
  on your files.}

procedure Split1Meg(hInFile: Cardinal; var OutFile, FileName: String);
var
hChopFile, Size1, ChopSize, BytesRead,
BytesWrite, ReadSize, Total, numPieces, HeaderSize, i: Cardinal;
NameLength: Word;
BadFile: Bool;
pMemBuf: Pointer;
CreateTime: TFileTime;

  function tryWrite(var Source; Size: Cardinal; opPos: Integer): Bool;
  begin
  {because WriteFile needs to be called many times, I placed it in this function.
   This function will Write the File and test for a file write Error}
  if WriteFile(hChopFile,Source,Size,BytesWrite,nil) and (BytesWrite = Size) then
    Result := False // Result is False for a Successful Write
    else
    begin
    Result := True;
    // a Result of True will end the file split
    BadFile := True;
    // BadFile as True will delete destination file
    SysErrorMsg(WriteErrText, WriteErrTitle+' '+Int2Str(opPos));
    // show a file write Error Message
    // with a debug reference of where it happened in opPos
    end;
  end;

begin

if NameLength < 3 then // checks for empty string
  begin
  CloseHandle(hInFile);
  MessageBox(hForm1, 'ERROR - File name is less than 3 characters long',
             'ERROR - Can NOT Create a File', MB_ICONERROR);
  Exit;
  end;

Size1 := GetFileSize(hInFile, @ReadSize);
// get file size to test if it is larger than a Megabyte
if (Size1 = MaxDWord) or (ReadSize <> Zero) then
  begin
  CloseHandle(hInFile);
  MessageBox(hForm1, 'ERROR - FileSize is incorrect, to large'#10'Over 4 Gigs',
             'ERROR - Can NOT Split File', MB_ICONERROR);
  Exit;
  end;

if Size1 <= Meg then
  begin
  CloseHandle(hInFile);
  MessageBox(hForm1, 'ERROR - FileSize is to Small, must be Larger than a Megabyte',
             'ERROR - Can NOT Split File', MB_ICONERROR);
  Exit;
  end;

NameLength := Length(FileName);
// these created files will have a File Header with the file name in it
HeaderSize := SizeOf(FileID) + SizeOf(numPieces) + SizeOf(NameLength) +
              NameLength + SizeOf(CreateTime);
{ HeaderSize is the amount of bytes added as the file header in the
  first file piece. This header has 2 Cardinals (FileID, numPieces),
  a Word (NameLength), and a TFileTime (CreateTime), which is 18 bytes,
  and the number of text characters in FileName, NameLength}
Size1 := Size1 + HeaderSize;
// Add the HeaderSize to the Size1 to get the total size of bytes for split.

numPieces := Size1 div Meg;
// you need to find out how may new files to create
if Size1 mod Meg <> Zero then
  Inc(numPieces);

GetMem(pMemBuf, ChunkSize);
{ I will use a ChunkSize memory Buffer to get and transfer the file bytes in the
  read and write operations. A ChunkSize of $200 seems to give the best performance
  You should experiment with different chunk sizes to see what difference it makes}

  try // try is here so finally will call FreeMem( )
  Total := HeaderSize;  // Total will record the amount read from the source file
  BadFile := False;
  for i := One to numPieces do // FOR LOOP for each file piece
    begin
    if BadFile then Break;
    // OutFile if the file Path and Name for each piece
    SetLength(OutFile, Length(OutFile)- Length(Int2Str(i-One)));
    OutFile := OutFile+Int2Str(i); // add the Piece Number to the file name

    hChopFile := CreateFile(PChar(OutFile),GENERIC_WRITE,Zero,nil,
               CREATE_ALWAYS,FILE_ATTRIBUTE_NORMAL or FILE_FLAG_SEQUENTIAL_SCAN,Zero);
    if hChopFile = INVALID_HANDLE_VALUE then
      begin
      CloseHandle(hInFile);
      SysErrorMsg(CreateErrText+#10+OutFile, CreateErrTitle);
      Exit;
      // pBufMem freed in the finally
      end;

    if i = numPieces then
      ChopSize := Size1-Total // last piece will be smaller than a Meg
      else
      ChopSize := Meg;

  {File Headers are an important and widely used way to store data for identifing
   and using the bytes in a file. You must be able to place the information you
   need for using a file, in it's file Header}

    if i = One then // only for the first piece, add a File header
      begin
      if tryWrite(FileID, SizeOf(FileID), -1) then Exit;
      { I add a File Identification number for safty, since there may be other
       files with the .1m1 file extentions}
      if tryWrite(numPieces, SizeOf(numPieces), -2) then Exit;
  // I must add the Number of file Pieces, to use when restoring this file
      if tryWrite(NameLength, SizeOf(NameLength), -3) then Exit;
  // For all text in a file, you will need to write its character length to file
      if tryWrite(FileName[One], NameLength, -4) then Exit;
      { you can NOT use the SizeOf( ) function for text strings.
        I use a reference to the first character in the FileName string,
        this will write the NameLength number of characters to file}
      GetFileTime(hInFile, nil, nil, @CreateTime);
      if tryWrite(CreateTime, SizeOf(CreateTime), -5) then Exit;
      ChopSize := Meg - HeaderSize;//(NameLength + HeaderSize);
      // you will need to change the ChopSize in order to get a one Meg file
      end;


  while ChopSize > Zero do
    begin
    if ChopSize > ChunkSize then ReadSize := ChunkSize else ReadSize := ChopSize;
     if not ReadFile(hInFile,pMemBuf^,ReadSize,BytesRead,nil) or
     (ReadSize <> BytesRead) then
        begin
        SysErrorMsg(ReadErrText, ReadErrTitle+' '+Int2Str(i));
        BadFile := True;
        Exit;
        end;

    if BytesRead = Zero then Break;
  {this while loop is like the one above in the Split3Pieces procedure.
  But now I have added the tryWrite function, which will test the
  file write operation for success and return True if there i a failure}
    if tryWrite(pMemBuf^, BytesRead, i) then Exit;

    Dec(ChopSize, BytesWrite);
    // I record the Total bytes written to the file
    Inc(Total, BytesWrite);
    end;

  CloseHandle(hChopFile);
  hChopFile := Zero
  end; // while loop
  
  finally
  FreeMem(pMemBuf);

  CloseHandle(hInFile);
  if hChopFile <> Zero then
    CloseHandle(hChopFile);
  end;

if not BadFile then // I do not delete the bad files created
MessageBox(hForm1, PChar('One Meg Split is Finished, you can see the files at'#10+
           OutFile),'FINISHED, 3 Piece Split', MB_ICONINFORMATION);
end;


procedure StartSplit(const InFile: String);
var
hReadFile: Cardinal;
FileName, OutFile: String;
begin
// get the file path and name from the hSplitEdit edit box
if (InFile = '') or (InFile[One] = '?') or (not FileExists(InFile)) then
  begin
  MessageBox(hForm1, 'ERROR - You must Have a valid File Path and Name in the'+
             'File to Split Edit box', 'ERROR - Not a Valid File', MB_ICONERROR);
  Exit;
  end;
FileName := InFile;

OutFile := GetSplitFolder;
// get the uotput folder from the hFolderEdit  edit box
if OutFile = '' then Exit;

if OutFile[Length(OutFile)] <> '\' then
  OutFile := OutFile+'\'; // check for back slash
// get the OutFile path and name by adding the file name to the OutFile path
OutFile := OutFile+GetFileName(FileName);

hReadFile := CreateFile(PChar(FileName),GENERIC_READ,FILE_SHARE_READ,nil,
               OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL or FILE_FLAG_SEQUENTIAL_SCAN,Zero);
// the hReadFile created above will be used in both the Split3Pieces and Split1Meg
if hReadFile = INVALID_HANDLE_VALUE then
  begin
  SysErrorMsg(CreateErrText+#10+FileName, CreateErrTitle);
  Exit;
  end;


if SendDlgItemMessage(hPage2, ID_1MegRB, BM_GETCHECK,Zero,Zero) = BST_CHECKED then
  begin
  SetLength(OutFile, Length(OutFile)- Length(GetFileExt(OutFile)));
  // chop off the file extention for the OutFile and add the split piece extention
  OutFile := OutFile+'.1meg0';
  FileName := GetFileName(FileName);
  Split1Meg(hReadFile, OutFile, FileName);
  end else
  begin
  OutFile := OutFile+'.3p0';
  Split3Pieces(hReadFile, OutFile);
  end;
end;


// / / /  File Restore Code / / / / / / / / / / / / /


{procedure Restore3Pieces( ) will open and read 3 split files, and create and
 write a "Whole" file from the pieces}

procedure Restore3Pieces(var SplitName, OutFile: String);
var
hSplitFile, hWholeFile, Size1, ReadSize, BytesRead, BytesWrite, i: Cardinal;
pBufMem: Pointer;
BadFile: BOOL;
begin
// Create a file, hWholeFile, to write all of the pieces to
hWholeFile := CreateFile(PChar(OutFile),GENERIC_WRITE,FILE_SHARE_READ,nil,
           CREATE_ALWAYS,FILE_ATTRIBUTE_NORMAL or FILE_FLAG_SEQUENTIAL_SCAN,Zero);
if hWholeFile = INVALID_HANDLE_VALUE then
  begin
  SysErrorMsg(CreateErrText+#10+OutFile, CreateErrTitle);
  Exit;
  end;

GetMem(pBufMem, ChunkSize);
// pBufMem is the memory block the file byte transfer will be stored into
hSplitFile := Zero;
BadFile := False;
for i := One to 3 do
  begin
  if BadFile then Break;
  // set the last file extention character to the piece number
  SplitName[Length(SplitName)] := Int2Str(i)[1];
  hSplitFile := CreateFile(PChar(SplitName),GENERIC_READ,FILE_SHARE_READ,nil,
             OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL or FILE_FLAG_SEQUENTIAL_SCAN,Zero);
  // open 3 split piece files in this loop to read bytes from
  if hSplitFile = INVALID_HANDLE_VALUE then
    begin
    SysErrorMsg(CreateErrText+#10+SplitName, CreateErrTitle);
    CloseHandle(hWholeFile);
    Exit;
    end;
  Size1 := GetFileSize(hSplitFile, @ReadSize);

  while Size1 > Zero do
    begin
    // Size1 is tested to see if the file piece is at the end of it's bytes
    if Size1 > ChunkSize then ReadSize := ChunkSize else ReadSize := Size1;
    // ReadSize will be ChunkSize untill there are less bytes left in the file
    if (not ReadFile(hSplitFile,pBufMem^,ReadSize,BytesRead,nil)) or
       (ReadSize <> BytesRead) then
      begin
      SysErrorMsg(ReadErrText, ReadErrTitle);
      BadFile := True;
      Break;
      end;
    // stop loop if there are no bytes read from file
    if BytesRead = Zero then Break;
    // test file write and the amount written to file
    if (not WriteFile(hWholeFile, pBufMem^, BytesRead, BytesWrite, nil)) or
       (BytesRead <> BytesWrite) then
      begin
      SysErrorMsg(WriteErrText, WriteErrTitle);
      BadFile := True;
      Break;
      end;
    Dec(Size1, BytesWrite);
    end; // while loop
  CloseHandle(hSplitFile);
  hSplitFile := Zero;
  end; // for loop

FreeMem(pBufMem);

CloseHandle(hWholeFile);
if hSplitFile <> Zero then
  CloseHandle(hSplitFile);

// if there is a read or write error, with BadFile = true, then delete OutFile
if BadFile then
  DeleteFile(PChar(OutFile))
  else
  MessageBox(hForm1, PChar('Three Piece Restore is Finished, you can see the'+
        ' files at'#10+OutFile),'FINISHED, 3 Piece Split', MB_ICONINFORMATION);
end;



{Restore1Meg procedure will read the file header of the first 1 Meg file piece
and then combine the files together}

procedure Restore1Meg(var SplitName, OutFolder: String);
var
hSplitFile, hWholeFile, Size1, ReadSize, BytesRead,
BytesWrite, numPieces, HeaderSize, i: Cardinal;
NameLength: Word;
pBufMem: Pointer;
FileName: String;
CreateTime: TFileTime;
BadFile: BOOL;

  function tryRead(var Dest; Size: Cardinal; opPos: Integer): Bool;
  begin
  if ReadFile(hSplitFile,Dest, Size, BytesRead,nil) and (Size = BytesRead) then
    Result := False
    else
    begin
    // the  opPos  will tell you at which operation the error happened
    SysErrorMsg(ReadErrText, ReadErrTitle+' '+Int2Str(opPos));
    CloseHandle(hSplitFile);
    BadFile := True;
    Result := True;
    end;
  end;

begin
// this is like the 3 piece restore, except I read the file header for One Meg split
hSplitFile := CreateFile(PChar(SplitName),GENERIC_READ,FILE_SHARE_READ,nil,
               OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL or FILE_FLAG_SEQUENTIAL_SCAN,Zero);
if hSplitFile = INVALID_HANDLE_VALUE then
    begin
    SysErrorMsg(CreateErrText+#10+SplitName, CreateErrTitle);
    Exit;
    end;

Size1 := GetFileSize(hSplitFile, @ReadSize);
if Size1 <> Meg then
  begin
  CloseHandle(hSplitFile);
  MessageBox(hForm1, 'ERROR Meg - This is NOT a valid One Meg Split File',
             'ERROR - Not a Valid Split File', MB_ICONERROR);
  Exit;
  end;

if tryRead(i, SizeOf(i), -1) then Exit;
// this is where I read the file header from the first file piece
if i <> FileID then
  begin
  // make sure the File ID is correct
  CloseHandle(hSplitFile);
  MessageBox(hForm1, 'ERROR FileID - This is NOT a valid One Meg Split File  ',
             'ERROR - Not a Valid Split File', MB_ICONERROR);
  Exit;
  end;

if tryRead(numPieces, SizeOf(numPieces), -2) then Exit;
// all of the file header data is read out of the file in the same order it was
// written to the file in the Split1Meg( ) procedure above

if tryRead(NameLength, SizeOf(NameLength), -3) then Exit;

SetLength(FileName, NameLength);
{for any String text data you must read the number of bytes in the string first
and then set the string length so you can read the bytes from file}
if tryRead(FileName[One], NameLength, -4) then Exit;
FileName := OutFolder+FileName;
if tryRead(CreateTime, SizeOf(CreateTime), -5) then Exit;
//MessageBox(hForm1, PChar(FileName), 'FileName', MB_ICONINFORMATION);

hWholeFile := CreateFile(PChar(FileName),GENERIC_WRITE,FILE_SHARE_READ,nil,
           CREATE_ALWAYS,FILE_ATTRIBUTE_NORMAL or FILE_FLAG_SEQUENTIAL_SCAN,Zero);
{the hWholeFile is the file that is written to, with the bytes of the file pieces}
if hWholeFile = INVALID_HANDLE_VALUE then
  begin
  CloseHandle(hSplitFile);
  SysErrorMsg(CreateErrText+#10+FileName, CreateErrTitle);
  Exit;
  end;
// you must get the number of bytes used for the header and subtract it from Size1
HeaderSize := SizeOf(FileID) + SizeOf(numPieces) + SizeOf(NameLength) +
              NameLength + SizeOf(CreateTime);
Size1 := Size1 - HeaderSize;
GetMem(pBufMem, ChunkSize);
BadFile := False;
for i := One to NumPieces do // start from one
  begin
  if BadFile then Break;
  if i > One then
    begin
    // the first split piece was created before this FOR loop
    SetLength(SplitName, Length(SplitName)- Length(Int2Str(i-One)));
    // the next split file name is built from the SplitName and the  i  loop counter
    SplitName := SplitName+Int2Str(i);
    hSplitFile := CreateFile(PChar(SplitName),GENERIC_READ,FILE_SHARE_READ,nil,
               OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL or FILE_FLAG_SEQUENTIAL_SCAN,Zero);
    if hSplitFile = INVALID_HANDLE_VALUE then
      begin
      SysErrorMsg(CreateErrText+#10+SplitName, CreateErrTitle);
      BadFile := True;
      Break;
      end;

    Size1 := GetFileSize(hSplitFile, @ReadSize);
    end;


  while Size1 > Zero do
    begin
    // loop untill all bytes are copied
    if Size1 > ChunkSize then // set the ReadSize
      ReadSize := ChunkSize
      else
      ReadSize := Size1;
    if tryRead(pBufMem^,ReadSize, i) then Break;
    if BytesRead = Zero then Break;

    if (not WriteFile(hWholeFile,pBufMem^,BytesRead,BytesWrite,nil)) or
     (BytesRead <> BytesWrite) then
      begin
      SysErrorMsg(WriteErrText, WriteErrTitle);
      BadFile := True;
      Break;
      end;

    Dec(Size1, BytesWrite); // reduce Size1 to track the number of bytes written
    end;

  CloseHandle(hSplitFile);
  hSplitFile := Zero;
  end;

FreeMem(pBufMem);
SetFileTime(hWholeFile, nil, nil, @CreateTime);
CloseHandle(hWholeFile);
if hSplitFile <> Zero then
  CloseHandle(hSplitFile);
if BadFile then
  DeleteFile(PChar(FileName)) // delete the bad file
  else
  MessageBox(hForm1, PChar('One Meg Restore is Finished, you can see the files at'#10+
           FileName),'FINISHED, 1 meg Restore', MB_ICONINFORMATION);

end;


{this StartRestore takes the file path and name of the first file piece, and
will test the file name extention and call Restore3Pieces or Restore1Meg }

procedure StartRestore(const InFile: String);
var
FileName, OutFile, Ext1: String;
begin
// test for valid file name
if (InFile = '') or (InFile[One] = '?') or (not FileExists(InFile)) then
  begin
  MessageBox(hForm1, 'ERROR - You must Have a valid File Path and file Name in the'+
             'File to Restore Edit box', 'ERROR - Not a Valid File', MB_ICONERROR);
  Exit;
  end;


Ext1 := UpperCase(GetFileExt(InFile));
// the file extention will determine which File restore procedure to call

OutFile := GetSplitFolder;
if OutFile = '' then Exit;

if OutFile[Length(OutFile)] <> '\' then
  OutFile := OutFile+'\'; // insure there is a  \

if Ext1 = '.3P1' then //  3P1  extention means it is a 3 piece restore
  begin
  OutFile := OutFile+GetFileName(InFile);
  // build the output file name from the OutFile and the Infile strings
  SetLength(OutFile, Length(OutFile)- Length(Ext1));
  FileName := InFile;
  Restore3Pieces(FileName, OutFile);
  end else
  if Ext1 = '.1MEG1' then // this is a one Meg restore
  begin
  FileName := InFile;
  // the Restore1Meg will read the outFile file name from it's file header
  Restore1Meg(FileName, OutFile);
  end else
  begin
  MessageBox(hForm1, 'ERROR - You must Have a .3p1 or .1meg1 File Extention'+
             ' for the Restroe File', 'ERROR - Not a Split File', MB_ICONERROR);
  Exit;
  end;

end;

end.