unit DataFilesU;

interface

procedure SaveFixed;
{the SaveFixed and LoadFixed procedures will write and read a
 muti-segment data file, with several fixed size variables in it}
procedure LoadFixed;

procedure SaveRecords(const OutFile: String);
{the SaveRecords and LoadRecords procedures will write and read a file
 that has 8 TDataRec records in it}
procedure LoadRecords(const InFile: String);

procedure SaveVarData(const OutFile: String);
{the SaveVarData and LoadVarData procedures will write and read a file
 that has some changing size variables in it}
procedure LoadVarData(const InFile: String);

procedure SaveStringRecs;
{the SaveStringRecs procedure will write a file with 5 TStrRec records
 and a file header with 5 THeader records}

procedure LoadListBox;
{the LoadListBox procedure will read the file header and place the 5
 THeader ListText strings in the List Box}

procedure Load1StringRec;
{the Load1StringRec will get the Index from the List Box and get just
 ONE TStrRec record from the file}


implementation

uses
  MakeApp, Windows, Messages, UseFilesU, SmallUtils;


type
// the TDataRec record is a Fixed Variable record placed in a file
  TDataRec = packed Record
    TrackNum, SomeNum: Cardinal;
    aRect: TRect;
    Text: String[63];
    end;

// the TStrRec has a String, so you will need to write it's length to file
  TStrRec = packed Record
    Width, Height: Integer;
    TextLines: String;
    end;

{ THeader record is used in the file header, to keep file position and size of
  a TStrRec record. It has list text, a description which will be shown in
  a list box. Header records should only contain fixed size variables}
  THeader = packed Record
    Position, Size: Cardinal;
    ListText: String[18];
    end;

  // TOrd1 is an Ordinal type written to file in the SaveFixed procedure
  TOrd1 = (orFirst, orSecond, orMiddle, orNext, orLast);

const
{ FileDataID is a safety Identifier for the Var muti-data files
  I use 6 text characters for this one, and a Cardinal for the next one}
FileDataID: Array[0..5] of Char = 'VSDF01'; // the '01' is the version
// FileStrID is a safety Identifier for string muti-data files
FileStrID: Cardinal = 719394801;
DataFile = 'C:\Data File 1.FixedData';
// DataFile is the file path for the Fixed Variable file
StringFile = 'C:\String File 1.StrRec';
// DataFile is the file path for the Fixed Variable file


procedure SaveFixed;
var
hFile, BytesWrite: Cardinal;
// all of the fixed size variables below will be written to one file
Int1: Integer;
Word1: Word;
Real1: Real;
aRect: TRect;
aryPnt: Array[Zero..Two] of TPoint;
aryChar: Array[Zero..15] of Char;
Str1: String[32];
Ord1: TOrd1;
setOrd: Set of TOrd1;
begin
{this procedure will write several different types of
 fixed size variables to one file}
hFile := CreateFile(DataFile,GENERIC_WRITE,FILE_SHARE_READ,nil,
               CREATE_ALWAYS,FILE_ATTRIBUTE_NORMAL or
               FILE_FLAG_SEQUENTIAL_SCAN,Zero);
if hFile = INVALID_HANDLE_VALUE then
  begin
  SysErrorMsg(CreateErrText+#10+DataFile, CreateErrTitle);
  Exit;
  end;

Int1 := -12345;
Word1 := 8888;
Real1 := 987.123;
SetRect(aRect, One,Two,3,4);
aryPnt[Zero].x := 22;
aryPnt[Zero].y := 44;
aryChar := 'Array Char 16'#0;
Str1 := ' String One';
Ord1 := orNext;
setOrd := [orFirst, orMiddle, orNext];
// the varaiables are all given values above
// and all are written to file in the same way using the SizeOf( ) function below

WriteFile(hFile,Int1,SizeOf(Int1),BytesWrite,nil);
WriteFile(hFile,Word1,SizeOf(Word1),BytesWrite,nil);
WriteFile(hFile,Real1,SizeOf(Real1),BytesWrite,nil);
WriteFile(hFile,aRect,SizeOf(aRect),BytesWrite,nil);
WriteFile(hFile,aryPnt,SizeOf(aryPnt),BytesWrite,nil);
WriteFile(hFile,aryChar,SizeOf(aryChar),BytesWrite,nil);
WriteFile(hFile,Str1,SizeOf(Str1),BytesWrite,nil);
WriteFile(hFile,Ord1,SizeOf(Ord1),BytesWrite,nil);
WriteFile(hFile,setOrd,SizeOf(setOrd),BytesWrite,nil);

BytesWrite := GetFileSize(hFile, nil);
CloseHandle(hFile);
{PLEASE NOTICE, that I do NOT test the WriteFile functions above to
 see if they are successful, instead I test the file size below.
  If the Size is not  105  then a write error has happened }
if BytesWrite = 105 then
  MessageBox(hForm1, PChar('New FixedData File is at - '+DataFile),
             'New Fixed Data File', MB_ICONERROR)
  else
  MessageBox(hForm1, 'ERROR - Data File is NOT the Correct Size',
             'Write File Error', MB_ICONERROR);
end;


procedure LoadFixed;
var
hFile, BytesWrite, Size: Cardinal;
// variables below are read from a file
Int1: Integer;
Word1: Word;
Real1: Real;
aRect: TRect;
aryPnt: Array[Zero..Two] of TPoint;
aryChar: Array[Zero..15] of Char;
Str1: String[32];
Ord1: TOrd1;
setOrd: Set of TOrd1;
begin
{this procedure will read all of the different types of
 fixed size variables above, from one file}
hFile := CreateFile(DataFile,GENERIC_READ,FILE_SHARE_READ,nil,
               OPEN_EXISTING,FILE_FLAG_SEQUENTIAL_SCAN,Zero);
if hFile = INVALID_HANDLE_VALUE then
  begin
  SysErrorMsg(CreateErrText+#10+DataFile, CreateErrTitle);
  Exit;
  end;

Size := GetFileSize(hFile, nil);
if Size <> 105 then
  begin
  // check to see if the file has the correct amount of data to read
  CloseHandle(hFile);
  MessageBox(hForm1, 'ERROR - File is NOT the Correct Size',
             'Bad File Size', MB_ICONERROR);
  Exit;
  end;

{ IMPORTANT ! !  There is NO information in this file about what
  the bytes in this file are used for, the only reason you can read
  the data in this file is because you made the code that created this file.
  So you can read the bytes of this file as data into variables because you
  know the order and the size of the Data Blocks that YOU wrote to this file.
  All variables are read from the file with the same method.}
ReadFile(hFile,Int1,SizeOf(Int1),BytesWrite,nil);
{ you need to read the EXACT same type of variables out of the file
  in the EXACT same order that you wrote them to file or you will have errors}
ReadFile(hFile,Word1,SizeOf(Word1),BytesWrite,nil);
ReadFile(hFile,Real1,SizeOf(Real1),BytesWrite,nil);
ReadFile(hFile,aRect,SizeOf(aRect),BytesWrite,nil);
ReadFile(hFile,aryPnt,SizeOf(aryPnt),BytesWrite,nil);
ReadFile(hFile,aryChar,SizeOf(aryChar),BytesWrite,nil);
ReadFile(hFile,Str1,SizeOf(Str1),BytesWrite,nil);
ReadFile(hFile,Ord1,SizeOf(Ord1),BytesWrite,nil);
ReadFile(hFile,setOrd,SizeOf(setOrd),BytesWrite,nil);

CloseHandle(hFile);

if Ord1 in setOrd then
  MessageBox(hForm1, PChar('Fixed Size Data values are -'#10+Int2Str(int1)+' '+
             Int2Str(aRect.Left)+' '+ Int2Str(aryPnt[Zero].x)+' '+aryChar+Str1),
             'Fixed Data Read', MB_ICONINFORMATION)
  else
  MessageBox(hForm1, 'ERROR - Fixed Data File is NOT Correct',
             'Bad File Data', MB_ICONERROR);
end;


procedure SaveRecords(const OutFile: String);
var
hFile, BytesWrite: Cardinal;
i: Integer;
aryRec1: Array of TDataRec;
BadFile: Boolean;

  function tryWrite(var Source; Size: Cardinal): Bool;
  begin
  // this tryWrite function is called for every file write of data
  if WriteFile(hFile,Source,Size,BytesWrite,nil) and (BytesWrite = Size) then
    Result := False // WriteFile must succeed and the BytesWrite must equal Size
    else
    begin
    SysErrorMsg(WriteErrText, WriteErrTitle); // show error msg
    BadFile := True; // set BadFile to True to delete the new file
    Result := True; // Result is True if there is a write Error
    end;
  end;


begin
// this procedure will create a file and write 8 records of TDataRec to the file
if Length(OutFile) < 6  then
  begin
  MessageBox(hForm1, 'ERROR - Data File Name must be at least 6 Charaters',
             'Invalid Data File Name', MB_ICONERROR);
  Exit;
  end;

SetLength(aryRec1, 8);
{ get the memory for the records with SetLength( ) and
  then fill the records with data in the for loop below}
for i := Zero to High(aryRec1) do
  begin
  aryRec1[i].TrackNum := i;
  aryRec1[i].SomeNum := Str2IntDef(GetWindowStr(hIntEdit), Zero);
  aryRec1[i].aRect.Left := i+One;
  aryRec1[i].Text := Int2Str(i)+' '+GetWindowStr(hStrEdit);
  end;

hFile := CreateFile(PChar(OutFile),GENERIC_WRITE,FILE_SHARE_READ,nil,
                   CREATE_ALWAYS, FILE_ATTRIBUTE_NORMAL or
                   FILE_FLAG_SEQUENTIAL_SCAN,Zero);
if hFile = INVALID_HANDLE_VALUE then
  begin
  SysErrorMsg(CreateErrText+#10+OutFile, CreateErrTitle);
  Exit;
  end;

BadFile := False; { BadFile will be set to True if there is a write Error.
 for almost all file writting, you should have a way to delete the file
 or fix it if there is a write error}
i := Length(aryRec1);

{there is the tryWrite( ) function above which is called when each time you
 will write a data segment to file, it tests to see if the WriteFile function
  was complete, and all the bytes were written,
  it returns True if there is a write file Error}
if not tryWrite(i, SizeOf(i)) then
  for i := Zero to High(aryRec1) do // loop through all records in array
    if tryWrite(aryRec1[i], SizeOf(TDataRec)) then Break;

CloseHandle(hFile);
if BadFile then // test for BadFile and Delete the file if it is bad
  begin
  DeleteFile(PChar(OutFile));
  MessageBox(hForm1, 'ERROR - Data File Could not be fully Written',
             'ERROR, NO data File', MB_ICONERROR);
  end else
  MessageBox(hForm1, PChar('Data File has been Created at'#10+OutFile),
             'SUCCESS, Data File Creation', MB_ICONINFORMATION);
end;


procedure LoadRecords(const InFile: String);
var
hFile: Cardinal;
i: Integer;
aryRec1: Array of TDataRec;
BytesRead: Cardinal;
BadFile: Boolean;

  function tryRead(var Dest; Size: Cardinal): Bool;
  begin
  // this tryRead function is called for every file read of data
  if ReadFile(hFile, Dest, Size, BytesRead,nil) and (Size = BytesRead) then
    Result := False // returns false if succesful
    else
    begin
    // if there is a Read Error this returns True and shows an Error Message
    SysErrorMsg(ReadErrText, ReadErrTitle);
    CloseHandle(hFile);
    // Close Handle and set BadFile to True
    BadFile := True;
    Result := True;
    end;
  end;


begin
// this procedure will read the file made in the SaveRecords procedure above
if Length(InFile) < 6  then
  begin
  MessageBox(hForm1, 'ERROR - Data File Name must be at least 6 Charaters',
             'Invalid Data File Name', MB_ICONERROR);
  Exit;
  end;

hFile := CreateFile(PChar(InFile),GENERIC_READ,FILE_SHARE_READ,nil,
               OPEN_EXISTING,FILE_FLAG_SEQUENTIAL_SCAN,Zero);
if hFile = INVALID_HANDLE_VALUE then
  begin
  SysErrorMsg(CreateErrText+#10+InFile, CreateErrTitle);
  Exit;
  end;

BadFile := False; // BadFile will be made True if there is a Read Error

if not tryRead(i, SizeOf(i)) then // get the number of records in the file
  begin
  SetLength(aryRec1, i); // set array length to the number of records in the file
  for i := Zero to High(aryRec1) do // loop through and read all of the records
    if tryRead(aryRec1[i], SizeOf(TDataRec)) then Break;
  end else
  BadFile := True;

CloseHandle(hFile);
if BadFile then
  begin
  MessageBox(hForm1, PChar('ERROR - Data File Could not be fully Read '#10+InFile),
             'ERROR, NO READ data File', MB_ICONERROR);
  end else
  begin
  SetWindowText(hStrEdit, @aryRec1[High(aryRec1)].Text[One]);
  SetWindowText(hIntEdit, PChar(Int2Str(aryRec1[High(aryRec1)].SomeNum)));
  MessageBox(hForm1, PChar('Data File has been Read at'#10+InFile),
             'SUCCESS, Read Data File', MB_ICONINFORMATION);
  end;
end;


{the SaveVarData procedure will write changing size variables to file}
procedure SaveVarData(const OutFile: String);
var
hFile: Cardinal;
DataSize: Integer;
BytesWrite: Cardinal;

Str1: String;
pText: PChar;
aryInteger: Array of Integer;

  function noWrite(var Source; Size: Cardinal): Bool;
  begin
  // noWrite will return True if the write is NOT successful
  if WriteFile(hFile,Source,Size,BytesWrite,nil) and (BytesWrite = Size) then
    Result := False
    else
    begin
    // when there is a File Write error, I close the file and delete it
    CloseHandle(hFile);
    DeleteFile(PChar(OutFile));
    SysErrorMsg(WriteErrText, WriteErrTitle); // show Error message
    Result := True;
    end;
  end;


begin
// OutFile is the text in the hVarEdit Edit box
if Length(OutFile) < 6  then
  begin
  MessageBox(hForm1, 'ERROR - Data File Name must be at least 6 Charaters',
             'Invalid Data File Name', MB_ICONERROR);
  Exit;
  end;

  // initialize all variables
Str1 := 'String Text to write and read in a file';
pText := 'More Text to use in this file';
  // when the compilier creates the pText above it adds a #0 to the end
SetLength(aryInteger, 4);
aryInteger[0] := 4444444;
aryInteger[1] := 8888888;
aryInteger[2] := 1;
aryInteger[3] := -2;

hFile := CreateFile(PChar(OutFile),GENERIC_WRITE,FILE_SHARE_READ,nil,
                   CREATE_ALWAYS, FILE_ATTRIBUTE_NORMAL or
                   FILE_FLAG_SEQUENTIAL_SCAN,Zero);
if hFile = INVALID_HANDLE_VALUE then
  begin
  SysErrorMsg(CreateErrText+#10+OutFile, CreateErrTitle);
  Exit;
  end;

{ first I write a File type ID number to the file.
  For all your data files you should have some kind of file Identifier
  as the first data block in the file, so you can try and detect if this file
  has the data bytes that you know how to read}
if noWrite(FileDataID, SizeOf(FileDataID)) then Exit;
// if the file write of noWrite fails, then Exit
DataSize := Length(Str1); // get the size of string bytes and write it to file
if noWrite(DataSize, SizeOf(DataSize)) then Exit;
if noWrite(Str1[One], DataSize) then Exit; // write string text to file
DataSize := StrLen(pText)+1; // add one byte for the NULL char #0
if noWrite(DataSize, SizeOf(DataSize)) then Exit; // also writes the NUL char #0
if noWrite(pText^, DataSize) then Exit;
DataSize := Length(aryInteger);
if noWrite(DataSize, SizeOf(DataSize)) then Exit;// write number of integers in array
{ IMPORTANT - you MUST do the math to get the byte Size of all the Data in the array,
 multiply the length of the array by the size it's members -
   Length(aryInteger) * SizeOf(Integer) }
if noWrite(aryInteger[Zero], DataSize*SizeOf(Integer)) then Exit;
   // use the First menber of the array aryInteger[Zero] as the Source buffer
CloseHandle(hFile);
MessageBox(hForm1, PChar('Data File has been Created at'#10+OutFile),
             'SUCCESS, Data File Creation', MB_ICONINFORMATION);

end;


// LoadVarData will read the non-fixed size variables from the file
procedure LoadVarData(const InFile: String);
var
hFile,BytesRead: Cardinal;
ID: Array[Zero..5] of Char;
DataSize: Integer;

Str1: String;
pText: PChar;
aryInteger: Array of Integer;

  function noRead(var Source; Size: Cardinal): Bool;
  begin
  // noRead will return True if the file read is NOT successful
  if ReadFile(hFile,Source,Size,BytesRead,nil) and (BytesRead = Size) then
    Result := False
    else
    begin
    CloseHandle(hFile); // close handle if read error
    SysErrorMsg(ReadErrText, ReadErrTitle);
    Result := True;
    end;
  end;


begin
// InFile is the text in the hVarEdit Edit box
if Length(InFile) < 6  then
  begin
  MessageBox(hForm1, 'ERROR - Data File Name must be at least 6 Charaters',
             'Invalid Data File Name', MB_ICONERROR);
  Exit;
  end;
// open the file for reading
hFile := CreateFile(PChar(InFile),GENERIC_READ,FILE_SHARE_READ,nil,
               OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL or FILE_FLAG_SEQUENTIAL_SCAN,Zero);
if hFile = INVALID_HANDLE_VALUE then
  begin
  SysErrorMsg(CreateErrText+#10+InFile, CreateErrTitle);
  Exit;
  end;

// if noRead fails (with True) then Exit
if noRead(ID, SizeOf(ID)) then Exit;
// for safty get the File Identification number, and test it
if ID <> FileDataID then
 begin
 CloseHandle(hFile);
 MessageBox(hForm1, PChar('ERROR - This File is NOT a Valid Var Data File'#10+InFile),
             'ERROR, NOT a Valid Data File', MB_ICONERROR);
 Exit;
 end;
// read the length of the String text data
if noRead(DataSize, SizeOf(DataSize)) then Exit;
SetLength(Str1, DataSize); // get memory for the string
if noRead(Str1[One], DataSize) then Exit; // read data into string
if noRead(DataSize, SizeOf(DataSize)) then Exit;
// read text length and get memory, the NULL char #0 is included
GetMem(pText, DataSize);
if noRead(pText^, DataSize) then // this also reads the final NULL terminator
  begin
  FreeMem(pText); // free the memory before Exit
  Exit;
  end;
if noRead(DataSize, SizeOf(DataSize)) then // read number of integers in array
  begin
  FreeMem(pText);
  Exit;
  end;
SetLength(aryInteger, DataSize); // get memory for the array with SetLength( )
if noRead(aryInteger[Zero], DataSize*SizeOf(Integer)) then
  begin
  FreeMem(pText);
  Exit;
  end;

CloseHandle(hFile);
MessageBox(hForm1, PChar(Str1+#10+pText+#10+Int2Str(aryInteger[Zero])),
             'SUCCESS, Data File Read', MB_ICONINFORMATION);
FreeMem(pText);
end;


{this SaveStringRecs procedure will show how to save records with strings to file
this will create a file header with the position and size of each string record}
procedure SaveStringRecs;
var
hFile: Cardinal;
i, Len, headerPos: Integer;
aryStrR: Array of TStrRec; { TStrRec records are the Data stored in this file.
 I use a file header with one THeader record for every TStrRec record.
 The THeader record has the position and size of the TStrRec record in file,
 this allows you to access the data for just ONE TStrRec record at a time.}
aryHeader: Array of THeader;
BytesWrite: Cardinal;
BadFile: Boolean;

  function tryWrite(var Source; Size: Cardinal): Bool;
  begin
  // tryWrite will return True if the write is NOT successful
  if WriteFile(hFile,Source,Size,BytesWrite,nil) and (BytesWrite = Size) then
    Result := False
    else
    begin
    SysErrorMsg(WriteErrText, WriteErrTitle);
    BadFile := True;
    Result := True;
    end;
  end;

begin
SetLength(aryStrR, 5);
// there are 5 TStrRec in this aryStrR array
for i := 0 to High(aryStrR) do
  with aryStrR[i] do
  begin
  // fills the array elements with data
  Width := (i+1)*20;
  Height := (i+1)*10;
  { the TextLines below are the main "Data" stored in this file. These text
    strings would be long strings from a Memo Edit}
  case i of
    0: TextLines :=  'The text of FUNNY'#13#10'that is here'#13#10'for Text Lines.';
    1: TextLines :=  'More text to show, as SAD subject you'#13#10+
                     'can see in the edit box';
    2: TextLines :=  'This is the FOOD text'#13#10'with 4 lines'#13#10'of info'+
                     #13#10'here to view.';
    3: TextLines :=  'Words for the WATER'#13#10'are here in this'#13#10+
                     'Text Block of words.';
    4: TextLines :=  'The subject of MONEY has'#13#10'this text information'+
                     #13#10'as lines of words.';
    end;
  end;

hFile := CreateFile(StringFile,GENERIC_WRITE,FILE_SHARE_READ,nil,
               CREATE_ALWAYS,FILE_ATTRIBUTE_NORMAL or FILE_FLAG_SEQUENTIAL_SCAN,Zero);
if hFile = INVALID_HANDLE_VALUE then
  begin
  SysErrorMsg(CreateErrText+#10+StringFile, CreateErrTitle);
  Exit;
  end;

{In this file I will have a file header that is used to store data segment
 position and size in a THeader. There will be 5 THeader records in the the
 file header, one for each TStrRec in this file}
SetLength(aryHeader, Length(aryStrR)); // make aryHeader the same length as aryStrR
headerPos := (Length(aryHeader)* SizeOf(THeader))+8;
{all file data position is math, the headerPos is used to store the
 location of for each TStrRec, to get the position of the first TStrRec,
 you multiply the number of THeader in aryHeader, by the byte size of a
 THeader. . . You must add eight to it because you have 2 file header integers
 - FileStrID - and - Len - written to file.}
for i := 0 to High(aryHeader) do
  with aryHeader[i] do
  begin
  // in order to access one TStrRec record, you need it's file position
  Position := headerPos;
  // You must do the math to calculate the file bytes occupied by this TStrRec
  Size := 12+Length(aryStrR[i].TextLines);
  { the Size will be the length of the string + 12, , 8 bytes for the
    Width and Height in the record, and 4 bytes for the - Len - integer
    added to file later, to record the length of the string.}
  case i of
    0: ListText := 'Funny stuff';
    1: ListText := 'Sad things';
    2: ListText := 'The Food is here';
    3: ListText := 'You need Water';
    4: ListText := 'Show me the Money';
    // ListText will be shown in a List Box when the file header is read
    end;
  Inc(headerPos, Size); // add the record size to file position
  end;

BadFile := False;
Len := Length(aryStrR);
{ first I write a File type ID number to the file.
  For your data files you should have some kind of Identifier
  as the first data block in the file, so you can try and detect if this file
  has the data bytes that you know how to read}
if not tryWrite(FileStrID, SizeOf(FileStrID)) and
   not tryWrite(Len, SizeOf(Len)) and { write number of TStrRec in array
     put the aryHeader into the file as a file header}
     not tryWrite(aryHeader[0], Length(aryHeader)*SizeOf(THeader)) then
     for i := Zero to High(aryStrR) do // for loop through all strings
       begin
       if tryWrite(aryStrR[i], 8) then Break;
   {IMPORTANT - I do NOT write the entire TStrRec to file, since it has a string
    in it. I only write the Fixed-Size variables, Width and Height, by setting
    the file write Size to 8}
       Len := Length(aryStrR[i].TextLines);
   // IMPORTANT you must always write the length of the string data to file
       if tryWrite(Len, SizeOf(Len)) then Break;
       if tryWrite(aryStrR[i].TextLines[One], Len) then Break;
   // without the file segment size (number of bytes),
   // you will not be able to read out this string
       end;

CloseHandle(hFile);
if BadFile then
  begin
  DeleteFile(StringFile);
  MessageBox(hForm1, 'ERROR - String Record File Could not be fully Written',
             'ERROR, NO data File', MB_ICONERROR);
  end else
  MessageBox(hForm1, PChar('String Record File has been Created at'#10+StringFile),
             'SUCCESS, Data File Creation', MB_ICONINFORMATION);

end;


{the LoadListBox procedure will not read the entire file, it will only read the
 file header, which is 5 THeader records, it will read the 5 records and place
 the ListText string in a List Box}
procedure LoadListBox;
var
hFile, Len: Cardinal;
i: Integer;
aryHeader: Array of THeader;
BytesRead, ID: Cardinal;

  function tryRead(var Dest; Size: Cardinal): Bool;
  begin
  // returns True if Successful
  if ReadFile(hFile,Dest, Size, BytesRead,nil) and (Size = BytesRead) then
    Result := True
    else
    begin
    CloseHandle(hFile);
    SysErrorMsg(ReadErrText, ReadErrTitle);
    Result := False;
    end;
  end;


begin
hFile := CreateFile(StringFile,GENERIC_READ,FILE_SHARE_READ,nil,
               OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL or FILE_FLAG_SEQUENTIAL_SCAN,Zero);
if hFile = INVALID_HANDLE_VALUE then
  begin
  SysErrorMsg(CreateErrText+#10+StringFile, CreateErrTitle);
  Exit;
  end;


if tryRead(ID, SizeOf(ID)) then
  begin
  // read and test fot the File ID number
  if ID <> FileStrID then
    begin
    CloseHandle(hFile);
    MessageBox(hForm1, PChar('ERROR - This File is NOT a Valid String Data File'#10+
             StringFile), 'ERROR, NOT a Valid Data File', MB_ICONERROR);
    Exit;
    end else
    if tryRead(Len, SizeOf(Len)) then // read the number of records in the file
      begin
      if Len > 24 then
        begin
    // the value of 24 is not anything, you should use your own safety value here
        CloseHandle(hFile);
        MessageBox(hForm1, PChar('ERROR - Array length is more than limit '#10+
             StringFile), 'ERROR, Bad File Amount', MB_ICONERROR);
        Exit;
        end;
      SetLength(aryHeader, Len);// get memory for your array with SetLength( )
    // now read all of the file header records into the array
      if tryRead(aryHeader[0], Len*SizeOf(THeader)) then
        begin
        SendMessage(hListBox, LB_RESETCONTENT, Zero, Zero);
        //Clear and enable list box
        EnableWindow(hListBox, True);
        for i := 0 to High(aryHeader) do
          SendMessage(hListBox,LB_ADDSTRING, Zero,
                      Integer(@aryHeader[i].ListText[One]));
          // FOR loop to send all ListText strings to hListBox
        end;
      end;
    end;
CloseHandle(hFile);
end;

{the Load1StringRec procedure will use the file created above, and read just
 ONE THeader record and ONE TStrRec out of the file.}
procedure Load1StringRec;
var
hFile: Cardinal;
Len, CurSel: Integer;
Header1: THeader;
StrRec1: TStrRec;
BytesRead, ID: Cardinal;
BadFile: Boolean;
MemoStr: String;

  function tryRead(var Dest; Size: Cardinal): Bool;
  begin
  // returns true is Un-successful
  if ReadFile(hFile,Dest, Size, BytesRead,nil) and (Size = BytesRead) then
    Result := False
    else
    begin
    CloseHandle(hFile);
    BadFile := True;
    Result := True;
    SysErrorMsg(ReadErrText, ReadErrTitle);
    end;
  end;


begin
if not IsWindowEnabled(hListBox) then
  begin
  MessageBox(hForm1, 'Error - You must Load a String Record File First',
            'ERROR, No File Loaded', MB_ICONERROR);
  Exit;
  end;

CurSel := SendMessage(hListBox, LB_GETCURSEL, Zero, Zero);
{ IMPORTANT - use the lixt box select index as the index of the THeader record
 and the index of the TStrRec to read from the file}
if CurSel = LB_ERR then
  begin
  MessageBox(hForm1, 'Error - There is no List Box Selection',
            'ERROR, No List box Select', MB_ICONERROR);
  SendMessage(hListBox, LB_SETCURSEL, Zero, Zero);
  Exit;
  end;

// open the file for reading
hFile := CreateFile(StringFile,GENERIC_READ,FILE_SHARE_READ,nil,
               OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL or FILE_FLAG_SEQUENTIAL_SCAN,Zero);
if hFile = INVALID_HANDLE_VALUE then
  begin
  SysErrorMsg(CreateErrText+#10+StringFile, CreateErrTitle);
  Exit;
  end;

BadFile := False;

if not tryRead(ID, SizeOf(ID)) then
  begin
  // read and test for the File ID number
  if ID <> FileStrID then
    begin
    BadFile := True;
    MessageBox(hForm1, PChar('ERROR - File is NOT a Valid String Record Data File'+
             #10+StringFile), 'ERROR, NOT a Valid Data File', MB_ICONERROR);
    end else
    if not tryRead(Len, SizeOf(Len)) then // read the number of strings in the file
      begin
      {I have included a test for the size of the Len variable, which should contain
      the numbar of string records in this file. If it is larger than 24 then I error
      out of this code. You should have some kind of "Safety" check for array lengths
      when you are building code and testing it. If in your code you incorrctly
      place the file position you may read an incorrect amount for the array length.
      It may read a value of 4 gigs and try and set the array length to that.
      Although this string file is very simple, I still place a test. After you
      get this working and test it, you can remove your safty test.}
      if Len > 24 then
        begin
    // the value of 24 is not anything, you should use your own safety value here
        CloseHandle(hFile);
        MessageBox(hForm1, PChar('ERROR - Array length is more than limit '+
             #10+StringFile),'ERROR, Bad File Amount', MB_ICONERROR);
        Exit;
        end;
      if CurSel > Len then // another safety test
        begin
        CloseHandle(hFile);
        MessageBox(hForm1, 'Error, The List Box Selection is Out of Range of the file',
             'ERROR, Selection Incorrect', MB_ICONERROR);
        Exit;
        end;

    {use the Index in CurSel to get the file position of the THeader record to
     read. You mutiply the index by the size of the THeader. Use SetFilePointer
     to change the file position.}
      if CurSel > 0 then
        SetFilePointer(hFile,CurSel*SizeOf(THeader),nil, FILE_CURRENT);

     // Read only One THeader record from this file into Header1
      if not tryRead(Header1, SizeOf(Header1)) then
        begin
        {The file position of the TStrRec record for this Index is in the
         Header1.Position, so move the file to the new position}
        SetFilePointer(hFile,Header1.Position,nil, FILE_BEGIN); // from beginning of file
        tryRead(StrRec1, 8); // only read the 2 fixed-Size variables with 8 read size
        tryRead(Len, SizeOf(Len)); // you must use a length number to read a string
        if Len > 256 then // safety test
          begin
      // the value of 256 is not anything, you should use your own safety value here
          CloseHandle(hFile);
          MessageBox(hForm1, PChar('ERROR - Array length is more than limit '+
              #10+StringFile),'ERROR, Bad File Amount', MB_ICONERROR);
          Exit;
          end;
        SetLength(StrRec1.TextLines, Len);
      // get string memory with SetLength , and read the string
        tryRead(StrRec1.TextLines[1], Len);
      // next add the width and height to MemoStr string, and set text in hEdit2
        MemoStr := 'Width = '+Int2Str(StrRec1.Width)+'  Height = '+
                   Int2Str(StrRec1.Height)+#13#10#13#10+StrRec1.TextLines;
        SetWindowText(hEdit2, PChar(MemoStr));
        end;
      end else
      BadFile := True;
  end;

CloseHandle(hFile);
if BadFile then
  begin
  MessageBox(hForm1, PChar('ERROR - String File Could not be fully Read '+
             #10+StringFile),'ERROR, NO READ data File', MB_ICONERROR);
  end;
end;

end.