;
; -=[ Declarations, definitions'n'stuff ]=-
;
	CBLOCK H'0020'
	W_TEMP			;
	STATUS_TEMP		;
	TMR0_TEMP		; Store TMR0 value at first MIDI bit
	MIDI_BIT		; Bit expected in MIDI byte being received
	SYNC_CNT		; Pulse lenght counter 
	MIDI_TEMP		; MIDI byte being received 
	TICKPER_H		; Tick period timer (high byte)
	TICKPER_L		; Tick period timer (low byte)
	PLL_PERIOD_T		; PLL period (temporary byte)
	PLL_PERIOD_H		; PLL period (high byte)
	PLL_PERIOD_L		; PLL period (low byte)
	TICK_CUMUL_H		; MIDI tick cumulative counter (high byte)
	TICK_CUMUL_M		; MIDI tick cumulative counter (middle byte)
	TICK_CUMUL_L		; MIDI tick cumulative counter (low byte)
	CALC_H			; Calculation register (high byte) 
	CALC_M			; Calculation register (middle byte) 
	CALC_L			; Calculation register (low byte) 
	CUMUL_H			; Cumulative counter (high byte)
	CUMUL_M			; Cumulative counter (middle byte)
	CUMUL_L			; Cumulative counter (low byte)
	SYNC_CUMUL_H		; Sync cumulative register (high byte)
	SYNC_CUMUL_L		; Sync cumulative register (low byte)
	INT_CUMUL_H		; Cumulative intensity register (low byte)
	INT_CUMUL_L		; Cumulative intensity register (low byte)
	SHUFFLE_CNT		; MIDI tick counter
	GL_STAT			; Global status bits
	INTENSITY		; Intensity setting
	BUF_CNT			; Number of entries stored in buffer
	LAST_BUF_ADDR
	TICKS_TO_DO
	TICKS_DONE
	TEMP
	BUF_POINT
	ENDC
;

BUF_START	EQU	H'48'
BUF_END		EQU	(BUF_START+H'24')

PULSE_LENGHT	EQU	D'60'	; Clock pulse lenght (approx. 2ms)
IDLE_LENGHT	EQU	D'60'	; Clock pulse lenght (approx. 2ms)
;
#define CARRY		STATUS,C
#define ZERO		STATUS,Z
;
#define	WAIT_TO_SYNC	GL_STAT,2
#define	IRQ_START_BIT	GL_STAT,3
#define NEW_TICK	GL_STAT,4
#define IRQ_T0IF	INTCON,T0IF
#define SYNC_GO		GL_STAT,6
#define NEW_TICK_IM	GL_STAT,7
#define SIGNATURE	GL_STAT		; Type of time signature: 0=2/4 , 1=3/4 , 2=4/4 , 3=4/3

#define	MIDI_IN		PORTB,1 ; MIDI input pin
#define	SYNC_CLOCK24	PORTA,2 ; Sync clock output (24ppq)
#define	SYNC_ON		PORTA,1	; I had to insert my nick somewhere!!! ;) 
#define	SYNC_CONT	PORTA,0	; Sync continue-pulse pin
#define TEST_PIN	PORTA,3
;
; 
; -=[ Macro declaration ]=-
;
CHECK_FLAGS_MACRO	MACRO
	BTFSC	IRQ_START_BIT	; Check for flags			2 1
	CALL	ADD_START	; ...					- 
	BTFSS	INTCON,T0IF	;					2 1
	GOTO	$+3		;					- 2
	BTFSS	INTCON,T0IE	;					2 1
	CALL	INC_REGISTERS	; ...					- 
	BTFSC	IRQ_T0IF	; ...					2 1
	CALL	INC_REGISTERS_IRQ	; ...				- 
	BTFSC	WAIT_TO_SYNC	;					2 1
	RETURN			;					- 2
	ENDM			;					(8+)
;
CHECK_T0IRQ	MACRO
	BTFSS	INTCON,T0IF	;					2 1
	GOTO	$+3		;					- 2
	BTFSS	INTCON,T0IE	;					2 1
	CALL	INC_REGISTERS	; ...					- 
	ENDM			;					(8+)
CHECK_DOTICK	MACRO
	BTFSC	NEW_TICK	;					2 1
	CALL	DO_TICK		; ...					- 
	ENDM			;					(8+)
;
;
;
;
; -=[ Constant tables and other call procedures ]=-
;
	ORG	H'0058'
;
; -=[ Shuffle table ]=-
;
; Values must be dividable by 4!

SHUFFLE_TABLE			; 2
	MOVF	SIGNATURE,W	; 1
	ANDLW	B'0000011'	; 1
	ADDWF	PCL,F		; 2+2 (8)
	RETLW	D'24'		; 2/4 over 1 bar
	RETLW	D'32'		; 3/4 over 1 bar
	RETLW	D'48'		; 4/4 over 1 bar
	RETLW	D'64'		; 4/3 over 1 bar
;
; -=[ Correction table ]=-
;
; This table corrects the intensity register value according to the signature, because
; there isn't enough  buffer space (data memory) available on 16F84 to cover some higher
; shuffle intensities. For example: at 4/3 signature and maximum intensity (10) there
; should have been 80 bytes available for the buffer alone!
;

CORRECTION_TABLE		; 2
	MOVF	SIGNATURE,W	; 1
	ANDLW	B'0000011'	; 1
	ADDWF	PCL,F		; 2
	DT	D'11',D'9',D'6',D'4'	; 2 (8i)

