	LIST	P=16F628

	__FUSES	_HS_OSC & _CP_OFF & _WDT_OFF & _PWRTE_ON & _BODEN_OFF & _LVP_OFF & _MCLRE_ON

; /-------------------------------------\
; |          Shuffler Firmware		|
; |	     By Bojan Burkeljc		|
; |	     Version 0.97b-F628		|
; |=====================================|
; | 	Microprocessor: PIC16F628	|
; |	   Cristal used: 10 MHz		|
; |=====================================|
; | Started coding on: 13th July 2000	|
; | Final Optimizing: 24th August 2002	|
; \-------------------------------------/
;
;------------------------------------------------------------------------------
; Features from v0.97b:
;  - first working version
;  - revised code a bit, smoother shuffle timing
;------------------------------------------------------------------------------
; Features from v0.93a:
;  - MIDI to DIN sync converter
;  - normal mode and 11 different shuffle intensity levels
;  - four different time signatures
;  - operation from 25 BPM to 300 BPM
;  - pulse widths varies from 1950 to 2500 
;  - Roland type Start/Stop (RA1) and Continue (RA0) signals
;
;------------------------------------------------------------------------------
;
	#include "P16F628.inc"
	#include "msync628.dcl"
	#include "msync628.mid"
;
; -=[ Program Start ]=- 
;
	ORG	H'0000'
;
; -=[ Initialization on startup ]=-
;
	GOTO	INIT

	ORG	H'0068'
INIT
	BCF	STATUS,RP1
	BCF	STATUS,RP0
	CLRF	PORTA		; Set RA pins low
	MOVLW	B'00000111'
	MOVWF	CMCON		; Comparators off
	BSF	STATUS,RP0	; Bank 1
	MOVLW	B'11100000'	; 	
	MOVWF	TRISA		; 
	MOVLW	B'11111111'	; Sets PORTB pins
	MOVWF	TRISB		; 
	MOVLW	B'10010000'	; Prescaler to TMR0, ratio 1:2, falling edge
	MOVWF	OPTION_REG	;    interrupt, TMR0 assigned to machine clock 
	MOVLW	D'19'		;
	MOVWF	SPBRG		;
	CLRF	PIE1		;
	BSF	PIE1,RCIE	;
	CLRF	TXSTA		;
	BSF	TXSTA,BRGH	; Hi Speed UART
	BCF	STATUS, RP0	; Bank 0
	MOVF	CMCON,F
	MOVLW	B'01000000'
	MOVWF	INTCON

	MOVLW	H'20'
	MOVWF	FSR
CLEAR_REG
	CLRF	INDF
	INCF	FSR,F
	MOVLW	BUF_END
	SUBWF	FSR,W
	BTFSS	ZERO
	GOTO	CLEAR_REG

	MOVLW	BUF_START
	MOVWF	LAST_BUF_ADDR
	MOVWF	BUF_POINT
;
	CLRF	PCLATH
;
	BSF	WAIT_TO_SYNC
	BSF	SYNC_GO

	SWAPF	PORTB,W		; Read Port B pins 4 to 7...		1
	ANDLW	H'0F'		; ...					1
	MOVWF	INTENSITY	; ...and store them as shuffle intensity1
	MOVLW	B'11111100'	; ...					1
	ANDWF	SIGNATURE,F	;					1
	RRF	PORTB,W		; Read Port B pins 2 and 3... 		1
	MOVWF	TEMP		;					1
	RRF	TEMP,W		;					1
	ANDLW	B'00000011'	; ...					1
	IORWF	SIGNATURE,F	; ...and store them as time signature	1
	CALL	CORRECTION_TABLE	;				7 (85)
	MOVWF	TEMP		;					1
	SUBWF	INTENSITY,W	;					1
	MOVF	TEMP,W		;					1
	BTFSC	CARRY		;					2 1
	MOVWF	INTENSITY	;					- 1
;
; -=[ Turn On synchronization procedure ]=-	OK OK OK
;
; This procedure makes sure that MIDI is not trasmiting any byte (which 
; might cause MIDI byte misreading) when we turn on this device
;
TURN_ON
	MOVLW	27		;
	MOVWF	TEMP		;
TURN_ON_CHECK
	BTFSS	MIDI_IN		; Check if line is at rest		2 1
	GOTO	MIDI_ACTIVE	; 					- 2 (3) 
	DECF	TEMP,F		; Decrement bit counter			1
	BTFSC	ZERO		; Was that 8th high bit?		2 1
	GOTO	SET_INT		; Yes, synchronization was successful	- 2 (-)
	GOTO	$+1		; No, keep repeating...			2
SYNCHRONIZE_AGAIN		;					(7)
	NOP			; Time waste...				1 
	GOTO	$+1		; ... time waste...			2
	CALL	DELAY_10	; ... some more time waste...		10
	CALL	DELAY_10	; ... {zzzzzzzzzzzzz}....		10
	GOTO	TURN_ON_CHECK	; Check again				2 (32)
;
MIDI_ACTIVE			; Midi is active		 	(3)
	MOVLW	27		; Reinit the idle counter		1
	MOVWF	TEMP		;					1
	GOTO	SYNCHRONIZE_AGAIN	; Return			2 (7)
SET_INT
	MOVLW	B'10010000'	;
	MOVWF	RCSTA		;
	CLRF	PIR1
	BSF	INTCON,GIE
;
;------------------------------------------------------------------------------
;
; -=[ Main Loop procedure ]=-
;
MAIN_LOOP
	BTFSC	WAIT_TO_SYNC	;					2 1
	GOTO	TIME_WASTE	;					- 2 (3)
	BTFSC	NEW_TICK_IM	;					2 1
	CALL	NEW_TICK_IMMIDIATE	;				- 
	BTFSC	NEW_TICK	;					2 1
	CALL	DO_TICK		;					- 

	CALL	DELAY_6		;					6

	BTFSC	WAIT_TO_SYNC	;					2 1
	GOTO	TIME_WASTE	;					- 2 (3)

	CALL	DELAY_6		;					6 (20)

	BTFSC	NEW_TICK	;					2 1
	CALL	DO_TICK		;					- 

	CALL	DELAY_8		;					6 (30)

	BTFSC	IRQ_START_BIT	;					2 1
	CALL	ADD_START	;					- 
	BTFSC	WAIT_TO_SYNC	;					2 1
	GOTO	TIME_WASTE	;					- 2 (3)

	CALL	DELAY_8		;					8 (42)
	BTFSC	NEW_TICK_IM	;					2 1
	CALL	NEW_TICK_IMMIDIATE	;				- 

	BTFSC	NEW_TICK	;					2 1
	CALL	DO_TICK		;					- 
	CALL	DELAY_6		;					6

	CHECK_T0IRQ		;					8 (60)
	BTFSC	WAIT_TO_SYNC	;					2 1
	GOTO	TIME_WASTE	;					- 2 (3)

	CALL	DELAY_5		;					5 (67)

	BTFSC	NEW_TICK	;					2 1
	CALL	DO_TICK		;					- 
	BTFSC	NEW_TICK_IM	;					2 1
	CALL	NEW_TICK_IMMIDIATE	;				- 

	CALL	DELAY_6		;					6 (79)

	BTFSC	IRQ_T0IF	;					2 1
	CALL	INC_REGISTERS_IRQ	;				- 
	BTFSC	WAIT_TO_SYNC	;					2 1
	GOTO	TIME_WASTE	;					- 2 (3)

	CALL	DELAY_8		;					6 (91)

	BTFSC	NEW_TICK	;					2 1
	CALL	DO_TICK		;					- 
;
	NOP			;					1
DECR_COUNTER			;					(94)
	CALL	DECR_PULSE_CNT	;					12
	GOTO	MAIN_LOOP	;					2 (108)
;
TIME_WASTE			;					(5)
	CALL	DELAY_10	;					10
	CALL	DELAY_10	;					10
	BTFSC	NEW_TICK_IM	;					2 1
	CALL	NEW_TICK_IMMIDIATE	;				- 
	CALL	DELAY_10	;					10
	CALL	DELAY_10	;					10
	CALL	DELAY_10	;					10
	CALL	DELAY_10	;					10
	BTFSC	NEW_TICK_IM	;					2 1
	CALL	NEW_TICK_IMMIDIATE	;				- 
;	DECF	MIDI_BIT,W	; This part makes sure that the sync	1
;	BTFSC	ZERO		;   pulse isn't skipped if interrupt 	2 1
;	GOTO	MAIN_LOOP	;   occurs while testing SYNC_CNT	- 2 (73)
READ_PANEL			; Read panel settings			(72)
	SWAPF	PORTB,W		; Read Port B pins 4 to 7...		1
	ANDLW	H'0F'		; ...					1
	MOVWF	INTENSITY	; ...and store them as shuffle intensity1
	MOVLW	B'11111100'	; ...					1
	ANDWF	SIGNATURE,F	;					1
	RRF	PORTB,W		; Read Port B pins 2 and 3... 		1
	MOVWF	TEMP		;					1
	RRF	TEMP,W		;					1
	ANDLW	B'00000011'	; ...					1
	IORWF	SIGNATURE,F	; ...and store them as time signature	1
	CALL	CORRECTION_TABLE	;				8 (88)
	MOVWF	TEMP		;					1
	SUBWF	INTENSITY,W	;					1
	MOVF	TEMP,W		;					1
	BTFSC	CARRY		;					2 1
	MOVWF	INTENSITY	;					- 1
	GOTO	DECR_COUNTER	;  					2 (94)
;
;
; -=[ Calculate routine ]=-
;
; This routine is executed on every received tick. It calculates the triggering
; time of next sync pulse.
; First of all the tick period counter value is divided by 16 and stored into 
; PLL_PERIOD register.
; 
;
DO_TICK				;					(2)
TICK_CALCULATE
	BCF	NEW_TICK	;					1
	MOVF	TICKPER_L,W	; ...					1 (4)
	ADDWF	TICK_CUMUL_L,F	; ...					1
	BTFSC	CARRY		; ...					1 2 1
	INCFSZ	TICK_CUMUL_M,F	; ...					2 - 1
	GOTO	$+2		;					- 2 2
	INCF	TICK_CUMUL_H,F	;					1  |
	MOVF	TICKPER_H,W	; ...					1<-+
	ADDWF	TICK_CUMUL_M,F	; ...					1
	BTFSC	CARRY		; ...					1
	INCF	TICK_CUMUL_H,F	; ...					1 (13)
;
	SWAPF	TICKPER_L,W	; Division of TICKPER  (CALC) by 16	1
	ANDLW	H'0F'		; ...					1
	MOVWF	PLL_PERIOD_L	; ... 					1
	SWAPF	TICKPER_H,W	; ...					1
	ANDLW	H'F0'		; ...					1
	IORWF	PLL_PERIOD_L,F	; ...					1 (19)
	SWAPF	TICKPER_H,W	; ...					1
	ANDLW	H'0F'		; ...					1
	MOVWF	PLL_PERIOD_H	; Result goes to PLL_PERIOD		1 (22)
;
	CLRF	TICKPER_H	; Clear TICKPER registers		1
	CLRF	TICKPER_L	; ...					1

	INCF	SHUFFLE_CNT,F	; Increment shuffle counter		1
	BTFSS	SIGNATURE,1	;					2 1
	GOTO	CALC_TABLE	;					- 1
	BTFSS	SHUFFLE_CNT,0	;					1
	GOTO	MULTIPLY	;  					- 2 (29)
;	
CALC_TABLE
	CALL	SHUFFLE_TABLE	; Get shuffle offset value		7
	SUBWF	SHUFFLE_CNT,W	;					1
;
CALC_ADD_INC			;					(36)
	MOVF	INTENSITY,W	; 					1
	BTFSS	CARRY		; If it is negative,also make INTENSITY	2 1
	GOTO	CALC_ADD_PLUS	; negative				- 2 (40)
	SUBWF	INT_CUMUL_L,F	; Subt. INTENSITY value from INT_CUMUL	1	
	BTFSC	CARRY		;					2 1
	GOTO	CHECK_LAST_TICK	;					- 2
	DECF	INT_CUMUL_H,F	;					1	
	GOTO	MULTIPLY	;					2
CHECK_LAST_TICK
	BTFSC	ZERO		;					2 1
	GOTO	CALC_LAST_TICK	;					- 2 (43)
	GOTO	MULTIPLY	;					2 (44)
;
CALC_ADD_PLUS			;					(40)
	ADDWF	INT_CUMUL_L,F	; Add INTENSITY value to INT_CUMUL	1
	BTFSC	CARRY		;					2 1
	INCF	INT_CUMUL_H,F	;					- 1
;
MULTIPLY			;					(44)
	CHECK_FLAGS_MACRO	; Check for flags			8 (52)
	MOVF	INT_CUMUL_L,W	;					1
	MOVWF	TEMP		; ...					1
	CLRF	PLL_PERIOD_T	; Initialize registers for 		1
	CLRF	CALC_L		;    multiplication			1

	MOVLW	0		;					1
	BTFSC	INT_CUMUL_H,0	;					2 1
	MOVF	PLL_PERIOD_L,W	;					- 1
	MOVWF	CALC_M		; ... 					1
	BTFSC	INT_CUMUL_H,0	;					2 1
	MOVF	PLL_PERIOD_H,W	;					- 1
	MOVWF	CALC_H		; ... 					1

	CALL	DECR_PULSE_CNT	;					12 (71)
	BSF	CARRY		;					1
	GOTO	$+2		;					2 (74)
MULT_LOOP			; Core of multiplying routine		(~0)
	BCF	CARRY		;					1
	RRF	TEMP,F		; 					1
	BTFSS	CARRY		; Multiply PLL_PERIOD by INT_CUMUL	2 1
	GOTO	MULT_ROTATE	;					- 2 (~5)
	MOVF	PLL_PERIOD_L,W	;					1
	ADDWF	CALC_L,F	;					1
	BTFSC	CARRY		;					1 2 1
	INCFSZ	CALC_M,F	;					2 - 1
	GOTO	$+2		;					  2 2
	INCF	CALC_H,F	;					1  |
	MOVF	PLL_PERIOD_H,W	;					1<-+
	ADDWF	CALC_M,F	;					1
	BTFSC	CARRY		;					2 1
	INCF	CALC_H,F	;					- 1
	MOVF	PLL_PERIOD_T,W	;					1
	ADDWF	CALC_H,F	;					1 (~16)
	CHECK_FLAGS_MACRO	;					8
	BCF	CARRY		;					1
MULT_ROTATE			;					(~25)
	RLF	PLL_PERIOD_L,F	; Prepare PLL_PERIOD for next pass	1
	RLF	PLL_PERIOD_H,F	;   thru multiplication routine		1
	RLF	PLL_PERIOD_T,F	;					1
;
	CHECK_T0IRQ		;					2 
;
	DECFSZ	TEMP,W		;					2 1
	GOTO	MULT_LOOP	;					- 2 (~26)
				;		Worst timing case: 74+33*7+32=337
MULT_END			; 					(337+)
	CHECK_FLAGS_MACRO	;					8
	CALL	DECR_PULSE_CNT	;					12 (358)
	MOVF	TICK_CUMUL_L,W	; Add TICK_CUMUL value to result of 	1
	ADDWF	CALC_L,F	;   multiplying				1
	BTFSC	CARRY		;					1 2 1 
	INCFSZ	CALC_M,F	;					2 - 1
	GOTO	$+2		;					- 2 2
	INCF	CALC_H,F	;					1 - -
	MOVF	TICK_CUMUL_M,W	; ...					1
	ADDWF	CALC_M,F	; ...					1
	BTFSC	CARRY		;					2 1
	INCF	CALC_H,F	;					- 1
	MOVF	TICK_CUMUL_H,W	; ...					1
	ADDWF	CALC_H,F	; ...					1 (370)
;
	DECFSZ	SHUFFLE_CNT,W	;					2 1
	GOTO	CALC_PROCEED	;					- 2 (373)
	MOVLW	1		;					1
	MOVWF	BUF_CNT		;					1
	MOVLW	BUF_START	;					1
	MOVWF	LAST_BUF_ADDR	;					1
	MOVWF	BUF_POINT	;					1
	GOTO	VALUE_2_SYNC_C	;					2 (378)

CALC_PROCEED			; 					(373)
	INCF	BUF_CNT,F	; Increment buffer entry counter	1
	DECF	BUF_CNT,W	; If there is no entries in buffer	1
	BTFSC	ZERO		;   store the result directly to	2 1
	GOTO	VALUE_2_SYNC_C	;   SYNC_CUMUL, otherwise proceed	- 2 (378)
VALUE_2_BUFFER			;					(377)
	MOVF	LAST_BUF_ADDR,W	; Store result to buffer via indirect	1
	MOVWF	FSR		;   addresing				1
	MOVF	CALC_H,W	; ...					1
	MOVWF	INDF		; ...					1
	INCF	FSR,F		; ...					1
	MOVF	CALC_M,W	; ...					1
	MOVWF	INDF		; ...					1 (384)
	INCF	FSR,W		; ...					1
	ADDLW	-BUF_END	; Adjust pointer to buffer space	1
	BTFSC	CARRY		; ...					1
	MOVLW	BUF_START-BUF_END	; ...				1
	ADDLW	BUF_END		; ...					1
	MOVWF	LAST_BUF_ADDR	; ...					1	
CALC_CHECK_TO_DO
	CALL	DECR_PULSE_CNT	;					12 (403)
	MOVF	TICKS_TO_DO,W	;					1
	SUBWF	SHUFFLE_CNT,W	;					1
	BTFSS	ZERO		;					2 1
	BSF	NEW_TICK	;					- 1
	RETURN			;					2
;
VALUE_2_SYNC_C			;					(378)
	MOVF	CALC_H,W	; Store result (CALC) to SYNC_CUMUL	1
	MOVWF	SYNC_CUMUL_H	; ...					1
	MOVF	CALC_M,W	; ...					1
	MOVWF	SYNC_CUMUL_L	; ...					1
	CHECK_FLAGS_MACRO	;					8
	GOTO	CALC_CHECK_TO_DO	;				8 (411)
;
CALC_LAST_TICK			;					(43)
	INCF	TICKS_DONE,F	;					1	
CALC_LAST_TICK_L		;					(45)(~0)
	BTFSC	SYNC_GO		;					2 1
	GOTO	CALC_LAST_TICK_P	;				- 2 (48)(~3)
	CALL	DELAY_10	;					10
	CALL	DELAY_10	;					10
	CALL	DELAY_10	;					10 (~32)
	BTFSS	SYNC_ON		;					2 1 
	GOTO	DECR_PULSE_CNT	;					- 
	CALL	DELAY_10	;					10
	CALL	DELAY_10	;					10
	CALL	DELAY_10	;					10
	CALL	DELAY_10	;					10
	CALL	DELAY_10	;					10 (~84)
	CHECK_FLAGS_MACRO	; Check for flags			8
	CALL	DECR_PULSE_CNT	;					12
	GOTO	CALC_LAST_TICK_L	;				2 (~107)	
CALC_LAST_TICK_P		;					(48)(~3)
	MOVLW	PULSE_LENGHT	; Initialize Sync pulse duration timer	1
	MOVWF	SYNC_CNT	;					1
	BSF	SYNC_CLOCK24	; 					1
	BCF	SYNC_GO		;					1
	MOVF	TICKS_DONE,W	;					1
	SUBWF	SHUFFLE_CNT,W	;					1
	BTFSS	ZERO		;					2 1
	GOTO	CALC_LAST_TICK	;					- 2 (~10)
	BSF	WAIT_TO_SYNC	;					1
	RETURN			;					2 (59)(~12)


;	
;
; -=[ Add on MIDI start bit routine ]=-
;
; Add [TMR0_TEMP/2+182] to TICKPER and CUMUL registers after the MIDI start bit has
; been received. TMR0_TEMP register holds a value of TMR0 from the the start bit
; was received. Value 54 represents compensation for changing TMR0 value at start bit
; and following eight data bits. 
;
; This routine should be called at least on every 550 machine clocks.
;
ADD_START			; 					(2)
	BCF	IRQ_START_BIT	; Clear start bit flag			1
	MOVLW	D'40'		;					1
	ADDWF	TMR0_TEMP,F	;					1
	BTFSS	CARRY		;					1
	GOTO	A_S_MINUS	;					1
	BCF	CARRY		;					1
	RRF	TMR0_TEMP,W	;					1
	ADDLW	D'54'		;					1
	MOVWF	TMR0_TEMP	; 					1 (11)
A_S_PLUS_P
	ADDWF	TICKPER_L,F	; Add value to TICKPER...		1
	INCF	TICKPER_H,F	; 					1
	BTFSC	ZERO		; ...					2 1
	GOTO	INC_REGISTERS_WTS	; If there wasn't any tick for	- 2 (16)
				;      a long time set first tick flag	
	BTFSS	CARRY		; ...					2 1
	GOTO	A_S_PLUS_1	; ...					- 2 (18)
	INCF	TICKPER_H,F	; ...					1
	BTFSC	ZERO		; ...					2 1
	GOTO	INC_REGISTERS_WTS	; If there wasn't any tick for	- 2 (21)
				;      a long time set first tick flag	
A_S_PLUS_1			;					(20)
	MOVF	TMR0_TEMP,W	; Add value to CUMUL...			1
	ADDWF	CUMUL_L,F	; ...					1
	MOVLW	1		;					1
	BTFSS	CARRY		;					2 1
	MOVLW	2		;					- 1
	ADDWF	CUMUL_M,F	;					1
	BTFSS	CARRY		;					2 1
	GOTO	INC_REGISTERS_P	; Check the pulse! ;) 			- 2 (29)
	INCF	CUMUL_H,F	;					1
	GOTO	INC_REGISTERS_P	; Check the pulse! ;) 			2 (31)
;	
A_S_MINUS			; The value is negative			(9)
	BSF	CARRY		; Set leading one			1
	RRF	TMR0_TEMP,W	;					1
	ADDLW	D'54'		;					1
	MOVWF	TMR0_TEMP	; 					1
	BTFSC	CARRY		;					2 1
	GOTO	A_S_PLUS_P	;					- 2
	ADDWF	TICKPER_L,F	; "Add" value to TICKPER...		1
	BTFSC	CARRY		; ...					2 1
	GOTO	A_S_MINUS_1	;					- 2 (20)
	DECF	TICKPER_H,F	; Decrement higher byte if...		1
				; ...lower one was negative...	
	INCFSZ	TICKPER_H,W	;					2 1
	GOTO	A_S_MINUS_1	;					- 2 (20)
	CLRF	TICKPER_L	;					1
	CLRF	TICKPER_H	;					1
A_S_MINUS_1			;
	INCF	TICKPER_H,F	; ...					1
	BTFSC	ZERO		; ...					2 1
	GOTO	INC_REGISTERS_WTS	; If there wasn't any tick for	- 2 (18)
				;      a long time set first tick flag	
A_S_MINUS_2			;					(21)
	MOVF	TMR0_TEMP,W	; "Add" value to CUMUL...		1
	ADDWF	CUMUL_L,F	;					1
	BTFSC	CARRY		;					2 1
	GOTO	A_S_MINUS_3	; Proceed in INC_REGISTERS routine	- 2 (25)
	DECF	CUMUL_M,F	; Decrement higher byte if...		1
	INCFSZ	CUMUL_M,W	; ...lower one was negative...		2 1
	GOTO	A_S_MINUS_3	;					- 2 (28)
	DECF	CUMUL_H,F	; ...					1
A_S_MINUS_3			;					(21)
	INCFSZ	CUMUL_M,F	;					1
	GOTO	INC_REGISTERS_P	; Check the pulse! ;) 			2 (22)
	INCF	CUMUL_H,F	;					- 1
	GOTO	INC_REGISTERS_P	; Check the pulse! ;) 			2 (22)

;
; This routine should be called at least on every 280 machine clocks.
;
;
INC_REGISTERS_IRQ		;					(2)
	BCF	IRQ_T0IF	;					1
	GOTO	INC_REGISTERS_1	;					2 (5)
;
INC_REGISTERS			;					(2)
	BCF	INTCON,T0IF	;					1
INC_REGISTERS_1			;					(5)
	BTFSS	SYNC_ON		;					2 1
	RETURN			;					- 2
	MOVLW	H'80'		;					1
	ADDWF	TICKPER_L,F	;					1
	BTFSC	CARRY		;					2 1 1
	INCFSZ	TICKPER_H,F	; Increment tick period timer on	- 1 2
	GOTO	$+2		; TMR0 overflow				2 2 -
	GOTO	INC_REGISTERS_WTS	; ...				- - 2 (14)
	MOVLW	H'80'		;					1 (14)
	ADDWF	CUMUL_L,F	;					1
	BTFSC	CARRY		;					2 1 1
	INCFSZ	CUMUL_M,F	; Increment global cumulative timer	- 2 1
	GOTO	$+2		; ...					2 - 2
	INCF	CUMUL_H,F	; ...					- 1 -
INC_REGISTERS_P
	MOVF	BUF_CNT,F	; Check if there is a valid entry in	1
	BTFSC	ZERO		;          SYNC_CUMUL registers		2 1
	RETURN			; It's not time yet to make a pulse	- 2 (23)
	BTFSS	SYNC_GO		; Check if sync is allowed		2 1
	RETURN			; ...					- 2 (25)
	MOVF	SYNC_CUMUL_L,W	; 					1
	SUBWF	CUMUL_M,W	; Subtract CUMUL registers from		1
	MOVF	SYNC_CUMUL_H,W	;	SYNC_CUMUL registers to		1
	BTFSS	CARRY		;	check if the time has come	2 1	
	INCF	SYNC_CUMUL_H,W	;	to make a sync pulse		- 1
	SUBWF	CUMUL_H,W	;	...				1
	BTFSS	CARRY		;	...				2 1	
	GOTO	DECR_PULSE_CNT	; It's not time yet to make a pulse	- 2 (33)
SYNC_TIME			;					(32)
	DECF	BUF_CNT,F	; Decrement buffer entry counter	1
	BTFSC	ZERO		; If there is no entry left skip	2 1
	GOTO	SYNC_PULSE	;   new entry retrieval out of buffer	- 2 (36)
	MOVF	BUF_POINT,W	;					1
	MOVWF	FSR		;					1
	MOVF	INDF,W		; New entry goes from buffer to		1
	MOVWF	SYNC_CUMUL_H	;   SYNC_CUMUL				1
	INCF	FSR,F		;   ...					1 (40)
	MOVF	INDF,W		;   ...					1
	MOVWF	SYNC_CUMUL_L	;   ...					1
	INCF	FSR,W		;   ...					1
	ADDLW	-BUF_END	; Adjust pointer to buffer space	1
	BTFSC	CARRY		; ...					1
	MOVLW	BUF_START-BUF_END	; ...				1
	ADDLW	BUF_END		; ...					1
	MOVWF	BUF_POINT	; ...					1	
SYNC_PULSE			;					(49)
	MOVLW	PULSE_LENGHT	; Initialize Sync pulse duration timer	1
	MOVWF	SYNC_CNT	;					1
	BSF	SYNC_CLOCK24	; 					1
	BCF	SYNC_GO		;					1
	INCF	TICKS_DONE,F	;					1
	RETURN			;					2 (59)
;
;
INC_REGISTERS_WTS		;					(14)
	CLRF	BUF_CNT		;					1
	MOVF	LAST_BUF_ADDR,W	;					1
	MOVWF	BUF_POINT	;					1
	MOVLW	B'01000011'	;					1
	ANDWF	GL_STAT,F	; 					1
	BSF	WAIT_TO_SYNC	; Set WAIT_TO_SYNC flag			1
	RETURN			; 					2 (27)
;
;
NEW_TICK_IMMIDIATE		;					(2)
	BTFSS	SYNC_GO		;					2 1
	RETURN			;					- 2 (5)
	BCF	NEW_TICK_IM	;					1
	BCF	SYNC_GO		;					1
	BSF	SYNC_CLOCK24	;					1
	MOVLW	PULSE_LENGHT	;					1
	MOVWF	SYNC_CNT	;					1
	RETURN			;					2 (11)
;
;
DECR_PULSE_CNT			;					(2)
	DECFSZ	SYNC_CNT,F	; Decrement sync pulse lenght counter	2 1
	RETURN			; Not zero, return			- 2 (5)
	BTFSS	SYNC_CLOCK24	;					2 1
	GOTO	DECR_PULSE_CNT_IDLE	;				- 2 (7)
	BCF	SYNC_CONT	; Put continue line low			1
	BCF	SYNC_CLOCK24	; Put sync line low			1 (8)
	MOVLW	IDLE_LENGHT	;					1
	MOVWF	SYNC_CNT	;					1
	RETURN			; Return				2 (12)

DECR_PULSE_CNT_IDLE		;					(5)
	BSF	SYNC_GO		;					- 1 
	RETURN			;					4 (12)
;
;
; -[ Delay procedures ]-
;
DELAY_10
	NOP
	NOP
DELAY_8
	NOP
DELAY_7
	NOP
DELAY_6
	NOP
DELAY_5
	NOP
DELAY_4
	RETURN
;
;
;
; Test procedure! Outputs stream of pulses at aprox. 530 BPM 
;
;DUMMY_LOOP
;	BCF	INTCON,GIE
;
;DUMMY_LOOP_1
;	CALL	DELAY_10
;	CALL	DELAY_10
;	CALL	DELAY_10
;	CALL	DELAY_10
;	DECFSZ	SYNC_CNT,F
;	GOTO	DUMMY_LOOP_1
;	MOVLW	B'00000100'
;	XORWF	PORTA,F
;	MOVLW	PULSE_LENGHT	; Initialize continue pulse lenght	1
;	MOVWF	SYNC_CNT	;    counter				1
;	GOTO	DUMMY_LOOP_1
;
;
;

	END
