	LIST	P=16F84
	#include "P16F84.inc"
;	#include <SyncOn.inc>

	__FUSES	_XT_OSC & _CP_OFF & _WDT_OFF & _PWRTE_ON
; /-----------------------------------\
; |       MIDI Output Firmware        |
; |	    Version 1.01-F84	      |
; |	    By Bojan Burkeljc	      |
; |===================================|
; | 	Microprocessor: PIC16F84      |
; | 	       Cristal: 4MHz	      |
; |===================================|
; | Started coding on: 27th Dec 1998  |
; | Ended coding on:   20th Jan 1999  |
; | Final Optimizing:  27th Jan 1999  |
; \-----------------------------------/
;
; !This version requires 4MHz cristal to run properly!  
;
; -=[ Declarations, definitions'n'stuff ]=-
;
	CBLOCK H'000D'
	TEMP			; Temporary variable
	MIDI_BIT		; Bit expected in MIDI byte being sent
	OUT_TEMP		;	
	BYTE_CNT		;
	MIDI_STATUS		;	
	VALUE1			;
	VALUE2			;
	VALUE3			;
	MIDI_CH			;
	CC_NUMBER		;
	ENDC
;
#define		VALUE_IN	PORTB	; MIDI value input pins
#define		MIDI_OUT	PORTB,7	; MIDI output pin
#define		MIDI_NOTE	PORTA,0	; MIDI command input port
#define		MIDI_CC		PORTA,1	; MIDI command input port
#define		MIDI_SYNC_ON	PORTA,2	; MIDI command input port
#define		MIDI_SYNC	PORTA,3	; MIDI command input port
#define		SETUP		PORTA,4	; Setup button
;
; -=[ Program Start ]=-
;
	ORG	H'0000'
	GOTO	INIT
;
; -=[ Initialization on startup ]=-
;
	ORG	H'0008'
INIT
	BSF	STATUS, RP0	; Bank 1
	MOVLW	B'01111111'	; 
	MOVWF	TRISB		; 
	MOVLW	B'00011111'	; 	
	MOVWF	TRISA		;  
;
;
	BCF	STATUS, RP0	; Bank 0
	CLRF	PORTA		; Set RA pins...
	CLRF	PORTB		; ...and RB pins low
;
	BSF	MIDI_OUT	; Puts MIDI line at rest
;
	CLRF	PCLATH

	CLRF	MIDI_BIT
	CLRF	MIDI_CH
	MOVLW	B'01000000'
	MOVWF	MIDI_STATUS
	MOVLW	7
	MOVWF	CC_NUMBER
	MOVLW	VALUE1
	MOVWF	FSR
;
;
; -=[ Main loop ]=-
;
; 
MAIN_LOOP
	BTFSC	MIDI_SYNC	;					21
	GOTO	DO_SYNC		;					-2 (3)
	BTFSC	MIDI_NOTE	;					21
	GOTO	DO_NOTE		;					-2 (5)
	BTFSC	MIDI_CC		;					21
	GOTO	DO_CC		;					-2 (7)
	BSF	MIDI_OUT	;					1
	BTFSC	SETUP		;					21
	GOTO	SETTINGS	;					-2 (10)
	CALL	DELAY		;					10
	CALL	DELAY		;					10
	NOP			;					1
	GOTO	MAIN_LOOP	;					2 (32)
;
DO_NOTE				;					(5)
NOTE_ON				
	BTFSC	MIDI_SYNC_ON	;					2 1
	GOTO	PANIC		;					- 2 (8)
	MOVF	PORTB,0		;					1
	ANDLW	B'01111111'	;					1
	MOVWF	VALUE1		;					1
	MOVWF	VALUE2		;					1
	MOVLW	2		;					1
	MOVWF	BYTE_CNT	;					1
	MOVLW	H'90'		;					1 
	IORWF	MIDI_CH,W	;					1
	MOVWF	VALUE3		; 		 			1
	NOP			;					1
	CALL	BYTE_TRANSMIT	; Make some damage... ;)		2 (19)
;
	MOVLW	208		;					1
	CALL	LONG_DELAY	;					29
	GOTO	$+1		;					2 (32)
;
NOTE_OFF
	BTFSC	MIDI_STATUS,0	;					2 1
	GOTO	NOTE_OFF_W_ON	;					- 2 (3)
;
	MOVLW	H'80'		;					1 
	IORWF	MIDI_CH,W	;					1
	MOVWF	VALUE3		; 		 			1 
	GOTO	NOTE_OFF_PROCEED	;				2 (7)
;
NOTE_OFF_W_ON			;					(3)
	MOVLW	H'90'		;					1 
	IORWF	MIDI_CH,W	;					1
	MOVWF	VALUE3		; 		 			1
	CLRF	VALUE1		;					1 (7)
	
NOTE_OFF_PROCEED		;					(7)
	GOTO	$+1		;					2
	GOTO	$+1		;					2
	GOTO	$+1		;					2
	GOTO	$+1		;					2
	MOVLW	2		;					1
	MOVWF	BYTE_CNT	;					1
	CALL	BYTE_TRANSMIT	; Make some damage... ;)		2 (19)
;		
	MOVLW	208		;					1
	CALL	LONG_DELAY	;					29
	GOTO	MAIN_LOOP	;					2 (32)

PANIC				;					(8)
	BTFSC	MIDI_SYNC_ON	;					2 1
	GOTO	$-1		;					- 2 
	CLRF	VALUE1		;					1
	MOVLW	D'123'		;					1 
	GOTO	CC_PROCEED	;					2
	
;
; -=[ Do Control Change ]=-
;
DO_CC				;					(7)
	MOVF	PORTB,0		;					1
	ANDLW	B'01111111'	;					1
	MOVWF	VALUE1		;					1
	MOVF	CC_NUMBER,W	;					1
CC_PROCEED			; This is from Panic 			(11)
	MOVWF	VALUE2		;					1
	MOVLW	2		;					1
	MOVWF	BYTE_CNT	;					1
	MOVLW	H'B0'		;					1 
	IORWF	MIDI_CH,W	;					1
	MOVWF	VALUE3		; 		 			1 (17)
	CALL	BYTE_TRANSMIT	; Make some damage... ;)		2 (19)
;
	MOVLW	208		;					1
	CALL	LONG_DELAY	;
	GOTO	MAIN_LOOP	;					2 (32)
;
; -=[ Do Sync ]=-
;
DO_SYNC				;					(3)
	CLRF	BYTE_CNT	;					1
	MOVLW	H'F8'		;					1
	MOVWF	VALUE1		;					1 (6)
	BTFSC	MIDI_SYNC_ON	; 					2 1
	GOTO	SYNC_ON		;					- 2 (9)
	BTFSS	MIDI_STATUS,7	;					2 1
	GOTO	SYNC_NO_CHANGE	;					- 2 (11)
	BCF	MIDI_STATUS,7	;					1
	MOVLW	H'FC'		;					1
	GOTO	SYNC_CHANGE	;					2 (14)
;
SYNC_NO_CHANGE			;					(11)
	GOTO	$+1		;					2
	GOTO	$+1		;					2
	GOTO	SYNC_GO		;					2 (17)
;
SYNC_ON				;					(9)
	BTFSC	MIDI_STATUS,7	;					2 1
	GOTO	SYNC_NO_CHANGE+1	;				- 2 (12)
	BSF	MIDI_STATUS,7	;					1
	BTFSC	MIDI_STATUS,6	;					2 1
	INCF	BYTE_CNT,1	;					- 1 (14)
	MOVLW	H'FB'		;					1
	MOVWF	VALUE3		;					1 (16)
	CALL	LONG_DELAY	;					29 (32+13)
	MOVLW	H'FA'		;					1
;
SYNC_CHANGE			;					(14)
	NOP			;					1
	MOVWF	VALUE2		;					1 
	INCF	BYTE_CNT,1	;					1 (17)
;	
SYNC_GO				;					(17)
	CALL	BYTE_TRANSMIT	;					2 (19)
;
	CALL	SYNC_DELAY	;					
	GOTO	MAIN_LOOP	;					2 (32)
;
; 
;
SETTINGS			;					(10)
	BTFSC	MIDI_NOTE	;					21
	GOTO	SET_NOTE	;					-2 (13)
	BTFSC	MIDI_CC		;					21
	GOTO	SET_CC_NUMBER	;					-2 (13)
	BTFSC	MIDI_SYNC	;					21
	GOTO	SET_CONTINOUS	;					-2 (13)
;
	BTFSC	SETUP		;					21
	GOTO	SETTINGS	;					-2
	GOTO	MAIN_LOOP	;					2
;
SET_NOTE			;					(13)
	BTFSC	MIDI_NOTE	;					21
	GOTO	$-1		;					-2
	MOVLW	B'00001111'	;					1
	ANDWF	PORTB,W		;					1
	MOVWF	MIDI_CH		;					1
	BCF	MIDI_STATUS,0	;					1
	BTFSC	PORTB,6		;					2 1
	BSF	MIDI_STATUS,0	;					1
	GOTO	SETTINGS	;					2
;
SET_CC_NUMBER
	BTFSC	MIDI_CC		;					21
	GOTO	$-1		;					-2
	MOVLW	B'01111111'	;					1
	ANDWF	PORTB,W		;					1
	MOVWF	CC_NUMBER	;					1
	GOTO	SETTINGS	;					2
;
SET_CONTINOUS
	BTFSC	MIDI_SYNC	;					2 1
	GOTO	$-1		;					- 2
	BSF	MIDI_STATUS,6	;					1
	BTFSS	PORTB,6		;					2 1
	BCF	MIDI_STATUS,6	;					1
	GOTO	SETTINGS	;					2
;
; -=[ Byte Transmit procedure ]=-
;
; Transmits whole MIDI byte
; Starts on: 19th clock 
; Ends on: 32th clock
; Stack levels used: 2
;
BYTE_TRANSMIT
BYTE_START			;					(19)
	BCF	MIDI_OUT	;					1 (20)
	MOVLW	9		;					1
	MOVWF	MIDI_BIT	;					1
	MOVLW	VALUE1		;					1
	ADDWF	BYTE_CNT,W	;					1
	MOVWF	FSR		;					1
	GOTO	$+1		;					2
	GOTO	$+1		;					2
	NOP			;					1
	MOVF	INDF,0		;					1
	MOVWF	OUT_TEMP	;					1 (32)
;
BYTE_MAIN
	CALL	DELAY		;					10
	CALL	TRANSMIT	;					12
	MOVWF	TEMP		;					1
	MOVF	TEMP,0		;					1
	BTFSC	STATUS,Z	;					2 1
	GOTO	BYTE_END	;					- 2 (27)
	GOTO	$+1		;					2
	GOTO	$+1		;					2
	GOTO	BYTE_MAIN	;					-2 (32)		
;
BYTE_END			;					(27)
	MOVLW	-1		;					1
	ADDWF	BYTE_CNT,F	;					1
	BTFSS	STATUS,C	;					2 1
	RETLW	0		; Return				- 2 (32)
;
;									(-1)
	CALL	DELAY		;					10	
	GOTO	$+1		;					2
	GOTO	$+1		;					2
	GOTO	$+1		;					2
	GOTO	$+1		;					2
	GOTO	BYTE_START	;					2 (19)

;
;
;
; -=[ Transmit procedure  ]=-
; Procedure lenght: 12 clocks
;
; Transmits bit on 10th clock. Returns 0 if stop bit is transmitted, otherwise returns 1
;

TRANSMIT			;					(2)
	DECF	MIDI_BIT,1	;					1
	BTFSC	STATUS,Z	;					21
	GOTO	TRANSMIT_END	;					-2 (6)
	RRF	OUT_TEMP,1	;					1
	BTFSS	STATUS,C	;					2 1
	GOTO	TRANSMIT_LOW	;					- 2 (9)
	NOP			;					1
	BSF	MIDI_OUT	;					1
	RETLW	1		;					2 (12)
;
TRANSMIT_LOW			;					(9)
	BCF	MIDI_OUT	;					1
	RETLW	1		;					2 (12)
;
TRANSMIT_END			; Stop bit trasmitted			(6)
	NOP			;					1
	GOTO	$+1		;					2
	BSF	MIDI_OUT	; Put line at rest			1
	RETLW	0		;					2 (12)
	

;
; -=[ 10 clocks delay ]=-
;
DELAY
	GOTO	$+1		;					2
	GOTO	$+1		;					2
	GOTO	$+1		;					2
	RETLW	0		;					2 (10)

;
; -=[ Long Delay procedure ]=-
;
; Causes delays from 4.8 ms (1 x 4.8 ms) to 1224.0 ms (255 x 4.8 ms).
; Duration value must be put into W register before procedure call.
; Stack levels used: 2
; Returns on 30th clock. 
;
LONG_DELAY			;					(1+2)
	MOVWF	OUT_TEMP	;					1
LONG_OUT_LOOP
	MOVLW	D'199'		;					1
	MOVWF	TEMP		;					1
LONG_IN_LOOP			
	CALL	DELAY		;					10
	CALL	DELAY		;					10
	NOP			;					1
	DECFSZ	TEMP,1		; 					2 1
	GOTO	LONG_IN_LOOP	; 					- 2 (24)
	CALL	DELAY		;					10
	CALL	DELAY		;					10
	DECFSZ	OUT_TEMP,1	; 					2 1
	GOTO	LONG_OUT_LOOP	; 					- 2 (199x24+22+2)  
				;					(3)
	CALL	DELAY		;					10
	CALL	DELAY		;					10
	NOP			;					1
	GOTO	$+1		;					2
	GOTO	$+1		;					2
	RETLW	0		;					2 (30)
;
;
SYNC_DELAY			;					(2)
	COMF	PORTB,W		;					1
	ANDLW	B'00111111'	;					1
	ADDLW	D'26'		;					1
	MOVWF	OUT_TEMP	;					1 (6)
SYNC_OUT_LOOP
	MOVLW	D'3'		;					1
	MOVWF	TEMP		;					1
SYNC_IN_LOOP			
	CALL	DELAY		;					10
	CALL	DELAY		;					10
	NOP			;					1
	DECFSZ	TEMP,1		; 					2 1
	GOTO	SYNC_IN_LOOP	; 					- 2 (24)
;				;					(3x24-1)
	CALL	DELAY		;					10
	CALL	DELAY		;					10
	DECFSZ	OUT_TEMP,1	; 					2 1
	GOTO	SYNC_OUT_LOOP	; 					- 2 (3x24+22+2)  
				;					(5)
	CALL	DELAY		;					10
	CALL	DELAY		;					10
	GOTO	$+1		;					2
	NOP			;					1
	RETLW	0		;					2 (30)
	



	END
