	LIST	P=16F84
	#include "P16F84.inc"

	__FUSES	_HS_OSC & _CP_OFF & _WDT_OFF & _PWRTE_ON

; /-------------------------------------\
; |  MIDI-to-SYNC24 Converter Firmware	|
; |	     By Bojan Burkeljc		|
; |	     Version 2.31-F84		|
; |=====================================|
; | 	Microprocessor: PIC16F84	|
; |	   Cristal used: 4 MHz		|
; |=====================================|
; | Started coding on: 15th April 2000	|
; | Final Optimizing: 15th April 2000	|
; \-------------------------------------/
;
;------------------------------------------------------------------------------
;
; Features from v.2.31 (FINAL VERSION!!!):
; - fixed code for 48 pulses per quater note clock line
; - improved MIDI start bit timing
;------------------------------------------------------------------------------
;
; Features from v.2.3:
; - fixed code for 48 pulses per quater note clock line
;
;------------------------------------------------------------------------------
;
; Features from v.2.2:
; - added 48 pulses per quater note clock on pin RA3 
;       (which is used to sync some old Korg devices)
;
;------------------------------------------------------------------------------
;
; Features from v.2.01:
; - procedure for synchronization to MIDI stream at turn on
; - procedure for synchronization to MIDI at rest (fixes MIDI sync clocks 
;	recognition flaws from previous versions)
; - fixed divided-down sync tempos (explained at CLOCK_M procedure below)
; - lots of code is rewritten (a byte... err... bit less clumsy coding ;) )
;  
;------------------------------------------------------------------------------
;
; Features from v.1.1:
;  - 8 different sync tempos
;		24 pulses per quater note on pin RB7 (Roland Sync24)
;		8 pulses per quater note on pin RB0 
;		4 pulses per quater note on pin RB1
;		2 pulses per quater note on pin RB2 
;		1 pulse per quater note on pin RB3
;		2 pulses per whole note on pin RB4
;		1 pulse per whole note on pin RB5
;		1 pulse per 2 whole notes on pin RB6
;  - Roland type Start/Stop (RA1) and Continue (RA0) signals
;
;------------------------------------------------------------------------------
;
;
; -=[ Declarations, definitions'n'stuff ]=-
;
	CBLOCK H'000D'
	TEMP			; Temporary variable
	COUNT			; Pulse lenght counter 
	COUNT_LO		; 
	MIDI_IDLE_CNT		; MIDI idling counter
	MIDI_BIT		; Bit expected in MIDI byte being received
	MIDI_TEMP		; MIDI byte being received 
	SYNC_OUT		; Output variable (PortB)
	SYNC_OUT_PRE		; Previous output value (negated)
	SCALE			; Sync divide scale
	STATE48			; Describes states of Clock48
				; STATE48=3 - at clock message, clock48 high for cca 2ms
				; STATE48=2 - clock48 goes low for cca 2ms
				; STATE48=1 - clock48 goes high again for cca 2ms
	TMR_START
	TMR_END
	TMR_PER
	TMR_CUR
	ENDC
;
MIDI_SYNC_CLOCK	EQU	H'F8'	; MIDI sync clock message
PULSE_LENGHT	EQU	D'63'	; Clock pulse lenght (approx. 2ms)
;
;
#define	MIDI_IN		PORTA,2 ; MIDI input pin
#define	SYNC_CLOCK24	PORTB,7 ; Sync clock output (24ppq)
#define	SYNC_CLOCK48	PORTA,3 ; Sync clock output (48ppq)
#define	SYNC_ON		PORTA,1	; I had to insert my nick somewhere!!! ;) 
#define	SYNC_CONT	PORTA,0	; Sync continue-pulse pin
;
; -=[ Program Start ]=-
;
	ORG	H'0000'
	GOTO	INIT
;
; -=[ Initialization on startup ]=-
;
	ORG	H'0010'
INIT
	BSF	STATUS, RP0	; Bank 1
	MOVLW	B'00000000'	; Sets PORTB pins as outputs
	MOVWF	TRISB		; ...
	MOVLW	B'00010100'	; Sets RA2->RA4 as inputs	
	MOVWF	TRISA		;   and RA0 & RA1 as outputs
	BCF	STATUS, RP0	; Bank 0
	CLRF	PORTA		; Set RA pins...
	CLRF	PORTB		; ...and RB pins low
;
	CLRF	MIDI_BIT
	CLRF	COUNT
	CLRF	PCLATH
	CLRF	SYNC_OUT
	CLRF	SYNC_OUT_PRE
	MOVLW	3
	MOVWF	SCALE
	MOVLW	1
	MOVWF	STATE48
	MOVLW	COUNT
	MOVWF	FSR
;
; -=[ Turn On synchronization procedure ]=-	OK OK OK
;
; This procedure makes sure that MIDI is not trasmiting any byte (which 
; might cause MIDI byte misreading) when we turn on this device
;
TURN_ON
	MOVLW	9		;
	MOVWF	MIDI_IDLE_CNT	;
TURN_ON_CHECK
	BTFSS	MIDI_IN		; Check if line is at rest		2 1
	GOTO	MIDI_ACTIVE	; 					- 2 (3) 
	DECF	MIDI_IDLE_CNT,F	; Decrement bit counter			1
	BTFSC	STATUS,Z	; Was that 8th high bit?		2 1
	GOTO	IDLE		; Yes, synchronization was successful	- 2 (-)
	GOTO	$+1		; No, keep repeating...			2
SYNCHRONIZE_AGAIN		;					(7)
	NOP			; Time waste...				1 
	GOTO	$+1		; ... time waste...			2
	CALL	DELAY_TEN	; ... some more time waste...		10
	CALL	DELAY_TEN	; ... {zzzzzzzzzzzzz}....		10
	GOTO	TURN_ON_CHECK	; Check again				2 (32)
;
MIDI_ACTIVE			; Midi is active		 	(3)
	MOVLW	9		; Reinit the idle counter		1
	MOVWF	MIDI_IDLE_CNT	;					1
	GOTO	SYNCHRONIZE_AGAIN	; Return			2 (7)
;
;------------------------------------------------------------------------------
;
; -=[ Idle procedure ]=-
;
IDLE
	BTFSS	MIDI_IN		; 					2			
	GOTO	START_BIT	; 					-
	BTFSS	MIDI_IN		; 					2			
	GOTO	START_BIT	; 					-
	BTFSS	MIDI_IN		; 					2			
	GOTO	START_BIT	; 					-
	BTFSS	MIDI_IN		; 					2			
	GOTO	START_BIT	; 					-
	BTFSS	MIDI_IN		; 					2			
	GOTO	START_BIT	; 					-
	NOP			;					1
	BTFSS	MIDI_IN		; 					2			
	GOTO	START_BIT	; 					-
	BTFSS	MIDI_IN		; 					2			
	GOTO	START_BIT	; 					-
	BTFSS	MIDI_IN		; 					2			
	GOTO	START_BIT	; 					-
	BTFSS	MIDI_IN		; 					2			
	GOTO	START_BIT	; 					-

IDLE_COUNTDOWN			;					(19) 
	DECFSZ	INDF,F		;					2 1
	GOTO	IDLE_COUNT_NOT_ZERO	;				- 2 (22)
	CLRF	PORTB		;					1
	BCF	SYNC_CONT	;					1
	DECFSZ	STATE48,F	;					2 1
	GOTO	IDLE_STATE48_NOT_ZERO	;				- 2 (26)
	BCF	SYNC_CLOCK48	;					1
	INCF	STATE48,F	;					1
	BTFSS	MIDI_IN		; 					2			
	GOTO	START_BIT	; 					-
	NOP			;					1
	GOTO	IDLE		; Idle some more			2  (32)	
;
IDLE_STATE48_NOT_ZERO		;					(26)
	MOVLW	B'00001000'	;					1
	XORWF	PORTA,F		;					1
	MOVLW	1		;					1
	XORWF	FSR,F		;					1
	GOTO	IDLE		;					2 (32)

IDLE_COUNT_NOT_ZERO		;					(22)
	MOVLW	PULSE_LENGHT	;					1
	BTFSS	SYNC_CLOCK48	;					2 1
	MOVWF	COUNT		;					- 1
	BTFSC	SYNC_CLOCK48	;					2 1
	MOVWF	COUNT_LO	;					- 1
	BTFSS	MIDI_IN		; 					2			
	GOTO	START_BIT	; 					-
	NOP			;					1
	GOTO	IDLE		; Idle some more			2  (32)
;
START_BIT			; Low MIDI line state detected		(3)
	MOVLW	9		; Initialization stuff			1
	MOVWF	MIDI_BIT	; ...					1
	CALL	DELAY_TEN	; 					10
	CALL	DELAY_TEN	; 					10
	CALL	DELAY_6		; 					6
	GOTO	READ_MIDI	; 					2 (33)
;
;------------------------------------------------------------------------------
;
; -=[ Read MIDI procedure ]=-
;
; This procedure reads MIDI bits (amazing, isn't it? ;) ) and calculates current 
; MIDI byte value.
; It must always execute in 32 clocks (32us) if 4MHz cristal is used:
;     4MHz/(4*32)=31.25 kHz -> MIDI protocol transmition frequency. 
; 
READ_MIDI
	DECF	MIDI_BIT,F	; Yep, these are MIDI message bits	1
	BTFSC	STATUS,Z	; Check if this is the end bit 		2 1 
	GOTO	BYTE_END?	; Yep, jump to test it			- 2 (4)
	BSF	STATUS,C	;					1
	BTFSS	MIDI_IN		; Is MIDI line high?			2 1
	BCF 	STATUS,C	; Nope, skip calculation		- 1
	RRF	MIDI_TEMP,F	;					1 (7)
	CALL	DELAY_TEN	;					10
	GOTO	COUNTDOWN	; 					2 (19)	
;								
COUNTDOWN			;					(19)
	DECFSZ	INDF,F		;					2 1
	GOTO	COUNT_NOT_ZERO	;					- 2 (22)
	CLRF	PORTB		;					1
	BCF	SYNC_CONT	;					1
	DECFSZ	STATE48,F	;					2 1
	GOTO	STATE48_NOT_ZERO	;				- 2 (26)
	BCF	SYNC_CLOCK48	;					1
	INCF	STATE48,F	;					1
	NOP			;					1
	GOTO	$+1		;					2
	GOTO	READ_MIDI	; Jump to beginning			2  (32)	
;
STATE48_NOT_ZERO		;					(26)
	MOVLW	B'00001000'	;					1
	XORWF	PORTA,F		;					1
	MOVLW	1		;					1
	XORWF	FSR,F		;					1
	GOTO	READ_MIDI	;					2 (32)
;
COUNT_NOT_ZERO			;					(22)
	MOVLW	PULSE_LENGHT	;					1
	BTFSS	SYNC_CLOCK48	;					2 1
	MOVWF	COUNT		;					- 1
	BTFSC	SYNC_CLOCK48	;					2 1
	MOVWF	COUNT_LO	;					- 1
	NOP			;					1
	GOTO	$+1		;					2
	GOTO	READ_MIDI	; Jump to beginning			2  (32)	
;	
; -=[ Byte end procedure ]=-
;
; This procedure detects if income MIDI bytes are useful to this device and
; acts properly. 
;
BYTE_END?			;					(4)
	BTFSS	MIDI_IN		; Is there really end bit (line high)?	2 1
	GOTO	TURN_ON		; Nope, an error had occured		- 2 (7)
	MOVLW	MIDI_SYNC_CLOCK	; Check out what message is it.		1
	SUBWF	MIDI_TEMP,W	;  					1
	BTFSC	STATUS,Z	; Was this a Clock message?		2 1
	GOTO	CLOCK_M		; Indeed, jump				- 2 (11)
	ADDLW	-2		; 					1
	BTFSC	STATUS,Z	; Was this a Start message?		2 1
	GOTO	START_M		; 					- 2 (14)
	ADDLW	-1		; 					1
	BTFSC	STATUS,Z	; Was this a Continue message?		2 1
	GOTO	CONT_M		;					- 2 (17)
	ADDLW	-1		; 					1
	BTFSC	STATUS,Z	; Was this a Stop message?		2 1
	GOTO	STOP_M		;					- 2 (20)
	GOTO	IDLE_COUNTDOWN	; Nothing important, jump to idle	2  (21)
;	
START_M				;					(14)
	BSF	SYNC_ON		; Sync On line goes high		1
	MOVLW	1		; Initializes scale counter and		1
	MOVWF	SCALE		;   other variables to make them	1
	CLRF	SYNC_OUT	;   put all outputs high on first	1
	COMF	SYNC_OUT,W	;   MIDI clock byte received		1
	MOVWF	SYNC_OUT_PRE	;  					1
	GOTO	TIME_WASTE	;					2 (22)
;
; -[ Clock Message procedure ]-
;
; The program gets here when current MIDI byte value is F8h and the stop
; bit is transmitted.
; First of all program inits the pulse lenght counter; when it comes to zero,
; all output pins go to low state. Then it decrements scale counter which
; actually divides number of MIDI ticks by 3 for implementation of lower tempo
; sync clock outputs (pins RB0 thru RB6). At this point the program splits
; in two ways: if scale counter is not zero, program goes to SCALE_NOT, which
; sets only 24ppqn pin to high state and stores negated (1's complement) value 
; of SYNC_OUT byte to SYNC_OUT_PRE (actually it does that twice on every three
; MIDI ticks but nevermind - just think of it as some time wasting). 
; If the scale counter is zero, program first checks if Start/stop line 
; is high (that is when MIDI device/sequencer is running): if it is, it
; proceeds, otherwise it goes to SCALE_NOT.
;
; Now, if the program proceeds, we are at 7th line of CLOCK_M: here we
; handle lower tempo clocks. What we do first is decrementing the 
; SYNC_OUT register in which we store what should be on PortB. But actually
; that isn't enough: if we would increment it on every third MIDI tick and 
; put that to PortB every time, only 8ppqn line would work properly.   
; We need to do a operation called negated implication:
;	PortB = NEG [SYNC_OUT -> (SYNC_OUT +1)]
; 		or less fancy:
; 	PortB =  NEG(SYNC_OUT)  AND (SYNC_OUT+1)
; First part of bitwise AND expression has been put into SYNC_OUT_PRE
; register, so we only do the bitwise AND operation in Clock_M (9th line).
;
; What we do with negated implication is that individual PortB bits (pins) 
; are set only on their state change from low to high:
; SYNC_OUT bit i (t-1) | SYNC_OUT bit i (t)  | PortB bit i (t)
;----------------------+---------------------+----------------
;	0	       |	0	     |	    0		i= 0 to 7
;	0	       |	1	     |	    1		
;	1	       |	0	     |	    0
;	1	       |	1	     |	    0
;----------------------+---------------------+----------------
; Argument (t-1) represents previous output update; (t) is the current. 
; Remember: SYNC_OUT_PRE (t) = NEG [SYNC_OUT (t-1)]
; 
	
CLOCK_M				;					(11)
	MOVLW	PULSE_LENGHT	; Sets pulse lenght count down		1
	MOVWF	COUNT		; ...					1
	DECFSZ	SCALE,F		; Decr. scale (divide by 3) counter	2 1
	GOTO	SCALE_NOT	; Scale counter is not zero-> jump	- 2 (16)
	BTFSS	SYNC_ON		; When device is stopped, it doesn't...	2 1
	GOTO	SCALE_NOT+1	; ...refresh other lines than 24ppqn	- 2 (18)
	DECF	SYNC_OUT,F	; Decrements binary divider		1
	MOVF	SYNC_OUT,W	; 				 	1
	ANDWF	SYNC_OUT_PRE,F	; AND's SYNC_OUT_PRE to SYNC_OUT...	1
	BSF	STATUS,C	;					1
	RLF	SYNC_OUT_PRE,W	;					1
	MOVWF	PORTB		;					1
	BSF	SYNC_CLOCK24	; Set RB7 (24ppqn pulse line) high	1 (24)
	BSF	SYNC_CLOCK48	; Set RA3 (48ppqn pulse line) high	1
	MOVLW	3		; Initializes counters...		1
	MOVWF	STATE48		; ...					1
	MOVWF	SCALE		; ...					1
	BCF	FSR,0		;					1
	GOTO	IDLE		; Jumps to beginning			2 (31)
;
SCALE_NOT			;					(16)
	GOTO	$+1		;					2 
	COMF	SYNC_OUT,W	; Negation of Sync_Out			1
	MOVWF	SYNC_OUT_PRE	; Put that to Sync_Out			1
	BCF	STATUS,C	; Clear carry				1
	BSF	SYNC_CLOCK24	; Set 24ppqn pulse line high		1 (22)
	BSF	SYNC_CLOCK48	; Set RA3 (48ppqn pulse line) high	1
	MOVLW	3		; Initializes counters...		1
	MOVWF	STATE48		; ...					1
	BCF	FSR,0		;					1
	GOTO	TIME_WASTE+3	;					2 (26)
;
CONT_M				;					(17)
	BSF	SYNC_CONT	; Sets Continue pin high		1
	MOVLW	1		; Initializes scale counter...		1
	MOVWF	SCALE		; ... and other variables...		1
	CLRF	SYNC_OUT	; ... to make them put all...		1
	COMF	SYNC_OUT,W	; ... outputs high on first...		1
	MOVWF	SYNC_OUT_PRE	; ... MIDI clock byte received		1
	BSF	SYNC_ON		;					1 (24)
	GOTO	TIME_WASTE+2	;					2 (26)
;
STOP_M				;					(20)
	BCF	SYNC_ON		; Sync on line goes low			1
	NOP			;					1
	GOTO	TIME_WASTE+1	;					2 (24)
;
TIME_WASTE			;					(22)
	GOTO	$+1		;	Offset:		0	(22)	2
	GOTO	$+1		;			1	(24)	2
	GOTO	$+1		;			2	(26)	2
	GOTO	IDLE		;			3	(28)	2 (30)
	
;
;
;
;
;
; -=[ Constant tables and other call procedures ]=-
;
;
; -[ Ten clocks delay call procedure ]-
;
DELAY_TEN
	GOTO	$+1
	GOTO	$+1
DELAY_6
	GOTO	$+1
	RETURN
;
;
;
	END
