/*
 * Decompiled with CFR 0.152.
 */
package com.equitysoft.squeeze;

import com.equitysoft.squeeze.AppSpec;
import com.equitysoft.squeeze.BMPUtils;
import com.equitysoft.squeeze.Bar;
import com.equitysoft.squeeze.DestDir;
import com.equitysoft.squeeze.Dummy;
import com.equitysoft.squeeze.ESDialog;
import com.equitysoft.squeeze.ESLabel;
import com.equitysoft.squeeze.ESQ;
import com.equitysoft.squeeze.ESTripleQ;
import com.equitysoft.squeeze.ESUtils;
import com.equitysoft.squeeze.ESZap;
import com.equitysoft.squeeze.EditPrefs;
import com.equitysoft.squeeze.ImageLook;
import com.equitysoft.squeeze.LayoutFile;
import com.equitysoft.squeeze.LibButton;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Vector;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

class FileFinder
extends JPanel
implements ActionListener,
ListSelectionListener,
Runnable {
    static Color ALTCOL = new Color(153, 153, 255);
    static File HOME_DIR;
    Dimension SQ = new Dimension(26, 26);
    Dimension DIM = new Dimension(200, 20);
    static JList list;
    DefaultListModel vals;
    JScrollPane sp;
    JComboBox lookin;
    static File currdir;
    static ImageIcon diricon;
    static ImageIcon docicon;
    static ImageIcon diskicon;
    LibButton goup;
    LibButton gohome;
    LibButton create;
    LibButton all;
    LibButton invert;
    static ImageLook il;
    Thread runner;
    boolean canrun;
    boolean ignore;
    boolean ignoreselect;
    Image dirimg = ESUtils.getSystemImage("dir.gif");
    Image diskimg;

    FileFinder() {
        super(false);
        diricon = new ImageIcon(this.dirimg);
        docicon = new ImageIcon(ESUtils.getSystemImage("doc.gif"));
        this.diskimg = ESUtils.getSystemImage("disk.gif");
        diskicon = new ImageIcon(this.diskimg);
        this.setLayout(new BorderLayout());
        this.create = new LibButton("Create applet", "go.gif");
        JPanel jPanel = new JPanel(false);
        jPanel.setLayout(new FlowLayout(0, 6, 5));
        jPanel.add(new JLabel("Look in:"));
        this.lookin = new JComboBox();
        jPanel.add(this.lookin);
        this.lookin.setRenderer(new LCRenderer());
        this.addRoots();
        this.goup = new LibButton(null, "updir.gif");
        jPanel.add(this.goup);
        this.goup.addActionListener(this);
        this.goup.setPreferredSize(this.SQ);
        this.goup.setToolTipText("Go up a directory level");
        this.gohome = new LibButton(null, "home.gif");
        jPanel.add(this.gohome);
        this.gohome.addActionListener(this);
        this.gohome.setPreferredSize(this.SQ);
        this.gohome.setToolTipText("Go to the home directory");
        this.add((Component)jPanel, "North");
        JPanel jPanel2 = new JPanel(false);
        jPanel2.setLayout(new BorderLayout());
        this.sp = new JScrollPane();
        this.vals = new DefaultListModel();
        list = new JList();
        list.setCellRenderer(new FFRenderer(list));
        list.setModel(this.vals);
        this.sp.getViewport().setView(list);
        jPanel2.add((Component)this.sp, "Center");
        il = new ImageLook(100, 200);
        jPanel2.add((Component)il, "East");
        this.add((Component)jPanel2, "Center");
        this.lookin.addActionListener(this);
        list.addListSelectionListener(this);
        JPanel jPanel3 = new JPanel(false);
        jPanel3.setLayout(new FlowLayout(0, 3, 3));
        this.all = new LibButton("Select all");
        jPanel3.add(this.all);
        this.all.addActionListener(this);
        this.invert = new LibButton("Invert");
        jPanel3.add(this.invert);
        this.invert.addActionListener(this);
        jPanel3.add(new Dummy(20));
        jPanel3.add(this.create);
        this.create.addActionListener(this);
        this.create.setPreferredSize(new Dimension(130, 35));
        this.add((Component)jPanel3, "South");
        this.setDir(currdir);
        this.setUpDir();
    }

    static Image getCurrent() {
        if (list.isSelectionEmpty()) {
            return null;
        }
        return FileFinder.il.img;
    }

    void setUpDir() {
        File file;
        this.ignore = true;
        int n = this.lookin.getItemCount();
        String string = currdir.getAbsolutePath();
        int n2 = 0;
        n2 = 0;
        while (n2 < n) {
            file = (File)this.lookin.getItemAt(n2);
            if (string.startsWith(file.getAbsolutePath())) break;
            ++n2;
        }
        int n3 = this.getDepth(currdir);
        if (n3 == 0) {
            this.lookin.setSelectedIndex(n2);
            this.ignore = false;
            return;
        }
        if (n2 == n) {
            new ESZap("A storage device is missing - unable to load the 'Lookin' directories.");
            return;
        }
        ++n2;
        file = currdir;
        while (true) {
            if (n2 == n) {
                this.lookin.addItem(file);
            } else {
                this.lookin.insertItemAt(file, n2);
            }
            file = file.getParentFile();
            if (file.getParentFile() == null) break;
            n = -1;
        }
        this.lookin.setSelectedItem(currdir);
        this.ignore = false;
    }

    void setDir(File file) {
        File file2;
        if (this.getDepth(file) == 0) {
            this.goup.setEnabled(false);
        } else {
            this.goup.setEnabled(true);
        }
        this.create.setEnabled(false);
        this.vals.removeAllElements();
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return;
        }
        int n = fileArray.length;
        File[] fileArray2 = new File[n];
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            file2 = fileArray[n3];
            if (file2.isDirectory()) {
                fileArray2[n2] = file2;
                ++n2;
            }
            ++n3;
        }
        FileFinder.fileBubbleSort(fileArray2, n2);
        int n4 = 0;
        while (n4 < n2) {
            this.vals.addElement(fileArray2[n4]);
            ++n4;
        }
        n2 = 0;
        int n5 = 0;
        while (n5 < n) {
            int n6;
            String string;
            file2 = fileArray[n5];
            if (!file2.isDirectory() && (string = file2.getName()).regionMatches(true, n6 = string.length() - 4, ".bmp", 0, 4)) {
                fileArray2[n2] = file2;
                ++n2;
            }
            ++n5;
        }
        FileFinder.fileBubbleSort(fileArray2, n2);
        int n7 = 0;
        while (n7 < n2) {
            this.vals.addElement(fileArray2[n7]);
            ++n7;
        }
        il.view(null);
        currdir = file;
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (this.ignoreselect) {
            return;
        }
        int n = list.getSelectedIndex();
        if (n < 0) {
            return;
        }
        File file = (File)this.vals.getElementAt(n);
        if (file.isDirectory()) {
            File file2;
            this.setDir(file);
            int n2 = this.lookin.getItemCount();
            String string = file.getAbsolutePath();
            int n3 = 0;
            n3 = 0;
            while (n3 < n2) {
                file2 = (File)this.lookin.getItemAt(n3);
                if (string.startsWith(file2.getAbsolutePath())) break;
                ++n3;
            }
            if (n3 == n2 - 1) {
                this.lookin.addItem(file);
                this.lookin.setSelectedIndex(n2);
            } else {
                int n4 = 0;
                n4 = n3;
                while (n4 < n2) {
                    file2 = (File)this.lookin.getItemAt(n4);
                    if (!string.startsWith(file2.getAbsolutePath())) break;
                    ++n4;
                }
                this.lookin.insertItemAt(file, n4);
                this.ignore = true;
                this.lookin.setSelectedItem(file);
                this.ignore = false;
            }
        } else {
            this.create.setEnabled(true);
            il.view(file);
        }
    }

    int getDepth(File file) {
        int n = 0;
        while ((file = file.getParentFile()) != null) {
            ++n;
        }
        return n;
    }

    void addRoots() {
        File[] fileArray = File.listRoots();
        int n = fileArray.length;
        this.ignore = true;
        int n2 = 0;
        while (n2 < n) {
            this.lookin.addItem(fileArray[n2]);
            ++n2;
        }
        this.ignore = false;
    }

    void removeLookin(File file) {
        Vector<File> vector = new Vector<File>();
        int n = this.lookin.getItemCount();
        String string = file.getAbsolutePath();
        int n2 = 0;
        while (n2 < n) {
            File file2 = (File)this.lookin.getItemAt(n2);
            String string2 = file2.getAbsolutePath();
            if (string2.startsWith(string) && !string2.equals(string)) {
                vector.addElement(file2);
            }
            ++n2;
        }
        n = vector.size();
        this.ignore = true;
        int n3 = 0;
        while (n3 < n) {
            this.lookin.removeItem(vector.elementAt(n3));
            ++n3;
        }
        this.ignore = false;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof JComboBox) {
            if (!this.ignore) {
                File file = (File)this.lookin.getSelectedItem();
                File[] fileArray = file.listFiles();
                if (fileArray == null) {
                    new ESZap("The device '" + file.getAbsolutePath() + "' is not accessible.");
                    this.ignore = true;
                    this.lookin.setSelectedItem(currdir);
                    this.ignore = false;
                    return;
                }
                this.removeLookin(file);
                this.setDir(file);
            }
        } else if (object instanceof LibButton) {
            LibButton libButton = (LibButton)object;
            if (libButton == this.goup) {
                if (this.getDepth(currdir) == 0) {
                    return;
                }
                File file = currdir.getParentFile();
                this.setDir(file);
                this.removeLookin(file);
            } else if (libButton == this.gohome) {
                this.setDir(HOME_DIR);
                Vector<File> vector = new Vector<File>();
                int n = this.lookin.getItemCount();
                int n2 = 0;
                while (n2 < n) {
                    File file = (File)this.lookin.getItemAt(n2);
                    if (this.getDepth(file) > 0) {
                        vector.addElement(file);
                    }
                    ++n2;
                }
                n = vector.size();
                this.ignore = true;
                int n3 = 0;
                while (n3 < n) {
                    this.lookin.removeItem(vector.elementAt(n3));
                    ++n3;
                }
                this.ignore = false;
                this.setUpDir();
            } else if (libButton == this.create) {
                if (this.runner == null) {
                    this.canrun = true;
                    this.runner = new Thread(this);
                    this.runner.start();
                }
            } else if (libButton == this.all || libButton == this.invert) {
                int n = this.vals.getSize();
                Vector<Integer> vector = new Vector<Integer>(50);
                int n4 = 0;
                while (n4 < n) {
                    File file = (File)this.vals.getElementAt(n4);
                    if (!file.isDirectory()) {
                        if (libButton == this.all) {
                            vector.addElement(new Integer(n4));
                        } else if (!list.isSelectedIndex(n4)) {
                            vector.addElement(new Integer(n4));
                        }
                    }
                    ++n4;
                }
                n = vector.size();
                int[] nArray = new int[n];
                int n5 = 0;
                while (n5 < n) {
                    nArray[n5] = (Integer)vector.elementAt(n5);
                    ++n5;
                }
                this.ignoreselect = true;
                list.setSelectedIndices(nArray);
                this.ignoreselect = false;
                il.view(null);
                if (nArray.length > 0) {
                    this.create.setEnabled(true);
                } else {
                    this.create.setEnabled(false);
                }
            }
        }
    }

    public void run() {
        RunProgress runProgress = null;
        Object[] objectArray = list.getSelectedValues();
        int n = objectArray.length;
        if (n == 0) {
            this.runner = null;
            return;
        }
        this.create.setEnabled(false);
        il.view(null);
        list.clearSelection();
        if (n > 1) {
            runProgress = new RunProgress(n);
        }
        boolean bl = true;
        if (EditPrefs.clipboard.isYes()) {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(new StringSelection(""), Bar.handle);
        }
        int n2 = 0;
        while (n2 < n) {
            if (!this.canrun) break;
            File file = (File)objectArray[n2];
            if (n > 1) {
                runProgress.set(n2 + 1, file.getName());
            }
            AppSpec appSpec = new AppSpec(file);
            appSpec.dim = EditPrefs.enlarge.isSelected() ? this.calcSize(BMPUtils.getDim(file)) : BMPUtils.getDim(file);
            if (appSpec != null) {
                File file2 = new File(DestDir.dir, appSpec.name + ".html");
                if (bl && file2.exists()) {
                    if (n > 1) {
                        int n3 = ESTripleQ.ask("Overwrite the existing '" + appSpec.name + "' file ?", "Overwrite all", "Overwrite", "Cancel");
                        if (n3 == 3) {
                            runProgress.closeDialog();
                            this.runner = null;
                            return;
                        }
                        if (n3 == 0) {
                            bl = false;
                        }
                    } else if (!ESQ.ask("Overwrite the existing file " + appSpec.name + "' ?", "Overwrite", "Cancel")) {
                        this.runner = null;
                        return;
                    }
                }
                appSpec.file = file2;
                LayoutFile.doSave(appSpec);
            }
            ++n2;
        }
        this.runner = null;
        if (n > 1) {
            runProgress.closeDialog();
        }
    }

    Dimension calcSize(Dimension dimension) {
        int n = EditPrefs.wid.getValue();
        int n2 = EditPrefs.hgt.getValue();
        float f = dimension.width;
        float f2 = dimension.height;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = f / f2;
        if (f > f2) {
            f3 = n;
            f4 = (int)(f3 / f5);
            if (f4 > (float)n2) {
                f4 = n2;
                f3 = (int)(f5 * f4);
            }
        } else {
            f4 = n2;
            f3 = (int)(f5 * f4);
            if (f3 > (float)n) {
                f3 = n;
                f4 = (int)(f3 / f5);
            }
        }
        return new Dimension((int)f3, (int)f4);
    }

    static void fileBubbleSort(File[] fileArray, int n) {
        int n2 = n - 1;
        boolean bl = false;
        while (true) {
            int n3 = 0;
            while (n3 < n2) {
                int n4 = n3 + 1;
                if (fileArray[n3].getName().compareToIgnoreCase(fileArray[n4].getName()) > 0) {
                    File file = fileArray[n4];
                    fileArray[n4] = fileArray[n3];
                    fileArray[n3] = file;
                    bl = true;
                }
                ++n3;
            }
            if (!bl) break;
            bl = false;
            --n2;
        }
    }

    class FFRenderer
    extends DefaultListCellRenderer {
        FFRenderer(JList jList) {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            File file = (File)object;
            Component component = super.getListCellRendererComponent((JList<?>)jList, file.getName(), n, bl, bl2);
            if (file.isDirectory()) {
                this.setIcon(diricon);
            } else {
                this.setIcon(docicon);
            }
            return component;
        }
    }

    class LCRenderer
    extends Component
    implements ListCellRenderer {
        boolean isdisk;
        Color back;
        String txt;
        int indent;
        boolean selected;

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            File file = (File)object;
            if (FileFinder.this.getDepth(file) > 0) {
                this.isdisk = false;
                this.txt = file.getName();
            } else {
                this.isdisk = true;
                this.txt = file.getAbsolutePath();
            }
            this.indent = n < 0 ? 0 : 1 + FileFinder.this.getDepth(file) * 8;
            this.selected = bl;
            return this;
        }

        public void update(Graphics graphics) {
            this.paint(graphics);
        }

        public void paint(Graphics graphics) {
            if (this.back == null) {
                this.back = this.getParent().getBackground();
            }
            graphics.setColor(this.selected ? ALTCOL : this.back);
            graphics.fillRect(0, 0, FileFinder.this.DIM.width + 30, FileFinder.this.DIM.height);
            if (this.isdisk) {
                graphics.drawImage(FileFinder.this.diskimg, this.indent, 2, null);
            } else {
                graphics.drawImage(FileFinder.this.dirimg, this.indent, 2, null);
            }
            graphics.setFont(ESUtils.MSG_FONT);
            graphics.setColor(Color.black);
            graphics.drawString(this.txt, this.indent + 21, 15);
        }

        public Dimension getPreferredSize() {
            return FileFinder.this.DIM;
        }
    }

    class RunProgress
    extends ESDialog
    implements ActionListener {
        ESLabel txt;
        int len;
        JProgressBar pb;

        RunProgress(int n) {
            super("Progress of applet creation.", false);
            this.len = n;
            this.jp.setLayout(new BorderLayout());
            JPanel jPanel = new JPanel();
            this.txt = new ESLabel("Creating applets...");
            jPanel.add(this.txt);
            this.jp.add((Component)jPanel, "North");
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new FlowLayout(1, 10, 5));
            this.pb = new JProgressBar(0, n);
            jPanel2.add(this.pb);
            this.pb.setPreferredSize(new Dimension(300, 25));
            this.pb.setStringPainted(true);
            this.jp.add((Component)jPanel2, "Center");
            JPanel jPanel3 = new JPanel();
            LibButton libButton = new LibButton("Cancel");
            jPanel3.add(libButton);
            libButton.addActionListener(this);
            this.jp.add((Component)jPanel3, "South");
            this.finishOff();
        }

        void set(int n, String string) {
            this.txt.setText("Creating applet for image '" + string + "'");
            this.pb.setValue(n);
            this.pb.setString(n + " of " + this.len);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            FileFinder.this.canrun = false;
            this.closeDialog();
        }
    }
}

