/*
 * Decompiled with CFR 0.152.
 */
package com.equitysoft.squeeze;

import com.equitysoft.squeeze.ColorPanel;
import com.equitysoft.squeeze.ESUtils;
import com.equitysoft.squeeze.ESZap;
import com.equitysoft.squeeze.ISLib;
import com.equitysoft.squeeze.PMBox;
import com.equitysoft.squeeze.PMBoxAdjuster;
import com.equitysoft.squeeze.Prefs;
import com.equitysoft.squeeze.URLBox;
import com.equitysoft.squeeze.VerticalLayout;
import com.equitysoft.squeeze.YesNo;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;

public class EditPrefs
extends JPanel {
    static final int OFF = 0;
    static final int DEFAULT = 1;
    static final int ORIG = 2;
    static JTextField version;
    static JTextField overmsg;
    static YesNo center;
    static YesNo html;
    static YesNo clipboard;
    static YesNo mag;
    static YesNo smooth;
    static URLBox url;
    static ColorPanel pagecol;
    static JRadioButton enlarge;
    static JRadioButton noenlarge;
    static JRadioButton origsize;
    static PMBox wid;
    static PMBox hgt;
    static PMBox jump;

    EditPrefs() {
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Applet options"));
        this.setLayout(new BorderLayout());
        JTabbedPane jTabbedPane = new JTabbedPane();
        this.add((Component)jTabbedPane, "Center");
        jTabbedPane.addTab("Enlarger", new Enlarger());
        url = new URLBox();
        jTabbedPane.addTab("Hyperlink", url);
        jTabbedPane.addTab("HTML options", new LastBox());
        jTabbedPane.setPreferredSize(new Dimension(jTabbedPane.getPreferredSize().width, 400));
        jTabbedPane.setIconAt(2, new ImageIcon(ESUtils.getESURL("sq1.gif")));
        jTabbedPane.setIconAt(1, new ImageIcon(ESUtils.getESURL("sq2.gif")));
        jTabbedPane.setIconAt(0, new ImageIcon(ESUtils.getESURL("sq3.gif")));
    }

    static void writeValues() {
        Prefs.setBoolean("html", html.isYes());
        Prefs.setBoolean("clipboard", clipboard.isYes());
        if (!noenlarge.isSelected()) {
            Prefs.setInt("enlarge", enlarge.isSelected() ? 1 : 2);
            Prefs.set("overmsg", overmsg.getText());
        } else {
            Prefs.setInt("enlarge", 0);
        }
        Prefs.setInt("wid", wid.getValue());
        Prefs.setInt("hgt", hgt.getValue());
        Prefs.setInt("jump", jump.getValue());
        Prefs.setBoolean("center", center.isYes());
        Prefs.setInt("page", pagecol.getRGB());
        if (version.getText().equals("")) {
            version.setText(Prefs.NEEDED);
        }
        Prefs.set("version", version.getText());
    }

    class LastBox
    extends JPanel {
        LastBox() {
            this.setLayout(new VerticalLayout(5, 3));
            html = new YesNo("Create HTML file", "Don't create", "Create file");
            this.add(html);
            html.setYes(Prefs.getBoolean("html"));
            clipboard = new YesNo("Paste HTML into system clipboard", "Don't paste", "Paste into clipboard");
            this.add(clipboard);
            clipboard.setYes(Prefs.getBoolean("clipboard"));
            pagecol = new ColorPanel("Webpage color", "page");
            this.add(pagecol);
            center = new YesNo("Position of applet on page", "Default", "Center");
            this.add(center);
            center.setYes(Prefs.getBoolean("center"));
            JPanel jPanel = new JPanel(false);
            jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Wrong Java version message"));
            version = new JTextField(30);
            jPanel.add(version);
            version.setText(Prefs.get("version"));
            version.setFont(ESUtils.MSG_FONT);
            this.add(jPanel);
        }
    }

    class Enlarger
    extends JPanel
    implements PMBoxAdjuster,
    ActionListener {
        JRadioButton inc1;
        JRadioButton inc10;

        Enlarger() {
            super(false);
            this.setLayout(new VerticalLayout(0, 3));
            JPanel jPanel = new JPanel(false);
            ButtonGroup buttonGroup = new ButtonGroup();
            noenlarge = new JRadioButton("Enlarger off");
            jPanel.add(noenlarge);
            buttonGroup.add(noenlarge);
            noenlarge.addActionListener(this);
            enlarge = new JRadioButton("Enlarger (scaled)");
            jPanel.add(enlarge);
            buttonGroup.add(enlarge);
            enlarge.addActionListener(this);
            origsize = new JRadioButton("Enlarger (orig size)");
            jPanel.add(origsize);
            buttonGroup.add(origsize);
            origsize.addActionListener(this);
            this.add((Component)jPanel, "North");
            JPanel jPanel2 = new JPanel(false);
            jPanel2.setLayout(new VerticalLayout(0, 3));
            jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Size to scale and fit image into for display"));
            JPanel jPanel3 = new JPanel(false);
            jPanel3.setLayout(new FlowLayout(1, 10, 0));
            wid = new PMBox("Width", this, Prefs.getInt("wid"), 0, 1000);
            jPanel3.add(wid);
            hgt = new PMBox("Height", this, Prefs.getInt("hgt"), 0, 1000);
            jPanel3.add(hgt);
            jPanel2.add(jPanel3);
            JPanel jPanel4 = new JPanel(false);
            ButtonGroup buttonGroup2 = new ButtonGroup();
            this.inc1 = new JRadioButton("Increment by 1");
            jPanel4.add(this.inc1);
            buttonGroup2.add(this.inc1);
            this.inc1.addActionListener(this);
            this.inc10 = new JRadioButton("Increment by 10");
            jPanel4.add(this.inc10);
            buttonGroup2.add(this.inc10);
            this.inc10.addActionListener(this);
            this.inc1.setSelected(true);
            jPanel2.add(jPanel4);
            this.add(jPanel2);
            JPanel jPanel5 = new JPanel(false);
            jPanel5.setLayout(new BorderLayout());
            jump = new PMBox("Percent enlargement per click", this, Prefs.getInt("jump"), 1, 35);
            jPanel5.add((Component)jump, "Center");
            mag = new YesNo("Magnification", "Hide", "Show");
            jPanel5.add((Component)mag, "East");
            this.add(jPanel5);
            smooth = new YesNo("Method of interpolating pixels", "Use replication", "Use averaging (smoother & slower)");
            this.add(smooth);
            JPanel jPanel6 = new JPanel(false);
            jPanel6.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Status message shown on mouse over"));
            overmsg = new JTextField(30);
            jPanel6.add(overmsg);
            overmsg.setText(Prefs.get("overmsg"));
            overmsg.setFont(ISLib.MSG_FONT);
            this.add(jPanel6);
            int n = Prefs.getInt("enlarge");
            if (n != 0) {
                if (n == 1) {
                    enlarge.setSelected(true);
                } else {
                    origsize.setSelected(true);
                    this.sizeOff();
                }
            } else {
                noenlarge.setSelected(true);
                this.off();
            }
        }

        void sizeOff() {
            Prefs.setInt("wid", wid.getValue());
            Prefs.setInt("hgt", hgt.getValue());
            wid.off();
            hgt.off();
            this.inc1.setSelected(true);
            this.inc1.setEnabled(false);
            this.inc10.setEnabled(false);
        }

        void sizeOn() {
            wid.on(Prefs.getInt("wid"));
            hgt.on(Prefs.getInt("hgt"));
            this.inc1.setEnabled(true);
            this.inc10.setEnabled(true);
        }

        void msgOff() {
            Prefs.setInt("jump", jump.getValue());
            jump.off();
            mag.off();
            smooth.off();
            Prefs.set("overmsg", overmsg.getText());
            overmsg.setText("");
            overmsg.setBackground(Color.lightGray);
            overmsg.setEnabled(false);
        }

        void msgOn() {
            jump.on(Prefs.getInt("jump"));
            overmsg.setEnabled(true);
            overmsg.setBackground(Color.white);
            overmsg.setText(Prefs.get("overmsg"));
            mag.on();
            smooth.on();
        }

        void off() {
            this.sizeOff();
            this.msgOff();
        }

        void on() {
            this.sizeOn();
            this.msgOn();
        }

        public boolean adjust(PMBox pMBox, int n) {
            return true;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JRadioButton jRadioButton = (JRadioButton)actionEvent.getSource();
            if (jRadioButton == this.inc1) {
                wid.setInc(1);
                hgt.setInc(1);
            } else if (jRadioButton == this.inc10) {
                wid.setInc(10);
                hgt.setInc(10);
            } else if (jRadioButton == enlarge || jRadioButton == origsize) {
                if (URLBox.yes.isSelected()) {
                    noenlarge.setSelected(true);
                    new ESZap("The enlarger option cannot be used with a hyperlink set");
                } else if (jRadioButton == enlarge) {
                    this.on();
                } else {
                    this.sizeOff();
                    this.msgOn();
                }
            } else if (jRadioButton == noenlarge) {
                this.off();
            }
        }
    }
}

