/*
 * Decompiled with CFR 0.152.
 */
package com.equitysoft.squeeze;

import com.equitysoft.squeeze.ESDialog;
import com.equitysoft.squeeze.ESUtils;
import com.equitysoft.squeeze.ESZap;
import com.equitysoft.squeeze.ImageLook;
import com.equitysoft.squeeze.LibButton;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

class DirFinder
extends ESDialog
implements ActionListener,
ListSelectionListener {
    static final int CHOOSE_DIR = 0;
    static final int CHOOSE_IMAGE = 1;
    static final int SAVE_JAR = 2;
    static Color ALTCOL = new Color(153, 153, 255);
    Dimension SQ = new Dimension(26, 26);
    Dimension DIM = new Dimension(250, 20);
    JList list;
    DefaultListModel vals;
    JScrollPane sp;
    JComboBox lookin;
    static File currdir;
    static File currfile;
    File homedir;
    int curridx;
    LibButton goup;
    LibButton gohome;
    LibButton select;
    LibButton cancel;
    boolean ignore;
    int type;
    ImageLook il;
    static JTextField fn;
    static ImageIcon diricon;
    static ImageIcon diskicon;
    static ImageIcon docicon;
    static Image dirimg;
    static Image diskimg;

    DirFinder(File file, String string, int n) {
        super(string);
        JPanel jPanel;
        this.type = n;
        this.homedir = currdir = file;
        if (docicon == null) {
            docicon = new ImageIcon(ESUtils.getSystemImage("doc.gif"));
            dirimg = ESUtils.getSystemImage("dir.gif");
            diricon = new ImageIcon(dirimg);
            diskimg = ESUtils.getSystemImage("disk.gif");
            diskicon = new ImageIcon(diskimg);
        }
        this.jp.setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(0, 6, 5));
        jPanel2.add(new JLabel("Look in:"));
        this.lookin = new JComboBox();
        jPanel2.add(this.lookin);
        this.lookin.setRenderer(new LCRenderer());
        this.addRoots();
        this.goup = new LibButton(null, "updir.gif");
        jPanel2.add(this.goup);
        this.goup.addActionListener(this);
        this.goup.setPreferredSize(this.SQ);
        this.goup.setToolTipText("Go up a directory level");
        this.gohome = new LibButton(null, "home.gif");
        jPanel2.add(this.gohome);
        this.gohome.addActionListener(this);
        this.gohome.setPreferredSize(this.SQ);
        this.gohome.setToolTipText("Go to the home directory");
        this.jp.add((Component)jPanel2, "North");
        JPanel jPanel3 = new JPanel();
        jPanel3.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel3.setLayout(new BorderLayout());
        this.sp = new JScrollPane();
        this.vals = new DefaultListModel();
        this.list = new JList();
        this.list.setSelectionMode(0);
        this.list.setCellRenderer(new FFRenderer(this.list));
        this.list.setModel(this.vals);
        this.sp.getViewport().setView(this.list);
        jPanel3.add((Component)this.sp, "Center");
        if (n == 1) {
            this.il = new ImageLook(100, 200);
            jPanel3.add((Component)this.il, "East");
        }
        this.jp.add((Component)jPanel3, "Center");
        this.lookin.addActionListener(this);
        this.list.addListSelectionListener(this);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout());
        if (n == 2) {
            jPanel = new JPanel();
            jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "JAR file name"));
            fn = new JTextField(25);
            jPanel.add(fn);
            fn.setFont(ESUtils.MSG_FONT);
            jPanel4.add((Component)jPanel, "North");
        }
        jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createEtchedBorder());
        String string2 = n == 0 ? "Select directory" : (n == 1 ? "Select image" : "Save");
        this.select = new LibButton(string2);
        jPanel.add(this.select);
        this.select.addActionListener(this);
        if (n == 1) {
            this.select.setEnabled(false);
        }
        this.cancel = new LibButton("Cancel");
        jPanel.add(this.cancel);
        this.cancel.addActionListener(this);
        jPanel4.add((Component)jPanel, "South");
        this.jp.add((Component)jPanel4, "South");
        this.setDir(currdir);
        this.setUpDir();
        this.finishOff();
        if (fn != null) {
            fn.requestFocus();
        }
    }

    void setUpDir() {
        File file;
        this.ignore = true;
        int n = this.lookin.getItemCount();
        String string = currdir.getAbsolutePath();
        int n2 = 0;
        n2 = 0;
        while (n2 < n) {
            file = (File)this.lookin.getItemAt(n2);
            if (string.startsWith(file.getAbsolutePath())) break;
            ++n2;
        }
        int n3 = this.getDepth(currdir);
        if (n3 == 0) {
            this.lookin.setSelectedIndex(n2);
            this.ignore = false;
            return;
        }
        if (n2 == n) {
            new ESZap("An expected device is missing - the program may not function properly.");
            return;
        }
        ++n2;
        file = currdir;
        while (true) {
            if (n2 == n) {
                this.lookin.addItem(file);
            } else {
                this.lookin.insertItemAt(file, n2);
            }
            file = file.getParentFile();
            if (file.getParentFile() == null) break;
            n = -1;
        }
        this.lookin.setSelectedItem(currdir);
        this.ignore = false;
    }

    void setDir(File file) {
        File file2;
        if (this.getDepth(file) == 0) {
            this.goup.setEnabled(false);
        } else {
            this.goup.setEnabled(true);
        }
        this.vals.removeAllElements();
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return;
        }
        int n = fileArray.length;
        File[] fileArray2 = new File[n];
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            file2 = fileArray[n3];
            if (file2.isDirectory()) {
                fileArray2[n2] = file2;
                ++n2;
            }
            ++n3;
        }
        DirFinder.fileBubbleSort(fileArray2, n2);
        int n4 = 0;
        while (n4 < n2) {
            this.vals.addElement(fileArray2[n4]);
            ++n4;
        }
        if (this.type != 0) {
            n2 = 0;
            int n5 = 0;
            while (n5 < n) {
                file2 = fileArray[n5];
                if (!file2.isDirectory()) {
                    String string = file2.getName();
                    int n6 = string.length() - 4;
                    if (this.type == 1 ? string.regionMatches(true, n6, ".gif", 0, 4) || string.regionMatches(true, n6, ".jpg", 0, 4) : string.regionMatches(true, n6, ".jar", 0, 4)) {
                        fileArray2[n2] = file2;
                        ++n2;
                    }
                }
                ++n5;
            }
            if (n2 > 0) {
                DirFinder.fileBubbleSort(fileArray2, n2);
                int n7 = 0;
                while (n7 < n2) {
                    this.vals.addElement(fileArray2[n7]);
                    ++n7;
                }
            }
            currfile = null;
            if (this.type == 1) {
                this.il.view(null);
                this.select.setEnabled(false);
            } else {
                fn.setText("");
            }
        }
        currdir = file;
        this.curridx = -2;
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        int n = this.list.getSelectedIndex();
        if (n < 0) {
            return;
        }
        if (this.curridx == n) {
            return;
        }
        this.curridx = n;
        File file = (File)this.vals.getElementAt(n);
        if (file.isDirectory()) {
            File file2;
            this.setDir(file);
            int n2 = this.lookin.getItemCount();
            String string = file.getAbsolutePath();
            int n3 = 0;
            n3 = 0;
            while (n3 < n2) {
                file2 = (File)this.lookin.getItemAt(n3);
                if (string.startsWith(file2.getAbsolutePath())) break;
                ++n3;
            }
            if (n3 == n2 - 1) {
                this.lookin.addItem(file);
                this.lookin.setSelectedIndex(n2);
            } else {
                int n4 = 0;
                n4 = n3;
                while (n4 < n2) {
                    file2 = (File)this.lookin.getItemAt(n4);
                    if (!string.startsWith(file2.getAbsolutePath())) break;
                    ++n4;
                }
                this.lookin.insertItemAt(file, n4);
                this.ignore = true;
                this.lookin.setSelectedItem(file);
                this.ignore = false;
            }
        } else if (this.type == 1) {
            currfile = file;
            this.il.view(file);
            this.select.setEnabled(true);
        } else if (this.type == 2) {
            currfile = file;
            fn.setText(file.getName());
        }
    }

    int getDepth(File file) {
        int n = 0;
        while ((file = file.getParentFile()) != null) {
            ++n;
        }
        return n;
    }

    void addRoots() {
        File[] fileArray = File.listRoots();
        int n = fileArray.length;
        this.ignore = true;
        int n2 = 0;
        while (n2 < n) {
            this.lookin.addItem(fileArray[n2]);
            ++n2;
        }
        this.ignore = false;
    }

    void removeLookin(File file) {
        Vector<File> vector = new Vector<File>();
        int n = this.lookin.getItemCount();
        String string = file.getAbsolutePath();
        int n2 = 0;
        while (n2 < n) {
            File file2 = (File)this.lookin.getItemAt(n2);
            String string2 = file2.getAbsolutePath();
            if (string2.startsWith(string) && !string2.equals(string)) {
                vector.addElement(file2);
            }
            ++n2;
        }
        n = vector.size();
        this.ignore = true;
        int n3 = 0;
        while (n3 < n) {
            this.lookin.removeItem(vector.elementAt(n3));
            ++n3;
        }
        this.ignore = false;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof JComboBox) {
            if (!this.ignore) {
                File file = (File)this.lookin.getSelectedItem();
                File[] fileArray = file.listFiles();
                if (fileArray == null) {
                    new ESZap("The device '" + file.getAbsolutePath() + "' is not accessible.");
                    this.ignore = true;
                    this.lookin.setSelectedItem(currdir);
                    this.ignore = false;
                    return;
                }
                this.removeLookin(file);
                this.setDir(file);
            }
        } else if (object instanceof LibButton) {
            LibButton libButton = (LibButton)object;
            if (libButton == this.goup) {
                if (this.getDepth(currdir) == 0) {
                    return;
                }
                File file = currdir.getParentFile();
                this.setDir(file);
                this.removeLookin(file);
            } else if (libButton == this.gohome) {
                this.setDir(this.homedir);
                Vector<File> vector = new Vector<File>();
                int n = this.lookin.getItemCount();
                int n2 = 0;
                while (n2 < n) {
                    File file = (File)this.lookin.getItemAt(n2);
                    if (this.getDepth(file) > 0) {
                        vector.addElement(file);
                    }
                    ++n2;
                }
                n = vector.size();
                this.ignore = true;
                int n3 = 0;
                while (n3 < n) {
                    this.lookin.removeItem(vector.elementAt(n3));
                    ++n3;
                }
                this.ignore = false;
                this.setUpDir();
            } else if (libButton == this.cancel) {
                if (fn != null) {
                    fn.setText("");
                }
                currfile = null;
                currdir = null;
                this.closeDialog();
            } else if (libButton == this.select) {
                this.closeDialog();
            }
        }
    }

    void finalCall() {
        currfile = null;
        currdir = null;
    }

    static File ask(File file, String string, int n) {
        new DirFinder(file, string, n);
        if (n == 0) {
            return currdir;
        }
        if (n == 2) {
            if (fn.getText().equals("")) {
                return null;
            }
            return new File(currdir, fn.getText());
        }
        return currfile;
    }

    static void fileBubbleSort(File[] fileArray, int n) {
        int n2 = n - 1;
        boolean bl = false;
        while (true) {
            int n3 = 0;
            while (n3 < n2) {
                int n4 = n3 + 1;
                if (fileArray[n3].getName().compareToIgnoreCase(fileArray[n4].getName()) > 0) {
                    File file = fileArray[n4];
                    fileArray[n4] = fileArray[n3];
                    fileArray[n3] = file;
                    bl = true;
                }
                ++n3;
            }
            if (!bl) break;
            bl = false;
            --n2;
        }
    }

    class FFRenderer
    extends DefaultListCellRenderer {
        FFRenderer(JList jList) {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            File file = (File)object;
            if (file.isDirectory()) {
                this.setIcon(diricon);
            } else {
                this.setIcon(docicon);
            }
            return super.getListCellRendererComponent((JList<?>)jList, file.getName(), n, bl, bl2);
        }
    }

    class LCRenderer
    extends Component
    implements ListCellRenderer {
        boolean isdisk;
        Color back;
        String txt;
        int indent;
        boolean selected;

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            File file = (File)object;
            if (DirFinder.this.getDepth(file) > 0) {
                this.isdisk = false;
                this.txt = file.getName();
            } else {
                this.isdisk = true;
                this.txt = file.getAbsolutePath();
            }
            this.indent = n < 0 ? 0 : 1 + DirFinder.this.getDepth(file) * 8;
            this.selected = bl;
            return this;
        }

        public void update(Graphics graphics) {
            this.paint(graphics);
        }

        public void paint(Graphics graphics) {
            if (this.back == null) {
                this.back = this.getParent().getBackground();
            }
            graphics.setColor(this.selected ? ALTCOL : this.back);
            graphics.fillRect(0, 0, DirFinder.this.DIM.width + 30, DirFinder.this.DIM.height);
            if (this.isdisk) {
                graphics.drawImage(diskimg, this.indent, 2, null);
            } else {
                graphics.drawImage(dirimg, this.indent, 2, null);
            }
            graphics.setFont(ESUtils.MSG_FONT);
            graphics.setColor(Color.black);
            graphics.drawString(this.txt, this.indent + 21, 15);
        }

        public Dimension getPreferredSize() {
            return DirFinder.this.DIM;
        }
    }
}

