/*
 * Decompiled with CFR 0.152.
 */
package com.equitysoft.components;

import com.equitysoft.components.EnterExitEvent;
import com.equitysoft.components.EnterExitListener;
import com.equitysoft.components.ImageInfo;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;

public class IEButton
extends Component
implements Serializable,
EnterExitListener {
    static final long serialVersionUID = 5088819068576749880L;
    public static final int TOOLTIP = 0;
    public static final int LABEL_SOUTH = 1;
    public static final int LABEL_EAST = 2;
    public static final int LABEL_NORTH = 3;
    public static final int LABEL_WEST = 4;
    protected static final int POSITIONS = 5;
    protected static Font MSG_FONT = new Font("Helvetica", 1, 12);
    private static final String EMPTY = "";
    private static final int NORMAL = 0;
    private static final int HLIGHT = 1;
    private static final int DEPRESS = 2;
    private static final int RELEASED = 3;
    private static final int SIZE = 36;
    private static final int DEFAULT_BORDER = 8;
    private static final Font DEFAULT_FONT = new Font("Helvetica", 1, 12);
    protected static Frame frame;
    protected static IEButton currbutton;
    private transient IEBR runner;
    private transient Color back;
    private transient Color fore;
    private transient Color darker;
    private transient int action;
    private transient boolean loaded;
    private transient boolean exited;
    private transient boolean canrun;
    private transient boolean canrepeat;
    private transient int hgt;
    private transient int hless1;
    private transient int wid;
    private transient int wless1;
    private transient int imgxoff;
    private transient int imgyoff;
    private transient int fdesc;
    private transient int textxoff;
    private transient int textyoff;
    private transient ImageInfo info;
    transient Image altimg;
    transient Image darkimg;
    private transient TBox txtbox;
    private transient RP rp;
    private transient IEButton handle;
    transient MA ma;
    static transient ResourceBundle rb;
    private Vector listeners;
    private Vector eelisteners;
    private boolean sliding;
    private String text;
    private int border_width;
    private int position;
    private int border;
    private boolean prefdimset;
    private boolean highlight;
    private boolean sticky;
    private boolean grayed_out;
    private boolean darkened;
    private boolean opaque;
    private boolean istraversable;
    private boolean inverted;
    private boolean repeat;
    private boolean isdown;
    private boolean ingroup;
    private long boxwait;
    private long interval;
    private int ttpos;
    private boolean outline;
    private Dimension prefdim;
    private Font currft;
    private Color background;
    private String command;

    public IEButton() {
        this.text = EMPTY;
        this.position = 1;
        this.classInit();
        this.prefdim = new Dimension(36, 36);
    }

    public IEButton(Image image) {
        this(image, null, 0);
    }

    public IEButton(Image image, String string) {
        this(image, string, 1);
    }

    public IEButton(Image image, String string, int n) {
        this.classInit();
        this.info.img = image;
        this.position = n;
        this.text = string == null ? EMPTY : string;
        n = 1;
        this.createAlt();
        this.calcDim();
    }

    public IEButton(String string) {
        this(null, string, 2);
    }

    static /* synthetic */ boolean access$0(IEButton iEButton) {
        return iEButton.loaded;
    }

    static /* synthetic */ int access$6(IEButton iEButton) {
        return iEButton.action;
    }

    public synchronized void addActionListener(ActionListener actionListener) {
        if (this.listeners == null) {
            this.listeners = new Vector(1);
        }
        this.listeners.addElement(actionListener);
    }

    public void addEnterExitListener(Object object) {
        if (this.eelisteners == null) {
            this.eelisteners = new Vector(1);
        }
        this.eelisteners.addElement(object);
    }

    private void addListeners() {
        this.ma = new MA();
        this.addMouseListener(this.ma);
        this.addMouseMotionListener(new MMA());
        this.addFocusListener(new FA());
        this.addKeyListener(new KA());
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                IEButton.this.loaded = false;
            }
        });
    }

    public void buttonStateChanged(EnterExitEvent enterExitEvent) {
        if (enterExitEvent.getState()) {
            this.setLitup(true);
        } else {
            this.setLitup(false);
        }
    }

    private void calcDim() {
        Serializable serializable;
        this.loaded = false;
        if (!this.prefdimset) {
            int n;
            int n2;
            serializable = this.getFontMetrics(this.currft);
            int n3 = this.border + this.border;
            if (this.info.img != null) {
                n2 = this.info.img.getWidth(null) + n3;
                n = this.info.img.getHeight(null) + n3;
                if (this.position == 1 || this.position == 3) {
                    n = n + ((FontMetrics)serializable).getHeight() + this.border;
                    int n4 = ((FontMetrics)serializable).stringWidth(this.text) + n3;
                    if (n4 > n2) {
                        n2 = n4;
                    }
                } else if (this.position == 2 || this.position == 4) {
                    n2 = ((FontMetrics)serializable).stringWidth(this.text) + n3 + this.border + n2;
                    int n5 = ((FontMetrics)serializable).getHeight() + n3;
                    if (n5 > n) {
                        n = n5;
                    }
                }
            } else if (this.position != 0) {
                n2 = ((FontMetrics)serializable).stringWidth(this.text) + n3 + n3;
                n = ((FontMetrics)serializable).getHeight() + n3;
            } else {
                n2 = 36;
                n = 36;
            }
            this.prefdim = new Dimension(n2, n);
        }
        this.setSize(this.prefdim);
        serializable = this.getParent();
        if (serializable != null) {
            ((Container)serializable).invalidate();
            ((Container)serializable).validate();
        }
    }

    private void classInit() {
        this.handle = this;
        this.setBackground(Color.white);
        this.info = new ImageInfo();
        this.ttpos = 1;
        this.loaded = false;
        this.currft = DEFAULT_FONT;
        this.sticky = false;
        this.grayed_out = true;
        this.prefdimset = false;
        this.boxwait = 800L;
        this.border = 8;
        this.opaque = false;
        this.outline = false;
        this.background = Color.lightGray;
        this.border_width = 1;
        this.addListeners();
    }

    private void createAlt() {
        if (this.info.img != null) {
            this.altimg = this.getAlternateImage(this.info.img);
        }
    }

    private void drawLabel(Graphics graphics) {
        if (this.position != 0) {
            graphics.setFont(this.currft);
            if (this.isEnabled()) {
                graphics.setColor(this.fore);
                graphics.drawString(this.text, this.textxoff, this.textyoff);
            } else {
                graphics.setColor(Color.white);
                graphics.drawString(this.text, this.textxoff + 1, this.textyoff);
                graphics.setColor(this.darker);
                graphics.drawString(this.text, this.textxoff, this.textyoff);
            }
        }
    }

    public void fireAction() {
        Vector vector;
        if (this.listeners == null) {
            return;
        }
        Serializable serializable = this;
        synchronized (serializable) {
            vector = (Vector)this.listeners.clone();
        }
        serializable = new ActionEvent(this, 0, this.command == null ? this.text : this.command);
        int n = 0;
        while (n < vector.size()) {
            ActionListener actionListener = (ActionListener)vector.elementAt(n);
            actionListener.actionPerformed((ActionEvent)serializable);
            ++n;
        }
    }

    public void fireEnterExit(boolean bl) {
        Vector vector;
        if (this.eelisteners == null) {
            return;
        }
        Serializable serializable = this;
        synchronized (serializable) {
            vector = (Vector)this.eelisteners.clone();
        }
        serializable = new EnterExitEvent(this, bl);
        int n = 0;
        while (n < vector.size()) {
            EnterExitListener enterExitListener = (EnterExitListener)vector.elementAt(n);
            enterExitListener.buttonStateChanged((EnterExitEvent)serializable);
            ++n;
        }
    }

    public String getActionCommand() {
        if (this.command == null) {
            return this.text;
        }
        return this.command;
    }

    public Image getAlternateImage(Image image) {
        RGBImageFilter rGBImageFilter = this.inverted ? new IF() : new GOF();
        Image image2 = this.createImage(new FilteredImageSource(image.getSource(), rGBImageFilter));
        this.prepareImage(image2, this);
        return image2;
    }

    public int getBorderInset() {
        return this.border;
    }

    public int getBorderWidth() {
        return this.border_width;
    }

    public Color getButtonBackground() {
        if (this.opaque) {
            return this.background;
        }
        if (this.back != null) {
            return this.back;
        }
        return Color.lightGray;
    }

    public static IEButton getDepressedButton() {
        return currbutton;
    }

    public Font getFont(Font font) {
        return this.currft;
    }

    public ImageInfo getImageInfo() {
        return this.info;
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getPreferredSize() {
        if (this.prefdim == null) {
            return new Dimension(36, 36);
        }
        return this.prefdim;
    }

    public long getRepeatInterval() {
        return this.interval;
    }

    protected static String getString(String string) {
        if (rb == null) {
            try {
                rb = ResourceBundle.getBundle("com.equitysoft.components.IEButtonResources");
            }
            catch (MissingResourceException missingResourceException) {
                return EMPTY;
            }
        }
        return rb.getString(string);
    }

    public String getText() {
        return this.text;
    }

    public Color getTextColor() {
        return this.getForeground();
    }

    public int getTextPosition() {
        return this.position;
    }

    public Color getTooltipBackground() {
        return this.getBackground();
    }

    public int getTooltipPosition() {
        return this.ttpos;
    }

    public long getTooltipTimeDelay() {
        return this.boxwait;
    }

    public boolean isDepressed() {
        return this.isdown;
    }

    public boolean isDownDarkened() {
        return this.darkened;
    }

    public boolean isEnabled() {
        return super.isEnabled();
    }

    public boolean isFocusTraversable() {
        return this.istraversable;
    }

    public boolean isGrayOutInverted() {
        return this.inverted;
    }

    public boolean isImageGrayOutEnabled() {
        return this.grayed_out;
    }

    public boolean isInGroup() {
        return this.ingroup;
    }

    public boolean isLitup() {
        return this.highlight;
    }

    public boolean isOpaque() {
        return this.opaque;
    }

    public boolean isOutlineDrawn() {
        return this.outline;
    }

    public boolean isSlidingTooltip() {
        return this.sliding;
    }

    public boolean isSticky() {
        return this.sticky;
    }

    public void paint(Graphics graphics) {
        if (!this.loaded) {
            if (this.getParent() == null) {
                return;
            }
            if (this.position == 0 && frame == null) {
                this.setFrame();
            }
            this.fore = this.getForeground();
            this.back = this.opaque ? this.background : this.getParent().getBackground();
            this.darker = this.back.darker();
            Dimension dimension = this.getSize();
            this.wid = dimension.width;
            this.hgt = dimension.height;
            this.wless1 = this.wid - 1;
            this.hless1 = this.hgt - 1;
            if (this.info.img != null) {
                this.imgxoff = (this.wid - this.info.img.getWidth(null)) / 2;
                if (this.imgxoff < 0) {
                    this.imgxoff = 0;
                }
            }
            if (this.position != 0) {
                FontMetrics fontMetrics = this.getFontMetrics(this.currft);
                int n = fontMetrics.stringWidth(this.text);
                if (this.position == 1 || this.position == 3) {
                    int n2 = this.info.img == null ? 0 : this.info.img.getHeight(null) + this.border;
                    int n3 = (this.hgt - n2 - fontMetrics.getHeight()) / 2;
                    this.textxoff = (this.wid - n) / 2;
                    if (this.position == 1) {
                        this.imgyoff = n3;
                        this.textyoff = this.hgt - n3 - fontMetrics.getDescent();
                    } else {
                        this.imgyoff = n3 + fontMetrics.getHeight() + this.border;
                        this.textyoff = n3 + fontMetrics.getHeight() - fontMetrics.getDescent();
                    }
                } else {
                    if (this.info.img != null) {
                        int n4 = this.info.img.getHeight(null);
                        this.imgyoff = n4 >= this.hgt ? 0 : (this.hgt - n4) / 2;
                        this.imgxoff = (this.wid - this.info.img.getWidth(null) - this.border - n) / 2;
                        if (this.position == 2) {
                            this.textxoff = this.imgxoff + this.info.img.getWidth(null) + this.border;
                        } else {
                            this.textxoff = this.imgxoff;
                            this.imgxoff = this.textxoff + n + this.border;
                        }
                    } else {
                        this.textxoff = (this.wid - n) / 2;
                    }
                    this.textyoff = (this.hgt - fontMetrics.getHeight()) / 2 + fontMetrics.getHeight() - fontMetrics.getDescent();
                }
            } else if (this.info.img != null) {
                this.imgyoff = (this.hgt - this.info.img.getHeight(null)) / 2;
                if (this.imgyoff < 0) {
                    this.imgyoff = 0;
                }
            }
            this.loaded = true;
        }
        if (this.opaque) {
            graphics.setColor(this.back);
            graphics.fillRect(0, 0, this.wid, this.hgt);
        }
        if (this.highlight && this.action == 0 && this.isEnabled()) {
            this.action = 1;
            this.exited = false;
        }
        if (this.sticky && this.isdown) {
            this.action = 2;
        }
        switch (this.action) {
            case 2: {
                if (this.info.img != null) {
                    graphics.drawImage(this.darkened ? this.darkimg : this.info.img, this.imgxoff + 1, this.imgyoff + 1, null);
                }
                if (this.position != 0) {
                    graphics.setColor(this.fore);
                    graphics.setFont(this.currft);
                    graphics.drawString(this.text, this.textxoff + 1, this.textyoff + 1);
                }
                this.paintBorder(graphics, this.wid, this.hgt, false, this.back, this.border_width, this.outline, this.fore);
                break;
            }
            case 3: {
                if (this.info.img != null) {
                    graphics.drawImage(this.info.img, this.imgxoff, this.imgyoff, null);
                }
                this.drawLabel(graphics);
                this.paintBorder(graphics, this.wid, this.hgt, true, this.back, this.border_width, this.outline, this.fore);
                break;
            }
            case 1: {
                if (!this.exited) {
                    if (this.info.img != null) {
                        graphics.drawImage(this.info.img, this.imgxoff, this.imgyoff, null);
                    }
                    this.drawLabel(graphics);
                    this.paintBorder(graphics, this.wid, this.hgt, true, this.back, this.border_width, this.outline, this.fore);
                    break;
                }
            }
            default: {
                if (this.info.img != null) {
                    if (this.grayed_out) {
                        graphics.drawImage(this.altimg, this.imgxoff, this.imgyoff, null);
                    } else if (!this.isEnabled()) {
                        graphics.drawImage(this.altimg, this.imgxoff, this.imgyoff, null);
                    } else {
                        graphics.drawImage(this.info.img, this.imgxoff, this.imgyoff, null);
                    }
                }
                this.drawLabel(graphics);
            }
        }
    }

    public void paintBorder(Graphics graphics, int n, int n2, boolean bl, Color color, int n3, boolean bl2, Color color2) {
        if (this.border_width == 0) {
            return;
        }
        int n4 = n - 1;
        int n5 = n2 - 1;
        int n6 = 0;
        int n7 = 0;
        graphics.setColor(color);
        int n8 = 0;
        while (n8 < n3) {
            graphics.draw3DRect(n6++, n7++, n4, n5, bl);
            n4 -= 2;
            n5 -= 2;
            ++n8;
        }
        if (bl2) {
            graphics.setColor(color2);
            graphics.drawRect(0, 0, this.wless1, this.hless1);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.handle = this;
        this.info = new ImageInfo();
        this.addListeners();
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        if (n == 0) {
            return;
        }
        byte[] byArray = new byte[n];
        objectInputStream.read(byArray);
        this.info.img = Toolkit.getDefaultToolkit().createImage(byArray);
        this.prepareImage(this.info.img, this);
        this.createAlt();
    }

    private void releaseButton() {
        this.isdown = false;
        this.action = 0;
        this.repaint();
    }

    public synchronized void removeActionListener(ActionListener actionListener) {
        this.listeners.removeElement(actionListener);
    }

    public void removeEnterExitListener(Object object) {
        this.eelisteners.removeElement(object);
    }

    public void setActionCommand(String string) {
        this.command = string;
    }

    public void setBorderInset(int n) {
        this.border = n < 0 ? 0 : n;
        if (this.prefdimset) {
            this.loaded = false;
        } else {
            this.calcDim();
        }
    }

    public void setBorderWidth(int n) {
        if (n >= 0) {
            this.border_width = n;
        }
    }

    public void setButtonBackground(Color color) {
        this.loaded = false;
        this.background = color;
    }

    public void setDepressed(boolean bl) {
        if (this.sticky) {
            if (bl && !this.isdown) {
                this.isdown = true;
                this.action = 2;
                this.repaint();
                if (this.ingroup && currbutton != this) {
                    if (currbutton != null) {
                        currbutton.releaseButton();
                    }
                    currbutton = this;
                }
            } else if (this.isdown) {
                this.releaseButton();
                if (this.ingroup) {
                    currbutton = null;
                }
            }
        }
    }

    public void setDownDarkened(boolean bl) {
        this.darkened = bl;
        if (bl) {
            this.darkimg = this.createImage(new FilteredImageSource(this.info.img.getSource(), new DF()));
            this.prepareImage(this.darkimg, this);
        }
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.action = 0;
        this.repaint();
    }

    public void setFocusTraversable(boolean bl) {
        this.istraversable = bl;
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.currft = font;
        if (this.position != 0) {
            this.calcDim();
        }
    }

    private void setFrame() {
        Container container = this.getParent();
        while (container != null && !(container instanceof Frame)) {
            container = container.getParent();
        }
        if (container != null) {
            frame = (Frame)container;
        }
    }

    public void setGrayOutInverted(boolean bl) {
        this.inverted = bl;
        this.createAlt();
    }

    public void setImageGrayOutEnabled(boolean bl) {
        this.grayed_out = bl;
    }

    public void setImageInfo(ImageInfo imageInfo) {
        this.info = imageInfo;
        this.createAlt();
        this.calcDim();
    }

    public void setInGroup(boolean bl) {
        if (bl) {
            this.setSticky(true);
        }
        this.ingroup = bl;
    }

    public void setLitup(boolean bl) {
        this.highlight = bl;
        this.action = 0;
        this.repaint();
    }

    public void setOpaque(boolean bl) {
        this.opaque = bl;
    }

    public void setOutlineDrawn(boolean bl) {
        this.outline = bl;
        if (bl && this.border_width == 1) {
            this.border_width = 2;
        }
    }

    public void setPreferredSize(Dimension dimension) {
        if (dimension == this.prefdim) {
            return;
        }
        if (dimension == null) {
            this.prefdimset = false;
        } else {
            this.prefdim = dimension;
            this.prefdimset = true;
        }
        this.calcDim();
    }

    public void setRepeat(boolean bl) {
        this.repeat = bl;
        this.interval = 60L;
    }

    public void setRepeatInterval(long l) {
        this.interval = l;
    }

    public void setSlidingTooltip(boolean bl) {
        this.sliding = bl;
    }

    public void setSticky(boolean bl) {
        this.sticky = bl;
    }

    public void setText(String string) {
        if (string == null) {
            string = EMPTY;
        } else {
            this.text = string;
        }
        this.loaded = false;
        this.repaint();
    }

    public void setTextColor(Color color) {
        this.setForeground(color);
        this.fore = color;
    }

    public void setTextPosition(int n) {
        if (n >= 0 && n < 5) {
            this.position = n;
            this.calcDim();
        }
    }

    public void setTooltipBackground(Color color) {
        if (color == null) {
            this.setBackground(Color.white);
        } else {
            this.setBackground(color);
        }
    }

    public void setTooltipPosition(int n) {
        if (n != 3 && n != 1) {
            return;
        }
        this.ttpos = n;
    }

    public void setTooltipTimeDelay(long l) {
        this.boxwait = l;
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public boolean willRepeat() {
        return this.repeat;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        if (this.info.img == null) {
            objectOutputStream.writeInt(0);
        } else {
            int n;
            objectOutputStream.writeInt((int)this.info.file.length());
            FileInputStream fileInputStream = new FileInputStream(this.info.file);
            byte[] byArray = new byte[512];
            while ((n = fileInputStream.read(byArray)) > -1) {
                objectOutputStream.write(byArray, 0, n);
            }
            fileInputStream.close();
            objectOutputStream.flush();
        }
    }

    class MMA
    extends MouseMotionAdapter {
        MMA() {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (!IEButton.this.isEnabled()) {
                return;
            }
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            if (!IEButton.this.contains(mouseEvent.getX(), mouseEvent.getY())) {
                IEButton.this.canrepeat = false;
                if (!IEButton.this.exited) {
                    IEButton.this.ma.mouseExited(mouseEvent);
                }
            } else if (IEButton.this.exited) {
                IEButton.this.fireEnterExit(true);
                IEButton.this.exited = false;
                IEButton.this.action = 2;
                IEButton.this.repaint();
            }
        }
    }

    private class FA
    extends FocusAdapter {
        FA() {
        }

        public void focusGained(FocusEvent focusEvent) {
            if (IEButton.this.istraversable) {
                IEButton.this.exited = false;
                IEButton.this.action = 1;
                IEButton.this.handle.repaint();
            }
        }

        public void focusLost(FocusEvent focusEvent) {
            if (IEButton.this.istraversable) {
                IEButton.this.exited = true;
                IEButton.this.action = 0;
                IEButton.this.handle.repaint();
            }
        }
    }

    private class KA
    extends KeyAdapter {
        boolean down;

        KA() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (IEButton.this.istraversable && !this.down && (keyEvent.getKeyCode() == 10 || keyEvent.getKeyCode() == 32)) {
                this.down = true;
                IEButton.this.action = 2;
                IEButton.this.handle.repaint();
            }
        }

        public void keyReleased(KeyEvent keyEvent) {
            if (IEButton.this.istraversable && (keyEvent.getKeyCode() == 10 || keyEvent.getKeyCode() == 32)) {
                this.down = false;
                IEButton.this.fireAction();
                IEButton.this.action = 3;
                IEButton.this.handle.repaint();
            }
        }

        public void keyTyped(KeyEvent keyEvent) {
        }
    }

    class RP
    extends Thread {
        RP() {
        }

        public void run() {
            if (IEButton.this.interval < 5L) {
                IEButton.this.interval = 5L;
            }
            try {
                Thread.sleep(300L);
            }
            catch (InterruptedException interruptedException) {}
            while (IEButton.this.canrepeat) {
                try {
                    Thread.sleep(IEButton.this.interval);
                }
                catch (InterruptedException interruptedException) {
                    break;
                }
                if (!IEButton.this.canrepeat) continue;
                IEButton.this.fireAction();
            }
            IEButton.this.rp = null;
        }
    }

    class MA
    extends MouseAdapter {
        MA() {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            if (!IEButton.this.isEnabled()) {
                return;
            }
            IEButton.this.fireEnterExit(true);
            if (currbutton == IEButton.this.handle) {
                return;
            }
            IEButton.this.exited = false;
            if (!IEButton.this.highlight) {
                IEButton.this.action = 1;
                IEButton.this.repaint();
            }
            if (IEButton.this.position == 0 && !IEButton.this.text.equals(IEButton.EMPTY) && IEButton.this.runner == null) {
                IEButton.this.runner = new IEBR();
                IEButton.this.canrun = true;
                IEButton.this.runner.start();
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
            if (!IEButton.this.isEnabled()) {
                return;
            }
            if (currbutton == IEButton.this.handle) {
                return;
            }
            IEButton.this.exited = true;
            IEButton.this.canrun = false;
            if (IEButton.this.txtbox != null) {
                ((Component)IEButton.this.txtbox).setVisible(false);
                IEButton.this.txtbox = null;
            }
            IEButton.this.action = 0;
            IEButton.this.repaint();
            IEButton.this.fireEnterExit(false);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (!IEButton.this.isEnabled()) {
                return;
            }
            IEButton.this.canrun = false;
            if (IEButton.this.txtbox != null) {
                ((Component)IEButton.this.txtbox).setVisible(false);
                IEButton.this.txtbox = null;
            }
            if (IEButton.this.repeat && currbutton != IEButton.this.handle && IEButton.this.rp == null) {
                IEButton.this.canrepeat = true;
                IEButton.this.rp = new RP();
                IEButton.this.rp.start();
            }
            if (IEButton.this.sticky) {
                if (!IEButton.this.isdown) {
                    IEButton.this.isdown = true;
                    IEButton.this.fireAction();
                    if (IEButton.this.ingroup && currbutton != IEButton.this.handle) {
                        if (currbutton != null) {
                            currbutton.releaseButton();
                        }
                        currbutton = IEButton.this.handle;
                    }
                } else {
                    IEButton.this.isdown = false;
                    IEButton.this.canrepeat = false;
                    if (IEButton.this.ingroup) {
                        currbutton = null;
                    }
                    return;
                }
            }
            IEButton.this.action = 2;
            IEButton.this.repaint();
            if (IEButton.this.repeat && IEButton.this.rp == null) {
                IEButton.this.canrepeat = true;
                IEButton.this.rp = new RP();
                IEButton.this.rp.start();
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (!IEButton.this.isEnabled()) {
                return;
            }
            if (!IEButton.this.sticky) {
                IEButton.this.canrepeat = false;
                if (IEButton.this.contains(mouseEvent.getX(), mouseEvent.getY())) {
                    IEButton.this.action = 1;
                    IEButton.this.repaint();
                    IEButton.this.fireAction();
                }
            } else if (IEButton.this.ingroup) {
                if (currbutton == null) {
                    IEButton.this.action = 1;
                    IEButton.this.repaint();
                    IEButton.this.fireAction();
                }
            } else if (!IEButton.this.isdown) {
                IEButton.this.action = 1;
                IEButton.this.repaint();
                IEButton.this.fireAction();
            }
        }
    }

    class IEBR
    extends Thread {
        IEBR() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            Point point;
            int n;
            Dimension dimension;
            if (!IEButton.this.canrun) {
                IEButton.this.runner = null;
                return;
            }
            try {
                Thread.sleep(IEButton.this.boxwait);
            }
            catch (InterruptedException interruptedException) {
                IEButton.this.runner = null;
                return;
            }
            int n2 = 0;
            IEBR iEBR = this;
            synchronized (iEBR) {
                if (!IEButton.this.canrun || frame == null) {
                    IEButton.this.runner = null;
                    return;
                }
                IEButton.this.txtbox = new TBox();
                dimension = IEButton.this.txtbox.getSize();
                n = dimension.height;
                point = IEButton.this.handle.getLocationOnScreen();
                if (!IEButton.this.sliding) {
                    if (IEButton.this.ttpos == 1) {
                        ((Component)IEButton.this.txtbox).setLocation(point.x, point.y + ((IEButton)IEButton.this).handle.getSize().height + 1);
                    } else {
                        ((Component)IEButton.this.txtbox).setLocation(point.x, point.y - dimension.height - 1);
                    }
                    ((Component)IEButton.this.txtbox).setVisible(true);
                    IEButton.this.runner = null;
                    return;
                }
                n2 = point.y + ((IEButton)IEButton.this).handle.getSize().height + 1;
                if (IEButton.this.ttpos == 1) {
                    ((Component)IEButton.this.txtbox).setLocation(point.x, n2);
                } else {
                    ((Component)IEButton.this.txtbox).setLocation(point.x, point.y - 1);
                }
                ((Component)IEButton.this.txtbox).setSize(1, 1);
                ((Component)IEButton.this.txtbox).setVisible(true);
                n2 += n;
            }
            int n3 = 2;
            while (n3 <= n) {
                block23: {
                    try {
                        Thread.sleep(5L);
                    }
                    catch (InterruptedException interruptedException) {
                        break;
                    }
                    IEBR iEBR2 = this;
                    synchronized (iEBR2) {
                        block22: {
                            block25: {
                                block24: {
                                    if (!IEButton.this.canrun) break block24;
                                    if (IEButton.this.txtbox != null) break block25;
                                }
                                Object var7_10 = null;
                                break block22;
                            }
                            if (IEButton.this.ttpos == 1) {
                                ((Component)IEButton.this.txtbox).setBounds(point.x, n2 - n3, dimension.width, n3);
                            } else {
                                ((Component)IEButton.this.txtbox).setBounds(point.x, point.y - n3, dimension.width, n3);
                            }
                            break block23;
                        }
                        break;
                    }
                }
                ++n3;
            }
            IEButton.this.runner = null;
        }
    }

    private class TBox
    extends Window {
        TBox() {
            super(frame);
            ((Component)this).setBackground(IEButton.this.handle.getBackground());
            this.setLayout(new BorderLayout());
            Label label = new Label(IEButton.this.text, 1);
            label.setFont(IEButton.this.currft);
            label.setForeground(IEButton.this.fore);
            this.add((Component)label, "Center");
            this.pack();
            this.setLayout(null);
        }

        public Insets getInsets() {
            return new Insets(1, 1, 1, 1);
        }

        public void paint(Graphics graphics) {
            Dimension dimension = this.getSize();
            if (!IEButton.this.canrun) {
                return;
            }
            graphics.drawRect(0, 0, dimension.width - 1, dimension.height - 1);
        }
    }

    private class GOF
    extends RGBImageFilter {
        public GOF() {
            this.canFilterIndexColorModel = true;
        }

        public int filterRGB(int n, int n2, int n3) {
            int n4 = (n3 & 0xFF0000) >> 16;
            int n5 = (n3 & 0xFF00) >> 8;
            int n6 = n3 & 0xFF;
            n4 = (n4 + n5 + n6) / 3;
            return -16777216 + (n4 << 16) + (n4 << 8) + n4;
        }
    }

    class IF
    extends RGBImageFilter {
        public IF() {
            this.canFilterIndexColorModel = true;
        }

        public int filterRGB(int n, int n2, int n3) {
            return n3 ^ 0xFFFFFF;
        }
    }

    class DF
    extends RGBImageFilter {
        public DF() {
            this.canFilterIndexColorModel = true;
        }

        public int filterRGB(int n, int n2, int n3) {
            return n3 & 0xFFAFAFAF;
        }
    }
}

