/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.applet.AppletContext;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.event.MouseEvent;
import java.awt.image.MemoryImageSource;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.InputStream;
import java.text.NumberFormat;
import java.util.Date;

public class Squeezer2
extends Applet {
    static final int bilen = 40;
    Image img;
    String msg;
    String overmsg;
    String mag;
    Dimension dim;
    int xnorth;
    int ynorth;
    int xsouth;
    int ysouth;
    double iwid;
    double ihgt;
    double ratio;
    double nwid;
    double nhgt;
    double ydisp;
    double xdisp;
    int origx;
    int origy;
    AppletContext ac;
    double exfactor;
    boolean smooth;
    boolean showmag;
    boolean usescale;
    Image os;
    Image scaleimg;
    NumberFormat nf;

    int dwordToInt(byte[] byArray, int n) {
        return (byArray[n + 3] & 0xFF) << 24 | (byArray[n + 2] & 0xFF) << 16 | (byArray[n + 1] & 0xFF) << 8 | byArray[n] & 0xFF;
    }

    public void paint(Graphics graphics) {
        if (this.msg != null) {
            graphics.setColor(Color.red);
            graphics.drawString(this.msg, 3, 14);
        } else if (this.img != null) {
            if (this.dim == null) {
                this.dim = this.getSize();
                this.xnorth = 0;
                this.ynorth = 0;
                this.xsouth = this.img.getWidth(null);
                this.ysouth = this.img.getHeight(null);
                this.nwid = this.dim.width;
                this.nhgt = this.dim.height;
                if (this.showmag) {
                    this.setMag();
                }
                this.os = this.createImage(this.dim.width, this.dim.height);
            }
            Graphics graphics2 = this.os.getGraphics();
            if (!this.usescale) {
                graphics2.drawImage(this.img, 0, 0, this.dim.width, this.dim.height, this.xnorth, this.ynorth, this.xsouth, this.ysouth, null);
            } else {
                graphics2.drawImage(this.scaleimg, 0, 0, this.dim.width, this.dim.height, this.xnorth, this.ynorth, this.xsouth, this.ysouth, null);
            }
            if (this.showmag) {
                graphics2.setColor(Color.red);
                graphics2.drawString(this.mag, 3, 14);
            }
            graphics.drawImage(this.os, 0, 0, null);
            graphics2.dispose();
        }
    }

    public void processMouseEvent(MouseEvent mouseEvent) {
        switch (mouseEvent.getID()) {
            case 501: {
                this.origx = mouseEvent.getX();
                this.origy = mouseEvent.getY();
                break;
            }
            case 504: {
                this.setCursor(new Cursor(1));
                this.ac.showStatus(this.overmsg);
                break;
            }
            case 500: {
                if ((mouseEvent.getModifiers() & 0x10) == 0) {
                    this.dim = null;
                    this.usescale = false;
                    this.start();
                    return;
                }
                double d = ((double)mouseEvent.getY() + this.ydisp) * this.exfactor;
                double d2 = ((double)mouseEvent.getX() + this.xdisp) * this.exfactor;
                this.nhgt *= this.exfactor;
                this.nwid = this.ratio * this.nhgt;
                if (this.smooth && this.nhgt > this.ihgt) {
                    this.usescale = true;
                    this.scaleimg = this.img.getScaledInstance((int)this.nwid, (int)this.nhgt, 16);
                }
                this.xdisp = d2 - (double)(this.dim.width / 2);
                if (this.xdisp < 0.0) {
                    this.xdisp = 0.0;
                }
                if (this.xdisp + (double)this.dim.width > this.nwid) {
                    this.xdisp = this.nwid - (double)this.dim.width;
                }
                this.xnorth = this.rescaleH(this.xdisp);
                this.ydisp = d - (double)(this.dim.height / 2);
                if (this.ydisp < 0.0) {
                    this.ydisp = 0.0;
                }
                if (this.ydisp + (double)this.dim.height > this.nhgt) {
                    this.ydisp = this.nhgt - (double)this.dim.height;
                }
                this.ynorth = this.rescaleV(this.ydisp);
                this.xsouth = this.rescaleH(this.xdisp + (double)this.dim.width);
                this.ysouth = this.rescaleV(this.ydisp + (double)this.dim.height);
                if (this.showmag) {
                    this.setMag();
                }
                this.repaint();
                System.gc();
                break;
            }
            case 505: {
                this.setCursor(Cursor.getDefaultCursor());
                this.ac.showStatus("");
            }
        }
    }

    public void processMouseMotionEvent(MouseEvent mouseEvent) {
        if (mouseEvent.getID() == 506) {
            int n = mouseEvent.getX();
            int n2 = n - this.origx;
            this.xdisp -= (double)n2;
            if (this.xdisp < 0.0) {
                this.xdisp = 0.0;
            } else if (this.xdisp + (double)this.dim.width > this.nwid) {
                this.xdisp = this.nwid - (double)this.dim.width;
            } else {
                this.origx = n;
            }
            this.xnorth = this.rescaleH(this.xdisp);
            this.xsouth = this.rescaleH(this.xdisp + (double)this.dim.width);
            int n3 = mouseEvent.getY();
            int n4 = n3 - this.origy;
            this.ydisp -= (double)n4;
            if (this.ydisp < 0.0) {
                this.ydisp = 0.0;
            } else if (this.ydisp + (double)this.dim.height > this.nhgt) {
                this.ydisp = this.nhgt - (double)this.dim.height;
            } else {
                this.origy = n3;
            }
            this.ynorth = this.rescaleH(this.ydisp);
            this.ysouth = this.rescaleH(this.ydisp + (double)this.dim.height);
            this.repaint();
        }
    }

    int rescaleH(double d) {
        if (this.usescale) {
            return (int)d;
        }
        return (int)(d * this.iwid / this.nwid);
    }

    int rescaleV(double d) {
        if (this.usescale) {
            return (int)d;
        }
        return (int)(d * this.ihgt / this.nhgt);
    }

    void setMag() {
        this.mag = "1 : " + this.nf.format(this.nhgt / this.ihgt);
    }

    public void start() {
        Object object;
        if (System.getProperty("java.version").compareTo("1.1") < 0) {
            this.msg = this.getParameter("version_message");
            return;
        }
        this.ac = this.getAppletContext();
        String string = String.valueOf(this.getParameter("data")) + ".t";
        try {
            object = new DataInputStream(this.getClass().getResourceAsStream(string));
            long l = ((DataInputStream)object).readLong();
            if (l != 0L && l < new Date().getTime()) {
                return;
            }
            this.overmsg = ((DataInputStream)object).readUTF();
            this.exfactor = 1.0 + (double)((DataInputStream)object).readInt() / 100.0;
            this.smooth = ((DataInputStream)object).readBoolean();
            this.showmag = ((DataInputStream)object).readBoolean();
            String string2 = ((DataInputStream)object).readUTF();
            ((FilterInputStream)object).close();
            if (this.showmag) {
                this.nf = NumberFormat.getNumberInstance();
                this.nf.setMaximumFractionDigits(3);
            }
            InputStream inputStream = this.getClass().getResourceAsStream(string2);
            System.out.println("Loading...");
            inputStream.skip(14L);
            byte[] byArray = new byte[40];
            inputStream.read(byArray, 0, 40);
            int n = this.dwordToInt(byArray, 4);
            int n2 = this.dwordToInt(byArray, 8);
            int n3 = this.wordToInt(byArray, 14);
            int n4 = this.dwordToInt(byArray, 20);
            int n5 = this.dwordToInt(byArray, 32);
            int n6 = this.dwordToInt(byArray, 16);
            if (n6 != 0) {
                return;
            }
            if (n3 == 24) {
                int[] nArray = new int[n2 * n];
                int n7 = 4 - n * 3 % 4;
                if (n7 == 4) {
                    n7 = 0;
                }
                int n8 = n2 * (n * 3 + n7);
                byte[] byArray2 = new byte[n8];
                inputStream.read(byArray2, 0, n8);
                int n9 = 0;
                int n10 = 0;
                while (n10 < n2) {
                    int n11 = 0;
                    while (n11 < n) {
                        nArray[n * (n2 - n10 - 1) + n11] = 0xFF000000 | (byArray2[n9 + 2] & 0xFF) << 16 | (byArray2[n9 + 1] & 0xFF) << 8 | byArray2[n9] & 0xFF;
                        n9 += 3;
                        ++n11;
                    }
                    n9 += n7;
                    ++n10;
                }
                this.img = this.createImage(new MemoryImageSource(n, n2, nArray, 0, n));
            } else if (n3 == 8) {
                int n12 = 0;
                n12 = n5 > 0 ? n5 : 1 << n3;
                int n13 = 4 - n % 4;
                if (n13 == 4) {
                    n13 = 0;
                }
                int n14 = n2 * (n + n13);
                int[] nArray = new int[n12];
                byte[] byArray3 = new byte[n12 * 4];
                inputStream.read(byArray3, 0, n12 * 4);
                int n15 = 0;
                int n16 = 0;
                while (n16 < n12) {
                    nArray[n16] = 0xFF000000 | (byArray3[n15 + 2] & 0xFF) << 16 | (byArray3[n15 + 1] & 0xFF) << 8 | byArray3[n15] & 0xFF;
                    n15 += 4;
                    ++n16;
                }
                int[] nArray2 = new int[n * n2];
                byte[] byArray4 = new byte[n14];
                inputStream.read(byArray4, 0, n14);
                n15 = 0;
                int n17 = 0;
                while (n17 < n2) {
                    int n18 = 0;
                    while (n18 < n) {
                        nArray2[n * (n2 - n17 - 1) + n18] = nArray[byArray4[n15] & 0xFF];
                        ++n15;
                        ++n18;
                    }
                    n15 += n13;
                    ++n17;
                }
                this.img = this.createImage(new MemoryImageSource(n, n2, nArray2, 0, n));
            }
            inputStream.close();
        }
        catch (Exception exception) {
            System.out.println("Error loading BMP");
            return;
        }
        this.enableEvents(48L);
        object = new MediaTracker((Component)this);
        ((MediaTracker)object).addImage(this.img, 0);
        try {
            ((MediaTracker)object).waitForAll();
        }
        catch (Exception exception) {
            System.out.println("Wait error");
        }
        this.iwid = this.img.getWidth(null);
        this.ihgt = this.img.getHeight(null);
        this.ratio = this.iwid / this.ihgt;
        this.repaint();
        System.gc();
    }

    public void stop() {
        this.img = null;
        System.gc();
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    int wordToInt(byte[] byArray, int n) {
        return (byArray[n + 1] & 0xFF) << 8 | byArray[n] & 0xFF;
    }
}

