/*
 * Decompiled with CFR 0.152.
 */
package com.equitysoft.extract;

import com.equitysoft.extract.DMTN;
import com.equitysoft.extract.Go;
import com.equitysoft.extract.GoLibButton;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;

class GoDir
extends JDialog
implements TreeWillExpandListener,
ActionListener,
TreeSelectionListener {
    static final int WID = 300;
    static final int HGT = 400;
    String EXTRACT = "Extract";
    String CANCEL = "Cancel";
    JScrollPane sp;
    DefaultTreeModel model;
    JTree tree;
    Color fore;
    Color back;
    Color highlight;
    ImageIcon disk;
    ImageIcon dir;
    ImageIcon opendir;
    ImageIcon system;
    static DMTN currmtn;
    DMTN root;
    JTextField tx;
    static GoDir handle;

    GoDir(Go go) {
        super(go, "SelfExtract-Pro", true);
        ((Component)this).setSize(300, 400);
        handle = this;
        this.disk = new ImageIcon(Go.getImage("disk.gif"));
        this.dir = new ImageIcon(Go.getImage("dir.gif"));
        this.system = new ImageIcon(Go.getImage("system.gif"));
        this.opendir = new ImageIcon(Go.getImage("opendir.gif"));
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(false);
        jPanel.setLayout(new FlowLayout(1, 5, 2));
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Destination directory"));
        this.tx = new JTextField(){

            public boolean isFocusTraversable() {
                return false;
            }
        };
        this.tx.setColumns(25);
        this.tx.setEditable(false);
        this.tx.setFont(new Font("dialog", 1, 12));
        jPanel.add(this.tx);
        container.add((Component)jPanel, "North");
        JScrollPane jScrollPane = new JScrollPane();
        container.add((Component)jScrollPane, "Center");
        File file = new File(System.getProperty("user.dir"));
        this.root = new DMTN(null);
        this.model = new DefaultTreeModel(this.root);
        this.tree = new JTree(this.model);
        jScrollPane.getViewport().add(this.tree);
        this.tree.setBackground(Color.white);
        this.tree.setCellRenderer(new Renderer());
        this.tree.setRowHeight(-1);
        this.back = this.tree.getBackground();
        this.fore = this.tree.getForeground();
        this.highlight = new Color(159, 152, 207);
        File[] fileArray = File.listRoots();
        GoDir.sort(fileArray);
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            DMTN dMTN = new DMTN(fileArray[n2], true);
            this.root.add(dMTN);
            dMTN.add(new DMTN(true));
            ++n2;
        }
        this.tree.expandPath(this.tree.getPathForRow(0));
        Vector vector = this.separatePath(file);
        currmtn = this.root;
        int n3 = vector.size();
        int n4 = 0;
        while (n4 < n3) {
            currmtn = this.getMatchingNode(currmtn, (File)vector.elementAt(n4));
            if (n4 < n3 - 1) {
                this.expandNode(currmtn);
            }
            ++n4;
        }
        this.setLine(file.getAbsolutePath());
        TreePath treePath = new TreePath(currmtn.getPath());
        this.tree.scrollPathToVisible(treePath);
        this.tree.setSelectionPath(treePath);
        this.tree.addTreeWillExpandListener(this);
        this.tree.addTreeSelectionListener(this);
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(BorderFactory.createEtchedBorder());
        GoLibButton goLibButton = new GoLibButton(this.EXTRACT);
        jPanel2.add(goLibButton);
        goLibButton.addActionListener(this);
        goLibButton = new GoLibButton(this.CANCEL);
        jPanel2.add(goLibButton);
        goLibButton.addActionListener(this);
        container.add((Component)jPanel2, "South");
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        ((Component)this).setLocation((dimension.width - 300) / 2, (dimension.height - 400) / 2);
        this.addWindowListener(Go.handle);
        ((Component)this).setVisible(true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        ((Component)this).setVisible(false);
        if (string == this.CANCEL) {
            System.exit(0);
        } else {
            File file = GoDir.currmtn.f;
            if (!file.exists()) {
                currmtn = null;
            }
        }
    }

    static File ask(Go go) {
        new GoDir(go);
        if (currmtn == null) {
            return null;
        }
        return GoDir.currmtn.f;
    }

    void setLine(String string) {
        this.tx.setText(" " + string);
    }

    Vector separatePath(File file) {
        Vector<File> vector = new Vector<File>(3);
        vector.addElement(file);
        while ((file = file.getParentFile()) != null) {
            vector.insertElementAt(file, 0);
        }
        return vector;
    }

    DMTN getMatchingNode(DMTN dMTN, File file) {
        DMTN dMTN2 = null;
        int n = dMTN.getChildCount();
        int n2 = 0;
        while (n2 < n) {
            dMTN2 = (DMTN)dMTN.getChildAt(n2);
            if (file.equals(dMTN2.f)) break;
            ++n2;
        }
        return dMTN2;
    }

    void expandNode(DMTN dMTN) {
        this.removeDummy(dMTN);
        this.addToNode(dMTN);
        TreePath treePath = new TreePath(dMTN.getPath());
        this.tree.expandPath(treePath);
    }

    void addToNode(DMTN dMTN) {
        File[] fileArray = dMTN.f.listFiles();
        if (fileArray == null) {
            return;
        }
        GoDir.sort(fileArray);
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                DMTN dMTN2 = new DMTN(file);
                dMTN.add(dMTN2);
                this.addMarkerNode(dMTN2);
            }
            ++n2;
        }
    }

    void addMarkerNode(DMTN dMTN) {
        File[] fileArray = dMTN.f.listFiles();
        if (fileArray == null) {
            return;
        }
        int n = fileArray.length;
        if (n == 0) {
            return;
        }
        int n2 = 0;
        while (n2 < n) {
            if (fileArray[n2].isDirectory()) {
                dMTN.add(new DMTN(true));
                break;
            }
            ++n2;
        }
    }

    boolean removeDummy(DMTN dMTN) {
        int n = dMTN.getChildCount();
        if (n == 1 && ((DMTN)dMTN.getChildAt((int)0)).dummy) {
            dMTN.removeAllChildren();
            return true;
        }
        return false;
    }

    public void treeWillExpand(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
        TreePath treePath = treeExpansionEvent.getPath();
        DMTN dMTN = (DMTN)treePath.getLastPathComponent();
        if (dMTN.isdisk && this.isInaccessibleDisk(dMTN)) {
            throw new ExpandVetoException(treeExpansionEvent);
        }
        if (this.removeDummy(dMTN)) {
            this.addToNode(dMTN);
        }
    }

    public void treeWillCollapse(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
        TreePath treePath = treeExpansionEvent.getPath();
        if (this.tree.getRowForPath(treePath) == 0) {
            throw new ExpandVetoException(treeExpansionEvent);
        }
    }

    boolean isInaccessibleDisk(DMTN dMTN) {
        File[] fileArray;
        return dMTN.isdisk && (fileArray = dMTN.f.listFiles()) == null;
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        TreePath treePath = this.tree.getSelectionPath();
        if (treePath == null) {
            return;
        }
        Object object = treePath.getLastPathComponent();
        DMTN dMTN = (DMTN)object;
        if (dMTN.f == null || this.isInaccessibleDisk(dMTN)) {
            this.tree.setSelectionPath(new TreePath(currmtn.getPath()));
        } else {
            currmtn = dMTN;
            this.setLine(dMTN.f.getAbsolutePath());
        }
    }

    static void sort(File[] fileArray) {
        int n = fileArray.length - 1;
        boolean bl = false;
        while (true) {
            int n2 = 0;
            while (n2 < n) {
                int n3 = n2 + 1;
                if (fileArray[n2].compareTo(fileArray[n3]) > 0) {
                    File file = fileArray[n3];
                    fileArray[n3] = fileArray[n2];
                    fileArray[n2] = file;
                    bl = true;
                }
                ++n2;
            }
            if (!bl) break;
            bl = false;
            --n;
        }
    }

    class Renderer
    extends JLabel
    implements TreeCellRenderer {
        boolean selected;

        Renderer() {
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            this.selected = bl;
            this.setForeground(Color.black);
            DMTN dMTN = (DMTN)object;
            if (dMTN.f == null) {
                this.setIcon(GoDir.this.system);
                this.selected = false;
            } else if (dMTN.isdisk) {
                this.setIcon(GoDir.this.disk);
                this.setText(dMTN.f.getAbsolutePath() + " ");
            } else if (bl2) {
                this.setIcon(GoDir.this.opendir);
                this.setText(dMTN.f.getName() + " ");
            } else {
                this.setIcon(GoDir.this.dir);
                this.setText(dMTN.f.getName() + " ");
            }
            return this;
        }

        public void paintComponent(Graphics graphics) {
            if (this.selected) {
                Dimension dimension = this.getSize();
                graphics.setColor(GoDir.this.highlight);
                graphics.fillRect(0, 0, dimension.width, dimension.height);
            }
            super.paintComponent(graphics);
        }
    }
}

