/*
 * Decompiled with CFR 0.152.
 */
package com.equitysoft.jicasso;

import com.equitysoft.jicasso.Bar;
import com.equitysoft.jicasso.DataUtils;
import com.equitysoft.jicasso.ESDialog;
import com.equitysoft.jicasso.ESZap;
import com.equitysoft.jicasso.LibButton;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import javax.media.j3d.Canvas3D;
import javax.swing.BorderFactory;
import javax.swing.JPanel;

class ViewRunning
extends ESDialog
implements ActionListener {
    String CANCEL = "Close";

    ViewRunning(Canvas3D canvas3D) {
        super("Running current layout");
        this.jp.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout());
        jPanel.setBorder(BorderFactory.createEtchedBorder());
        LibButton libButton = new LibButton(this.CANCEL);
        jPanel.add(libButton);
        libButton.addActionListener(this);
        jPanel.add(libButton);
        this.jp.add((Component)jPanel, "North");
        this.jp.add((Component)canvas3D, "Center");
        this.finishOff();
        canvas3D.requestFocus();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.CANCEL == actionEvent.getActionCommand()) {
            System.gc();
            Bar.handle.repaint();
            this.closeDialog();
        }
    }

    static void runIt() {
        Canvas3D canvas3D = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            DataUtils.writeAll(dataOutputStream);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
            int n = dataInputStream.readInt();
            int n2 = dataInputStream.readInt();
            canvas3D = DataUtils.getCanvas(dataInputStream, new Dimension(n, n2));
            canvas3D.setSize(n, n2);
        }
        catch (Exception exception) {
            new ESZap("Error loading layout - " + exception.getMessage());
        }
        if (canvas3D != null) {
            new ViewRunning(canvas3D);
        }
        System.gc();
    }
}

