/*
 * Decompiled with CFR 0.152.
 */
package com.equitysoft.jicasso;

import com.equitysoft.jicasso.ESUtils;
import com.equitysoft.jicasso.ESZap;
import com.equitysoft.jicasso.LayoutFile;
import com.equitysoft.jicasso.Prefs;
import com.equitysoft.jicasso.ViewHTML;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JMenu;

class ViewMenu
extends JMenu
implements ActionListener {
    String VIEW_HTML = "HTML source";
    String VIEW_STATS = "HTML/JAR file sizes";
    String LAUNCH_VIEWER = "Applet in browser";

    ViewMenu() {
        super("View   ");
        this.add(ESUtils.getMI(this.VIEW_HTML, this));
        this.add(ESUtils.getMI(this.LAUNCH_VIEWER, this));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == this.VIEW_HTML) {
            if (LayoutFile.currappspec != null) {
                new ViewHTML();
            } else {
                new ESZap("Open a saved layout file first.");
            }
        } else if (string == this.LAUNCH_VIEWER) {
            if (LayoutFile.currappspec == null) {
                new ESZap("Save the layout first.");
                return;
            }
            File file = LayoutFile.currappspec.file;
            if (file == null) {
                new ESZap("Save and name this layout first.");
                return;
            }
            if (!file.exists()) {
                new ESZap("File " + file.getName() + " not found");
                return;
            }
            String string2 = "file:/" + file.getAbsolutePath().replace(File.separatorChar, '/');
            String string3 = Prefs.get("browser");
            if (string3.equals("")) {
                new ESZap("Set the browser first in preferences");
                return;
            }
            try {
                Runtime.getRuntime().exec(string3 + " " + string2);
            }
            catch (Exception exception) {
                new ESZap("Error launching browser - check the command line in preferences.");
            }
        }
    }
}

