/*
 * Decompiled with CFR 0.152.
 */
package com.equitysoft.jicasso;

import com.equitysoft.jicasso.AppSpec;
import com.equitysoft.jicasso.ESDialog;
import com.equitysoft.jicasso.ESUtils;
import com.equitysoft.jicasso.ESZap;
import com.equitysoft.jicasso.LayoutFile;
import com.equitysoft.jicasso.LibButton;
import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

class ViewHTML
extends ESDialog
implements ActionListener {
    String UNDO_EDIT = "Undo edits";
    String SAVE = "Save and exit";
    String CANCEL = "Cancel";
    JTextArea ta;
    AppSpec appspec = LayoutFile.currappspec;

    ViewHTML() {
        super("Contents of file  '" + LayoutFile.currappspec.file.getName() + "'");
        if (this.appspec == null) {
            new ESZap("Save and name this layout first.");
            return;
        }
        if (!this.appspec.file.exists()) {
            new ESZap("File " + this.appspec.file.getName() + " not found");
            return;
        }
        int n = (int)this.appspec.file.length();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MMM dd, yyyy");
        String string = simpleDateFormat.format(new Date(this.appspec.file.lastModified()));
        this.setTitle(this.getTitle() + "     Last modified on " + string + '.');
        this.jp.setLayout(new BorderLayout());
        this.ta = new JTextArea(ESUtils.getFileAsString(this.appspec.file), 25, 100);
        this.ta.setFont(new Font("Monospaced", 0, 12));
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.getViewport().add(this.ta);
        this.jp.add("Center", jScrollPane);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout());
        jPanel.setBorder(BorderFactory.createEtchedBorder());
        LibButton libButton = new LibButton(this.UNDO_EDIT);
        libButton.addActionListener(this);
        jPanel.add(libButton);
        libButton = new LibButton(this.SAVE);
        libButton.addActionListener(this);
        jPanel.add(libButton);
        libButton = new LibButton(this.CANCEL);
        libButton.addActionListener(this);
        jPanel.add(libButton);
        this.jp.add("North", jPanel);
        this.finishOff();
        this.ta.requestFocus();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.CANCEL == actionEvent.getActionCommand()) {
            this.closeDialog();
        } else if (this.SAVE == actionEvent.getActionCommand()) {
            if (!ESUtils.saveStringAsFile(this.ta.getText(), this.appspec.file)) {
                new ESZap("Error writing file");
            }
            this.closeDialog();
        } else {
            this.ta.setText(ESUtils.getFileAsString(this.appspec.file));
        }
    }
}

