/*
 * Decompiled with CFR 0.152.
 */
package com.equitysoft.jicasso;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.Serializable;
import java.util.Hashtable;

public class VerticalLayout
implements LayoutManager {
    public static final int CENTER = 0;
    public static final int RIGHT = 1;
    public static final int LEFT = 2;
    public static final int BOTH = 3;
    public static final int TOP = 1;
    public static final int BOTTOM = 2;
    private int vgap;
    private int alignment;
    private int anchor;
    private Hashtable comps;

    public VerticalLayout() {
        this(5, 0, 1);
    }

    public VerticalLayout(int n) {
        this(n, 0, 1);
    }

    public VerticalLayout(int n, int n2) {
        this(n, n2, 1);
    }

    public VerticalLayout(int n, int n2, int n3) {
        this.vgap = n;
        this.alignment = n2;
        this.anchor = n3;
    }

    private Dimension layoutSize(Container container, boolean bl) {
        Dimension dimension = new Dimension(0, 0);
        Object object = container.getTreeLock();
        synchronized (object) {
            int n = container.getComponentCount();
            int n2 = 0;
            while (n2 < n) {
                Component component = container.getComponent(n2);
                if (component.isVisible()) {
                    Dimension dimension2 = bl ? component.getMinimumSize() : component.getPreferredSize();
                    dimension.width = Math.max(dimension.width, dimension2.width);
                    dimension.height += dimension2.height;
                    if (n2 > 0) {
                        dimension.height += this.vgap;
                    }
                }
                ++n2;
            }
        }
        Insets insets = container.getInsets();
        dimension.width += insets.left + insets.right;
        dimension.height += insets.top + insets.bottom + this.vgap + this.vgap;
        return dimension;
    }

    public void layoutContainer(Container container) {
        Insets insets = container.getInsets();
        Dimension dimension = this.layoutSize(container, false);
        Object object = container.getTreeLock();
        synchronized (object) {
            Serializable serializable;
            int n = container.getComponentCount();
            Dimension dimension2 = container.getSize();
            int n2 = 0;
            int n3 = 0;
            while (n3 < n) {
                Component component = container.getComponent(n3);
                serializable = component.getPreferredSize();
                n2 += ((Dimension)serializable).height + this.vgap;
                ++n3;
            }
            n2 -= this.vgap;
            n2 = this.anchor == 1 ? insets.top : (this.anchor == 0 ? (dimension2.height - n2) / 2 : dimension2.height - n2 - insets.bottom);
            int n4 = 0;
            while (n4 < n) {
                serializable = container.getComponent(n4);
                Dimension dimension3 = ((Component)serializable).getPreferredSize();
                int n5 = insets.left;
                int n6 = dimension3.width;
                if (this.alignment == 0) {
                    n5 = (dimension2.width - dimension3.width) / 2;
                } else if (this.alignment == 1) {
                    n5 = dimension2.width - dimension3.width - insets.right;
                } else if (this.alignment == 3) {
                    n6 = dimension2.width - insets.left - insets.right;
                }
                ((Component)serializable).setBounds(n5, n2, n6, dimension3.height);
                n2 += dimension3.height + this.vgap;
                ++n4;
            }
        }
    }

    public Dimension minimumLayoutSize(Container container) {
        return this.layoutSize(container, false);
    }

    public Dimension preferredLayoutSize(Container container) {
        return this.layoutSize(container, false);
    }

    public void addLayoutComponent(String string, Component component) {
    }

    public void removeLayoutComponent(Component component) {
    }

    public String toString() {
        return this.getClass().getName() + "[vgap=" + this.vgap + " align=" + this.alignment + " anchor=" + this.anchor + "]";
    }
}

