/*
 * Decompiled with CFR 0.152.
 */
package com.equitysoft.jicasso;

import com.equitysoft.jicasso.CompType;
import com.equitysoft.jicasso.FileManager;
import com.equitysoft.jicasso.Grid;
import com.equitysoft.jicasso.MultiSelectionMenu;
import com.equitysoft.jicasso.MultiSelector;
import com.equitysoft.jicasso.Props;
import com.equitysoft.jicasso.TexType;
import java.io.File;

class TextureMenu
extends MultiSelectionMenu
implements MultiSelector,
Props {
    static String[] options = new String[]{"No texture", "Modulate", "Blend", "Replace", "Decal"};

    TextureMenu() {
        super("Texture", options, null);
        this.setMultiSelector(this);
        TexType texType = (TexType)Grid.getCurrent().getProp(6);
        if (texType != null) {
            this.setState(texType.type);
        }
    }

    public void multiCallBack(MultiSelectionMenu multiSelectionMenu, int n) {
        CompType compType = Grid.getCurrent();
        if (n != 0) {
            if (this.previous == 0) {
                File file = FileManager.getChooserImage("Choose texture image");
                if (file == null) {
                    this.reset();
                    return;
                }
                compType.setProp(6, new TexType(file, n));
            } else {
                TexType texType = (TexType)compType.getProp(6);
                texType.type = n;
                compType.setProp(6, texType);
            }
        } else {
            compType.setProp(6, null);
        }
    }
}

