/*
 * Decompiled with CFR 0.152.
 */
package com.equitysoft.jicasso;

import com.equitysoft.jicasso.AlignmentMenu;
import com.equitysoft.jicasso.CUtils;
import com.equitysoft.jicasso.DataUtils;
import com.equitysoft.jicasso.FontMenu;
import com.equitysoft.jicasso.ShellBox;
import com.equitysoft.jicasso.TexType;
import com.equitysoft.jicasso.TextAdjust;
import java.awt.Font;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.media.j3d.Appearance;
import javax.media.j3d.Font3D;
import javax.media.j3d.FontExtrusion;
import javax.media.j3d.Geometry;
import javax.media.j3d.Node;
import javax.media.j3d.Shape3D;
import javax.media.j3d.TexCoordGeneration;
import javax.media.j3d.Text3D;
import javax.media.j3d.TransformGroup;
import javax.swing.JPopupMenu;
import javax.vecmath.Point3f;

class Text3DBox
extends ShellBox {
    String text;
    Text3D tobj;
    Shape3D s3d;
    int alignment;
    String fname = "TimesRoman";
    int fstyle = 0;
    int fsize = 1;

    Text3DBox() {
    }

    public void addTo(TransformGroup transformGroup) {
        transformGroup.addChild((Node)this.bg);
    }

    public void addToMenu(JPopupMenu jPopupMenu) {
        jPopupMenu.add(new TextAdjust());
        jPopupMenu.add(new FontMenu());
        jPopupMenu.add(new AlignmentMenu());
    }

    public void finalInit(Object object) {
        this.text = (String)object;
        super.finalInit(object);
    }

    Node getNode(Appearance appearance) {
        this.s3d = this.getShape(appearance);
        return this.s3d;
    }

    public Object getProp(int n) {
        switch (n) {
            case 24: {
                return new Integer(4);
            }
            case 8: {
                return this.s3d.getAppearance();
            }
            case 16: {
                return this.fname;
            }
            case 17: {
                return new Integer(this.fstyle);
            }
            case 18: {
                return new Integer(this.fsize);
            }
            case 6: {
                return this.texture;
            }
            case 20: {
                return new Integer(this.alignment);
            }
        }
        return super.getProp(n);
    }

    Shape3D getShape(Appearance appearance) {
        appearance.setCapability(4);
        appearance.setCapability(5);
        FontExtrusion fontExtrusion = new FontExtrusion();
        Font3D font3D = new Font3D(new Font(this.fname, this.fstyle, this.fsize), fontExtrusion);
        this.tobj = new Text3D(font3D, this.text, new Point3f(0.0f, 0.0f, 0.0f), 0, CUtils.getTextAlignment(this.alignment));
        this.tobj.setCapability(3);
        this.tobj.setCapability(18);
        this.tobj.setCapability(6);
        this.s3d = new Shape3D();
        this.s3d.setGeometry((Geometry)this.tobj);
        this.s3d.setAppearance(appearance);
        this.s3d.setCapability(14);
        this.s3d.setCapability(15);
        return this.s3d;
    }

    public void readSubObj(DataInputStream dataInputStream) throws IOException {
        this.fname = dataInputStream.readUTF();
        this.fstyle = dataInputStream.readInt();
        this.fsize = dataInputStream.readInt();
        this.text = dataInputStream.readUTF();
        dataInputStream.readInt();
        this.alignment = dataInputStream.readInt();
        this.addChild(this.getNode(CUtils.initAppearance()));
    }

    public void setProp(int n, Object object) {
        switch (n) {
            case 6: {
                if (object != null) {
                    TexCoordGeneration texCoordGeneration = new TexCoordGeneration();
                    texCoordGeneration.setEnable(true);
                    this.s3d.getAppearance().setTexCoordGeneration(texCoordGeneration);
                }
                this.texture = CUtils.setTexture((TexType)object, this.s3d.getAppearance());
                break;
            }
            case 10: {
                this.transparency = CUtils.getTrans(object, this.s3d.getAppearance());
                break;
            }
            case 4: {
                this.text = (String)object;
                DataUtils.replaceCurrent(this);
                break;
            }
            case 16: {
                this.fname = (String)object;
                DataUtils.replaceCurrent(this);
                break;
            }
            case 17: {
                this.fstyle = (Integer)object;
                DataUtils.replaceCurrent(this);
                break;
            }
            case 18: {
                Integer n2 = (Integer)object;
                this.fsize = n2;
                DataUtils.replaceCurrent(this);
                break;
            }
            case 20: {
                Integer n3 = (Integer)object;
                this.alignment = n3;
                DataUtils.replaceCurrent(this);
                break;
            }
            default: {
                super.setProp(n, object);
            }
        }
    }

    public void writeSubObj(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(5);
        dataOutputStream.writeUTF(this.fname);
        dataOutputStream.writeInt(this.fstyle);
        dataOutputStream.writeInt(this.fsize);
        dataOutputStream.writeUTF(this.text);
        dataOutputStream.writeInt(CUtils.getTextAlignment(this.alignment));
        dataOutputStream.writeInt(this.alignment);
    }
}

