/*
 * Decompiled with CFR 0.152.
 */
package com.equitysoft.jicasso;

import com.equitysoft.jicasso.APLib;
import com.equitysoft.jicasso.BHInfo;
import com.equitysoft.jicasso.CUtils;
import com.equitysoft.jicasso.ColorAdjust;
import com.equitysoft.jicasso.CompType;
import com.equitysoft.jicasso.DataUtils;
import com.equitysoft.jicasso.FontMenu;
import com.equitysoft.jicasso.Props;
import com.equitysoft.jicasso.SelectionCallingMenu;
import com.equitysoft.jicasso.Selector;
import com.equitysoft.jicasso.TextAdjust;
import com.sun.j3d.utils.geometry.Text2D;
import java.awt.Color;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Node;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.TransformGroup;
import javax.swing.JPopupMenu;

class Text2DBox
extends TransformGroup
implements CompType,
Props,
Selector {
    BranchGroup bg;
    String text;
    String name;
    Text2D tobj;
    String fname = "Helvetica";
    int fstyle = 1;
    int fsize = 150;
    Color color = Color.white;
    int sides = 1;
    int pos;
    BHInfo bh;

    Text2DBox() {
        this.text = this.text;
        this.setCapability(18);
        this.setCapability(17);
        this.setCapability(1);
        this.bg = new BranchGroup();
        this.bg.setCapability(17);
        this.bg.addChild((Node)this);
    }

    public void addTo(TransformGroup transformGroup) {
        transformGroup.addChild((Node)this.bg);
    }

    public void callBack(SelectionCallingMenu selectionCallingMenu) {
        this.sides = selectionCallingMenu.getState();
        DataUtils.replaceCurrent(this);
    }

    public void detachIt() {
        this.bg.detach();
    }

    public void finalInit(Object object) {
        this.text = (String)object;
        this.tobj = this.getText2D();
        this.addChild((Node)this.tobj);
    }

    public Object getProp(int n) {
        switch (n) {
            case 24: {
                return new Integer(4);
            }
            case 22: {
                return this.name;
            }
            case 8: {
                return this.tobj.getAppearance();
            }
            case 7: {
                return new Integer(this.pos);
            }
            case 5: {
                return this.color;
            }
            case 16: {
                return this.fname;
            }
            case 17: {
                return new Integer(this.fstyle);
            }
            case 18: {
                return new Integer(this.fsize);
            }
            case 21: {
                return this.bh;
            }
        }
        return null;
    }

    Text2D getText2D() {
        Text2D text2D = new Text2D(this.text, APLib.getColor(this.color), this.fname, this.fsize, this.fstyle);
        text2D.getGeometry().setCapability(18);
        text2D.setCapability(14);
        text2D.setCapability(15);
        if (this.sides == 1) {
            PolygonAttributes polygonAttributes = new PolygonAttributes();
            polygonAttributes.setCullFace(0);
            polygonAttributes.setBackFaceNormalFlip(true);
            text2D.getAppearance().setPolygonAttributes(polygonAttributes);
        }
        return text2D;
    }

    public void readObj(DataInputStream dataInputStream) throws IOException {
        CUtils.readTransform(dataInputStream, this);
        this.text = dataInputStream.readUTF();
        this.color = CUtils.readColor(dataInputStream);
        this.fname = dataInputStream.readUTF();
        this.fsize = dataInputStream.readInt();
        this.fstyle = dataInputStream.readInt();
        this.sides = dataInputStream.readInt();
        this.tobj = this.getText2D();
        this.addChild((Node)this.tobj);
        if (dataInputStream.readBoolean()) {
            this.bh = BHInfo.readBH(dataInputStream);
        }
    }

    public void setMenu(JPopupMenu jPopupMenu) {
        jPopupMenu.add(new ColorAdjust());
        jPopupMenu.addSeparator();
        jPopupMenu.add(new TextAdjust());
        jPopupMenu.add(new FontMenu());
        SelectionCallingMenu selectionCallingMenu = new SelectionCallingMenu("Double sided", "No", "Yes", this);
        selectionCallingMenu.setState(this.sides);
        jPopupMenu.add(selectionCallingMenu);
    }

    public void setProp(int n, Object object) {
        switch (n) {
            case 22: {
                this.name = (String)object;
                break;
            }
            case 7: {
                Integer n2 = (Integer)object;
                this.pos = n2;
                break;
            }
            case 5: {
                this.color = (Color)object;
                DataUtils.replaceCurrent(this);
            }
            case 4: {
                this.text = (String)object;
                DataUtils.replaceCurrent(this);
                break;
            }
            case 16: {
                this.fname = (String)object;
                DataUtils.replaceCurrent(this);
                break;
            }
            case 17: {
                this.fstyle = (Integer)object;
                DataUtils.replaceCurrent(this);
                break;
            }
            case 18: {
                Integer n3 = (Integer)object;
                this.fsize = n3;
                DataUtils.replaceCurrent(this);
                break;
            }
            case 21: {
                this.bh = (BHInfo)object;
                break;
            }
        }
    }

    public void writeObj(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeUTF(this.getClass().getName().substring(23));
        dataOutputStream.writeUTF(this.name);
        dataOutputStream.writeInt(6);
        CUtils.writeTransform(dataOutputStream, this);
        dataOutputStream.writeUTF(this.text);
        CUtils.writeColor(dataOutputStream, this.color);
        dataOutputStream.writeUTF(this.fname);
        dataOutputStream.writeInt(this.fsize);
        dataOutputStream.writeInt(this.fstyle);
        dataOutputStream.writeInt(this.sides);
        if (this.bh == null) {
            dataOutputStream.writeBoolean(false);
        } else {
            this.bh.writeBH(dataOutputStream);
        }
    }
}

