/*
 * Decompiled with CFR 0.152.
 */
package com.equitysoft.jicasso;

import com.equitysoft.jicasso.Bar;
import com.equitysoft.jicasso.FileManager;
import com.equitysoft.jicasso.Grid;
import com.equitysoft.jicasso.HelpMenu;
import com.equitysoft.jicasso.MainPanel;
import com.equitysoft.jicasso.OptionsMenu;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

class SysProps {
    static Font TOOLTIP_FONT = new Font("SansSerif", 1, 13);
    static DataInputStream dis;
    static File CURR_DIR;
    static File PROPS_DIR;
    static File PROPS_FILE;
    static File DEFAULT_FILE;
    static File TMP_DIR;
    static File APPLET_DIR;
    static String EMPTY;
    static int PROPS_VERSION;
    static int spin;
    static int plugin;
    static String cd;

    SysProps() {
    }

    static void writeProps() {
        try {
            DataOutputStream dataOutputStream = new DataOutputStream(new FileOutputStream(PROPS_FILE));
            dataOutputStream.writeInt(PROPS_VERSION);
            Dimension dimension = ((Component)((Object)Grid.canvas)).getSize();
            dataOutputStream.writeInt(dimension.width);
            dataOutputStream.writeInt(dimension.height);
            dataOutputStream.writeUTF(FileManager.chooserdir.getAbsolutePath());
            dataOutputStream.writeUTF(FileManager.appletdir.getAbsolutePath());
            dataOutputStream.writeInt(HelpMenu.showlogo.getState());
            dataOutputStream.writeInt(Bar.useplugin.state);
            dataOutputStream.writeInt(OptionsMenu.navigation.getState());
            dataOutputStream.writeFloat(Grid.scale);
            Point point = Bar.handle.getLocation();
            dataOutputStream.writeInt(point.x);
            dataOutputStream.writeInt(point.y);
            point = Grid.handle.getLocation();
            dataOutputStream.writeInt(point.x);
            dataOutputStream.writeInt(point.y);
            dataOutputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static void setDirs() {
        CURR_DIR = new File(System.getProperty("user.dir"));
        PROPS_DIR = new File(CURR_DIR, "props");
        APPLET_DIR = new File(CURR_DIR, "applets");
        if (!PROPS_DIR.exists()) {
            PROPS_DIR.mkdir();
        }
        PROPS_FILE = new File(PROPS_DIR, "props.jcf");
        TMP_DIR = new File(PROPS_DIR, "temp");
        if (!TMP_DIR.exists()) {
            TMP_DIR.mkdir();
        }
        if (!APPLET_DIR.exists()) {
            APPLET_DIR.mkdir();
        }
    }

    static boolean exists() {
        if (PROPS_FILE.exists()) {
            try {
                dis = new DataInputStream(new FileInputStream(PROPS_FILE));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return true;
        }
        return false;
    }

    static void setDelayedProps() {
        HelpMenu.showlogo.setState(spin);
        Bar.useplugin.set(plugin);
    }

    static boolean setProps() {
        try {
            if (dis.readInt() != PROPS_VERSION) {
                dis.close();
                PROPS_FILE.delete();
                return false;
            }
            MainPanel.prefdim = new Dimension(dis.readInt(), dis.readInt());
            FileManager.chooserdir = new File(dis.readUTF());
            FileManager.appletdir = new File(dis.readUTF());
            spin = dis.readInt();
            plugin = dis.readInt();
            OptionsMenu.navigation.setState(dis.readInt());
            Grid.scale = dis.readFloat();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    static Point getBarLoc() {
        int n = 0;
        int n2 = 0;
        try {
            n = dis.readInt();
            n2 = dis.readInt();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new Point(n, n2);
    }

    static Point getGridLoc() {
        int n = 0;
        int n2 = 0;
        try {
            n = dis.readInt();
            n2 = dis.readInt();
            dis.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new Point(n, n2);
    }

    static {
        EMPTY = "";
        PROPS_VERSION = 2;
    }
}

