/*
 * Decompiled with CFR 0.152.
 */
package com.equitysoft.jicasso;

import com.equitysoft.jicasso.CUtils;
import com.equitysoft.jicasso.DataUtils;
import com.equitysoft.jicasso.FloatAdjust;
import com.equitysoft.jicasso.IntAdjust;
import com.equitysoft.jicasso.ShellBox;
import com.sun.j3d.utils.geometry.Sphere;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.media.j3d.Appearance;
import javax.media.j3d.Node;
import javax.swing.JPopupMenu;

class SphereBox
extends ShellBox {
    float radius = 1.0f;
    int divisions = 40;
    Sphere sphere;

    SphereBox() {
    }

    void addToMenu(JPopupMenu jPopupMenu) {
        jPopupMenu.add(new FloatAdjust(11, "Radius"));
        jPopupMenu.add(new IntAdjust(13, "Divisions", 5, 1000));
    }

    Node getNode(Appearance appearance) {
        this.sphere = new Sphere(this.radius, 99, this.divisions, appearance);
        return this.sphere;
    }

    public Object getProp(int n) {
        switch (n) {
            case 8: {
                return this.sphere.getAppearance();
            }
            case 22: {
                return "Sphere";
            }
            case 11: {
                return new Float(this.radius);
            }
            case 13: {
                return new Integer(this.divisions);
            }
        }
        return super.getProp(n);
    }

    void readSubObj(DataInputStream dataInputStream) throws IOException {
        this.radius = dataInputStream.readFloat();
        this.divisions = dataInputStream.readInt();
        this.addChild(this.getNode(CUtils.initAppearance()));
    }

    public void setProp(int n, Object object) {
        switch (n) {
            case 11: {
                Float f = (Float)object;
                this.radius = f.floatValue();
                DataUtils.replaceCurrent(this);
                break;
            }
            case 13: {
                Integer n2 = (Integer)object;
                this.divisions = n2;
                DataUtils.replaceCurrent(this);
                break;
            }
            default: {
                super.setProp(n, object);
            }
        }
    }

    void writeSubObj(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(0);
        dataOutputStream.writeFloat(this.radius);
        dataOutputStream.writeInt(this.divisions);
    }
}

