/*
 * Decompiled with CFR 0.152.
 */
package com.equitysoft.jicasso;

import com.equitysoft.jicasso.APLib;
import com.equitysoft.jicasso.BHInfo;
import com.equitysoft.jicasso.CUtils;
import com.equitysoft.jicasso.CompColor;
import com.equitysoft.jicasso.CompType;
import com.equitysoft.jicasso.IntAdjust;
import com.equitysoft.jicasso.PercentAdjust;
import com.equitysoft.jicasso.Props;
import com.equitysoft.jicasso.TexType;
import com.equitysoft.jicasso.TextureMenu;
import java.awt.Color;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Vector;
import javax.media.j3d.Appearance;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.media.j3d.TransformGroup;
import javax.swing.JPopupMenu;

public abstract class ShellBox
extends TransformGroup
implements CompType,
Props {
    public static final int SPHERE = 0;
    public static final int CUBE = 1;
    public static final int BOX = 2;
    public static final int CONE = 3;
    public static final int CYLINDER = 4;
    public static final int TEXT3D = 5;
    public static final int TEXT2D = 6;
    BranchGroup bg;
    String name;
    int transparency = -1;
    int shininess = -1;
    TexType texture;
    Color diffuse;
    Color specular;
    Color emissive;
    Color ambient;
    int pos;
    BHInfo bh;

    ShellBox() {
        this.setCapability(18);
        this.setCapability(17);
        this.setCapability(1);
        this.bg = new BranchGroup();
        this.bg.setCapability(17);
        this.bg.addChild((Node)this);
    }

    public void addTo(TransformGroup transformGroup) {
        transformGroup.addChild((Node)this.bg);
    }

    abstract void addToMenu(JPopupMenu var1);

    public void detachIt() {
        this.bg.detach();
    }

    public void finalInit(Object object) {
        this.addChild(this.getNode(CUtils.initAppearance()));
    }

    abstract Node getNode(Appearance var1);

    public Object getProp(int n) {
        switch (n) {
            case 24: {
                return new Integer(-1);
            }
            case 22: {
                return this.name;
            }
            case 7: {
                return new Integer(this.pos);
            }
            case 10: {
                if (this.transparency >= 0) {
                    return new Integer(this.transparency);
                }
                return new Integer(0);
            }
            case 6: {
                return this.texture;
            }
            case 21: {
                return this.bh;
            }
            case 23: {
                Appearance appearance = (Appearance)this.getProp(8);
                return appearance.getMaterial();
            }
            case 25: {
                int n2 = (int)((Material)this.getProp(23)).getShininess();
                return new Integer(n2);
            }
        }
        return null;
    }

    public void readObj(DataInputStream dataInputStream) throws IOException {
        String string;
        this.readSubObj(dataInputStream);
        CUtils.readTransform(dataInputStream, this);
        this.transparency = dataInputStream.readInt();
        if (this.transparency >= 0) {
            this.setProp(10, new Integer(this.transparency));
        }
        if ((this.shininess = dataInputStream.readInt()) >= 0) {
            this.setProp(25, new Integer(this.shininess));
        }
        if ((this.diffuse = CUtils.readColor(dataInputStream)) != null) {
            this.setProp(0, this.diffuse);
        }
        if ((this.specular = CUtils.readColor(dataInputStream)) != null) {
            this.setProp(1, this.specular);
        }
        if ((this.emissive = CUtils.readColor(dataInputStream)) != null) {
            this.setProp(2, this.emissive);
        }
        if ((this.ambient = CUtils.readColor(dataInputStream)) != null) {
            this.setProp(3, this.ambient);
        }
        if (!(string = dataInputStream.readUTF()).equals("")) {
            this.setProp(6, new TexType(string, dataInputStream.readInt()));
        }
        if (dataInputStream.readBoolean()) {
            this.bh = BHInfo.readBH(dataInputStream);
        }
    }

    abstract void readSubObj(DataInputStream var1) throws IOException;

    public void setMenu(JPopupMenu jPopupMenu) {
        jPopupMenu.add(new CompColor());
        jPopupMenu.add(new TextureMenu());
        jPopupMenu.add(new PercentAdjust(10, "Transparency"));
        jPopupMenu.add(new IntAdjust(25, "Shininess", 1, 128));
        jPopupMenu.addSeparator();
        this.addToMenu(jPopupMenu);
    }

    public void setProp(int n, Object object) {
        switch (n) {
            case 22: {
                this.name = (String)object;
                break;
            }
            case 7: {
                Integer n2 = (Integer)object;
                this.pos = n2;
                break;
            }
            case 0: {
                this.diffuse = (Color)object;
                ((Material)this.getProp(23)).setDiffuseColor(APLib.getColor(this.diffuse));
                break;
            }
            case 1: {
                this.specular = (Color)object;
                ((Material)this.getProp(23)).setSpecularColor(APLib.getColor(this.specular));
                break;
            }
            case 2: {
                this.emissive = (Color)object;
                ((Material)this.getProp(23)).setEmissiveColor(APLib.getColor(this.emissive));
                break;
            }
            case 3: {
                this.ambient = (Color)object;
                ((Material)this.getProp(23)).setAmbientColor(APLib.getColor(this.ambient));
                break;
            }
            case 6: {
                this.texture = CUtils.setTexture((TexType)object, (Appearance)this.getProp(8));
                break;
            }
            case 10: {
                this.transparency = CUtils.getTrans(object, (Appearance)this.getProp(8));
                break;
            }
            case 25: {
                this.shininess = (Integer)object;
                ((Material)this.getProp(23)).setShininess((float)this.shininess);
                break;
            }
            case 21: {
                this.bh = (BHInfo)object;
                break;
            }
            case 26: {
                if (this.texture == null) break;
                Vector vector = (Vector)object;
                vector.addElement(this.texture.path);
                break;
            }
        }
    }

    public void writeObj(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeUTF(this.getClass().getName().substring(23));
        dataOutputStream.writeUTF(this.name);
        this.writeSubObj(dataOutputStream);
        CUtils.writeTransform(dataOutputStream, this);
        dataOutputStream.writeInt(this.transparency);
        dataOutputStream.writeInt(this.shininess);
        CUtils.writeColor(dataOutputStream, this.diffuse);
        CUtils.writeColor(dataOutputStream, this.specular);
        CUtils.writeColor(dataOutputStream, this.emissive);
        CUtils.writeColor(dataOutputStream, this.ambient);
        if (this.texture == null) {
            dataOutputStream.writeUTF("");
        } else {
            this.texture.writeTex(dataOutputStream);
        }
        if (this.bh == null) {
            dataOutputStream.writeBoolean(false);
        } else {
            this.bh.writeBH(dataOutputStream);
        }
    }

    abstract void writeSubObj(DataOutputStream var1) throws IOException;
}

