/*
 * Decompiled with CFR 0.152.
 */
package com.equitysoft.jicasso;

import com.equitysoft.jicasso.APLib;
import com.equitysoft.jicasso.BackgroundMenu;
import com.equitysoft.jicasso.Bar;
import com.equitysoft.jicasso.DataUtils;
import com.equitysoft.jicasso.ESUtils;
import com.equitysoft.jicasso.Grid;
import com.equitysoft.jicasso.MBar;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.media.j3d.Background;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Node;
import javax.swing.JColorChooser;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.vecmath.Color3f;

class ScreenColor
extends JMenu
implements ActionListener {
    static String CUSTOM = "Select custom color";
    String REMOVE = "Remove current";
    static Color back = Color.black;
    static BranchGroup bg;
    static JMenuItem rem;

    ScreenColor() {
        super("Background color");
        this.add(ESUtils.getMI(CUSTOM, this));
        rem = this.add(ESUtils.getMI(this.REMOVE, this));
        rem.setEnabled(false);
        this.addSeparator();
        MBar.addColors(this);
    }

    static void writeBackground(DataOutputStream dataOutputStream) throws IOException {
        if (bg == null) {
            dataOutputStream.writeInt(0);
        } else {
            dataOutputStream.writeInt(back.getRGB());
        }
    }

    static void removeIt() {
        if (bg != null) {
            bg.detach();
        }
        bg = null;
        rem.setEnabled(false);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Color color = null;
        String string = actionEvent.getActionCommand();
        if (string == this.REMOVE) {
            ScreenColor.removeIt();
            return;
        }
        if (string == CUSTOM) {
            color = JColorChooser.showDialog(Grid.handle, CUSTOM, back);
            Bar.handle.repaint();
        } else {
            color = MBar.getColor(string);
        }
        if (color == null) {
            return;
        }
        ScreenColor.addColor(color);
    }

    static void addColor(Color color) {
        rem.setEnabled(true);
        back = color;
        Color3f color3f = APLib.getColor(color);
        ScreenColor.removeIt();
        BackgroundMenu.removeIt();
        Background background = new Background(color3f);
        background.setApplicationBounds((Bounds)DataUtils.bnds);
        bg = new BranchGroup();
        bg.setCapability(17);
        bg.addChild((Node)background);
        Grid.bg.addChild((Node)bg);
    }
}

