/*
 * Decompiled with CFR 0.152.
 */
package com.equitysoft.jicasso;

import com.equitysoft.jicasso.BHInfo;
import com.equitysoft.jicasso.ESDialog;
import com.equitysoft.jicasso.LibButton;
import com.equitysoft.jicasso.MultiOption;
import com.equitysoft.jicasso.PMBox;
import com.equitysoft.jicasso.VerticalLayout;
import com.equitysoft.jicasso.YesNo;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

class RotateInfo
extends BHInfo {
    int direc;
    boolean relative;
    int time = 4;

    RotateInfo() {
        this.type = 1;
    }

    void writeSubBH(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(this.direc);
        dataOutputStream.writeBoolean(this.relative);
        dataOutputStream.writeInt(this.time);
    }

    void readSubBH(DataInputStream dataInputStream) throws IOException {
        this.direc = dataInputStream.readInt();
        this.relative = dataInputStream.readBoolean();
        this.time = dataInputStream.readInt();
    }

    boolean alter() {
        new RotateDialog();
        return BHInfo.changed;
    }

    class RotateDialog
    extends ESDialog
    implements ActionListener {
        String APPLY = "Apply";
        String CANCEL = "Cancel";
        String[] ax = new String[]{"Y axis", "X axis", "Z axis"};
        MultiOption axis;
        YesNo rel;
        PMBox tm;

        RotateDialog() {
            super("Rotate");
            RotateInfo.this.type = 1;
            this.jp.setLayout(new VerticalLayout(5, 3));
            this.axis = new MultiOption("Around which axis", this.ax, null, RotateInfo.this.direc);
            this.jp.add(this.axis);
            this.axis.setOption(RotateInfo.this.direc);
            this.rel = new YesNo("Relative to", "Current position", "Center of layout");
            this.jp.add(this.rel);
            this.rel.setYes(RotateInfo.this.relative);
            this.tm = new PMBox("Rotation time (secs)", null, RotateInfo.this.time, 1, 1000);
            this.jp.add(this.tm);
            Container container = new Container();
            container.setLayout(new FlowLayout());
            this.jp.add(container);
            container.add(new LibButton(this.APPLY, this));
            container.add(new LibButton(this.CANCEL, this));
            this.finishOff();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string == this.CANCEL) {
                BHInfo.changed = false;
                this.closeDialog();
                return;
            }
            BHInfo.changed = true;
            RotateInfo.this.direc = this.axis.getOption();
            RotateInfo.this.relative = this.rel.isYes();
            RotateInfo.this.time = this.tm.curr;
            this.closeDialog();
        }
    }
}

