/*
 * Decompiled with CFR 0.152.
 */
package com.equitysoft.jicasso;

import com.equitysoft.jicasso.AngleAdjust;
import com.equitysoft.jicasso.AttnBox;
import com.equitysoft.jicasso.Bar;
import com.equitysoft.jicasso.ESUtils;
import com.equitysoft.jicasso.FloatChange;
import com.equitysoft.jicasso.Grid;
import com.equitysoft.jicasso.LightBox;
import com.equitysoft.jicasso.RotateAdjuster;
import com.equitysoft.jicasso.Settable;
import com.equitysoft.jicasso.Status;
import com.equitysoft.jicasso.VectorAdjuster;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Vector;
import javax.media.j3d.SpotLight;
import javax.swing.JColorChooser;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.vecmath.Vector3f;

class LightsMenu
extends JMenu
implements ActionListener,
Settable {
    static final int NONE = 0;
    static final int PSELECT = 1;
    static final int SSELECT = 2;
    static final int ANGLE = 0;
    static final int DIREC = 1;
    static final int CONCEN = 2;
    String SPOT = "Add spot";
    String POINT = "Add point";
    String DADD = "Add directional";
    String DALTER = "Change direction";
    String DDEL = "Delete directional";
    String HIDE = "Hide lights";
    String SELECTS = "Select spot";
    String DELETES = "Remove spot";
    String ALL = "Remove all lights";
    String SATTN = "Alter spot attenuation";
    String SDIR = "Alter direction";
    String SANGLE = "Alter spread";
    String SCONCEN = "Alter concentration";
    String PATTN = "Alter point attenuation";
    String SELECTP = "Select point";
    String DELETEP = "Remove point";
    static Vector plights;
    static Vector slights;
    static boolean pdelete;
    static boolean sdelete;
    static JMenuItem dalter;
    static JMenuItem ddel;
    static JMenuItem sselect;
    static JMenuItem sdel;
    static JMenuItem pselect;
    static JMenuItem pdel;
    static JMenuItem sdir;
    static JMenuItem sangle;
    static JMenuItem scon;
    static JMenuItem sattn;
    static JMenuItem pattn;
    static LightBox direct;
    static LightBox currs;
    static LightBox currp;
    static int action;

    LightsMenu() {
        super("Lights   ");
        slights = new Vector();
        plights = new Vector();
        JMenu jMenu = new JMenu("Directional light");
        this.add(jMenu);
        jMenu.add(ESUtils.getMI(this.DADD, this));
        dalter = ESUtils.getMI(this.DALTER, this);
        jMenu.add(dalter);
        ddel = ESUtils.getMI(this.DDEL, this);
        jMenu.add(ddel);
        LightsMenu.directOff();
        jMenu = new JMenu("Point light");
        this.add(jMenu);
        jMenu.add(ESUtils.getMI(this.POINT, this));
        pselect = ESUtils.getMI(this.SELECTP, this);
        jMenu.add(pselect);
        pselect.setEnabled(false);
        jMenu.addSeparator();
        pattn = ESUtils.getMI(this.PATTN, this);
        jMenu.add(pattn);
        jMenu.addSeparator();
        pdel = ESUtils.getMI(this.DELETEP, this);
        jMenu.add(pdel);
        jMenu = new JMenu("Spot light");
        this.add(jMenu);
        jMenu.add(ESUtils.getMI(this.SPOT, this));
        sselect = ESUtils.getMI(this.SELECTS, this);
        jMenu.add(sselect);
        sselect.setEnabled(false);
        jMenu.addSeparator();
        sattn = ESUtils.getMI(this.SATTN, this);
        jMenu.add(sattn);
        sangle = ESUtils.getMI(this.SANGLE, this);
        jMenu.add(sangle);
        sdir = ESUtils.getMI(this.SDIR, this);
        jMenu.add(sdir);
        scon = ESUtils.getMI(this.SCONCEN, this);
        jMenu.add(scon);
        jMenu.addSeparator();
        sdel = ESUtils.getMI(this.DELETES, this);
        jMenu.add(sdel);
        LightsMenu.spotOff();
        LightsMenu.pointOff();
        this.addSeparator();
        this.add(ESUtils.getMI(this.HIDE, this));
        this.add(ESUtils.getMI(this.ALL, this));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == this.DALTER) {
            if (direct != null) {
                new RotateAdjuster(direct, " Rotate directional");
            }
        } else if (string == this.HIDE) {
            LightsMenu.setOn(false, slights);
            LightsMenu.setOn(false, plights);
        } else if (string == this.SELECTP) {
            LightsMenu.setOn(false, slights);
            if (LightsMenu.getPcount() == 1) {
                currp = LightsMenu.getFirstP();
                currp.setOn(true);
                LightsMenu.pointOn();
            } else {
                action = 1;
                Status.tmpSet("Click on the pointlight to be selected", Color.black, Color.magenta);
                LightsMenu.setOn(true, plights);
            }
        } else if (string == this.SELECTS) {
            LightsMenu.setOn(false, plights);
            if (LightsMenu.getScount() == 1) {
                currs = LightsMenu.getFirstS();
                currs.setOn(true);
                LightsMenu.spotOn();
            } else {
                action = 2;
                Status.tmpSet("Click on the spotlight to be selected", Color.black, Color.magenta);
                LightsMenu.setOn(true, slights);
            }
        } else if (string == this.DDEL) {
            LightsMenu.removeDirect();
        } else if (string == this.DELETES) {
            LightsMenu.currs.bg.detach();
            slights.setElementAt(null, LightsMenu.currs.pos);
            currs = null;
            LightsMenu.spotOff();
            if (LightsMenu.getScount() == 0) {
                sselect.setEnabled(false);
            }
        } else if (string == this.DELETEP) {
            LightsMenu.currp.bg.detach();
            plights.setElementAt(null, LightsMenu.currp.pos);
            currp = null;
            LightsMenu.pointOff();
            if (LightsMenu.getPcount() == 0) {
                pselect.setEnabled(false);
            }
        } else if (string == this.SATTN) {
            new AttnBox(currs);
        } else if (string == this.PATTN) {
            new AttnBox(currp);
        } else if (string == this.SANGLE) {
            if (LightsMenu.getScount() == 1) {
                this.adjustAngle();
            }
        } else if (string == this.SDIR) {
            Vector3f vector3f = new Vector3f();
            ((SpotLight)LightsMenu.currs.light).getDirection(vector3f);
            new VectorAdjuster(1, vector3f, " Alter spot direction", this);
        } else if (string == this.SCONCEN) {
            new FloatChange(2, this, "Concentration");
        } else if (string == this.ALL) {
            LightsMenu.deleteAll();
        } else {
            Color color = JColorChooser.showDialog(Grid.handle, "Choose the color of the light", Color.white);
            Bar.handle.repaint();
            if (color == null) {
                return;
            }
            if (string == this.DADD) {
                LightsMenu.removeDirect();
                direct = new LightBox(0, color);
                direct.addTo(Grid.tg);
                LightsMenu.directOn();
            } else if (string == this.POINT) {
                LightsMenu.allOff();
                LightBox lightBox = new LightBox(2, color);
                if (lightBox != null) {
                    lightBox.pos = plights.size();
                    plights.addElement(lightBox);
                    LightsMenu.pointOn();
                    lightBox.addTo(Grid.tg);
                }
                pselect.setEnabled(true);
                LightsMenu.pointOn();
                currp = lightBox;
            } else if (string == this.SPOT) {
                LightsMenu.allOff();
                LightBox lightBox = new LightBox(1, color);
                if (lightBox != null) {
                    lightBox.pos = slights.size();
                    slights.addElement(lightBox);
                    LightsMenu.spotOn();
                    lightBox.addTo(Grid.tg);
                }
                sselect.setEnabled(true);
                LightsMenu.spotOn();
                currs = lightBox;
            }
        }
    }

    static void allOff() {
        LightsMenu.setOn(false, slights);
        LightsMenu.setOn(false, plights);
    }

    void adjustAngle() {
        new AngleAdjust(0, "Spread ", this);
    }

    public void setProp(int n, Object object) {
        switch (n) {
            case 0: {
                float f = ((Float)object).floatValue();
                ((SpotLight)LightsMenu.currs.light).setSpreadAngle(f);
                break;
            }
            case 1: {
                ((SpotLight)LightsMenu.currs.light).setDirection((Vector3f)object);
                break;
            }
            case 2: {
                float f = ((Float)object).intValue();
                ((SpotLight)LightsMenu.currs.light).setConcentration(f);
            }
        }
    }

    public Object getProp(int n) {
        switch (n) {
            case 2: {
                return new Float(((SpotLight)LightsMenu.currs.light).getConcentration());
            }
            case 0: {
                return new Float(((SpotLight)LightsMenu.currs.light).getSpreadAngle());
            }
        }
        return null;
    }

    static void addLight(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readInt();
        LightBox lightBox = new LightBox(n, new Color(dataInputStream.readInt()), dataInputStream);
        switch (n) {
            case 0: {
                LightsMenu.directOn();
                direct = lightBox;
                break;
            }
            case 2: {
                pselect.setEnabled(true);
                lightBox.setOn(false);
                plights.addElement(lightBox);
                break;
            }
            case 1: {
                sselect.setEnabled(true);
                lightBox.setOn(false);
                slights.addElement(lightBox);
            }
        }
        lightBox.addTo(Grid.tg);
    }

    static void deleteAll() {
        LightsMenu.deleteAllS();
        LightsMenu.deleteAllC();
        LightsMenu.removeDirect();
        System.gc();
        LightsMenu.pointOff();
        LightsMenu.spotOff();
    }

    static void deleteAllS() {
        int n = slights.size();
        int n2 = 0;
        while (n2 < n) {
            Object e = slights.elementAt(n2);
            if (e != null) {
                LightBox lightBox = (LightBox)((Object)e);
                lightBox.bg.detach();
            }
            ++n2;
        }
        slights.removeAllElements();
    }

    static void deleteAllC() {
        int n = plights.size();
        int n2 = 0;
        while (n2 < n) {
            Object e = plights.elementAt(n2);
            if (e != null) {
                LightBox lightBox = (LightBox)((Object)e);
                lightBox.bg.detach();
            }
            ++n2;
        }
        plights.removeAllElements();
    }

    static void directOn() {
        dalter.setEnabled(true);
        ddel.setEnabled(true);
    }

    static void directOff() {
        dalter.setEnabled(false);
        ddel.setEnabled(false);
    }

    static void spotOn() {
        LightsMenu.pointOff();
        sdel.setEnabled(true);
        sdir.setEnabled(true);
        sangle.setEnabled(true);
        scon.setEnabled(true);
        sattn.setEnabled(true);
    }

    static void spotOff() {
        sdel.setEnabled(false);
        sdir.setEnabled(false);
        sangle.setEnabled(false);
        scon.setEnabled(false);
        sattn.setEnabled(false);
    }

    static void pointOn() {
        LightsMenu.spotOff();
        pdel.setEnabled(true);
        pattn.setEnabled(true);
    }

    static void pointOff() {
        pdel.setEnabled(false);
        pattn.setEnabled(false);
    }

    static void removeDirect() {
        if (direct != null) {
            LightsMenu.direct.bg.detach();
            direct = null;
            LightsMenu.directOff();
        }
    }

    static void selected(LightBox lightBox) {
        switch (action) {
            case 1: {
                currp = lightBox;
                currs = null;
                LightsMenu.pointOn();
                break;
            }
            case 2: {
                currs = lightBox;
                currp = null;
                LightsMenu.spotOn();
                break;
            }
            default: {
                return;
            }
        }
        action = 0;
        Status.unset();
        LightsMenu.allOff();
        lightBox.setOn(true);
    }

    static int getPcount() {
        int n = plights.size();
        if (n == 0) {
            return 0;
        }
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            if (plights.elementAt(n3) != null) {
                ++n2;
            }
            ++n3;
        }
        return n2;
    }

    static LightBox getFirstP() {
        int n = plights.size();
        int n2 = 0;
        while (n2 < n) {
            if (plights.elementAt(n2) != null) {
                return (LightBox)((Object)plights.elementAt(n2));
            }
            ++n2;
        }
        return null;
    }

    static int getScount() {
        int n = slights.size();
        if (n == 0) {
            return 0;
        }
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            if (slights.elementAt(n3) != null) {
                ++n2;
            }
            ++n3;
        }
        return n2;
    }

    static LightBox getFirstS() {
        int n = slights.size();
        int n2 = 0;
        while (n2 < n) {
            if (slights.elementAt(n2) != null) {
                return (LightBox)((Object)slights.elementAt(n2));
            }
            ++n2;
        }
        return null;
    }

    static void setOn(boolean bl, Vector vector) {
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            Object e = vector.elementAt(n2);
            if (e != null) {
                LightBox lightBox = (LightBox)((Object)e);
                lightBox.setOn(bl);
            }
            ++n2;
        }
    }
}

