/*
 * Decompiled with CFR 0.152.
 */
package com.equitysoft.jicasso;

import com.equitysoft.jicasso.APLib;
import com.equitysoft.jicasso.CUtils;
import com.equitysoft.jicasso.DataUtils;
import com.sun.j3d.utils.geometry.Sphere;
import java.awt.Color;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.media.j3d.Appearance;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.ColoringAttributes;
import javax.media.j3d.DirectionalLight;
import javax.media.j3d.Light;
import javax.media.j3d.Node;
import javax.media.j3d.PointLight;
import javax.media.j3d.SpotLight;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.TransparencyAttributes;
import javax.vecmath.Color3f;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;

public class LightBox
extends TransformGroup {
    public static final int DIRECTIONAL = 0;
    public static final int SPOT = 1;
    public static final int POINT = 2;
    BranchGroup bg;
    Color color;
    Light light;
    Sphere sp;
    int type;
    int pos;

    LightBox(int n, Color color, DataInputStream dataInputStream) {
        this(n, color);
        try {
            CUtils.readTransform(dataInputStream, this);
            switch (n) {
                case 2: {
                    ((PointLight)this.light).setAttenuation(CUtils.readPoint(dataInputStream));
                    break;
                }
                case 1: {
                    SpotLight spotLight = (SpotLight)this.light;
                    spotLight.setAttenuation(CUtils.readPoint(dataInputStream));
                    spotLight.setSpreadAngle(dataInputStream.readFloat());
                    spotLight.setConcentration(dataInputStream.readFloat());
                    spotLight.setDirection(CUtils.readVector(dataInputStream));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    LightBox(int n, Color color) {
        SpotLight spotLight;
        ColoringAttributes coloringAttributes;
        this.type = n;
        this.color = color;
        Color3f color3f = APLib.getColor(color);
        this.setCapability(18);
        this.setCapability(17);
        this.setCapability(1);
        this.bg = new BranchGroup();
        this.bg.setCapability(17);
        Appearance appearance = new Appearance();
        if (n != 0) {
            coloringAttributes = new ColoringAttributes(color3f, 2);
            appearance.setColoringAttributes(coloringAttributes);
            appearance.setCapability(11);
            appearance.setCapability(10);
            spotLight = new TransparencyAttributes(0, 0.0f);
            spotLight.setCapability(3);
            appearance.setTransparencyAttributes((TransparencyAttributes)spotLight);
            this.sp = new Sphere(0.3f, 96, appearance);
            this.addChild((Node)this.sp);
        }
        this.bg.addChild((Node)this);
        switch (n) {
            case 0: {
                this.light = new DirectionalLight();
                break;
            }
            case 2: {
                coloringAttributes = new PointLight();
                this.light = coloringAttributes;
                coloringAttributes.setCapability(20);
                coloringAttributes.setCapability(21);
                break;
            }
            case 1: {
                spotLight = new SpotLight();
                this.light = spotLight;
                spotLight.setCapability(20);
                spotLight.setCapability(21);
                spotLight.setCapability(27);
                spotLight.setCapability(26);
                spotLight.setCapability(23);
                spotLight.setCapability(22);
                spotLight.setCapability(25);
                spotLight.setCapability(24);
            }
        }
        this.light.setCapability(15);
        this.light.setColor(color3f);
        this.light.setInfluencingBounds((Bounds)DataUtils.bnds);
        this.addChild((Node)this.light);
    }

    void writeLightBox(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(this.type);
        dataOutputStream.writeInt(this.color.getRGB());
        CUtils.writeTransform(dataOutputStream, this);
        switch (this.type) {
            case 2: {
                PointLight pointLight = (PointLight)this.light;
                Point3f point3f = new Point3f();
                pointLight.getAttenuation(point3f);
                CUtils.writePoint(dataOutputStream, point3f);
                break;
            }
            case 1: {
                SpotLight spotLight = (SpotLight)this.light;
                Point3f point3f = new Point3f();
                spotLight.getAttenuation(point3f);
                CUtils.writePoint(dataOutputStream, point3f);
                dataOutputStream.writeFloat(spotLight.getSpreadAngle());
                dataOutputStream.writeFloat(spotLight.getConcentration());
                Vector3f vector3f = new Vector3f();
                spotLight.getDirection(vector3f);
                CUtils.writeVector(dataOutputStream, vector3f);
            }
        }
    }

    void setOn(boolean bl) {
        TransparencyAttributes transparencyAttributes = this.sp.getAppearance().getTransparencyAttributes();
        if (!bl) {
            transparencyAttributes.setTransparency(1.0f);
        } else {
            transparencyAttributes.setTransparency(0.0f);
        }
    }

    void addTo(TransformGroup transformGroup) {
        transformGroup.addChild((Node)this.bg);
    }
}

