/*
 * Decompiled with CFR 0.152.
 */
package com.equitysoft.jicasso;

import com.equitysoft.jicasso.AppSpec;
import com.equitysoft.jicasso.Bar;
import com.equitysoft.jicasso.DataUtils;
import com.equitysoft.jicasso.ESUtils;
import com.equitysoft.jicasso.ESZap;
import com.equitysoft.jicasso.FileManager;
import com.equitysoft.jicasso.Grid;
import com.equitysoft.jicasso.HTMLCreator;
import com.equitysoft.jicasso.LayoutReader;
import com.equitysoft.jicasso.RecentFiles;
import com.equitysoft.jicasso.SysProps;
import com.equitysoft.jicasso.ToolBar;
import java.awt.Component;
import java.awt.Dimension;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public class LayoutFile {
    static final int THIS_VERSION = 1;
    static final String TMP_NAME = "temp_layout";
    public static final String PARAM_FILE = "jc.text";
    static final String SUFFIX = ".jar";
    static String SAVE_MSG = "Saving the current applet.";
    static String SAVE_AS_MSG = "Specify the HTML file to save to.";
    static AppSpec currappspec;
    static String[] classlib;
    static Date today;
    static ZipOutputStream zos;
    static FileOutputStream cfos;
    static Hashtable zipped;
    static ZipFile ozf;
    static byte[] buf;
    static String y;

    static void openHTML() {
        File file = FileManager.getAppletFile("Select layout to open");
        if (file == null) {
            return;
        }
        AppSpec appSpec = HTMLCreator.getFirstApplet(file);
        if (appSpec != null) {
            LayoutFile.openLayout(appSpec);
        }
    }

    static void saveAll(boolean bl) {
        if (!bl && currappspec != null) {
            if (Bar.useplugin.state == 1 && !LayoutFile.currappspec.plugin || Bar.useplugin.state == 0 && LayoutFile.currappspec.plugin) {
                new ESZap("To change the use of the plugin use 'Save as'");
                return;
            }
            LayoutFile.doSave(currappspec);
        } else {
            File file = FileManager.getSaveApplet(SAVE_MSG);
            if (file == null) {
                return;
            }
            AppSpec appSpec = new AppSpec(file);
            if (LayoutFile.doSave(appSpec)) {
                LayoutFile.setCurrappspec(appSpec);
            }
        }
    }

    static void setCurrappspec(AppSpec appSpec) {
        currappspec = appSpec;
        Bar.setHeader(appSpec);
    }

    static boolean doSave(AppSpec appSpec) {
        Object object;
        appSpec.dim = ((Component)((Object)Grid.canvas)).getSize();
        boolean bl = false;
        if (Bar.useplugin.state == 1) {
            appSpec.plugin = true;
            bl = true;
        }
        today = new Date();
        if (zipped == null) {
            zipped = new Hashtable(20);
        } else {
            zipped.clear();
        }
        File file = new File(SysProps.TMP_DIR, "temp_layout.jar");
        try {
            zos = new ZipOutputStream(new FileOutputStream(file));
        }
        catch (IOException iOException) {
            new ESZap("Error creating JAR file " + file.getName());
            return false;
        }
        if (!LayoutFile.addManifest()) {
            return false;
        }
        File file2 = new File(SysProps.TMP_DIR, appSpec.dataname == null ? appSpec.setDataName() + ".t" : appSpec.dataname + ".t");
        try {
            object = new DataOutputStream(new FileOutputStream(file2));
            ((DataOutputStream)object).writeInt(1);
            ((DataOutputStream)object).writeInt(Bar.useplugin.state);
            DataUtils.writeAll((DataOutputStream)object);
            ((FilterOutputStream)object).close();
        }
        catch (IOException iOException) {
            new ESZap("Error '" + iOException.getMessage() + "' writing parameter file.");
            return false;
        }
        if (!LayoutFile.addZipFile(file2)) {
            new ESZap("Unable to load parameter file.");
            return false;
        }
        object = DataUtils.files;
        int n = ((Vector)object).size();
        int n2 = 0;
        while (n2 < n) {
            File file3 = (File)((Vector)object).elementAt(n2);
            if (!LayoutFile.addZipFile(file3)) {
                return false;
            }
            ++n2;
        }
        n = classlib.length;
        appSpec.mainclass = classlib[0];
        int n3 = 0;
        while (n3 < n) {
            if (!LayoutFile.addZipSystemFile(classlib[n3])) {
                new ESZap("Unable to save " + classlib[n3] + " in JAR file.");
                return false;
            }
            ++n3;
        }
        try {
            zos.close();
        }
        catch (IOException iOException) {
            new ESZap("Error closing JAR file.");
            return false;
        }
        if (!appSpec.nohtml && !HTMLCreator.createHTML(appSpec)) {
            return false;
        }
        File file4 = new File(appSpec.file.getParent(), appSpec.name + SUFFIX);
        if (file4.exists()) {
            file4.delete();
        }
        file.renameTo(file4);
        RecentFiles.addFile(appSpec.file);
        return true;
    }

    static boolean addZipSystemFile(String string) {
        if (zipped.containsKey(string)) {
            return true;
        }
        zipped.put(string, "");
        try {
            int n;
            InputStream inputStream = ESUtils.cls.getResourceAsStream("applets/" + string);
            zos.putNextEntry(new ZipEntry(string));
            while ((n = inputStream.read(buf)) != -1) {
                zos.write(buf, 0, n);
            }
            inputStream.close();
        }
        catch (IOException iOException) {
            new ESZap("Error writing JAR entry " + string);
            return false;
        }
        return true;
    }

    static boolean addZipFile(File file) {
        if (!file.exists()) {
            new ESZap("Can't find file " + file.getAbsolutePath() + " for loading");
            return false;
        }
        String string = file.getName();
        if (zipped.containsKey(string)) {
            return true;
        }
        zipped.put(string, "");
        return LayoutFile.addToZip(file);
    }

    static boolean addToZip(File file) {
        if (!file.exists()) {
            new ESZap("Unable to find file " + file);
            return false;
        }
        String string = file.getName();
        try {
            int n;
            FileInputStream fileInputStream = new FileInputStream(file);
            zos.putNextEntry(new ZipEntry(string));
            while ((n = fileInputStream.read(buf)) != -1) {
                zos.write(buf, 0, n);
            }
            fileInputStream.close();
        }
        catch (IOException iOException) {
            new ESZap("Error writing JAR entry " + string);
            return false;
        }
        return true;
    }

    static boolean addManifest() {
        try {
            zos.putNextEntry(new ZipEntry("META-INF/MANIFEST.MF"));
            String string = "Manifest-Version: 1.0\r\n";
            byte[] byArray = string.getBytes();
            zos.write(byArray, 0, byArray.length);
        }
        catch (IOException iOException) {
            new ESZap("Error writing JAR manifest.");
            return false;
        }
        return true;
    }

    static void openLayout(AppSpec appSpec) {
        if (LayoutFile.readLayout(appSpec)) {
            currappspec = appSpec;
            Bar.setHeader(currappspec);
            if (appSpec.plugin) {
                Bar.useplugin.set(1);
            } else {
                Bar.useplugin.set(0);
            }
        }
    }

    static boolean readLayout(AppSpec appSpec) {
        File file = new File(appSpec.file.getParent(), appSpec.name + SUFFIX);
        if (!file.exists()) {
            new ESZap(file.getName() + " needed but not found.");
            return false;
        }
        try {
            ozf = new ZipFile(file);
        }
        catch (IOException iOException) {
            new ESZap(file.getName() + " could not be read as a JAR file.");
            return false;
        }
        Enumeration<? extends ZipEntry> enumeration = ozf.entries();
        ZipEntry zipEntry = null;
        String string = null;
        while (enumeration.hasMoreElements()) {
            zipEntry = enumeration.nextElement();
            string = zipEntry.getName();
            if (string.endsWith(".t")) break;
        }
        if (!string.endsWith(".t")) {
            new ESZap("The AppletPainter parameter file was not found in the JAR file.");
            return false;
        }
        appSpec.dataname = string.substring(0, string.indexOf(".t"));
        try {
            ZipEntry zipEntry2 = ozf.getEntry(string);
            DataInputStream dataInputStream = new DataInputStream(ozf.getInputStream(zipEntry2));
            if (dataInputStream.readInt() != 1) {
                new ESZap("Incompatible applet version - unable to edit.");
                dataInputStream.close();
                return false;
            }
            Bar.useplugin.set(dataInputStream.readInt());
            ToolBar.newLayout();
            Dimension dimension = new Dimension(dataInputStream.readInt(), dataInputStream.readInt());
            if (!dimension.equals(((Component)((Object)Grid.canvas)).getSize())) {
                Grid.setDimension(dimension);
            }
            dataInputStream.readFloat();
            dataInputStream.readInt();
            LayoutReader.readAll(dataInputStream, dimension);
            dataInputStream.close();
            ozf.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            new ESZap("Error reading parameter file from the JAR file.");
            return false;
        }
        RecentFiles.addFile(appSpec.file);
        return true;
    }

    static File getFromZip(String string) {
        ZipEntry zipEntry = ozf.getEntry(string);
        if (zipEntry == null) {
            new ESZap("Entry " + string + " not found in JAR");
            return null;
        }
        File file = new File(SysProps.TMP_DIR, string);
        if (file.exists()) {
            return file;
        }
        try {
            int n;
            InputStream inputStream = ozf.getInputStream(zipEntry);
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            while ((n = inputStream.read(buf)) != -1) {
                fileOutputStream.write(buf, 0, n);
            }
            fileOutputStream.close();
            inputStream.close();
        }
        catch (IOException iOException) {
            new ESZap("Error reading " + file + " from JAR.");
            return null;
        }
        return file;
    }

    static {
        classlib = new String[]{"Jicasso.class", "AppDoItem.class"};
        buf = new byte[512];
        y = "Until the software is registered, applets will only work for 72 hours after saving";
    }
}

