/*
 * Decompiled with CFR 0.152.
 */
package com.equitysoft.jicasso;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;
import java.io.Serializable;
import java.util.Vector;

class IEButton
extends Component {
    static final int TOOLTIP = 0;
    static final int LABEL_SOUTH = 1;
    static final int LABEL_EAST = 2;
    static final int LABEL_NORTH = 3;
    static final int LABEL_WEST = 4;
    static final int POSITIONS = 5;
    static Font MSG_FONT = new Font("Helvetica", 1, 12);
    static final String EMPTY = "";
    static final int NORMAL = 0;
    static final int HLIGHT = 1;
    static final int DEPRESS = 2;
    static final int RELEASED = 3;
    static final int SIZE = 36;
    static final int DEFAULT_BORDER = 8;
    static Font DEFAULT_FONT = new Font("Helvetica", 1, 12);
    static Frame frame;
    static IEButton currbutton;
    IEBR runner;
    Color back;
    Color fore;
    Color darker;
    int action;
    boolean loaded;
    boolean exited;
    boolean canrun;
    boolean canrepeat;
    int hgt;
    int hless1;
    int wid;
    int wless1;
    int imgxoff;
    int imgyoff;
    int fdesc;
    int textxoff;
    int textyoff;
    Image img;
    transient Image altimg;
    transient Image darkimg;
    TBox txtbox;
    private transient RP rp;
    IEButton handle;
    Vector listeners;
    Vector eelisteners;
    private boolean sliding;
    String text;
    private int border_width;
    private int position;
    private int border;
    boolean prefdimset;
    boolean highlight;
    boolean sticky;
    boolean grayed_out;
    boolean darkened;
    boolean opaque;
    boolean istraversable;
    boolean inverted;
    boolean repeat;
    boolean isdown;
    boolean ingroup;
    long boxwait;
    long interval;
    private int ttpos;
    boolean outline;
    Dimension prefdim;
    Font currft;
    Color background;
    String command;

    public IEButton() {
        this.text = EMPTY;
        this.position = 1;
        this.classInit();
        this.prefdim = new Dimension(36, 36);
    }

    private void classInit() {
        this.handle = this;
        this.enableEvents(16L);
        this.setBackground(Color.white);
        this.ttpos = 1;
        this.loaded = false;
        this.currft = DEFAULT_FONT;
        this.sticky = false;
        this.grayed_out = true;
        this.prefdimset = false;
        this.boxwait = 800L;
        this.border = 8;
        this.opaque = false;
        this.outline = false;
        this.background = Color.lightGray;
        this.border_width = 1;
        this.addListeners();
    }

    private void addListeners() {
        this.addFocusListener(new FA());
        this.addKeyListener(new KA());
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                IEButton.this.loaded = false;
            }
        });
    }

    public IEButton(String string) {
        this(null, string, 2);
    }

    public IEButton(Image image) {
        this(image, null, 0);
    }

    public IEButton(Image image, String string) {
        this(image, string, 1);
    }

    public IEButton(Image image, String string, int n) {
        this.classInit();
        this.img = image;
        this.position = n;
        this.text = string == null ? EMPTY : string;
        n = 1;
        this.createAlt();
        this.calcDim();
    }

    private void createAlt() {
        if (this.img != null) {
            this.altimg = this.getAlternateImage(this.img);
        }
    }

    public Image getAlternateImage(Image image) {
        RGBImageFilter rGBImageFilter = this.inverted ? new IF() : new GOF();
        Image image2 = this.createImage(new FilteredImageSource(image.getSource(), rGBImageFilter));
        this.prepareImage(image2, this);
        return image2;
    }

    public void setGrayOutInverted(boolean bl) {
        this.inverted = bl;
        this.createAlt();
    }

    public void setDownDarkened(boolean bl) {
        this.darkened = bl;
        if (bl) {
            this.darkimg = this.createImage(new FilteredImageSource(this.img.getSource(), new DF()));
            this.prepareImage(this.darkimg, this);
        }
    }

    public void setTooltipPosition(int n) {
        if (n != 3 && n != 1) {
            return;
        }
        this.ttpos = n;
    }

    public void setSlidingTooltip(boolean bl) {
        this.sliding = bl;
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.action = 0;
        this.repaint();
    }

    public boolean isEnabled() {
        return super.isEnabled();
    }

    private void releaseButton() {
        this.isdown = false;
        this.action = 0;
        this.repaint();
    }

    private void calcDim() {
        Serializable serializable;
        this.loaded = false;
        if (!this.prefdimset) {
            int n;
            int n2;
            serializable = this.getFontMetrics(this.currft);
            int n3 = this.border + this.border;
            if (this.img != null) {
                n2 = this.img.getWidth(null) + n3;
                n = this.img.getHeight(null) + n3;
                if (this.position == 1 || this.position == 3) {
                    n = n + ((FontMetrics)serializable).getHeight() + this.border;
                    int n4 = ((FontMetrics)serializable).stringWidth(this.text) + n3;
                    if (n4 > n2) {
                        n2 = n4;
                    }
                } else if (this.position == 2 || this.position == 4) {
                    n2 = ((FontMetrics)serializable).stringWidth(this.text) + n3 + this.border + n2;
                    int n5 = ((FontMetrics)serializable).getHeight() + n3;
                    if (n5 > n) {
                        n = n5;
                    }
                }
            } else if (this.position != 0) {
                n2 = ((FontMetrics)serializable).stringWidth(this.text) + n3 + n3;
                n = ((FontMetrics)serializable).getHeight() + n3;
            } else {
                n2 = 36;
                n = 36;
            }
            this.prefdim = new Dimension(n2, n);
        }
        this.setSize(this.prefdim);
        serializable = this.getParent();
        if (serializable != null) {
            ((Container)serializable).invalidate();
            ((Container)serializable).validate();
        }
    }

    private void setFrame() {
        Container container = this.getParent();
        while (container != null && !(container instanceof Frame)) {
            container = container.getParent();
        }
        if (container != null) {
            frame = (Frame)container;
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        if (!this.loaded) {
            if (this.getParent() == null) {
                return;
            }
            if (this.position == 0 && frame == null) {
                this.setFrame();
            }
            this.fore = this.getForeground();
            this.back = this.opaque ? this.background : this.getParent().getBackground();
            this.darker = this.back.darker();
            Dimension dimension = this.getSize();
            this.wid = dimension.width;
            this.hgt = dimension.height;
            this.wless1 = this.wid - 1;
            this.hless1 = this.hgt - 1;
            if (this.img != null) {
                this.imgxoff = (this.wid - this.img.getWidth(null)) / 2;
                if (this.imgxoff < 0) {
                    this.imgxoff = 0;
                }
            }
            if (this.position != 0) {
                FontMetrics fontMetrics = this.getFontMetrics(this.currft);
                int n = fontMetrics.stringWidth(this.text);
                if (this.position == 1 || this.position == 3) {
                    int n2 = this.img == null ? 0 : this.img.getHeight(null) + this.border;
                    int n3 = (this.hgt - n2 - fontMetrics.getHeight()) / 2;
                    this.textxoff = (this.wid - n) / 2;
                    if (this.position == 1) {
                        this.imgyoff = n3;
                        this.textyoff = this.hgt - n3 - fontMetrics.getDescent();
                    } else {
                        this.imgyoff = n3 + fontMetrics.getHeight() + this.border;
                        this.textyoff = n3 + fontMetrics.getHeight() - fontMetrics.getDescent();
                    }
                } else {
                    if (this.img != null) {
                        int n4 = this.img.getHeight(null);
                        this.imgyoff = n4 >= this.hgt ? 0 : (this.hgt - n4) / 2;
                        this.imgxoff = (this.wid - this.img.getWidth(null) - this.border - n) / 2;
                        if (this.position == 2) {
                            this.textxoff = this.imgxoff + this.img.getWidth(null) + this.border;
                        } else {
                            this.textxoff = this.imgxoff;
                            this.imgxoff = this.textxoff + n + this.border;
                        }
                    } else {
                        this.textxoff = (this.wid - n) / 2;
                    }
                    this.textyoff = (this.hgt - fontMetrics.getHeight()) / 2 + fontMetrics.getHeight() - fontMetrics.getDescent();
                }
            } else if (this.img != null) {
                this.imgyoff = (this.hgt - this.img.getHeight(null)) / 2;
                if (this.imgyoff < 0) {
                    this.imgyoff = 0;
                }
            }
            this.loaded = true;
        }
        if (this.opaque) {
            graphics.setColor(this.back);
            graphics.fillRect(0, 0, this.wid, this.hgt);
        }
        if (this.highlight && this.action == 0 && this.isEnabled()) {
            this.action = 1;
            this.exited = false;
        }
        if (this.sticky && this.isdown) {
            this.action = 2;
        }
        switch (this.action) {
            case 2: {
                if (this.img != null) {
                    graphics.drawImage(this.darkened ? this.darkimg : this.img, this.imgxoff + 1, this.imgyoff + 1, null);
                }
                if (this.position != 0) {
                    graphics.setColor(this.fore);
                    graphics.setFont(this.currft);
                    graphics.drawString(this.text, this.textxoff + 1, this.textyoff + 1);
                }
                this.paintBorder(graphics, this.wid, this.hgt, false, this.back, this.border_width, this.outline, this.fore);
                break;
            }
            case 3: {
                if (this.img != null) {
                    graphics.drawImage(this.img, this.imgxoff, this.imgyoff, null);
                }
                this.drawLabel(graphics);
                this.paintBorder(graphics, this.wid, this.hgt, true, this.back, this.border_width, this.outline, this.fore);
                break;
            }
            case 1: {
                if (!this.exited) {
                    if (this.img != null) {
                        graphics.drawImage(this.img, this.imgxoff, this.imgyoff, null);
                    }
                    this.drawLabel(graphics);
                    this.paintBorder(graphics, this.wid, this.hgt, true, this.back, this.border_width, this.outline, this.fore);
                    break;
                }
            }
            default: {
                if (this.img != null) {
                    if (this.grayed_out) {
                        graphics.drawImage(this.altimg, this.imgxoff, this.imgyoff, null);
                    } else if (!this.isEnabled()) {
                        graphics.drawImage(this.altimg, this.imgxoff, this.imgyoff, null);
                    } else {
                        graphics.drawImage(this.img, this.imgxoff, this.imgyoff, null);
                    }
                }
                this.drawLabel(graphics);
            }
        }
    }

    public void paintBorder(Graphics graphics, int n, int n2, boolean bl, Color color, int n3, boolean bl2, Color color2) {
        if (this.border_width == 0) {
            return;
        }
        int n4 = n - 1;
        int n5 = n2 - 1;
        int n6 = 0;
        int n7 = 0;
        graphics.setColor(color);
        int n8 = 0;
        while (n8 < n3) {
            graphics.draw3DRect(n6++, n7++, n4, n5, bl);
            n4 -= 2;
            n5 -= 2;
            ++n8;
        }
        if (bl2) {
            graphics.setColor(color2);
            graphics.drawRect(0, 0, this.wless1, this.hless1);
        }
    }

    private void drawLabel(Graphics graphics) {
        if (this.position != 0) {
            graphics.setFont(this.currft);
            if (this.isEnabled()) {
                graphics.setColor(this.fore);
                graphics.drawString(this.text, this.textxoff, this.textyoff);
            } else {
                graphics.setColor(Color.white);
                graphics.drawString(this.text, this.textxoff + 1, this.textyoff);
                graphics.setColor(this.darker);
                graphics.drawString(this.text, this.textxoff, this.textyoff);
            }
        }
    }

    public void setTextPosition(int n) {
        if (n >= 0 && n < 5) {
            this.position = n;
            this.calcDim();
        }
    }

    public void setOutlineDrawn(boolean bl) {
        this.outline = bl;
        if (bl && this.border_width == 1) {
            this.border_width = 2;
        }
    }

    public void setSticky(boolean bl) {
        this.sticky = bl;
    }

    public void setInGroup(boolean bl) {
        if (bl) {
            this.setSticky(true);
        }
        this.ingroup = bl;
    }

    public void setImageGrayOutEnabled(boolean bl) {
        this.grayed_out = bl;
    }

    public void setLitup(boolean bl) {
        this.highlight = bl;
        this.action = 0;
        this.repaint();
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.currft = font;
        if (this.position != 0) {
            this.calcDim();
        }
    }

    public void setBorderInset(int n) {
        this.border = n < 0 ? 0 : n;
        if (this.prefdimset) {
            this.loaded = false;
        } else {
            this.calcDim();
        }
    }

    public void setBorderWidth(int n) {
        if (n >= 0) {
            this.border_width = n;
        }
    }

    public void setPreferredSize(Dimension dimension) {
        if (dimension == this.prefdim) {
            return;
        }
        if (dimension == null) {
            this.prefdimset = false;
        } else {
            this.prefdim = dimension;
            this.prefdimset = true;
        }
        this.calcDim();
    }

    public Dimension getPreferredSize() {
        if (this.prefdim == null) {
            return new Dimension(36, 36);
        }
        return this.prefdim;
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public void setText(String string) {
        if (string == null) {
            string = EMPTY;
        } else {
            this.text = string;
        }
        this.loaded = false;
        this.repaint();
    }

    public Color getTextColor() {
        return this.getForeground();
    }

    public void setOpaque(boolean bl) {
        this.opaque = bl;
    }

    public void setButtonBackground(Color color) {
        this.loaded = false;
        this.background = color;
    }

    public void setTooltipBackground(Color color) {
        if (color == null) {
            this.setBackground(Color.white);
        } else {
            this.setBackground(color);
        }
    }

    public void setDepressed(boolean bl) {
        if (this.sticky) {
            if (bl && !this.isdown) {
                this.isdown = true;
                this.action = 2;
                this.repaint();
                if (this.ingroup && currbutton != this) {
                    if (currbutton != null) {
                        currbutton.releaseButton();
                    }
                    currbutton = this;
                }
            } else if (this.isdown) {
                this.releaseButton();
                if (this.ingroup) {
                    currbutton = null;
                }
            }
        }
    }

    public boolean isDepressed() {
        return this.isdown;
    }

    public static IEButton getDepressedButton() {
        return currbutton;
    }

    public void setTooltipTimeDelay(long l) {
        this.boxwait = l;
    }

    public void setActionCommand(String string) {
        this.command = string;
    }

    public synchronized void addActionListener(ActionListener actionListener) {
        if (this.listeners == null) {
            this.listeners = new Vector(1);
        }
        this.listeners.addElement(actionListener);
    }

    public boolean isFocusTraversable() {
        return this.istraversable;
    }

    public void setFocusTraversable(boolean bl) {
        this.istraversable = bl;
    }

    public void setRepeat(boolean bl) {
        this.repeat = bl;
        this.interval = 60L;
    }

    public void setRepeatInterval(long l) {
        this.interval = l;
    }

    public void fireAction() {
        Vector vector;
        if (this.listeners == null) {
            return;
        }
        IEButton iEButton = this;
        synchronized (iEButton) {
            vector = (Vector)this.listeners.clone();
        }
        ActionEvent actionEvent = new ActionEvent(this, 0, this.command == null ? this.text : this.command);
        int n = 0;
        while (n < vector.size()) {
            ActionListener actionListener = (ActionListener)vector.elementAt(n);
            actionListener.actionPerformed(actionEvent);
            ++n;
        }
    }

    public void processMouseEvent(MouseEvent mouseEvent) {
        switch (mouseEvent.getID()) {
            case 504: {
                if (!this.isEnabled()) {
                    return;
                }
                if (currbutton == this.handle) {
                    return;
                }
                this.exited = false;
                if (!this.highlight) {
                    this.action = 1;
                    this.repaint();
                }
                if (this.position != 0 || this.text.equals(EMPTY) || this.runner != null) break;
                this.runner = new IEBR();
                this.canrun = true;
                this.runner.start();
                break;
            }
            case 505: {
                if (!this.isEnabled()) {
                    return;
                }
                if (currbutton == this.handle) {
                    return;
                }
                this.exited = true;
                IEButton iEButton = this.handle;
                synchronized (iEButton) {
                    this.canrun = false;
                    if (this.txtbox != null) {
                        ((Component)this.txtbox).setVisible(false);
                        this.txtbox = null;
                    }
                }
                this.action = 0;
                this.repaint();
                break;
            }
            case 501: {
                if (!this.isEnabled()) {
                    return;
                }
                IEButton iEButton = this.handle;
                synchronized (iEButton) {
                    this.canrun = false;
                    if (this.txtbox != null) {
                        ((Component)this.txtbox).setVisible(false);
                        this.txtbox = null;
                    }
                }
                if (this.repeat && currbutton != this.handle && this.rp == null) {
                    this.canrepeat = true;
                    this.rp = new RP();
                    this.rp.start();
                }
                if (this.sticky) {
                    if (!this.isdown) {
                        this.isdown = true;
                        this.fireAction();
                        if (this.ingroup && currbutton != this.handle) {
                            if (currbutton != null) {
                                currbutton.releaseButton();
                            }
                            currbutton = this.handle;
                        }
                    } else {
                        this.isdown = false;
                        this.canrepeat = false;
                        if (this.ingroup) {
                            currbutton = null;
                        }
                        return;
                    }
                }
                this.action = 2;
                this.repaint();
                if (!this.repeat || this.rp != null) break;
                this.canrepeat = true;
                this.rp = new RP();
                this.rp.start();
                break;
            }
            case 502: {
                if (!this.isEnabled()) {
                    return;
                }
                if (!this.sticky) {
                    this.canrepeat = false;
                    if (!this.contains(mouseEvent.getX(), mouseEvent.getY())) break;
                    this.action = 1;
                    this.repaint();
                    this.fireAction();
                    break;
                }
                if (this.ingroup) {
                    if (currbutton != null) break;
                    this.action = 1;
                    this.repaint();
                    this.fireAction();
                    break;
                }
                if (this.isdown) break;
                this.action = 1;
                this.repaint();
                this.fireAction();
            }
        }
    }

    class DF
    extends RGBImageFilter {
        public DF() {
            this.canFilterIndexColorModel = true;
        }

        public int filterRGB(int n, int n2, int n3) {
            return n3 & 0xFFAFAFAF;
        }
    }

    class IF
    extends RGBImageFilter {
        public IF() {
            this.canFilterIndexColorModel = true;
        }

        public int filterRGB(int n, int n2, int n3) {
            return n3 ^ 0xFFFFFF;
        }
    }

    private class GOF
    extends RGBImageFilter {
        public GOF() {
            this.canFilterIndexColorModel = true;
        }

        public int filterRGB(int n, int n2, int n3) {
            int n4 = (n3 & 0xFF0000) >> 16;
            int n5 = (n3 & 0xFF00) >> 8;
            int n6 = n3 & 0xFF;
            n4 = (n4 + n5 + n6) / 3;
            return -16777216 + (n4 << 16) + (n4 << 8) + n4;
        }
    }

    private class TBox
    extends Window {
        TBox() {
            super(frame);
            ((Component)this).setBackground(IEButton.this.handle.getBackground());
            this.setLayout(new BorderLayout());
            Label label = new Label(IEButton.this.text, 1);
            label.setFont(IEButton.this.currft);
            label.setForeground(IEButton.this.fore);
            this.add((Component)label, "Center");
            this.pack();
            this.setLayout(null);
        }

        public void paint(Graphics graphics) {
            Dimension dimension = this.getSize();
            if (!IEButton.this.canrun) {
                return;
            }
            graphics.drawRect(0, 0, dimension.width - 1, dimension.height - 1);
        }

        public Insets getInsets() {
            return new Insets(1, 1, 1, 1);
        }
    }

    class IEBR
    extends Thread {
        IEBR() {
        }

        public void run() {
            Point point;
            int n;
            Dimension dimension;
            if (!IEButton.this.canrun) {
                IEButton.this.runner = null;
                return;
            }
            try {
                Thread.sleep(IEButton.this.boxwait);
            }
            catch (InterruptedException interruptedException) {
                IEButton.this.runner = null;
                return;
            }
            int n2 = 0;
            IEButton iEButton = IEButton.this.handle;
            synchronized (iEButton) {
                if (!IEButton.this.canrun || frame == null) {
                    IEButton.this.runner = null;
                    return;
                }
                IEButton.this.txtbox = new TBox();
                dimension = IEButton.this.txtbox.getSize();
                n = dimension.height;
                point = IEButton.this.handle.getLocationOnScreen();
                if (!IEButton.this.sliding) {
                    if (IEButton.this.ttpos == 1) {
                        ((Component)IEButton.this.txtbox).setLocation(point.x, point.y + IEButton.this.handle.getSize().height + 1);
                    } else {
                        ((Component)IEButton.this.txtbox).setLocation(point.x, point.y - dimension.height - 1);
                    }
                    ((Component)IEButton.this.txtbox).setVisible(true);
                    IEButton.this.runner = null;
                    return;
                }
                n2 = point.y + IEButton.this.handle.getSize().height + 1;
                if (IEButton.this.ttpos == 1) {
                    ((Component)IEButton.this.txtbox).setLocation(point.x, n2);
                } else {
                    ((Component)IEButton.this.txtbox).setLocation(point.x, point.y - 1);
                }
                ((Component)IEButton.this.txtbox).setSize(1, 1);
                ((Component)IEButton.this.txtbox).setVisible(true);
                n2 += n;
            }
            int n3 = 2;
            while (n3 <= n) {
                try {
                    Thread.sleep(5L);
                }
                catch (InterruptedException interruptedException) {
                    break;
                }
                IEButton iEButton2 = IEButton.this.handle;
                synchronized (iEButton2) {
                    if (!IEButton.this.canrun || IEButton.this.txtbox == null) {
                        break;
                    }
                    if (IEButton.this.ttpos == 1) {
                        ((Component)IEButton.this.txtbox).setBounds(point.x, n2 - n3, dimension.width, n3);
                    } else {
                        ((Component)IEButton.this.txtbox).setBounds(point.x, point.y - n3, dimension.width, n3);
                    }
                }
                ++n3;
            }
            IEButton.this.runner = null;
        }
    }

    class RP
    extends Thread {
        RP() {
        }

        public void run() {
            if (IEButton.this.interval < 5L) {
                IEButton.this.interval = 5L;
            }
            try {
                Thread.sleep(300L);
            }
            catch (InterruptedException interruptedException) {}
            while (IEButton.this.canrepeat) {
                try {
                    Thread.sleep(IEButton.this.interval);
                }
                catch (InterruptedException interruptedException) {
                    break;
                }
                if (!IEButton.this.canrepeat) continue;
                IEButton.this.fireAction();
            }
            IEButton.this.rp = null;
        }
    }

    private class KA
    extends KeyAdapter {
        boolean down;

        private KA() {
        }

        public void keyTyped(KeyEvent keyEvent) {
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (IEButton.this.istraversable && !this.down && (keyEvent.getKeyCode() == 10 || keyEvent.getKeyCode() == 32)) {
                this.down = true;
                IEButton.this.action = 2;
                IEButton.this.handle.repaint();
            }
        }

        public void keyReleased(KeyEvent keyEvent) {
            if (IEButton.this.istraversable && (keyEvent.getKeyCode() == 10 || keyEvent.getKeyCode() == 32)) {
                this.down = false;
                IEButton.this.fireAction();
                IEButton.this.action = 3;
                IEButton.this.handle.repaint();
            }
        }
    }

    private class FA
    extends FocusAdapter {
        private FA() {
        }

        public void focusGained(FocusEvent focusEvent) {
            if (IEButton.this.istraversable) {
                IEButton.this.exited = false;
                IEButton.this.action = 1;
                IEButton.this.handle.repaint();
            }
        }

        public void focusLost(FocusEvent focusEvent) {
            if (IEButton.this.istraversable) {
                IEButton.this.exited = true;
                IEButton.this.action = 0;
                IEButton.this.handle.repaint();
            }
        }
    }
}

