/*
 * Decompiled with CFR 0.152.
 */
package com.equitysoft.jicasso;

import com.equitysoft.jicasso.Bar;
import com.equitysoft.jicasso.CompType;
import com.equitysoft.jicasso.DataUtils;
import com.equitysoft.jicasso.ESZap;
import com.equitysoft.jicasso.Jicasso;
import com.equitysoft.jicasso.LightBox;
import com.equitysoft.jicasso.LightsMenu;
import com.equitysoft.jicasso.MainPanel;
import com.equitysoft.jicasso.PressPanel;
import com.equitysoft.jicasso.Props;
import com.equitysoft.jicasso.Props2Menu;
import com.equitysoft.jicasso.PropsMenu;
import com.equitysoft.jicasso.Status;
import com.equitysoft.jicasso.ToolBar;
import com.sun.j3d.utils.behaviors.picking.PickObject;
import com.sun.j3d.utils.behaviors.picking.PickRotateBehavior;
import com.sun.j3d.utils.behaviors.picking.PickTranslateBehavior;
import com.sun.j3d.utils.behaviors.picking.PickZoomBehavior;
import com.sun.j3d.utils.universe.SimpleUniverse;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.Point;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Vector;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.Node;
import javax.media.j3d.SceneGraphPath;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.swing.JDialog;

public class Grid
extends JDialog
implements WindowListener,
ComponentListener,
Props {
    static StringBuffer sb = new StringBuffer(60);
    static Grid handle;
    static MainPanel canvas;
    static BoundingSphere bounds;
    static BranchGroup bg;
    static TransformGroup tg;
    static Vector widgets;
    static PickObject po;
    static int current;
    static float scale;

    Grid() {
        super(Bar.handle, "", false);
        handle = this;
        widgets = new Vector();
        current = -1;
        this.getContentPane().setLayout(new BorderLayout());
        bounds = DataUtils.bnds;
        GraphicsConfiguration graphicsConfiguration = SimpleUniverse.getPreferredConfiguration();
        canvas = new MainPanel(graphicsConfiguration);
        this.getContentPane().add((Component)((Object)canvas));
        SimpleUniverse simpleUniverse = new SimpleUniverse((Canvas3D)canvas);
        simpleUniverse.getViewingPlatform().setNominalViewingTransform();
        bg = new BranchGroup();
        bg.setCapability(14);
        bg.setCapability(13);
        tg = new TransformGroup();
        Transform3D transform3D = new Transform3D();
        transform3D.setScale((double)scale);
        tg.setTransform(transform3D);
        bg.addChild((Node)tg);
        po = new PickObject((Canvas3D)canvas, bg);
        tg.setCapability(18);
        tg.setCapability(17);
        tg.setCapability(14);
        tg.setCapability(13);
        PickRotateBehavior pickRotateBehavior = new PickRotateBehavior(bg, (Canvas3D)canvas, (Bounds)bounds, 256);
        tg.addChild((Node)pickRotateBehavior);
        PickZoomBehavior pickZoomBehavior = new PickZoomBehavior(bg, (Canvas3D)canvas, (Bounds)bounds, 256);
        tg.addChild((Node)pickZoomBehavior);
        PickTranslateBehavior pickTranslateBehavior = new PickTranslateBehavior(bg, (Canvas3D)canvas, (Bounds)bounds, 256);
        tg.addChild((Node)pickTranslateBehavior);
        simpleUniverse.addBranchGraph(bg);
        this.addWindowListener(this);
        this.addComponentListener(this);
    }

    static CompType getCurrent() {
        if (current < 0) {
            return null;
        }
        return (CompType)widgets.elementAt(current);
    }

    static void addObject(Object object, boolean bl) {
        CompType compType = (CompType)object;
        compType.addTo(tg);
        int n = widgets.size();
        compType.setProp(7, new Integer(n));
        widgets.addElement(object);
        if (bl) {
            current = n;
            Grid.setCurrent();
            Status.setComponent(compType);
        }
    }

    static void replaceComp(int n, CompType compType) {
        if (widgets.size() <= n) {
            widgets.addElement(compType);
        } else {
            widgets.setElementAt(compType, n);
        }
        compType.addTo(tg);
    }

    static void deleteCurrent() {
        if (current < 0) {
            new ESZap("No object currently selected");
            return;
        }
        Object e = widgets.elementAt(current);
        if (e == null) {
            return;
        }
        CompType compType = (CompType)e;
        compType.detachIt();
        widgets.setElementAt(null, current);
        Grid.deselect();
        System.gc();
    }

    static void deleteAll() {
        int n = widgets.size();
        if (n == 0) {
            return;
        }
        int n2 = 0;
        while (n2 < n) {
            Object e = widgets.elementAt(n2);
            if (e != null) {
                CompType compType = (CompType)e;
                compType.detachIt();
            }
            ++n2;
        }
        widgets.removeAllElements();
        Grid.deselect();
        System.gc();
    }

    static void pickWidget(int n, int n2) {
        ToolBar.hideMenu();
        SceneGraphPath sceneGraphPath = po.pickClosest(n, n2);
        if (sceneGraphPath == null) {
            Grid.deselect();
            Status.setOrig();
            return;
        }
        Node node = sceneGraphPath.getNode(0);
        if (node instanceof CompType) {
            CompType compType = (CompType)node;
            Integer n3 = (Integer)compType.getProp(7);
            int n4 = n3;
            if (n4 == current) {
                return;
            }
            current = n4;
            Grid.setCurrent();
            Status.setComponent(compType);
            System.gc();
        } else if (node instanceof LightBox) {
            LightsMenu.selected((LightBox)node);
        }
    }

    static void setCurrent() {
        ToolBar.setOn();
        PropsMenu.set();
        Props2Menu.set();
        PressPanel.off();
    }

    static void deselect() {
        current = -1;
        ToolBar.setOff();
        PressPanel.off();
        Status.setOrig();
    }

    static void setDimension(Dimension dimension) {
        ((Component)((Object)canvas)).setSize(dimension);
        MainPanel.prefdim = dimension;
        handle.pack();
        Grid.checkSize();
        MainPanel.prefdim = null;
        handle.repaint();
    }

    static void checkSize() {
        Point point = handle.getLocation();
        Dimension dimension = handle.getSize();
        boolean bl = false;
        if (point.y + dimension.height > Jicasso.screendim.height) {
            dimension.height = Jicasso.screendim.height - point.y;
            bl = true;
        }
        if (point.x + dimension.width > Jicasso.screendim.width) {
            dimension.width = Jicasso.screendim.width - point.x;
            bl = true;
        }
        if (bl) {
            ((Component)handle).setSize(dimension);
            handle.invalidate();
            handle.validate();
        }
    }

    static void setOrig() {
        Dimension dimension = canvas.getSize();
        sb.setLength(0);
        sb.append("Wid: ").append(dimension.width).append(" x Hgt: ").append(dimension.height);
        handle.setTitle(sb.toString());
    }

    static void setPos(int n, int n2) {
        sb.setLength(0);
        sb.append("X: ").append(n + 1).append("  Y: ").append(n2 + 1);
        handle.setTitle(sb.toString());
    }

    static void setPos(int n, int n2, int n3, int n4) {
        sb.setLength(0);
        sb.append(" X: ").append(n).append(" Y: ").append(n2).append("  Wid: ");
        sb.append(n3).append(" Hgt: ").append(n4);
        handle.setTitle(sb.toString());
    }

    public void componentResized(ComponentEvent componentEvent) {
        this.invalidate();
        this.validate();
        Grid.setOrig();
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        Jicasso.closeIt();
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    static {
        scale = 0.2f;
    }
}

