/*
 * Decompiled with CFR 0.152.
 */
package com.equitysoft.jicasso;

import com.equitysoft.jicasso.APLib;
import com.equitysoft.jicasso.Bar;
import com.equitysoft.jicasso.DataUtils;
import com.equitysoft.jicasso.ESUtils;
import com.equitysoft.jicasso.Grid;
import com.equitysoft.jicasso.PercentAdjust;
import com.equitysoft.jicasso.Props;
import com.equitysoft.jicasso.Settable;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.ExponentialFog;
import javax.media.j3d.Node;
import javax.swing.JColorChooser;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.vecmath.Color3f;

class FogColor
extends JMenu
implements ActionListener,
Settable,
Props {
    String CUSTOM = "Add exponential fog";
    String REMOVE = "Remove fog";
    static FogColor handle;
    static BranchGroup bg;
    static PercentAdjust pa;
    static ExponentialFog ef;
    static Color fog;
    static int density;
    static JMenuItem rem;

    FogColor() {
        super("Fog");
        handle = this;
        this.add(ESUtils.getMI(this.CUSTOM, this));
        pa = new PercentAdjust(19, "Density", this);
        this.add(pa);
        pa.setEnabled(false);
        rem = ESUtils.getMI(this.REMOVE, this);
        this.add(rem);
        rem.setEnabled(false);
    }

    static void writeFog(DataOutputStream dataOutputStream) throws IOException {
        if (bg == null) {
            dataOutputStream.writeInt(0);
        } else {
            dataOutputStream.writeInt(fog.getRGB());
            dataOutputStream.writeInt(density);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object var2_2 = null;
        String string = actionEvent.getActionCommand();
        if (string == this.REMOVE) {
            FogColor.removeIt();
        } else if (string == this.CUSTOM) {
            Color color = JColorChooser.showDialog(Grid.handle, this.CUSTOM, fog);
            Bar.handle.repaint();
            if (color == null) {
                return;
            }
            FogColor.addFog(color);
        }
    }

    static void addFog(Color color) {
        rem.setEnabled(true);
        fog = color;
        Color3f color3f = APLib.getColor(color);
        if (bg != null) {
            bg.detach();
        }
        ef = new ExponentialFog(color3f);
        ef.setCapability(17);
        ef.setInfluencingBounds((Bounds)DataUtils.bnds);
        bg = new BranchGroup();
        bg.setCapability(17);
        bg.addChild((Node)ef);
        Grid.bg.addChild((Node)bg);
        pa.setEnabled(true);
    }

    static void removeIt() {
        if (bg != null) {
            bg.detach();
            bg = null;
            ef = null;
        }
        pa.setEnabled(false);
        rem.setEnabled(false);
    }

    public Object getProp(int n) {
        switch (n) {
            case 19: {
                return new Integer(density);
            }
        }
        return null;
    }

    public void setProp(int n, Object object) {
        switch (n) {
            case 19: {
                Integer n2 = (Integer)object;
                density = n2;
                if (density == 0) {
                    ef.setDensity(0.0f);
                    break;
                }
                ef.setDensity((float)density / 100.0f);
            }
        }
    }

    static {
        fog = Color.black;
        density = 100;
    }
}

