/*
 * Decompiled with CFR 0.152.
 */
package com.equitysoft.jicasso;

import com.equitysoft.jicasso.ESUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;
import javax.swing.JButton;
import javax.swing.Timer;

public class FlashButton
extends JButton
implements ActionListener {
    static RGBImageFilter filter;
    Timer timer;
    Dimension prefdim;
    boolean up;
    boolean entered;
    boolean repeat;
    Image img;
    Image alt;
    boolean loaded;
    int x;
    int y;

    public FlashButton(Image image, String string, Dimension dimension, ActionListener actionListener, String string2) {
        if (filter == null) {
            filter = new GOF();
        }
        this.enableEvents(16L);
        this.img = image;
        this.alt = this.getAlternateImage(image);
        this.prefdim = dimension;
        this.setPreferredSize(dimension);
        if (string != null) {
            this.setToolTipText(string);
        }
        this.addActionListener(actionListener);
        if (string2 != null) {
            this.setActionCommand(string2);
        }
        this.setBorderPainted(false);
    }

    void setRepeat(boolean bl) {
        this.repeat = bl;
    }

    Image getAlternateImage(Image image) {
        Image image2 = this.createImage(new FilteredImageSource(image.getSource(), filter));
        this.prepareImage(image2, this);
        return ESUtils.loadImage(image2);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.up) {
            return;
        }
        this.doClick();
        if (this.timer.getDelay() == 300) {
            this.timer.setDelay(30);
        }
        this.timer.start();
    }

    public void paintComponent(Graphics graphics) {
        if (this.img == null) {
            return;
        }
        if (!this.loaded) {
            this.x = (this.prefdim.width - this.img.getWidth(null)) / 2;
            this.y = (this.prefdim.height - this.img.getHeight(null)) / 2;
            this.loaded = true;
        }
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, this.prefdim.width, this.prefdim.height);
        if (!this.isEnabled()) {
            graphics.drawImage(this.alt, this.x, this.y, null);
        } else if (this.up) {
            graphics.drawImage(this.img, this.x, this.y, null);
        } else {
            graphics.drawImage(this.img, this.x + 1, this.y + 1, null);
        }
        if (this.entered) {
            graphics.setColor(Color.black);
            graphics.drawRect(0, 0, this.prefdim.width - 1, this.prefdim.height - 1);
            graphics.setColor(Color.lightGray);
            graphics.draw3DRect(1, 1, this.prefdim.width - 3, this.prefdim.height - 3, this.up);
        }
    }

    public void processMouseEvent(MouseEvent mouseEvent) {
        if (!this.isEnabled()) {
            return;
        }
        switch (mouseEvent.getID()) {
            case 504: {
                this.up = true;
                this.entered = true;
                this.repaint();
                break;
            }
            case 505: {
                this.up = true;
                this.repaint();
                this.entered = false;
                break;
            }
            case 501: {
                this.up = false;
                this.repaint();
                if (!this.repeat) break;
                if (this.timer == null) {
                    this.timer = new Timer(300, this);
                } else {
                    this.timer.setDelay(300);
                }
                this.timer.setRepeats(false);
                this.timer.start();
                break;
            }
            case 502: {
                this.up = true;
                this.repaint();
                if (this.contains(mouseEvent.getX(), mouseEvent.getY())) break;
                return;
            }
        }
        super.processMouseEvent(mouseEvent);
    }

    private class GOF
    extends RGBImageFilter {
        public GOF() {
            this.canFilterIndexColorModel = true;
        }

        public int filterRGB(int n, int n2, int n3) {
            int n4 = (n3 & 0xFF0000) >> 16;
            int n5 = (n3 & 0xFF00) >> 8;
            int n6 = n3 & 0xFF;
            n4 = (n4 + n5 + n6) / 3;
            return -16777216 + (n4 << 16) + (n4 << 8) + n4;
        }
    }
}

