/*
 * Decompiled with CFR 0.152.
 */
package com.equitysoft.jicasso;

import com.equitysoft.jicasso.Bar;
import com.equitysoft.jicasso.ESZap;
import com.equitysoft.jicasso.FlashButton;
import com.equitysoft.jicasso.LayoutFile;
import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGImageDecoder;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.StringTokenizer;
import javax.swing.JMenuItem;

class ESUtils {
    static Dimension DIM = new Dimension(30, 30);
    static Font MSG_FONT = new Font("dialog", 1, 12);
    static String PRODUCT = " Jicasso Beta 3";
    static MediaTracker tracker;
    static Class cls;

    ESUtils() {
    }

    static JMenuItem getMI(String string, ActionListener actionListener) {
        JMenuItem jMenuItem = new JMenuItem(string);
        jMenuItem.addActionListener(actionListener);
        return jMenuItem;
    }

    static FlashButton getButton(String string, ActionListener actionListener) {
        FlashButton flashButton = new FlashButton(ESUtils.getSystemImage(string), null, DIM, actionListener, null);
        flashButton.setRepeat(true);
        flashButton.setEnabled(false);
        return flashButton;
    }

    static int getArrayPos(String[] stringArray, String string) {
        int n = stringArray.length;
        int n2 = 0;
        n2 = 0;
        while (n2 < n) {
            if (string.equals(stringArray[n2])) break;
            ++n2;
        }
        if (n2 == n) {
            return -1;
        }
        return n2;
    }

    static int getArrayPos(int[] nArray, Integer n) {
        int n2 = nArray.length;
        int n3 = 0;
        int n4 = n;
        n3 = 0;
        while (n3 < n2) {
            if (n4 == nArray[n3]) break;
            ++n3;
        }
        if (n3 == n2) {
            return -1;
        }
        return n3;
    }

    static boolean saveStringAsFile(String string, File file) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\r\n");
        if (file.exists()) {
            file.delete();
        }
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                bufferedWriter.write(string2, 0, string2.length());
                bufferedWriter.write("\r\n", 0, 2);
            }
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            new ESZap("Error writing file " + file.getName());
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static String getSystemFileAsString(String string) {
        if (cls == null) {
            cls = Bar.handle.getClass();
        }
        int n = 256;
        byte[] byArray = new byte[1];
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n);
        byte by = 13;
        try {
            InputStream inputStream = cls.getResourceAsStream(string);
            if (inputStream == null) {
                return null;
            }
            while (true) {
                if (inputStream.read(byArray, 0, 1) <= -1) {
                    inputStream.close();
                    return byteArrayOutputStream.toString();
                }
                if (byArray[0] == by) continue;
                byteArrayOutputStream.write(byArray, 0, 1);
            }
        }
        catch (IOException iOException) {
            return null;
        }
    }

    static String getFileAsString(File file) {
        if (!file.exists()) {
            return null;
        }
        int n = (int)file.length();
        byte[] byArray = new byte[n];
        try {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
            bufferedInputStream.read(byArray, 0, n);
            bufferedInputStream.close();
        }
        catch (IOException iOException) {
            return null;
        }
        return new String(byArray, 0, n);
    }

    static URL getESURL(String string) {
        URL uRL;
        if (cls == null) {
            cls = Bar.handle.getClass();
        }
        if ((uRL = cls.getResource("images/" + string)) == null) {
            return null;
        }
        return uRL;
    }

    static Image getSystemImage(String string) {
        return ESUtils.loadImage(Toolkit.getDefaultToolkit().getImage(ESUtils.getESURL(string)));
    }

    static BufferedImage getBufferedImage(File file) {
        if (!file.exists()) {
            return null;
        }
        String string = file.getName();
        BufferedImage bufferedImage = null;
        if (string.endsWith(".jpg") || string.endsWith(".JPG")) {
            try {
                FileInputStream fileInputStream = new FileInputStream(file);
                JPEGImageDecoder jPEGImageDecoder = JPEGCodec.createJPEGDecoder((InputStream)fileInputStream);
                bufferedImage = jPEGImageDecoder.decodeAsBufferedImage();
                fileInputStream.close();
            }
            catch (Exception exception) {
                new ESZap("Error reading the JPEG file.");
                return null;
            }
        } else {
            Image image = ESUtils.getImage(file);
            bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 1);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.drawImage(image, 0, 0, null);
        }
        return bufferedImage;
    }

    static Image getImage(File file) {
        return ESUtils.loadImage(Toolkit.getDefaultToolkit().getImage(file.getAbsolutePath()));
    }

    static Image loadImage(Image image) {
        try {
            if (tracker == null) {
                tracker = new MediaTracker(Bar.handle);
            }
            tracker.addImage(image, 0);
            tracker.waitForID(0);
        }
        catch (Exception exception) {
            return null;
        }
        if (image.getWidth(null) <= 0) {
            return null;
        }
        return image;
    }

    static void copyFile(File file, File file2) {
        byte[] byArray = LayoutFile.buf;
        try {
            int n;
            FileInputStream fileInputStream = new FileInputStream(file);
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            while ((n = fileInputStream.read(byArray)) > 0) {
                fileOutputStream.write(byArray, 0, n);
            }
            fileInputStream.close();
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            new ESZap("Error " + iOException.getMessage() + " copying files");
        }
    }

    static void textBubbleSort(String[] stringArray, int n) {
        int n2 = n - 1;
        boolean bl = false;
        while (true) {
            int n3 = 0;
            while (n3 < n2) {
                int n4 = n3 + 1;
                if (stringArray[n3].compareTo(stringArray[n4]) > 0) {
                    String string = stringArray[n4];
                    stringArray[n4] = stringArray[n3];
                    stringArray[n3] = string;
                    bl = true;
                }
                ++n3;
            }
            if (!bl) break;
            bl = false;
            --n2;
        }
    }
}

