/*
 * Decompiled with CFR 0.152.
 */
package com.equitysoft.jicasso;

import com.equitysoft.jicasso.AppSpec;
import com.equitysoft.jicasso.ESQ;
import com.equitysoft.jicasso.ESUtils;
import com.equitysoft.jicasso.ESZap;
import com.equitysoft.jicasso.Grid;
import com.equitysoft.jicasso.LayoutFile;
import com.equitysoft.jicasso.ToolBar;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JPopupMenu;

class DeleteMenu
extends JPopupMenu
implements ActionListener {
    String DELETE_COMP = "Remove current component";
    String DELETE_ALL = "Remove all components in layout";
    String DELETE_FILES = "Delete saved layout file";
    static DeleteMenu handle;

    DeleteMenu() {
        handle = this;
        this.add(ESUtils.getMI(this.DELETE_COMP, this));
        this.add(ESUtils.getMI(this.DELETE_ALL, this));
        this.addSeparator();
        this.add(ESUtils.getMI(this.DELETE_FILES, this));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        ToolBar.setOff();
        if (string == this.DELETE_COMP) {
            Grid.deleteCurrent();
        } else if (string == this.DELETE_ALL) {
            Grid.deleteAll();
        } else if (string == this.DELETE_FILES) {
            if (LayoutFile.currappspec == null) {
                new ESZap("First open the HTML file to delete.");
                return;
            }
            AppSpec appSpec = LayoutFile.currappspec;
            if (!ESQ.ask("Do you want to delete the file '" + appSpec.file.getName() + "' ?", "Delete", "Cancel")) {
                return;
            }
            File file = new File(appSpec.file.getParent(), appSpec.name + ".jar");
            if (file.exists()) {
                file.delete();
            }
            if (appSpec.file.exists()) {
                appSpec.file.delete();
            }
            ToolBar.newLayout();
        }
    }
}

