/*
 * Decompiled with CFR 0.152.
 */
package com.equitysoft.jicasso;

import com.equitysoft.jicasso.AmbientColor;
import com.equitysoft.jicasso.BackgroundMenu;
import com.equitysoft.jicasso.CompType;
import com.equitysoft.jicasso.ESUtils;
import com.equitysoft.jicasso.ESZap;
import com.equitysoft.jicasso.FogColor;
import com.equitysoft.jicasso.Grid;
import com.equitysoft.jicasso.LightBox;
import com.equitysoft.jicasso.LightsMenu;
import com.equitysoft.jicasso.MainPanel;
import com.equitysoft.jicasso.OptionsMenu;
import com.equitysoft.jicasso.Props;
import com.equitysoft.jicasso.ScreenColor;
import com.sun.j3d.utils.behaviors.keyboard.KeyNavigatorBehavior;
import com.sun.j3d.utils.geometry.Box;
import com.sun.j3d.utils.geometry.Cone;
import com.sun.j3d.utils.geometry.Cylinder;
import com.sun.j3d.utils.geometry.Sphere;
import com.sun.j3d.utils.geometry.Text2D;
import com.sun.j3d.utils.image.TextureLoader;
import com.sun.j3d.utils.universe.SimpleUniverse;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.Vector;
import javax.media.j3d.Alpha;
import javax.media.j3d.AmbientLight;
import javax.media.j3d.Appearance;
import javax.media.j3d.Background;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.DirectionalLight;
import javax.media.j3d.ExponentialFog;
import javax.media.j3d.Font3D;
import javax.media.j3d.FontExtrusion;
import javax.media.j3d.Geometry;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.media.j3d.PointLight;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.RotationInterpolator;
import javax.media.j3d.Shape3D;
import javax.media.j3d.SpotLight;
import javax.media.j3d.TexCoordGeneration;
import javax.media.j3d.Text3D;
import javax.media.j3d.Texture;
import javax.media.j3d.TextureAttributes;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.TransparencyAttributes;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;

public class DataUtils
implements Props {
    static final int[] TEXTURES = new int[]{2, 4, 5, 3};
    static BoundingSphere bnds = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), Double.MAX_VALUE);
    static Vector files;

    static void replaceCurrent(CompType compType) {
        compType.detachIt();
        Integer n = (Integer)compType.getProp(7);
        int n2 = n;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            compType.writeObj(dataOutputStream);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
            Object var8_9 = null;
            var8_9 = Class.forName("com.equitysoft.jicasso." + dataInputStream.readUTF()).newInstance();
            CompType compType2 = var8_9;
            compType2.setProp(22, dataInputStream.readUTF());
            dataInputStream.readInt();
            compType2.readObj(dataInputStream);
            Grid.replaceComp(n2, compType2);
            compType2.setProp(7, new Integer(n2));
        }
        catch (Exception exception) {
            new ESZap("Error changing component " + exception.getMessage());
        }
        System.gc();
    }

    static void writeAll(DataOutputStream dataOutputStream) throws IOException {
        Object e;
        if (files == null) {
            files = new Vector();
        } else {
            files.removeAllElements();
        }
        Dimension dimension = ((Component)((Object)MainPanel.handle)).getSize();
        dataOutputStream.writeInt(dimension.width);
        dataOutputStream.writeInt(dimension.height);
        dataOutputStream.writeFloat(Grid.scale);
        dataOutputStream.writeInt(OptionsMenu.navigation.getState());
        ScreenColor.writeBackground(dataOutputStream);
        int n = BackgroundMenu.image.getState();
        dataOutputStream.writeInt(n);
        if (n != 0) {
            dataOutputStream.writeUTF(BackgroundMenu.path.getAbsolutePath());
            files.addElement(BackgroundMenu.path);
        }
        AmbientColor.writeAmbient(dataOutputStream);
        FogColor.writeFog(dataOutputStream);
        int n2 = 0;
        if (LightsMenu.direct != null) {
            ++n2;
        }
        n2 += LightsMenu.getPcount();
        dataOutputStream.writeInt(n2 += LightsMenu.getScount());
        if (LightsMenu.direct != null) {
            LightsMenu.direct.writeLightBox(dataOutputStream);
        }
        int n3 = LightsMenu.plights.size();
        int n4 = 0;
        while (n4 < n3) {
            e = LightsMenu.plights.elementAt(n4);
            if (e != null) {
                ((LightBox)((Object)e)).writeLightBox(dataOutputStream);
            }
            ++n4;
        }
        n3 = LightsMenu.slights.size();
        int n5 = 0;
        while (n5 < n3) {
            e = LightsMenu.slights.elementAt(n5);
            if (e != null) {
                ((LightBox)((Object)e)).writeLightBox(dataOutputStream);
            }
            ++n5;
        }
        Vector vector = Grid.widgets;
        int n6 = vector.size();
        int n7 = 0;
        int n8 = 0;
        while (n8 < n6) {
            Object e2 = vector.elementAt(n8);
            if (e2 != null) {
                ++n7;
            }
            ++n8;
        }
        dataOutputStream.writeInt(n7);
        int n9 = 0;
        while (n9 < n6) {
            Object e3 = vector.elementAt(n9);
            if (e3 != null) {
                CompType compType = (CompType)e3;
                compType.writeObj(dataOutputStream);
                compType.setProp(26, files);
            }
            ++n9;
        }
    }

    static Canvas3D getCanvas(DataInputStream dataInputStream, Dimension dimension) throws IOException {
        GraphicsConfiguration graphicsConfiguration = SimpleUniverse.getPreferredConfiguration();
        Canvas3D canvas3D = new Canvas3D(graphicsConfiguration);
        SimpleUniverse simpleUniverse = new SimpleUniverse(canvas3D);
        simpleUniverse.getViewingPlatform().setNominalViewingTransform();
        BranchGroup branchGroup = new BranchGroup();
        TransformGroup transformGroup = new TransformGroup();
        Transform3D transform3D = new Transform3D();
        transform3D.setScale((double)dataInputStream.readFloat());
        transformGroup.setTransform(transform3D);
        branchGroup.addChild((Node)transformGroup);
        if (dataInputStream.readInt() == 1) {
            transformGroup.setCapability(18);
            transformGroup.setCapability(17);
            KeyNavigatorBehavior keyNavigatorBehavior = new KeyNavigatorBehavior(transformGroup);
            keyNavigatorBehavior.setSchedulingBounds((Bounds)bnds);
            transformGroup.addChild((Node)keyNavigatorBehavior);
        }
        DataUtils.readAll(dataInputStream, branchGroup, transformGroup, dimension);
        branchGroup.compile();
        simpleUniverse.addBranchGraph(branchGroup);
        return canvas3D;
    }

    static BufferedImage getBI(String string) {
        return ESUtils.getBufferedImage(new File(string));
    }

    static void readAll(DataInputStream dataInputStream, BranchGroup branchGroup, TransformGroup transformGroup, Dimension dimension) throws IOException {
        Background background;
        Object object;
        int n = 0;
        n = dataInputStream.readInt();
        if (n != 0) {
            object = new Background(DataUtils.getColor(n));
            object.setApplicationBounds((Bounds)bnds);
            branchGroup.addChild((Node)object);
        }
        if ((n = dataInputStream.readInt()) != 0) {
            object = DataUtils.getBI(dataInputStream.readUTF());
            TextureLoader textureLoader = null;
            background = null;
            if (object != null) {
                switch (n) {
                    case 1: {
                        textureLoader = new TextureLoader((BufferedImage)object);
                        background = new Background(textureLoader.getImage());
                        break;
                    }
                    case 2: {
                        textureLoader = new TextureLoader((BufferedImage)object);
                        background = new Background(textureLoader.getScaledImage(dimension.width, dimension.height));
                        break;
                    }
                    case 3: {
                        BufferedImage bufferedImage = new BufferedImage(dimension.width, dimension.height, 1);
                        int n2 = ((BufferedImage)object).getHeight();
                        int n3 = ((BufferedImage)object).getWidth();
                        Graphics2D graphics2D = bufferedImage.createGraphics();
                        int n4 = 0;
                        while (n4 < dimension.height) {
                            int n5 = 0;
                            while (n5 < dimension.width) {
                                graphics2D.drawImage((Image)object, n5, n4, null);
                                n5 += n3;
                            }
                            n4 += n2;
                        }
                        object = bufferedImage;
                        textureLoader = new TextureLoader((BufferedImage)object);
                        background = new Background(textureLoader.getImage());
                    }
                }
                background.setApplicationBounds((Bounds)bnds);
                branchGroup.addChild(background);
            }
        }
        if ((n = dataInputStream.readInt()) != 0) {
            object = new AmbientLight(DataUtils.getColor(n));
            object.setInfluencingBounds((Bounds)bnds);
            branchGroup.addChild((Node)object);
        }
        if ((n = dataInputStream.readInt()) != 0) {
            int n6 = dataInputStream.readInt();
            float f = 0.0f;
            if (n6 > 0) {
                f = (float)n6 / 100.0f;
            }
            background = new ExponentialFog(DataUtils.getColor(n), f);
            background.setInfluencingBounds((Bounds)bnds);
            branchGroup.addChild((Node)background);
        }
        n = dataInputStream.readInt();
        int n7 = 0;
        while (n7 < n) {
            DataUtils.addLight(dataInputStream, transformGroup);
            ++n7;
        }
        n = dataInputStream.readInt();
        int n8 = 0;
        while (n8 < n) {
            dataInputStream.readUTF();
            dataInputStream.readUTF();
            DataUtils.addWidget(dataInputStream, dataInputStream.readInt(), transformGroup);
            ++n8;
        }
    }

    static void addLight(DataInputStream dataInputStream, TransformGroup transformGroup) throws IOException {
        DirectionalLight directionalLight = null;
        int n = dataInputStream.readInt();
        Color3f color3f = DataUtils.getColor(dataInputStream.readInt());
        TransformGroup transformGroup2 = DataUtils.readTransform(dataInputStream);
        switch (n) {
            case 0: {
                directionalLight = new DirectionalLight();
                break;
            }
            case 2: {
                PointLight pointLight = new PointLight();
                directionalLight = pointLight;
                pointLight.setAttenuation(DataUtils.readPoint(dataInputStream));
                break;
            }
            case 1: {
                SpotLight spotLight = new SpotLight();
                directionalLight = spotLight;
                spotLight.setAttenuation(DataUtils.readPoint(dataInputStream));
                spotLight.setSpreadAngle(dataInputStream.readFloat());
                spotLight.setConcentration(dataInputStream.readFloat());
                spotLight.setDirection(DataUtils.readVector(dataInputStream));
            }
        }
        directionalLight.setCapability(15);
        directionalLight.setColor(color3f);
        directionalLight.setInfluencingBounds((Bounds)bnds);
        transformGroup2.addChild((Node)directionalLight);
        transformGroup.addChild((Node)transformGroup2);
    }

    static Point3f readPoint(DataInputStream dataInputStream) throws IOException {
        return new Point3f(dataInputStream.readFloat(), dataInputStream.readFloat(), dataInputStream.readFloat());
    }

    static Vector3f readVector(DataInputStream dataInputStream) throws IOException {
        return new Vector3f(dataInputStream.readFloat(), dataInputStream.readFloat(), dataInputStream.readFloat());
    }

    static TransformGroup readTransform(DataInputStream dataInputStream) throws IOException {
        TransformGroup transformGroup = new TransformGroup();
        float[] fArray = new float[16];
        int n = 0;
        while (n < 16) {
            fArray[n] = dataInputStream.readFloat();
            ++n;
        }
        Transform3D transform3D = new Transform3D(fArray);
        transformGroup.setTransform(transform3D);
        return transformGroup;
    }

    static void addWidget(DataInputStream dataInputStream, int n, TransformGroup transformGroup) throws IOException {
        Appearance appearance = new Appearance();
        appearance.setMaterial(new Material());
        switch (n) {
            case 0: {
                Sphere sphere = new Sphere(dataInputStream.readFloat(), 3, dataInputStream.readInt(), appearance);
                DataUtils.addPrimitive(dataInputStream, transformGroup, (Node)sphere, appearance);
                break;
            }
            case 1: {
                float f = dataInputStream.readFloat();
                Box box = new Box(f, f, f, 3, appearance);
                DataUtils.addPrimitive(dataInputStream, transformGroup, (Node)box, appearance);
                break;
            }
            case 2: {
                Box box = new Box(dataInputStream.readFloat(), dataInputStream.readFloat(), dataInputStream.readFloat(), 3, appearance);
                DataUtils.addPrimitive(dataInputStream, transformGroup, (Node)box, appearance);
                break;
            }
            case 3: {
                Cone cone = new Cone(dataInputStream.readFloat(), dataInputStream.readFloat(), 3, dataInputStream.readInt(), dataInputStream.readInt(), appearance);
                DataUtils.addPrimitive(dataInputStream, transformGroup, (Node)cone, appearance);
                break;
            }
            case 4: {
                Cylinder cylinder = new Cylinder(dataInputStream.readFloat(), dataInputStream.readFloat(), 3, dataInputStream.readInt(), dataInputStream.readInt(), appearance);
                DataUtils.addPrimitive(dataInputStream, transformGroup, (Node)cylinder, appearance);
                break;
            }
            case 5: {
                FontExtrusion fontExtrusion = new FontExtrusion();
                Font3D font3D = new Font3D(new Font(dataInputStream.readUTF(), dataInputStream.readInt(), dataInputStream.readInt()), fontExtrusion);
                Text3D text3D = new Text3D(font3D, dataInputStream.readUTF(), new Point3f(0.0f, 0.0f, 0.0f), 0, dataInputStream.readInt());
                dataInputStream.readInt();
                Shape3D shape3D = new Shape3D();
                shape3D.setGeometry((Geometry)text3D);
                shape3D.setAppearance(appearance);
                TexCoordGeneration texCoordGeneration = new TexCoordGeneration();
                texCoordGeneration.setEnable(true);
                appearance.setTexCoordGeneration(texCoordGeneration);
                DataUtils.addPrimitive(dataInputStream, transformGroup, (Node)shape3D, appearance);
                break;
            }
            case 6: {
                TransformGroup transformGroup2 = DataUtils.readTransform(dataInputStream);
                Text2D text2D = new Text2D(dataInputStream.readUTF(), DataUtils.getColor(dataInputStream.readInt()), dataInputStream.readUTF(), dataInputStream.readInt(), dataInputStream.readInt());
                if (dataInputStream.readInt() == 1) {
                    PolygonAttributes polygonAttributes = new PolygonAttributes();
                    polygonAttributes.setCullFace(0);
                    polygonAttributes.setBackFaceNormalFlip(true);
                    text2D.getAppearance().setPolygonAttributes(polygonAttributes);
                }
                DataUtils.addBH(dataInputStream, transformGroup, transformGroup2, (Node)text2D);
            }
        }
    }

    static void addPrimitive(DataInputStream dataInputStream, TransformGroup transformGroup, Node node, Appearance appearance) throws IOException {
        String string;
        TransformGroup transformGroup2 = DataUtils.readTransform(dataInputStream);
        Material material = appearance.getMaterial();
        int n = dataInputStream.readInt();
        if (n >= 0) {
            float f = (float)n / 100.0f;
            appearance.setTransparencyAttributes(new TransparencyAttributes(2, f));
        }
        if ((n = dataInputStream.readInt()) >= 0) {
            material.setShininess((float)n);
        }
        if ((n = dataInputStream.readInt()) != 0) {
            material.setDiffuseColor(DataUtils.getColor(n));
        }
        if ((n = dataInputStream.readInt()) != 0) {
            material.setSpecularColor(DataUtils.getColor(n));
        }
        if ((n = dataInputStream.readInt()) != 0) {
            material.setEmissiveColor(DataUtils.getColor(n));
        }
        if ((n = dataInputStream.readInt()) != 0) {
            material.setAmbientColor(DataUtils.getColor(n));
        }
        if (!(string = dataInputStream.readUTF()).equals("")) {
            BufferedImage bufferedImage = DataUtils.getBI(string);
            TextureLoader textureLoader = new TextureLoader(bufferedImage);
            Texture texture = textureLoader.getTexture();
            TextureAttributes textureAttributes = new TextureAttributes();
            textureAttributes.setTextureMode(TEXTURES[dataInputStream.readInt() - 1]);
            appearance.setTexture(texture);
            appearance.setTextureAttributes(textureAttributes);
        }
        DataUtils.addBH(dataInputStream, transformGroup, transformGroup2, node);
    }

    static void addBH(DataInputStream dataInputStream, TransformGroup transformGroup, TransformGroup transformGroup2, Node node) throws IOException {
        if (!dataInputStream.readBoolean()) {
            transformGroup.addChild((Node)transformGroup2);
            transformGroup2.addChild(node);
            return;
        }
        TransformGroup transformGroup3 = new TransformGroup();
        transformGroup3.setCapability(18);
        switch (dataInputStream.readInt()) {
            case 1: {
                int n = dataInputStream.readInt();
                if (!dataInputStream.readBoolean()) {
                    transformGroup.addChild((Node)transformGroup2);
                    transformGroup2.addChild((Node)transformGroup3);
                    transformGroup3.addChild(node);
                } else {
                    transformGroup.addChild((Node)transformGroup3);
                    transformGroup3.addChild((Node)transformGroup2);
                    transformGroup2.addChild(node);
                }
                Alpha alpha = new Alpha(-1, (long)(dataInputStream.readInt() * 1000));
                Transform3D transform3D = new Transform3D();
                switch (n) {
                    case 1: {
                        transform3D.rotZ(4.71238898038469);
                        break;
                    }
                    case 2: {
                        transform3D.rotX(4.71238898038469);
                    }
                }
                RotationInterpolator rotationInterpolator = new RotationInterpolator(alpha, transformGroup3, transform3D, 0.0f, (float)Math.PI * 2);
                rotationInterpolator.setSchedulingBounds((Bounds)bnds);
                transformGroup.addChild((Node)rotationInterpolator);
            }
        }
    }

    static Color3f getColor(int n) {
        Color color = new Color(n);
        float f = color.getRed() == 0 ? 0.0f : (float)color.getRed() / 255.0f;
        float f2 = color.getGreen() == 0 ? 0.0f : (float)color.getGreen() / 255.0f;
        float f3 = color.getBlue() == 0 ? 0.0f : (float)color.getBlue() / 255.0f;
        return new Color3f(f, f2, f3);
    }
}

