/*
 * Decompiled with CFR 0.152.
 */
package com.equitysoft.jicasso;

import com.equitysoft.jicasso.CUtils;
import com.equitysoft.jicasso.DataUtils;
import com.equitysoft.jicasso.FloatAdjust;
import com.equitysoft.jicasso.IntAdjust;
import com.equitysoft.jicasso.ShellBox;
import com.sun.j3d.utils.geometry.Cylinder;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.media.j3d.Appearance;
import javax.media.j3d.Node;
import javax.swing.JPopupMenu;

class CylinderBox
extends ShellBox {
    float height = 1.0f;
    float radius = 1.0f;
    int xdivisions = 40;
    int ydivisions = 40;
    Cylinder cylinder;

    CylinderBox() {
    }

    void addToMenu(JPopupMenu jPopupMenu) {
        jPopupMenu.add(new FloatAdjust(11, "Height"));
        jPopupMenu.add(new FloatAdjust(12, "Radius"));
        jPopupMenu.add(new IntAdjust(13, "X divisions", 5, 1000));
        jPopupMenu.add(new IntAdjust(14, "Y divisions", 5, 1000));
    }

    Node getNode(Appearance appearance) {
        this.cylinder = new Cylinder(this.radius, this.height, 99, this.xdivisions, this.ydivisions, appearance);
        return this.cylinder;
    }

    public Object getProp(int n) {
        switch (n) {
            case 8: {
                return this.cylinder.getAppearance();
            }
            case 11: {
                return new Float(this.height);
            }
            case 12: {
                return new Float(this.radius);
            }
            case 13: {
                return new Integer(this.xdivisions);
            }
            case 14: {
                return new Integer(this.ydivisions);
            }
        }
        return super.getProp(n);
    }

    void readSubObj(DataInputStream dataInputStream) throws IOException {
        this.radius = dataInputStream.readFloat();
        this.height = dataInputStream.readFloat();
        this.xdivisions = dataInputStream.readInt();
        this.ydivisions = dataInputStream.readInt();
        this.addChild(this.getNode(CUtils.initAppearance()));
    }

    public void setProp(int n, Object object) {
        switch (n) {
            case 11: {
                Float f = (Float)object;
                this.height = f.floatValue();
                DataUtils.replaceCurrent(this);
                break;
            }
            case 12: {
                Float f = (Float)object;
                this.radius = f.floatValue();
                DataUtils.replaceCurrent(this);
                break;
            }
            case 13: {
                Integer n2 = (Integer)object;
                this.xdivisions = n2;
                DataUtils.replaceCurrent(this);
                break;
            }
            case 14: {
                Integer n3 = (Integer)object;
                this.ydivisions = n3;
                DataUtils.replaceCurrent(this);
                break;
            }
            default: {
                super.setProp(n, object);
            }
        }
    }

    void writeSubObj(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(4);
        dataOutputStream.writeFloat(this.radius);
        dataOutputStream.writeFloat(this.height);
        dataOutputStream.writeInt(this.xdivisions);
        dataOutputStream.writeInt(this.ydivisions);
    }
}

