/*
 * Decompiled with CFR 0.152.
 */
package com.equitysoft.jicasso;

import com.equitysoft.jicasso.CompType;
import com.equitysoft.jicasso.ESUtils;
import com.equitysoft.jicasso.ESZap;
import com.equitysoft.jicasso.FileFinder;
import com.equitysoft.jicasso.FileManager;
import com.equitysoft.jicasso.Grid;
import com.equitysoft.jicasso.Props;
import com.equitysoft.jicasso.SysProps;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import javax.swing.JMenu;

class CustomMenu
extends JMenu
implements ActionListener,
Props {
    String DEFINE = "Save current component to library";
    String ADD = "Add library component to scene";
    String DELETE = "Delete component in library";
    File CDIR;

    CustomMenu() {
        super("Custom   ");
        this.add(ESUtils.getMI(this.DEFINE, this));
        this.add(ESUtils.getMI(this.ADD, this));
        this.add(ESUtils.getMI(this.DELETE, this));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string;
        if (this.CDIR == null) {
            this.CDIR = new File(SysProps.CURR_DIR, "comps");
            if (!this.CDIR.exists()) {
                this.CDIR.mkdir();
            }
        }
        if ((string = actionEvent.getActionCommand()) == this.DEFINE) {
            CompType compType = Grid.getCurrent();
            if (compType == null) {
                new ESZap("No component currently selected");
                return;
            }
            String[] stringArray = new String[]{".jcc"};
            File file = FileFinder.ask(this.CDIR, "Specify name of component", 2, "Component name", stringArray);
            if (file == null) {
                return;
            }
            this.CDIR = file.getParentFile();
            file = FileManager.checkExtension(file, "jcc");
            try {
                int n;
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
                compType.writeObj(dataOutputStream);
                byte[] byArray = byteArrayOutputStream.toByteArray();
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                byte[] byArray2 = new byte[256];
                while ((n = byteArrayInputStream.read(byArray2, 0, 256)) > -1) {
                    fileOutputStream.write(byArray2, 0, n);
                }
                fileOutputStream.close();
            }
            catch (Exception exception) {
                new ESZap("Error saving component " + exception.getMessage());
            }
        } else if (string == this.ADD) {
            String[] stringArray = new String[]{".jcc"};
            File file = FileFinder.ask(this.CDIR, "Select component to add", 0, "Component name", stringArray);
            if (file == null) {
                return;
            }
            this.CDIR = file.getParentFile();
            try {
                int n;
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                FileInputStream fileInputStream = new FileInputStream(file);
                byte[] byArray = new byte[256];
                while ((n = fileInputStream.read(byArray, 0, 256)) > -1) {
                    byteArrayOutputStream.write(byArray, 0, n);
                }
                fileInputStream.close();
                byte[] byArray3 = byteArrayOutputStream.toByteArray();
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray3);
                DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
                Object obj = Class.forName("com.equitysoft.jicasso." + dataInputStream.readUTF()).newInstance();
                if (obj == null) {
                    new ESZap("Unable to create the component");
                    return;
                }
                CompType compType = (CompType)obj;
                compType.setProp(22, dataInputStream.readUTF());
                dataInputStream.readInt();
                compType.readObj(dataInputStream);
                Grid.addObject(obj, true);
            }
            catch (Exception exception) {
                new ESZap("Error creating component " + exception.getMessage());
            }
        } else if (string == this.DELETE) {
            String[] stringArray = new String[]{".jcc"};
            File file = FileFinder.ask(this.CDIR, "Select component to delete", 0, "Component name", stringArray);
            if (file == null) {
                return;
            }
            this.CDIR = file.getParentFile();
            file.delete();
        }
    }
}

