/*
 * Decompiled with CFR 0.152.
 */
package com.equitysoft.jicasso;

import com.equitysoft.jicasso.APLib;
import com.equitysoft.jicasso.CompType;
import com.equitysoft.jicasso.Grid;
import com.equitysoft.jicasso.Props;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.media.j3d.Appearance;
import javax.media.j3d.Material;
import javax.swing.JColorChooser;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.vecmath.Color3f;

class CompColor
extends JMenu
implements ActionListener,
Props {
    String DIFF = "Diffuse";
    String SPEC = "Specular";
    String EMIS = "Emissive";
    String AMB = "Ambient";

    CompColor() {
        super("Set color");
        JMenuItem jMenuItem = new JMenuItem(this.DIFF);
        jMenuItem.addActionListener(this);
        this.add(jMenuItem);
        jMenuItem = new JMenuItem(this.SPEC);
        jMenuItem.addActionListener(this);
        this.add(jMenuItem);
        jMenuItem = new JMenuItem(this.EMIS);
        jMenuItem.addActionListener(this);
        this.add(jMenuItem);
        jMenuItem = new JMenuItem(this.AMB);
        jMenuItem.addActionListener(this);
        this.add(jMenuItem);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Color color;
        CompType compType = Grid.getCurrent();
        if (compType == null) {
            return;
        }
        String string = actionEvent.getActionCommand();
        Color3f color3f = new Color3f();
        Appearance appearance = (Appearance)compType.getProp(8);
        Material material = appearance.getMaterial();
        if (string == this.DIFF) {
            material.getDiffuseColor(color3f);
            color = JColorChooser.showDialog(Grid.handle, "0 color", APLib.getColor(color3f));
            if (color == null) {
                return;
            }
            compType.setProp(0, color);
        }
        if (string == this.SPEC) {
            material.getSpecularColor(color3f);
            color = JColorChooser.showDialog(Grid.handle, "1 color", APLib.getColor(color3f));
            if (color == null) {
                return;
            }
            compType.setProp(1, color);
        }
        if (string == this.EMIS) {
            material.getEmissiveColor(color3f);
            color = JColorChooser.showDialog(Grid.handle, "2 color", APLib.getColor(color3f));
            if (color == null) {
                return;
            }
            compType.setProp(2, color);
        }
        if (string == this.AMB) {
            material.getAmbientColor(color3f);
            color = JColorChooser.showDialog(Grid.handle, "3 color", APLib.getColor(color3f));
            if (color == null) {
                return;
            }
            compType.setProp(3, color);
        }
    }
}

