/*
 * Decompiled with CFR 0.152.
 */
package com.equitysoft.jicasso;

import com.equitysoft.jicasso.Bar;
import com.equitysoft.jicasso.Prefs;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JColorChooser;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

class ColorPanel
extends JPanel
implements ActionListener {
    JRadioButton no;
    JRadioButton yes;
    JTextField col;
    String msg;

    ColorPanel(String string, String string2) {
        super(false);
        this.msg = string;
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), string));
        ButtonGroup buttonGroup = new ButtonGroup();
        this.setLayout(new FlowLayout(1, 5, 3));
        this.no = new JRadioButton("Use default");
        this.add(this.no);
        this.no.addActionListener(this);
        buttonGroup.add(this.no);
        this.no.setSelected(true);
        this.yes = new JRadioButton("Color set");
        this.add(this.yes);
        this.yes.addActionListener(this);
        buttonGroup.add(this.yes);
        this.col = new JTextField(8);
        this.add(this.col);
        this.col.setEditable(false);
        this.col.setFont(new Font("Dialog", 1, 10));
        this.add(this.col);
        int n = Integer.parseInt(Prefs.get(string2));
        if (n == 0) {
            this.off();
        } else {
            this.yes.setSelected(true);
            this.on(new Color(n));
        }
    }

    boolean isYes() {
        return this.yes.isSelected();
    }

    int getRGB() {
        if (this.no.isSelected()) {
            return 0;
        }
        return this.col.getBackground().getRGB();
    }

    void chooseColor() {
        Color color = JColorChooser.showDialog(Bar.handle, "Choose color for " + this.msg + " background", this.col.isEnabled() ? this.col.getBackground() : Color.lightGray);
        if (color != null) {
            this.on(color);
        } else {
            this.no.setSelected(true);
            this.off();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.yes.isSelected()) {
            this.chooseColor();
        } else {
            this.off();
        }
    }

    void on(Color color) {
        this.col.setEnabled(true);
        this.col.setBackground(color);
    }

    void off() {
        this.col.setBackground(Color.lightGray);
        this.col.setEnabled(false);
    }
}

