/*
 * Decompiled with CFR 0.152.
 */
package com.equitysoft.jicasso;

import com.equitysoft.jicasso.ESUtils;
import com.equitysoft.jicasso.TexType;
import com.sun.j3d.utils.image.TextureLoader;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.media.j3d.Appearance;
import javax.media.j3d.Material;
import javax.media.j3d.Texture;
import javax.media.j3d.TextureAttributes;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.TransparencyAttributes;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;

class CUtils {
    CUtils() {
    }

    static Float getScaleFromGroup(TransformGroup transformGroup) {
        Transform3D transform3D = new Transform3D();
        transformGroup.getTransform(transform3D);
        return new Float(transform3D.getScale());
    }

    static int getTextAlignment(int n) {
        switch (n) {
            case 0: {
                return 1;
            }
            case 1: {
                return 3;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 0;
            }
        }
        return 0;
    }

    static int getTextAttr(int n) {
        switch (n) {
            case 1: {
                return 2;
            }
            case 2: {
                return 4;
            }
            case 3: {
                return 5;
            }
            case 4: {
                return 3;
            }
        }
        return 0;
    }

    static int getTrans(Object object, Appearance appearance) {
        Integer n = (Integer)object;
        int n2 = n;
        float f = (float)n2 / 100.0f;
        TransparencyAttributes transparencyAttributes = new TransparencyAttributes(2, f);
        transparencyAttributes.setCapability(3);
        appearance.setTransparencyAttributes(transparencyAttributes);
        return n2;
    }

    static Appearance initAppearance() {
        Appearance appearance = new Appearance();
        appearance.setCapability(1);
        appearance.setCapability(0);
        appearance.setCapability(3);
        appearance.setCapability(2);
        appearance.setCapability(11);
        appearance.setCapability(10);
        appearance.setCapability(7);
        appearance.setCapability(6);
        Material material = new Material();
        material.setCapability(0);
        material.setCapability(1);
        appearance.setMaterial(material);
        return appearance;
    }

    static Color readColor(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readInt();
        if (n == 0) {
            return null;
        }
        return new Color(n);
    }

    static Point3f readPoint(DataInputStream dataInputStream) throws IOException {
        return new Point3f(dataInputStream.readFloat(), dataInputStream.readFloat(), dataInputStream.readFloat());
    }

    static String readText(DataInputStream dataInputStream) throws IOException {
        String string = dataInputStream.readUTF();
        if (string.equals("")) {
            return null;
        }
        return string;
    }

    static void readTransform(DataInputStream dataInputStream, TransformGroup transformGroup) throws IOException {
        float[] fArray = new float[16];
        int n = 0;
        while (n < 16) {
            fArray[n] = dataInputStream.readFloat();
            ++n;
        }
        Transform3D transform3D = new Transform3D(fArray);
        transformGroup.setTransform(transform3D);
    }

    static Vector3f readVector(DataInputStream dataInputStream) throws IOException {
        return new Vector3f(dataInputStream.readFloat(), dataInputStream.readFloat(), dataInputStream.readFloat());
    }

    static void setScaleForGroup(Object object, TransformGroup transformGroup) {
        Float f = (Float)object;
        Transform3D transform3D = new Transform3D();
        transformGroup.getTransform(transform3D);
        transform3D.setScale((double)f.floatValue());
        transformGroup.setTransform(transform3D);
    }

    static TexType setTexture(TexType texType, Appearance appearance) {
        if (texType == null) {
            appearance.setTexture(null);
            return null;
        }
        BufferedImage bufferedImage = ESUtils.getBufferedImage(texType.path);
        if (bufferedImage == null) {
            return null;
        }
        TextureLoader textureLoader = new TextureLoader(bufferedImage);
        Texture texture = textureLoader.getTexture();
        TextureAttributes textureAttributes = new TextureAttributes();
        textureAttributes.setTextureMode(CUtils.getTextAttr(texType.type));
        appearance.setTexture(texture);
        appearance.setTextureAttributes(textureAttributes);
        return texType;
    }

    static void writeColor(DataOutputStream dataOutputStream, Color color) throws IOException {
        if (color == null) {
            dataOutputStream.writeInt(0);
        } else {
            dataOutputStream.writeInt(color.getRGB());
        }
    }

    static void writePoint(DataOutputStream dataOutputStream, Point3f point3f) throws IOException {
        dataOutputStream.writeFloat(point3f.x);
        dataOutputStream.writeFloat(point3f.y);
        dataOutputStream.writeFloat(point3f.z);
    }

    static void writeText(DataOutputStream dataOutputStream, String string) throws IOException {
        if (string == null) {
            dataOutputStream.writeUTF("");
        } else {
            dataOutputStream.writeUTF(string);
        }
    }

    static void writeTransform(DataOutputStream dataOutputStream, TransformGroup transformGroup) throws IOException {
        Transform3D transform3D = new Transform3D();
        transformGroup.getTransform(transform3D);
        float[] fArray = new float[16];
        transform3D.get(fArray);
        int n = 0;
        while (n < 16) {
            dataOutputStream.writeFloat(fArray[n]);
            ++n;
        }
    }

    static void writeVector(DataOutputStream dataOutputStream, Vector3f vector3f) throws IOException {
        dataOutputStream.writeFloat(vector3f.x);
        dataOutputStream.writeFloat(vector3f.y);
        dataOutputStream.writeFloat(vector3f.z);
    }
}

