/*
 * Decompiled with CFR 0.152.
 */
package com.equitysoft.jicasso;

import com.equitysoft.jicasso.AmbientColor;
import com.equitysoft.jicasso.DataUtils;
import com.equitysoft.jicasso.ESUtils;
import com.equitysoft.jicasso.FileManager;
import com.equitysoft.jicasso.FogColor;
import com.equitysoft.jicasso.Grid;
import com.equitysoft.jicasso.MainPanel;
import com.equitysoft.jicasso.MultiSelectionMenu;
import com.equitysoft.jicasso.MultiSelector;
import com.equitysoft.jicasso.ScreenColor;
import com.sun.j3d.utils.image.TextureLoader;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import javax.media.j3d.Background;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Node;
import javax.swing.JMenu;

public class BackgroundMenu
extends JMenu
implements MultiSelector {
    public static final int NONE = 0;
    public static final int SINGLE = 1;
    public static final int SCALED = 2;
    public static final int TILED = 3;
    static BackgroundMenu handle;
    String[] options = new String[]{"No image", "Unscaled image", "Scaled image", "Tiled image"};
    static MultiSelectionMenu image;
    static BranchGroup bg;
    static File path;

    BackgroundMenu() {
        super("Background    ");
        handle = this;
        this.add(new ScreenColor());
        this.add(new AmbientColor());
        this.add(new FogColor());
        image = new MultiSelectionMenu("Background image", this.options, this);
        this.add(image);
    }

    static void removeIt() {
        if (bg != null) {
            bg.detach();
        }
        bg = null;
    }

    public void multiCallBack(MultiSelectionMenu multiSelectionMenu, int n) {
        if (n == 0) {
            if (bg != null) {
                path = null;
                bg.detach();
                bg = null;
                System.gc();
            }
            return;
        }
        File file = FileManager.getChooserImage("Choose background image");
        if (file == null) {
            return;
        }
        BackgroundMenu.addBackground(n, file);
    }

    static void addBackground(int n, File file) {
        BufferedImage bufferedImage = ESUtils.getBufferedImage(file);
        if (bufferedImage == null) {
            return;
        }
        Dimension dimension = ((Component)((Object)MainPanel.handle)).getSize();
        TextureLoader textureLoader = null;
        Background background = null;
        switch (n) {
            case 1: {
                textureLoader = new TextureLoader(bufferedImage);
                background = new Background(textureLoader.getImage());
                break;
            }
            case 2: {
                textureLoader = new TextureLoader(bufferedImage);
                background = new Background(textureLoader.getScaledImage(dimension.width, dimension.height));
                break;
            }
            case 3: {
                BufferedImage bufferedImage2 = new BufferedImage(dimension.width, dimension.height, 1);
                int n2 = bufferedImage.getHeight();
                int n3 = bufferedImage.getWidth();
                Graphics2D graphics2D = bufferedImage2.createGraphics();
                int n4 = 0;
                while (n4 < dimension.height) {
                    int n5 = 0;
                    while (n5 < dimension.width) {
                        graphics2D.drawImage((Image)bufferedImage, n5, n4, null);
                        n5 += n3;
                    }
                    n4 += n2;
                }
                bufferedImage = bufferedImage2;
                textureLoader = new TextureLoader(bufferedImage);
                background = new Background(textureLoader.getImage());
            }
        }
        BackgroundMenu.removeIt();
        ScreenColor.removeIt();
        path = file;
        bg = new BranchGroup();
        bg.setCapability(17);
        background.setApplicationBounds((Bounds)DataUtils.bnds);
        bg.addChild((Node)background);
        Grid.bg.addChild((Node)bg);
        System.gc();
    }
}

