/*
 * Decompiled with CFR 0.152.
 */
package com.equitysoft.jicasso;

import com.equitysoft.jicasso.Adjuster;
import com.equitysoft.jicasso.ESUtils;
import com.equitysoft.jicasso.FlashButton;
import com.equitysoft.jicasso.PressPanel;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JPanel;

class ArrowPanel
extends JPanel
implements ActionListener {
    static final int ALL = 0;
    static final int ANGLE = 1;
    static final int VERTICAL = 2;
    static final int LEFT = 0;
    static final int UP = 1;
    static final int DOWN = 2;
    static final int RIGHT = 3;
    static final int SEGMENT = 4;
    static final int QUARTER = 5;
    static FlashButton left;
    static FlashButton right;
    static FlashButton up;
    static FlashButton down;
    static FlashButton quarter;
    static FlashButton segment;
    static Adjuster adj;

    ArrowPanel() {
        this.setBorder(BorderFactory.createEtchedBorder());
        this.setLayout(new GridLayout(2, 3));
        segment = ESUtils.getButton("segment.gif", this);
        this.add(segment);
        up = ESUtils.getButton("up.gif", this);
        this.add(up);
        quarter = ESUtils.getButton("quarter.gif", this);
        this.add(quarter);
        left = ESUtils.getButton("left.gif", this);
        this.add(left);
        down = ESUtils.getButton("down.gif", this);
        this.add(down);
        right = ESUtils.getButton("right.gif", this);
        this.add(right);
    }

    static void panelOff() {
        left.setEnabled(false);
        right.setEnabled(false);
        up.setEnabled(false);
        down.setEnabled(false);
        segment.setEnabled(false);
        quarter.setEnabled(false);
        adj = null;
    }

    static void panelOn(Adjuster adjuster, int n) {
        PressPanel.panelOff();
        adj = adjuster;
        PressPanel.labelOn();
        switch (n) {
            case 0: {
                ArrowPanel.arrows();
                break;
            }
            case 1: {
                ArrowPanel.arrows();
                break;
            }
            case 2: {
                ArrowPanel.vertical();
            }
        }
    }

    static void arrows() {
        left.setEnabled(true);
        right.setEnabled(true);
        down.setEnabled(true);
        up.setEnabled(true);
    }

    static void angle() {
        segment.setEnabled(true);
        quarter.setEnabled(true);
    }

    static void vertical() {
        down.setEnabled(true);
        up.setEnabled(true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == left) {
            adj.alterValue(0);
        } else if (object == right) {
            adj.alterValue(3);
        } else if (object == up) {
            adj.alterValue(1);
        } else if (object == down) {
            adj.alterValue(2);
        } else if (object == quarter) {
            adj.alterValue(5);
        } else if (object == segment) {
            adj.alterValue(4);
        }
    }
}

