/*
 * Decompiled with CFR 0.152.
 */
package com.equitysoft.jicasso;

import com.equitysoft.jicasso.APLib;
import com.equitysoft.jicasso.Bar;
import com.equitysoft.jicasso.DataUtils;
import com.equitysoft.jicasso.ESUtils;
import com.equitysoft.jicasso.Grid;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.media.j3d.AmbientLight;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Node;
import javax.swing.JColorChooser;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.vecmath.Color3f;

class AmbientColor
extends JMenu
implements ActionListener {
    String CUSTOM = "Set ambient color";
    String REMOVE = "Remove ambient color";
    static BranchGroup bg;
    static Color amb;
    static JMenuItem rem;

    AmbientColor() {
        super("Ambient color");
        this.add(ESUtils.getMI(this.CUSTOM, this));
        rem = ESUtils.getMI(this.REMOVE, this);
        this.add(rem);
        rem.setEnabled(false);
    }

    static void writeAmbient(DataOutputStream dataOutputStream) throws IOException {
        if (bg == null) {
            dataOutputStream.writeInt(0);
        } else {
            dataOutputStream.writeInt(amb.getRGB());
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Color color = null;
        String string = actionEvent.getActionCommand();
        if (string == this.REMOVE) {
            AmbientColor.removeIt();
        } else {
            color = JColorChooser.showDialog(Grid.handle, this.CUSTOM, amb);
            Bar.handle.repaint();
            if (color == null) {
                return;
            }
            AmbientColor.addAmbient(color);
        }
    }

    static void addAmbient(Color color) {
        rem.setEnabled(true);
        amb = color;
        Color3f color3f = APLib.getColor(color);
        if (bg != null) {
            bg.detach();
        }
        AmbientLight ambientLight = new AmbientLight(color3f);
        ambientLight.setInfluencingBounds((Bounds)DataUtils.bnds);
        bg = new BranchGroup();
        bg.setCapability(17);
        bg.addChild((Node)ambientLight);
        Grid.bg.addChild((Node)bg);
    }

    static void removeIt() {
        if (bg != null) {
            bg.detach();
            bg = null;
        }
        rem.setEnabled(false);
    }

    static {
        amb = Color.black;
    }
}

