/*
 * Decompiled with CFR 0.152.
 */
package com.equitysoft.isafe;

import com.equitysoft.isafe.ESDialog;
import com.equitysoft.isafe.ESZap;
import com.equitysoft.isafe.LibButton;
import com.equitysoft.isafe.Prefs;
import com.equitysoft.isafe.TextOption;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

class TextPreview
extends ESDialog
implements ActionListener,
Runnable {
    String CANCEL = "Continue";
    Image img;
    boolean canrun;
    CenterPanel cp;
    int x;
    int ydisp;
    int strwid;
    Dimension dim;
    Font f;
    Color col;
    String text = TextOption.text.getText();

    TextPreview(Image image) {
        super("Overlay preview");
        int n;
        if (this.text.equals("")) {
            new ESZap("First enter text that is to appear across the image.");
            return;
        }
        this.img = image;
        this.dim = new Dimension(image.getWidth(null), image.getHeight(null));
        int n2 = TextOption.textcol.getRGB();
        this.col = n2 == 0 ? Color.lightGray : new Color(n2);
        this.f = TextOption.getTextFont();
        FontMetrics fontMetrics = this.getFontMetrics(this.f);
        int n3 = TextOption.getValue();
        if (n3 == 1) {
            this.ydisp = this.dim.height / 2 + TextOption.custom.getCurr();
        } else if (n3 == 0) {
            this.ydisp = fontMetrics.getAscent() + TextOption.custom.getCurr();
        } else if (n3 == 2) {
            this.ydisp = this.dim.height - fontMetrics.getDescent() - 1 - TextOption.custom.getCurr();
        }
        StringBuffer stringBuffer = new StringBuffer(this.text);
        int n4 = TextOption.spaces.getCurr();
        int n5 = 0;
        while (n5 < n4) {
            stringBuffer.append(" ");
            ++n5;
        }
        String string = stringBuffer.toString();
        int n6 = n = fontMetrics.stringWidth(string);
        while (n6 <= this.dim.width) {
            stringBuffer.append(string);
            n6 += n;
        }
        this.text = stringBuffer.toString();
        this.strwid = fontMetrics.stringWidth(this.text);
        this.jp.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(false);
        LibButton libButton = new LibButton(this.CANCEL);
        jPanel.add(libButton);
        libButton.addActionListener(this);
        this.jp.add((Component)jPanel, "North");
        this.cp = new CenterPanel();
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setBorder(BorderFactory.createLoweredBevelBorder());
        jScrollPane.getViewport().add(this.cp);
        this.jp.add((Component)jScrollPane, "Center");
        if (TextOption.animate.isYes()) {
            Thread thread = new Thread(this);
            this.canrun = true;
            thread.start();
        }
        this.finishOff();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.canrun = false;
        this.closeDialog();
        System.gc();
    }

    void finalCall() {
        this.canrun = false;
    }

    public void run() {
        int n = Prefs.getInt("txtstep");
        long l = Prefs.getInt("txtdelay");
        this.x = this.strwid;
        try {
            while (this.canrun) {
                Thread.sleep(l);
                this.x -= n;
                if (this.x <= 0) {
                    this.x = this.strwid;
                }
                this.cp.repaint();
            }
        }
        catch (InterruptedException interruptedException) {}
    }

    class CenterPanel
    extends Component {
        CenterPanel() {
        }

        public Dimension getPreferredSize() {
            return TextPreview.this.dim;
        }

        public void paint(Graphics graphics) {
            graphics.drawImage(TextPreview.this.img, 0, 0, this);
            graphics.setColor(TextPreview.this.col);
            graphics.setFont(TextPreview.this.f);
            int n = TextPreview.this.x - TextPreview.this.strwid;
            graphics.setClip(0, 0, TextPreview.this.dim.width, TextPreview.this.dim.height);
            graphics.drawString(TextPreview.this.text, n, TextPreview.this.ydisp);
            graphics.drawString(TextPreview.this.text, TextPreview.this.x, TextPreview.this.ydisp);
        }

        public void update(Graphics graphics) {
            this.paint(graphics);
        }
    }
}

