/*
 * Decompiled with CFR 0.152.
 */
package com.equitysoft.isafe;

import com.equitysoft.isafe.ColorPanel;
import com.equitysoft.isafe.ESZap;
import com.equitysoft.isafe.FileFinder;
import com.equitysoft.isafe.FileManager;
import com.equitysoft.isafe.ISLib;
import com.equitysoft.isafe.LibButton;
import com.equitysoft.isafe.PMBox;
import com.equitysoft.isafe.PMBoxAdjuster;
import com.equitysoft.isafe.Prefs;
import com.equitysoft.isafe.SetTiming;
import com.equitysoft.isafe.TextPreview;
import com.equitysoft.isafe.VerticalLayout;
import com.equitysoft.isafe.YesNo;
import com.equitysoft.isafe.YesNoListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

class TextOption
extends JPanel
implements ActionListener,
YesNoListener,
PMBoxAdjuster {
    static final int TOP = 0;
    static final int CENTER = 1;
    static final int BOTTOM = 2;
    static String[] names = new String[]{"Helvetica", "TimesRoman", "Courier", "Dialog"};
    static String[] styles = new String[]{"Plain", "Bold", "Plain/italic", "Bold/italic"};
    static YesNo usetext;
    static YesNo animate;
    static JTextField text;
    static JComboBox fname;
    static JComboBox fstyle;
    static JRadioButton top;
    static JRadioButton bottom;
    static JRadioButton center;
    static ColorPanel textcol;
    static PMBox fsize;
    static PMBox spaces;
    static PMBox custom;
    static LibButton timing;
    static LibButton preview;

    TextOption() {
        super(false);
        this.setLayout(new VerticalLayout(0, 3));
        usetext = new YesNo(null, "No text", "Use text overlay", this, false);
        this.add(usetext);
        usetext.setGaps(5, 0);
        JPanel jPanel = new JPanel(false);
        jPanel.setLayout(new FlowLayout(1, 5, 1));
        text = new JTextField(30);
        jPanel.add(text);
        text.setFont(ISLib.MSG_FONT);
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Text to overlay"));
        this.add(jPanel);
        jPanel = new JPanel(false);
        jPanel.setLayout(new BorderLayout());
        animate = new YesNo("Text animation", "Static", "Moving ");
        jPanel.add((Component)animate, "Center");
        animate.setGaps(1, 0);
        animate.setYes(Prefs.getBoolean("animate"));
        textcol = new ColorPanel("Color of the text", Prefs.getInt("textcol"));
        jPanel.add((Component)textcol, "East");
        textcol.setGaps(1, 0);
        this.add(jPanel);
        jPanel = new JPanel(false);
        jPanel.setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel(false);
        jPanel.setLayout(new FlowLayout(1, 0, 0));
        jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Text position"));
        ButtonGroup buttonGroup = new ButtonGroup();
        top = new JRadioButton("Top");
        jPanel2.add(top);
        top.addActionListener(this);
        buttonGroup.add(top);
        center = new JRadioButton("Center");
        jPanel2.add(center);
        center.addActionListener(this);
        buttonGroup.add(center);
        bottom = new JRadioButton("Bottom");
        jPanel2.add(bottom);
        bottom.addActionListener(this);
        buttonGroup.add(bottom);
        jPanel.add((Component)jPanel2, "Center");
        custom = new PMBox("Position offset (pixels)", this, 0, 0, 500);
        jPanel.add((Component)custom, "East");
        custom.setGaps(2, 0);
        this.add(jPanel);
        jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1, 10, 0));
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Text font"));
        jPanel2 = new JPanel(false);
        jPanel2.setLayout(new VerticalLayout(5, 3, 0));
        JPanel jPanel3 = new JPanel(false);
        jPanel3.setLayout(new FlowLayout(2, 0, 0));
        jPanel3.add(new JLabel("Name:  "));
        fname = new JComboBox();
        jPanel3.add(fname);
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            fname.addItem(names[n2]);
            ++n2;
        }
        fname.setSelectedIndex(Prefs.getInt("fname"));
        jPanel2.add(jPanel3);
        jPanel3 = new JPanel(false);
        jPanel3.setLayout(new FlowLayout(2, 0, 0));
        jPanel3.add(new JLabel("Style:  "));
        fstyle = new JComboBox();
        jPanel3.add(fstyle);
        n = styles.length;
        int n3 = 0;
        while (n3 < n) {
            fstyle.addItem(styles[n3]);
            ++n3;
        }
        fstyle.setSelectedIndex(Prefs.getInt("fstyle"));
        jPanel2.add(jPanel3);
        jPanel.add(jPanel2);
        fsize = new PMBox("Font size", this, Prefs.getInt("fsize"), 3, 100);
        jPanel.add(fsize);
        fsize.setGaps(5, 2);
        this.add(jPanel);
        jPanel = new JPanel(false);
        jPanel.setLayout(new FlowLayout(1, 3, 0));
        spaces = new PMBox("Spaces in gap", this, Prefs.getInt("spaces"), 0, 100);
        jPanel.add((Component)spaces, "Center");
        spaces.setGaps(5, 0);
        timing = new LibButton("Timing");
        jPanel.add(timing);
        timing.addActionListener(this);
        preview = new LibButton("Preview");
        jPanel.add(preview);
        preview.addActionListener(this);
        this.add(jPanel);
        usetext.setYes(Prefs.getBoolean("usetext"));
        this.setValue(Prefs.getInt("tpos"));
        if (!usetext.isYes()) {
            this.off();
        } else {
            text.setText(Prefs.get("text"));
            custom.set(Prefs.getInt("toffset"));
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof LibButton) {
            LibButton libButton = (LibButton)object;
            if (libButton == timing) {
                new SetTiming("txtdelay", "txtstep");
            } else {
                Image image = FileFinder.getCurrent();
                if (image == null) {
                    new ESZap("First select a main image on the right for the preview");
                    return;
                }
                new TextPreview(image);
            }
        }
    }

    public boolean adjust(PMBox pMBox, int n) {
        return true;
    }

    public void changedYesNo(YesNo yesNo) {
        if (yesNo == usetext) {
            if (usetext.isYes() && !FileManager.canUse(1)) {
                usetext.setYes(false);
            } else if (!usetext.isYes()) {
                this.off();
            } else {
                this.on();
            }
        }
    }

    static int findMatch(String string, String[] stringArray) {
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            if (string.equals(stringArray[n2])) break;
            ++n2;
        }
        if (n2 == n) {
            return -1;
        }
        return n2;
    }

    static int getFname() {
        return TextOption.findMatch((String)fname.getSelectedItem(), names);
    }

    static int getFstyle() {
        return TextOption.findMatch((String)fstyle.getSelectedItem(), styles);
    }

    static Font getTextFont() {
        return new Font((String)fname.getSelectedItem(), TextOption.getTextStyle(), fsize.getCurr());
    }

    static int getTextStyle() {
        switch (fstyle.getSelectedIndex()) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
        }
        return 0;
    }

    static int getValue() {
        if (top.isSelected()) {
            return 0;
        }
        if (center.isSelected()) {
            return 1;
        }
        return 2;
    }

    void off() {
        text.setText("");
        text.setBackground(Color.lightGray);
        text.setEnabled(false);
        top.setEnabled(false);
        bottom.setEnabled(false);
        center.setEnabled(false);
        custom.off();
        animate.off();
        textcol.allOff();
        preview.setEnabled(false);
        fname.setEnabled(false);
        fstyle.setEnabled(false);
        fsize.off();
        spaces.off();
        timing.setEnabled(false);
    }

    void on() {
        top.setEnabled(true);
        bottom.setEnabled(true);
        center.setEnabled(true);
        animate.on();
        center.setEnabled(true);
        custom.on(Prefs.getInt("toffset"));
        textcol.allOn();
        preview.setEnabled(true);
        fname.setEnabled(true);
        fstyle.setEnabled(true);
        fsize.on(Prefs.getInt("fsize"));
        spaces.on(Prefs.getInt("spaces"));
        timing.setEnabled(true);
        text.setEnabled(true);
        text.setBackground(Color.white);
        text.setText(Prefs.get("text"));
        text.requestFocus();
    }

    void setValue(int n) {
        if (n == 0) {
            top.setSelected(true);
        } else if (n == 1) {
            center.setSelected(true);
        } else if (n == 2) {
            bottom.setSelected(true);
        }
    }
}

