/*
 * Decompiled with CFR 0.152.
 */
package com.equitysoft.isafe;

import com.equitysoft.isafe.ESDialog;
import com.equitysoft.isafe.ESUtils;
import com.equitysoft.isafe.ESZap;
import com.equitysoft.isafe.EditPrefs;
import com.equitysoft.isafe.FileFinder;
import com.equitysoft.isafe.LibButton;
import com.equitysoft.isafe.PMBox;
import com.equitysoft.isafe.PMBoxAdjuster;
import com.equitysoft.isafe.Prefs;
import com.equitysoft.isafe.Preview;
import com.equitysoft.isafe.SetTiming;
import com.equitysoft.isafe.VerticalLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class PositionBox
extends JPanel
implements ActionListener {
    public static final int NONE = 0;
    public static final int DOWN = 1;
    public static final int ACROSS = 2;
    public static final int DIAGONAL = 3;
    static final int TLEFT = 1;
    static final int BRIGHT = 2;
    static final int CENTER = 3;
    static final int CUSTOM = 4;
    int xpos;
    int ypos;
    int opos;
    JTextField custom;
    JRadioButton st;
    JRadioButton tl;
    JRadioButton br;
    JRadioButton ce;
    JRadioButton cu;
    JRadioButton dn;
    JRadioButton ac;
    JRadioButton di;
    JRadioButton dup;
    JRadioButton nodup;
    LibButton preview;
    LibButton time;

    PositionBox() {
        super(false);
        this.setLayout(new VerticalLayout(0, 3));
        JPanel jPanel = new JPanel(false);
        jPanel.setLayout(new FlowLayout(0, 4, 0));
        JPanel jPanel2 = new JPanel(false);
        jPanel2.setLayout(new BorderLayout());
        jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Overlay position"));
        jPanel2.setLayout(new BorderLayout());
        ButtonGroup buttonGroup = new ButtonGroup();
        JPanel jPanel3 = new JPanel(false);
        jPanel3.setLayout(new FlowLayout(0, 2, 2));
        this.tl = new JRadioButton("Top-left");
        jPanel3.add(this.tl);
        this.tl.addActionListener(this);
        buttonGroup.add(this.tl);
        this.ce = new JRadioButton("Center");
        jPanel3.add(this.ce);
        this.ce.addActionListener(this);
        buttonGroup.add(this.ce);
        this.br = new JRadioButton("Bottom-right");
        jPanel3.add(this.br);
        this.br.addActionListener(this);
        buttonGroup.add(this.br);
        jPanel2.add((Component)jPanel3, "North");
        JPanel jPanel4 = new JPanel(false);
        jPanel4.setLayout(new FlowLayout(0, 2, 2));
        this.cu = new JRadioButton("Custom position");
        jPanel4.add(this.cu);
        this.cu.addActionListener(this);
        buttonGroup.add(this.cu);
        this.custom = new JTextField(10);
        jPanel4.add(this.custom);
        this.custom.setFont(ESUtils.MSG_FONT);
        this.custom.setEditable(false);
        jPanel2.add((Component)jPanel4, "South");
        this.opos = Prefs.getInt("opos");
        if (this.opos == 1) {
            this.tl.setSelected(true);
            this.off();
        } else if (this.opos == 3) {
            this.ce.setSelected(true);
            this.off();
        } else if (this.opos == 2) {
            this.br.setSelected(true);
            this.off();
        } else {
            this.cu.setSelected(true);
            this.xpos = Prefs.getInt("xpos");
            this.ypos = Prefs.getInt("ypos");
            this.on();
        }
        jPanel.add(jPanel2);
        this.preview = new LibButton("Preview");
        jPanel.add(this.preview);
        this.preview.addActionListener(this);
        this.add(jPanel);
        JPanel jPanel5 = new JPanel(false);
        jPanel5.setLayout(new VerticalLayout(0, 3));
        jPanel5.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Overlay movement"));
        ButtonGroup buttonGroup2 = new ButtonGroup();
        MListener mListener = new MListener();
        JPanel jPanel6 = new JPanel(false);
        jPanel6.setLayout(new FlowLayout(1, 5, 0));
        this.st = new JRadioButton("Static");
        jPanel6.add(this.st);
        buttonGroup2.add(this.st);
        this.st.addActionListener(mListener);
        this.dn = new JRadioButton("Down");
        jPanel6.add(this.dn);
        buttonGroup2.add(this.dn);
        this.dn.addActionListener(mListener);
        this.ac = new JRadioButton("Right");
        jPanel6.add(this.ac);
        buttonGroup2.add(this.ac);
        this.ac.addActionListener(mListener);
        this.di = new JRadioButton("Diagonal");
        jPanel6.add(this.di);
        buttonGroup2.add(this.di);
        this.di.addActionListener(mListener);
        jPanel5.add(jPanel6);
        JPanel jPanel7 = new JPanel(false);
        ButtonGroup buttonGroup3 = new ButtonGroup();
        this.nodup = new JRadioButton("Single image");
        jPanel7.add(this.nodup);
        buttonGroup3.add(this.nodup);
        this.nodup.addActionListener(mListener);
        this.dup = new JRadioButton("Double image");
        jPanel7.add(this.dup);
        buttonGroup3.add(this.dup);
        this.dup.addActionListener(mListener);
        if (Prefs.getBoolean("duplicate")) {
            this.dup.setSelected(true);
        } else {
            this.nodup.setSelected(true);
        }
        this.time = new LibButton("Timing");
        jPanel7.add(this.time);
        this.time.addActionListener(this);
        jPanel5.add(jPanel7);
        this.add(jPanel5);
        this.setMovement(Prefs.getInt("movement"));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof LibButton) {
            LibButton libButton = (LibButton)object;
            if (libButton == this.time) {
                new SetTiming("delay", "step");
            } else if (libButton == this.preview) {
                this.showPreview();
            }
        } else if (this.cu.isSelected()) {
            this.opos = 4;
            new CustomPos();
        } else if (this.tl.isSelected()) {
            this.opos = 1;
            this.off();
        } else if (this.ce.isSelected()) {
            this.opos = 3;
            this.off();
        } else if (this.br.isSelected()) {
            this.opos = 2;
            this.off();
        }
    }

    void allOff() {
        this.off();
        this.tl.setEnabled(false);
        this.br.setEnabled(false);
        this.ce.setEnabled(false);
        this.cu.setEnabled(false);
        this.st.setEnabled(false);
        this.dn.setEnabled(false);
        this.ac.setEnabled(false);
        this.di.setEnabled(false);
        this.time.setEnabled(false);
        this.dup.setEnabled(false);
        this.nodup.setEnabled(false);
        this.preview.setEnabled(false);
    }

    void allOn() {
        this.tl.setEnabled(true);
        this.br.setEnabled(true);
        this.ce.setEnabled(true);
        this.cu.setEnabled(true);
        this.st.setEnabled(true);
        this.dn.setEnabled(true);
        this.ac.setEnabled(true);
        this.di.setEnabled(true);
        this.preview.setEnabled(true);
    }

    int getMovement() {
        if (this.st.isSelected()) {
            return 0;
        }
        if (this.dn.isSelected()) {
            return 1;
        }
        if (this.ac.isSelected()) {
            return 2;
        }
        return 3;
    }

    void off() {
        this.custom.setText("");
        this.custom.setBackground(Color.lightGray);
    }

    void on() {
        this.custom.setBackground(Color.white);
        this.custom.setText(" X: " + this.xpos + "  Y: " + this.ypos);
    }

    void setMovement(int n) {
        if (n == 0) {
            this.nodup.setSelected(true);
            this.nodup.setEnabled(false);
            this.dup.setEnabled(false);
            this.st.setSelected(true);
            return;
        }
        if (n == 1) {
            this.dn.setSelected(true);
        } else if (n == 2) {
            this.ac.setSelected(true);
        } else if (n == 3) {
            this.di.setSelected(true);
        }
        this.nodup.setEnabled(true);
        this.dup.setEnabled(true);
    }

    public void showPreview() {
        Image image = FileFinder.getCurrent();
        if (image == null) {
            new ESZap("First select a main image on the right for the preview");
            return;
        }
        int n = image.getWidth(null);
        int n2 = image.getHeight(null);
        Image image2 = EditPrefs.il.img;
        int n3 = 0;
        int n4 = 0;
        int n5 = EditPrefs.il.img.getHeight(null);
        int n6 = EditPrefs.il.img.getWidth(null);
        if (this.opos == 2) {
            n3 = n - n6;
            n4 = n2 - n5;
        } else if (this.opos == 3) {
            n3 = (n - n6) / 2;
            n4 = (n2 - n5) / 2;
        } else if (this.opos == 4) {
            n3 = this.xpos;
            n4 = this.ypos;
        }
        int n7 = this.getMovement();
        boolean bl = this.dup.isSelected();
        if (n7 != 0 && bl) {
            if (n7 == 1) {
                n4 = 0;
            } else if (n7 == 2) {
                n3 = 0;
            } else if (n7 == 3) {
                n4 = 0;
                n3 = 0;
            }
        }
        new Preview(image, image2, n3, n4, n7, bl);
    }

    class MListener
    implements ActionListener {
        MListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JRadioButton jRadioButton = (JRadioButton)actionEvent.getSource();
            if (jRadioButton != PositionBox.this.nodup && jRadioButton != PositionBox.this.dup) {
                if (PositionBox.this.st.isSelected()) {
                    PositionBox.this.time.setEnabled(false);
                    PositionBox.this.nodup.setSelected(true);
                    PositionBox.this.nodup.setEnabled(false);
                    PositionBox.this.dup.setEnabled(false);
                } else {
                    PositionBox.this.time.setEnabled(true);
                    PositionBox.this.nodup.setEnabled(true);
                    PositionBox.this.dup.setEnabled(true);
                }
            }
        }
    }

    class CustomPos
    extends ESDialog
    implements PMBoxAdjuster,
    ActionListener {
        PMBox xp;
        PMBox yp;
        int currx;
        int curry;
        LibButton set;
        LibButton cancel;

        CustomPos() {
            super("Set position.");
            if (PositionBox.this.opos != 4) {
                this.currx = 0;
                this.curry = 0;
            } else {
                this.currx = PositionBox.this.xpos;
                this.curry = PositionBox.this.ypos;
            }
            this.jp.setLayout(new BorderLayout());
            this.xp = new PMBox("X position", this, this.currx, 0, 1000);
            this.jp.add((Component)this.xp, "North");
            this.yp = new PMBox("Y position", this, this.curry, 0, 1000);
            this.jp.add((Component)this.yp, "Center");
            JPanel jPanel = new JPanel();
            this.set = new LibButton("Set");
            jPanel.add(this.set);
            this.set.addActionListener(this);
            this.cancel = new LibButton("Cancel");
            jPanel.add(this.cancel);
            this.cancel.addActionListener(this);
            this.jp.add((Component)jPanel, "South");
            this.finishOff();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            LibButton libButton = (LibButton)actionEvent.getSource();
            if (libButton == this.set) {
                PositionBox.this.opos = 4;
                PositionBox.this.xpos = this.xp.curr;
                PositionBox.this.ypos = this.yp.curr;
                this.closeDialog();
                PositionBox.this.on();
            } else {
                PositionBox.this.opos = 3;
                PositionBox.this.ce.setSelected(true);
                PositionBox.this.off();
                this.closeDialog();
            }
        }

        public boolean adjust(PMBox pMBox, int n) {
            return true;
        }
    }
}

