/*
 * Decompiled with CFR 0.152.
 */
package com.equitysoft.isafe;

import com.equitysoft.isafe.ESUtils;
import com.equitysoft.isafe.PMAdjuster;
import com.equitysoft.isafe.PMBoxAdjuster;
import com.equitysoft.isafe.PlusMinus;
import java.awt.Color;
import java.awt.FlowLayout;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JTextField;

class PMBox
extends JPanel
implements PMAdjuster {
    int min;
    int max;
    int curr;
    PMBoxAdjuster adj;
    JTextField tf;
    PlusMinus pm;

    PMBox(String string, PMBoxAdjuster pMBoxAdjuster, int n, int n2, int n3) {
        this.adj = pMBoxAdjuster;
        this.curr = n;
        this.min = n2;
        this.max = n3;
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), string));
        this.tf = new JTextField(4);
        this.tf.setEditable(false);
        this.tf.setBackground(Color.white);
        this.tf.setForeground(Color.black);
        this.tf.setFont(ESUtils.MSG_FONT);
        this.tf.setText(String.valueOf(this.curr));
        this.add(this.tf);
        this.pm = new PlusMinus();
        this.add(this.pm);
        this.pm.setAdjuster(this);
    }

    void setGaps(int n, int n2) {
        this.setLayout(new FlowLayout(1, n, n2));
    }

    int getCurr() {
        return this.curr;
    }

    void off() {
        this.pm.off();
        this.tf.setText("");
        this.tf.setEnabled(false);
        this.tf.setBackground(Color.lightGray);
    }

    void on(int n) {
        this.tf.setBackground(Color.white);
        this.curr = n;
        this.tf.setEnabled(true);
        this.pm.on();
        this.tf.setText(String.valueOf(n));
    }

    public void adjust(PlusMinus plusMinus, int n) {
        int n2 = this.curr + n;
        if (n2 >= this.min && n2 <= this.max) {
            if (!this.adj.adjust(this, n2)) {
                return;
            }
            this.curr = n2;
            this.tf.setText(String.valueOf(this.curr));
        }
    }

    void set(int n) {
        this.tf.setText(String.valueOf(n));
        this.curr = n;
    }
}

