/*
 * Decompiled with CFR 0.152.
 */
package com.equitysoft.isafe;

import com.equitysoft.isafe.Bar;
import com.equitysoft.isafe.ESUtils;
import com.equitysoft.isafe.ESZap;
import com.equitysoft.isafe.ISafe;
import com.equitysoft.isafe.LibButton;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

class HelpBox
extends JFrame
implements ActionListener,
HyperlinkListener {
    static final Cursor HAND = new Cursor(12);
    static Dimension DIM = new Dimension(25, 25);
    static String EXCEPTION = "Exception loading page";
    static String FINISH = "Close help";
    static LibButton back;
    static LibButton forward;
    static LibButton index;
    static Vector pages;
    static int currpage;
    static JEditorPane html;
    static Dimension BDIM;
    static Font TOOLTIP_FONT;

    static {
        BDIM = new Dimension(40, 25);
        TOOLTIP_FONT = new Font("SansSerif", 1, 13);
    }

    HelpBox() {
        Bar.handle.repaint();
        this.setTitle(String.valueOf(ESUtils.PRODUCT) + " documentation.");
        ((Frame)this).setIconImage(ESUtils.getSystemImage(ISafe.SYS_ICON));
        JPanel jPanel = new JPanel();
        jPanel.setOpaque(true);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)jPanel, "Center");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ((Component)HelpBox.this).setVisible(false);
            }
        });
        jPanel.setBackground(Color.lightGray);
        jPanel.setLayout(new BorderLayout());
        pages = new Vector(1);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.setBackground(Color.lightGray);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new FlowLayout(1, 5, 0));
        jPanel3.setBackground(Color.lightGray);
        back = new LibButton("Back", "left.gif");
        jPanel3.add(back);
        back.setEnabled(false);
        back.addActionListener(this);
        index = new LibButton("Contents", "index.gif");
        jPanel3.add(index);
        index.setEnabled(false);
        index.addActionListener(this);
        forward = new LibButton("Forward", "right.gif");
        jPanel3.add(forward);
        forward.setEnabled(false);
        forward.addActionListener(this);
        jPanel2.add((Component)jPanel3, "West");
        LibButton libButton = new LibButton(FINISH);
        jPanel2.add((Component)libButton, "East");
        libButton.addActionListener(this);
        jPanel2.setBorder(BorderFactory.createEtchedBorder());
        jPanel.add((Component)jPanel2, "North");
        URL uRL = this.getClass().getResource("help/index.html");
        pages.addElement(uRL);
        try {
            html = new JEditorPane(uRL);
        }
        catch (Exception exception) {
            new ESZap("Help not found");
            return;
        }
        html.setEditable(false);
        html.addHyperlinkListener(this);
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), BorderFactory.createLoweredBevelBorder()));
        JViewport jViewport = jScrollPane.getViewport();
        jViewport.add(html);
        jPanel.add((Component)jScrollPane, "Center");
        ((Component)this).setSize(2 * ISafe.screendim.width / 3, 2 * ISafe.screendim.height / 3);
        Dimension dimension = this.getSize();
        ((Component)this).setLocation(ISafe.screendim.width - dimension.width, ISafe.screendim.height - dimension.height);
        ((Component)this).setVisible(true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand() == FINISH) {
            ((Component)this).setVisible(false);
            return;
        }
        LibButton libButton = (LibButton)actionEvent.getSource();
        if (libButton == index) {
            if (currpage == 0) {
                return;
            }
            try {
                html.setPage((URL)pages.elementAt(0));
            }
            catch (Exception exception) {
                ((Component)this).setVisible(false);
                new ESZap(EXCEPTION);
                return;
            }
            back.setEnabled(false);
            forward.setEnabled(true);
            currpage = 0;
            index.setEnabled(false);
        } else {
            if (pages.size() <= 1) {
                return;
            }
            if (libButton == back) {
                --currpage;
                try {
                    html.setPage((URL)pages.elementAt(currpage));
                }
                catch (Exception exception) {
                    ((Component)this).setVisible(false);
                    new ESZap(EXCEPTION);
                    return;
                }
                forward.setEnabled(true);
                if (currpage == 0) {
                    back.setEnabled(false);
                    index.setEnabled(false);
                }
            } else if (libButton == forward) {
                ++currpage;
                index.setEnabled(true);
                try {
                    html.setPage((URL)pages.elementAt(currpage));
                }
                catch (Exception exception) {
                    ((Component)this).setVisible(false);
                    new ESZap(EXCEPTION);
                    return;
                }
                back.setEnabled(true);
                if (currpage + 1 == pages.size()) {
                    forward.setEnabled(false);
                }
            }
        }
    }

    public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
        if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            this.setCursor(Cursor.getDefaultCursor());
            URL uRL = hyperlinkEvent.getURL();
            try {
                html.setPage(uRL);
            }
            catch (Exception exception) {
                ((Component)this).setVisible(false);
                new ESZap(EXCEPTION);
                return;
            }
            back.setEnabled(true);
            index.setEnabled(true);
            if (pages.size() == 1) {
                pages.addElement(uRL);
                ++currpage;
            } else if (currpage + 1 == pages.size()) {
                pages.addElement(uRL);
                ++currpage;
            } else if (uRL.equals((URL)pages.elementAt(currpage + 1))) {
                if (++currpage + 1 == pages.size()) {
                    forward.setEnabled(false);
                }
            } else {
                int n = pages.size() - 1;
                while (n > currpage) {
                    pages.removeElementAt(n);
                    --n;
                }
                pages.addElement(uRL);
                ++currpage;
                forward.setEnabled(false);
            }
        } else if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ENTERED) {
            this.setCursor(HAND);
        } else if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.EXITED) {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }
}

