/*
 * Decompiled with CFR 0.152.
 */
package com.equitysoft.isafe;

import com.equitysoft.isafe.AppSpec;
import com.equitysoft.isafe.Bar;
import com.equitysoft.isafe.ESUtils;
import com.equitysoft.isafe.EditPrefs;
import com.equitysoft.isafe.ISLib;
import com.equitysoft.isafe.SysProps;
import java.awt.Color;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;

public class HTMLCreator {
    static String APPLET_START = "<applet code=\"";
    static String SEARCH_BEGIN = String.valueOf(APPLET_START) + "APApplet";
    static String APPLET_END = "</applet>";
    static String NAME_BEGIN = "\" archive=\"";
    static String EDITED_BEGIN = "<!-- Created ";
    static String EDITED_END = " -->";
    static String BODY = "</body>";
    static StringBuffer sb = new StringBuffer(512);
    static StringBuffer sb2;
    static String half1;
    static String half2;
    static boolean useskeleton;

    static void addEnd() {
        if (useskeleton) {
            sb.append(half2);
        } else {
            sb.append(BODY).append("\n</html>");
        }
    }

    static void addStart(AppSpec appSpec) {
        sb.setLength(0);
        if (useskeleton) {
            sb.append(half1);
            return;
        }
        HTMLCreator.appendEditedBy();
        sb.append("\n<html>\n<head>");
        if (appSpec != null) {
            sb.append("\n<title>").append(appSpec.origname).append("</title>");
        }
        sb.append("\n</head>\n<body");
        if (EditPrefs.pagecol.isYes()) {
            Color color = new Color(EditPrefs.pagecol.getRGB());
            sb.append(" bgcolor=\"#");
            sb.append(HTMLCreator.getHex(color.getRed()));
            sb.append(HTMLCreator.getHex(color.getGreen()));
            sb.append(HTMLCreator.getHex(color.getBlue()));
            sb.append("\"");
        }
        sb.append(">\n");
    }

    static void appendAppletString(AppSpec appSpec, StringBuffer stringBuffer) {
        stringBuffer.append(APPLET_START);
        stringBuffer.append(appSpec.mainclass);
        stringBuffer.append(NAME_BEGIN);
        if (EditPrefs.relative.isYes()) {
            stringBuffer.append(EditPrefs.reldir.getText()).append('/');
        }
        stringBuffer.append(appSpec.name).append(".jar").append("\" width=");
        stringBuffer.append(appSpec.dim.width).append(" height=");
        stringBuffer.append(appSpec.dim.height);
        stringBuffer.append(">\n<param name=\"author\" value=\"").append(ISLib.getAuthor());
        stringBuffer.append("\">\n<param name=\"version_message\" value=\"").append(EditPrefs.version.getText());
        stringBuffer.append("\">\n<param name=\"data\" value=\"").append(appSpec.paramfile);
        stringBuffer.append("\">\n").append(APPLET_END);
    }

    static void appendEditedBy() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MMM dd, yyyy");
        sb.append(EDITED_BEGIN).append(simpleDateFormat.format(new Date())).append(EDITED_END);
    }

    static boolean createHTML(AppSpec appSpec) {
        if (EditPrefs.html.getOption() == 1) {
            HTMLCreator.addStart(appSpec);
            if (EditPrefs.center.isYes()) {
                sb.append("<center>\n");
            }
            HTMLCreator.appendAppletString(appSpec, sb);
            if (EditPrefs.center.isYes()) {
                sb.append("\n</center>\n");
            }
            HTMLCreator.addEnd();
            if (!ESUtils.saveStringAsFile(sb.toString(), appSpec.file)) {
                return false;
            }
        } else if (EditPrefs.html.getOption() == 2) {
            HTMLCreator.appendAppletString(appSpec, sb);
            sb.append("\n");
        }
        if (EditPrefs.clipboard.isYes()) {
            if (sb2 == null) {
                sb2 = new StringBuffer(256);
            }
            sb2.setLength(0);
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            try {
                String string = (String)clipboard.getContents(Bar.handle).getTransferData(DataFlavor.stringFlavor);
                sb2.append(string);
            }
            catch (Exception exception) {}
            HTMLCreator.appendAppletString(appSpec, sb2);
            sb2.append("\n");
            clipboard.setContents(new StringSelection(sb2.toString()), Bar.handle);
        }
        return true;
    }

    static String getHex(int n) {
        String string = Integer.toHexString(n);
        if (string.length() == 1) {
            string = "0" + string;
        }
        return string;
    }

    static void setSkeleton() {
        useskeleton = false;
        if (!EditPrefs.skeleton.isYes()) {
            return;
        }
        String string = EditPrefs.skelpath.getText();
        if (string.equals(SysProps.EMPTY)) {
            EditPrefs.skeletonOff();
            return;
        }
        File file = new File(string);
        if (!file.exists()) {
            EditPrefs.skeletonOff();
            return;
        }
        String string2 = ESUtils.getFileAsString(file);
        if (string2 == null) {
            EditPrefs.skeletonOff();
            return;
        }
        int n = string2.indexOf("<imagesafe>");
        if (n < 0 && (n = string2.indexOf("<IMAGESAFE>")) < 0) {
            EditPrefs.skeletonOff();
            return;
        }
        if (n == 0 || n + 11 == string2.length()) {
            EditPrefs.skeletonOff();
            return;
        }
        half1 = string2.substring(0, n);
        half2 = string2.substring(n + 11);
        useskeleton = true;
    }
}

